function output = ModelAY11(x,x0,del,param)

% ------------------------------------------------------ AY(1,1) --------------------------------------------------------------
% 
% mu1(x1) = (theta1 - x1)*kappa11; 
% sigma11(x1) = sqrt(x1); 
% 
% Dv(x1) = log(x1)/2;
% 
% 
% lnpX(del, x1, x10, 3) = - log(del)/2 - log(2*pi)/2 - Dv(x1) + c(x1, x10, -1)/del + c(x1, x10, 0) + c(x1, x10, 1)*del + c(x1, x10, 2)*del^2/2 + c(x1, x10, 3)*del^3/6; 
% 
% 
% c(x1, x10, -1) = -2*(sqrt(x1) - sqrt(x10))^2; 
% 
% c(x1, x10, 0) = (1/4)*(-4*x1*kappa11 + 4*x10*kappa11 + (-1 + 4*theta1*kappa11)*log(x1) + log(x10) - 4*theta1*kappa11*log(x10)); 
% 
% c(x1, x10, 1) = (1/(96*sqrt(x1)*sqrt(x10)))*(-9 - 16*x1^(3/2)*sqrt(x10)*kappa11^2 - 16*x1*x10*kappa11^2 - 16*sqrt(x1)*x10^(3/2)*kappa11^2 - 48*theta1^2*kappa11^2 + 48*theta1*kappa11*(1 + 2*sqrt(x1)*sqrt(x10)*kappa11)); 
% 
% c(x1, x10, 2) = -((9 - 48*theta1*kappa11 + 16*x1*x10*kappa11^2 + 48*theta1^2*kappa11^2)/(384*x1*x10)); 
% 
% c(x1, x10, 3) = (-945 - 1440*x1*x10*kappa11^2 - 7680*theta1^3*kappa11^3 + 1024*x1^(5/2)*x10^(3/2)*kappa11^4 + 1792*x1^2*x10^2*kappa11^4 + 1024*x1^(3/2)*x10^(5/2)*kappa11^4 + 3840*theta1^4*kappa11^4 + 480*theta1*kappa11*(9 + 16*x1*x10*kappa11^2) - 480*theta1^2*(kappa11^2 + 16*x1*x10*kappa11^4))/(61440*x1^(3/2)*x10^(3/2)); 
% 
% 
x1 = x;
x10 = x0;
theta1 = param(1);
kappa11 = param(2);

Dv = log(x1)/2;

cm1 = -2*(sqrt(x1) - sqrt(x10))^2; 

c0 = (1/4)*(-4*x1*kappa11 + 4*x10*kappa11 + (-1 + 4*theta1*kappa11)*log(x1) + log(x10) - 4*theta1*kappa11*log(x10)); 

c1 = (1/(96*sqrt(x1)*sqrt(x10)))*(-9 - 16*x1^(3/2)*sqrt(x10)*kappa11^2 - 16*x1*x10*kappa11^2 - 16*sqrt(x1)*x10^(3/2)*kappa11^2 - 48*theta1^2*kappa11^2 + 48*theta1*kappa11*(1 + 2*sqrt(x1)*sqrt(x10)*kappa11)); 

c2 = -((9 - 48*theta1*kappa11 + 16*x1*x10*kappa11^2 + 48*theta1^2*kappa11^2)/(384*x1*x10)); 

c3 = (-945 - 1440*x1*x10*kappa11^2 - 7680*theta1^3*kappa11^3 + 1024*x1^(5/2)*x10^(3/2)*kappa11^4 + 1792*x1^2*x10^2*kappa11^4 + 1024*x1^(3/2)*x10^(5/2)*kappa11^4 + 3840*theta1^4*kappa11^4 + 480*theta1*kappa11*(9 + 16*x1*x10*kappa11^2) - 480*theta1^2*(kappa11^2 + 16*x1*x10*kappa11^4))/(61440*x1^(3/2)*x10^(3/2)); 

output = - log(del)/2 - log(2*pi)/2 - Dv + cm1/del + c0 + c1*del + c2*del^2/2 + c3*del^3/6; 
