function output = ModelAY22(x,x0,del,param)

% ------------------------------------------------------ AY(2,2) --------------------------------------------------------------
% 
% 
% 
% mu1(x1, x2) = (theta1 - x1)*kappa11 + (theta2 - x2)*kappa12; 
% mu2(x1, x2) = (theta1 - x1)*kappa21 + (theta2 - x2)*kappa22; 
% sigma11(x1, x2) = sqrt(x1); 
% sigma21(x1, x2) = 0; 
% sigma12(x1, x2) = 0; 
% sigma22(x1, x2) = sqrt(x2); 
% 
% 
% Dv(x1,x2) = log(x1*x2)/2;
% 
% 
% lnpX(del, x1, x2, x10, x20, 2) = -log(del) - log(2*pi) - Dv(x1,x2) + c(x1, x2, x10, x20, -1)/del + c(x1, x2, x10, x20, 0) + c(x1, x2, x10, x20, 1)*del + c(x1, x2, x10, x20, 2)*del^2/2; 
% 
% 
% c(x1, x2, x10, x20, -1) = -((21*(x1 - x10)^6)/(256*x10^5)) + (7*(x1 - x10)^5)/(64*x10^4) - (5*(x1 - x10)^4)/(32*x10^3) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20) - (21*(x2 - x20)^6)/(256*x20^5) + (7*(x2 - x20)^5)/(64*x20^4) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2); 
% 
% 
% c(x1, x2, x10, x20, 0) = ((x1 - x10)^4*(1 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(16*x10^4) + ((x1 - x10)^2*(1 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(8*x10^2) - ((x1 - x10)*(1 + 4*x10*kappa11 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(4*x10) + ((x1 - x10)^3*(-1 + 4*theta1*kappa11 - 4*x20*kappa12 + 4*theta2*kappa12))/(12*x10^3) - ((x1 - x10)^2*(x2 - x20)^2*(x20*kappa12 + x10*kappa21))/ (48*x10^2*x20^2) - ((x1 - x10)*(x2 - x20)*(x20*kappa12 + x10*kappa21))/(2*x10*x20) + ((x1 - x10)^2*(x2 - x20)*(7*x20*kappa12 + x10*kappa21))/ (24*x10^2*x20) - ((x1 - x10)^3*(x2 - x20)*(10*x20*kappa12 + x10*kappa21))/(48*x10^3*x20) + ((x1 - x10)*(x2 - x20)^2*(x20*kappa12 + 7*x10*kappa21))/(24*x10*x20^2) - ((x1 - x10)*(x2 - x20)^3*(x20*kappa12 + 10*x10*kappa21))/ (48*x10*x20^3) + ((x2 - x20)^4*(1 + 4*x10*kappa21 - 4*theta1*kappa21 - 4*theta2*kappa22))/(16*x20^4) + ((x2 - x20)^2*(1 + 4*x10*kappa21 - 4*theta1*kappa21 - 4*theta2*kappa22))/(8*x20^2) - ((x2 - x20)*(1 + 4*x10*kappa21 - 4*theta1*kappa21 + 4*x20*kappa22 - 4*theta2*kappa22))/(4*x20) + ((x2 - x20)^3*(-1 - 4*x10*kappa21 + 4*theta1*kappa21 + 4*theta2*kappa22))/(12*x20^3); 
% 
% 
% c(x1, x2, x10, x20, 1) = (1/(48*x10^2*x20^2))*((x1 - x10)*(x2 - x20)*(16*x20^3*kappa12^2 + x20^2*kappa12*(9 - 16*theta1*kappa11 - 16*theta2*kappa12) + x10^2*kappa21*(9 + 16*x10*kappa21 - 16*theta1*kappa21 - 16*theta2*kappa22))) + (1/(192*x10^2*x20))*((x1 - x10)*(48*x20^3*kappa12^2 - 48*x20^2*kappa12*(-1 + 2*theta1*kappa11 + 2*theta2*kappa12) + 8*x10^2*kappa21*(-7 - 12*x10*kappa21 + 12*theta1*kappa21 + 12*theta2*kappa22) + x20*(9 + 48*theta1^2*kappa11^2 - 8*x10*kappa12 - 48*theta2*kappa12 + 48*theta2^2*kappa12^2 + 48*theta1*kappa11*(-1 + 2*theta2*kappa12) - 48*x10^2*(kappa11^2 + 2*kappa21*kappa22)))) + (1/(768*x10^3*x20))*((x1 - x10)^2*(-144*x20^3*kappa12^2 + 16*x20^2*kappa12*(-9 + 18*theta1*kappa11 + 2*x10*kappa12 + 18*theta2*kappa12) - 16*x10^2*kappa21*(-1 + 4*x10*kappa21 + 2*theta1*kappa21 + 2*theta2*kappa22) + x20*(-144*theta1^2*kappa11^2 + 16*x10*kappa12 - 144*theta1*kappa11*(-1 + 2*theta2*kappa12) - 9*(3 - 16*theta2*kappa12 + 16*theta2^2*kappa12^2) + 16*x10^2*(kappa11^2 - 4*kappa12*kappa21 + 2*kappa21*kappa22)))) + (1/(768*x10*x20^3))* ((x2 - x20)^2*(-16*x20^2*kappa12*(-1 + 2*theta1*kappa11 + 4*x20*kappa12 + 2*theta2*kappa12) - 144*x10^3*kappa21^2 + 16*x10^2*kappa21*(-9 + 2*x20*kappa21 + 18*theta1*kappa21 + 18*theta2*kappa22) + x10*(16*x20*kappa21 + 16*x20^2*(2*kappa11*kappa12 - 4*kappa12*kappa21 + kappa22^2) - 9*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22))))) + (1/(192*x10*x20^2))*((x2 - x20)*(8*x20^2*kappa12*(-7 + 12*theta1*kappa11 - 12*x20*kappa12 + 12*theta2*kappa12) + 48*x10^3*kappa21^2 - 48*x10^2*kappa21*(-1 + 2*theta1*kappa21 + 2*theta2*kappa22) + x10*(-8*x20*kappa21 - 48*x20^2*(2*kappa11*kappa12 + kappa22^2) + 3*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22))))) - (1/(32*x10*x20))*(x20*(3 + 16*theta1^2*kappa11^2 - 16*theta2*kappa12 + 16*x20^2*kappa12^2 + 16*theta2^2*kappa12^2 + 16*x20*kappa12*(1 - 2*theta2*kappa12) - 16*theta1*kappa11*(1 + 2*x20*kappa12 - 2*theta2*kappa12)) + 16*x10^3*kappa21^2 + 16*x10^2*(kappa21*(1 - 2*theta1*kappa21 - 2*theta2*kappa22) + x20*(kappa11^2 + 2*kappa21*kappa22)) + x10*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22) + 16*x20^2*(2*kappa11*kappa12 + kappa22^2) - 32*x20*(theta1*(kappa11^2 + kappa21*kappa22) + theta2*(kappa11*kappa12 + kappa22^2)))); 
% 
% 
% c(x1, x2, x10, x20, 2) = (-(1/(384*x10^2*x20^2)))*(16*x10*x20^2*kappa12*(1 - 2*theta1*kappa11 + 4*x20*kappa12 - 2*theta2*kappa12) + 3*x20^2*(3 + 16*theta1^2*kappa11^2 - 16*theta2*kappa12 + 16*x20^2*kappa12^2 + 16*theta2^2*kappa12^2 + 16*x20*kappa12*(1 - 2*theta2*kappa12) - 16*theta1*kappa11*(1 + 2*x20*kappa12 - 2*theta2*kappa12)) + 48*x10^4*kappa21^2 + 16*x10^3*kappa21*(3 + 4*x20*kappa21 - 6*theta1*kappa21 - 6*theta2*kappa22) + x10^2*(-16*x20*kappa21*(-1 + 2*theta1*kappa21 + 2*theta2*kappa22) + 16*x20^2*(kappa11^2 + 2*kappa11*kappa12 + 4*kappa12*kappa21 + 2*kappa21*kappa22 + kappa22^2) + 3*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22)))); 
% 
% 

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

theta1 = param(1);
theta2 = param(2);
kappa11 = param(3);
kappa12 = param(4);
kappa21 = param(5);
kappa22 = param(6);

Dv = log(x1*x2)/2;

cm1 = -((21*(x1 - x10)^6)/(256*x10^5)) + (7*(x1 - x10)^5)/(64*x10^4) - (5*(x1 - x10)^4)/(32*x10^3) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20) - (21*(x2 - x20)^6)/(256*x20^5) + (7*(x2 - x20)^5)/(64*x20^4) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2); 


c0 = ((x1 - x10)^4*(1 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(16*x10^4) + ((x1 - x10)^2*(1 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(8*x10^2) - ((x1 - x10)*(1 + 4*x10*kappa11 - 4*theta1*kappa11 + 4*x20*kappa12 - 4*theta2*kappa12))/(4*x10) + ((x1 - x10)^3*(-1 + 4*theta1*kappa11 - 4*x20*kappa12 + 4*theta2*kappa12))/(12*x10^3) - ((x1 - x10)^2*(x2 - x20)^2*(x20*kappa12 + x10*kappa21))/ (48*x10^2*x20^2) - ((x1 - x10)*(x2 - x20)*(x20*kappa12 + x10*kappa21))/(2*x10*x20) + ((x1 - x10)^2*(x2 - x20)*(7*x20*kappa12 + x10*kappa21))/ (24*x10^2*x20) - ((x1 - x10)^3*(x2 - x20)*(10*x20*kappa12 + x10*kappa21))/(48*x10^3*x20) + ((x1 - x10)*(x2 - x20)^2*(x20*kappa12 + 7*x10*kappa21))/(24*x10*x20^2) - ((x1 - x10)*(x2 - x20)^3*(x20*kappa12 + 10*x10*kappa21))/ (48*x10*x20^3) + ((x2 - x20)^4*(1 + 4*x10*kappa21 - 4*theta1*kappa21 - 4*theta2*kappa22))/(16*x20^4) + ((x2 - x20)^2*(1 + 4*x10*kappa21 - 4*theta1*kappa21 - 4*theta2*kappa22))/(8*x20^2) - ((x2 - x20)*(1 + 4*x10*kappa21 - 4*theta1*kappa21 + 4*x20*kappa22 - 4*theta2*kappa22))/(4*x20) + ((x2 - x20)^3*(-1 - 4*x10*kappa21 + 4*theta1*kappa21 + 4*theta2*kappa22))/(12*x20^3); 


c1 = (1/(48*x10^2*x20^2))*((x1 - x10)*(x2 - x20)*(16*x20^3*kappa12^2 + x20^2*kappa12*(9 - 16*theta1*kappa11 - 16*theta2*kappa12) + x10^2*kappa21*(9 + 16*x10*kappa21 - 16*theta1*kappa21 - 16*theta2*kappa22))) + (1/(192*x10^2*x20))*((x1 - x10)*(48*x20^3*kappa12^2 - 48*x20^2*kappa12*(-1 + 2*theta1*kappa11 + 2*theta2*kappa12) + 8*x10^2*kappa21*(-7 - 12*x10*kappa21 + 12*theta1*kappa21 + 12*theta2*kappa22) + x20*(9 + 48*theta1^2*kappa11^2 - 8*x10*kappa12 - 48*theta2*kappa12 + 48*theta2^2*kappa12^2 + 48*theta1*kappa11*(-1 + 2*theta2*kappa12) - 48*x10^2*(kappa11^2 + 2*kappa21*kappa22)))) + (1/(768*x10^3*x20))*((x1 - x10)^2*(-144*x20^3*kappa12^2 + 16*x20^2*kappa12*(-9 + 18*theta1*kappa11 + 2*x10*kappa12 + 18*theta2*kappa12) - 16*x10^2*kappa21*(-1 + 4*x10*kappa21 + 2*theta1*kappa21 + 2*theta2*kappa22) + x20*(-144*theta1^2*kappa11^2 + 16*x10*kappa12 - 144*theta1*kappa11*(-1 + 2*theta2*kappa12) - 9*(3 - 16*theta2*kappa12 + 16*theta2^2*kappa12^2) + 16*x10^2*(kappa11^2 - 4*kappa12*kappa21 + 2*kappa21*kappa22)))) + (1/(768*x10*x20^3))* ((x2 - x20)^2*(-16*x20^2*kappa12*(-1 + 2*theta1*kappa11 + 4*x20*kappa12 + 2*theta2*kappa12) - 144*x10^3*kappa21^2 + 16*x10^2*kappa21*(-9 + 2*x20*kappa21 + 18*theta1*kappa21 + 18*theta2*kappa22) + x10*(16*x20*kappa21 + 16*x20^2*(2*kappa11*kappa12 - 4*kappa12*kappa21 + kappa22^2) - 9*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22))))) + (1/(192*x10*x20^2))*((x2 - x20)*(8*x20^2*kappa12*(-7 + 12*theta1*kappa11 - 12*x20*kappa12 + 12*theta2*kappa12) + 48*x10^3*kappa21^2 - 48*x10^2*kappa21*(-1 + 2*theta1*kappa21 + 2*theta2*kappa22) + x10*(-8*x20*kappa21 - 48*x20^2*(2*kappa11*kappa12 + kappa22^2) + 3*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22))))) - (1/(32*x10*x20))*(x20*(3 + 16*theta1^2*kappa11^2 - 16*theta2*kappa12 + 16*x20^2*kappa12^2 + 16*theta2^2*kappa12^2 + 16*x20*kappa12*(1 - 2*theta2*kappa12) - 16*theta1*kappa11*(1 + 2*x20*kappa12 - 2*theta2*kappa12)) + 16*x10^3*kappa21^2 + 16*x10^2*(kappa21*(1 - 2*theta1*kappa21 - 2*theta2*kappa22) + x20*(kappa11^2 + 2*kappa21*kappa22)) + x10*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22) + 16*x20^2*(2*kappa11*kappa12 + kappa22^2) - 32*x20*(theta1*(kappa11^2 + kappa21*kappa22) + theta2*(kappa11*kappa12 + kappa22^2)))); 


c2 = (-(1/(384*x10^2*x20^2)))*(16*x10*x20^2*kappa12*(1 - 2*theta1*kappa11 + 4*x20*kappa12 - 2*theta2*kappa12) + 3*x20^2*(3 + 16*theta1^2*kappa11^2 - 16*theta2*kappa12 + 16*x20^2*kappa12^2 + 16*theta2^2*kappa12^2 + 16*x20*kappa12*(1 - 2*theta2*kappa12) - 16*theta1*kappa11*(1 + 2*x20*kappa12 - 2*theta2*kappa12)) + 48*x10^4*kappa21^2 + 16*x10^3*kappa21*(3 + 4*x20*kappa21 - 6*theta1*kappa21 - 6*theta2*kappa22) + x10^2*(-16*x20*kappa21*(-1 + 2*theta1*kappa21 + 2*theta2*kappa22) + 16*x20^2*(kappa11^2 + 2*kappa11*kappa12 + 4*kappa12*kappa21 + 2*kappa21*kappa22 + kappa22^2) + 3*(3 + 16*theta1^2*kappa21^2 - 16*theta2*kappa22 + 16*theta2^2*kappa22^2 + 16*theta1*kappa21*(-1 + 2*theta2*kappa22)))); 


output = -log(del) - log(2*pi) - Dv + cm1/del + c0 + c1*del + c2*del^2/2; 

