function output = ModelB10(x,x0,del,param)


% \[Mu]1[x1_, x2_] = b1 (a1 - x1);
% \[Mu]2[x1_, x2_] = b2 (a2 - x2);
% \[Sigma]11[x1_, x2_] = g1;
% \[Sigma]22[x1_, x2_] = g2*Sqrt[x2];
% \[Sigma]12[x1_, x2_] = 0;
% \[Sigma]21[x1_, x2_] = 0;
% 
% Dv[x1_,x2_]= Log[x2]/2 + Log[g1] + Log[g2];
% 
% x10 and x20 designate the two components of the vector x0 (the backward variable);
% 
% The expansion at order K=2 for the log-transition function is: 
% 
% lnpX[del,x1,x2,x10,x20,2] = - Log[2*Pi*del] - Dv[x1,x2] + c[x1,x2,x10,x20,-1]/del + c[x1,x2,x10,x20,0] + c[x1,x2,x10,x20,1]*del + c[x1,x2,x10,x20,2]*del^2/2; 
% 
% c[x1,x2,x10,x20,-1] = 1/ 2 (-((x1 - x10)^2/g1^2) - (x2 - x20)^2/(x20 g2^2)) - ( 21 (x2 - x20)^6)/(256 x20^5 g2^2) + (7 (x2 - x20)^5)/( 64 x20^4 g2^2) - (5 (x2 - x20)^4)/( 32 x20^3 g2^2) + (x2 - x20)^3/(4 x20^2 g2^2);
% 
% 
% c[x1,x2,x10,x20,0] = -(((x1 - x10)^2 b1)/( 2 g1^2)) + ((x1 - x10) (-x10 + a1) b1)/g1^2 + ((x2 - x20)^4 (-4 a2 b2 + g2^2))/( 16 x20^4 g2^2) - ((x2 - x20)^3 (-4 a2 b2 + g2^2))/( 12 x20^3 g2^2) + ((x2 - x20)^2 (-4 a2 b2 + g2^2))/( 8 x20^2 g2^2) - ((x2 - x20) (4 x20 b2 - 4 a2 b2 + g2^2))/(4 x20 g2^2); 
% 
% 
% c[x1,x2,x10,x20,1] = -(((x1 - x10)^2 b1^2)/( 6 g1^2)) - ((x1 - x10) (x10 - a1) b1^2)/( 2 g1^2) + ((x2 - x20)^2 (16 x20^2 b2^2 - 144 a2^2 b2^2 + 144 a2 b2 g2^2 - 27 g2^4))/( 768 x20^3 g2^2) + ((x2 - x20) (-16 x20^2 b2^2 + 16 a2^2 b2^2 - 16 a2 b2 g2^2 + 3 g2^4))/( 64 x20^2 g2^2) + (-16 x20^2 b2^2 g1^2 + 16 x20 (2 a2 b2^2 g1^2 + b1 (-x10^2 b1 + 2 x10 a1 b1 - a1^2 b1 + g1^2) g2^2) + g1^2 (-16 a2^2 b2^2 + 16 a2 b2 g2^2 - 3 g2^4))/( 32 x20 g1^2 g2^2); 
% 
% 
% c[x1,x2,x10,x20,2] = -((48 a2^2 b2^2 + 16 x20^2 (4 b1^2 + b2^2) - 48 a2 b2 g2^2 + 9 g2^4)/(384 x20^2)); 

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

a1 = param(1);
a2 = param(2);
b1 = param(3);
b2 = param(4);
g1 = param(5);
g2 = param(6);

Dv = log(x2)/2 + log(g1) + log(g2);
cm1 =  1/ 2 *(-((x1 - x10)^2/g1^2) - (x2 - x20)^2/(x20 *g2^2)) - ( 21* (x2 - x20)^6)/(256 *x20^5 *g2^2) + (7 *(x2 - x20)^5)/( 64 *x20^4* g2^2) - (5 *(x2 - x20)^4)/( 32* x20^3 *g2^2) + (x2 - x20)^3/(4 *x20^2 *g2^2);
c0 =  -(((x1 - x10)^2* b1)/( 2 *g1^2)) + ((x1 - x10)* (-x10 + a1)* b1)/g1^2 + ((x2 - x20)^4 *(-4* a2* b2 + g2^2))/( 16* x20^4 *g2^2) - ((x2 - x20)^3* (-4 *a2* b2 + g2^2))/( 12* x20^3 *g2^2) + ((x2 - x20)^2 *(-4 *a2* b2 + g2^2))/( 8* x20^2* g2^2) - ((x2 - x20)* (4* x20* b2 - 4* a2* b2 + g2^2))/(4 *x20* g2^2); 
c1 = -(((x1 - x10)^2 *b1^2)/( 6 *g1^2)) - ((x1 - x10)* (x10 - a1)* b1^2)/( 2* g1^2) + ((x2 - x20)^2* (16* x20^2 *b2^2 - 144* a2^2* b2^2 + 144 *a2 *b2 *g2^2 - 27 *g2^4))/( 768* x20^3 *g2^2) + ((x2 - x20)* (-16* x20^2* b2^2 + 16* a2^2* b2^2 - 16* a2* b2* g2^2 + 3* g2^4))/( 64* x20^2* g2^2) + (-16 *x20^2 *b2^2 *g1^2 + 16 *x20* (2* a2* b2^2* g1^2 + b1* (-x10^2* b1 + 2 *x10* a1* b1 - a1^2 *b1 + g1^2) *g2^2) + g1^2* (-16 *a2^2* b2^2 + 16* a2 *b2 *g2^2 - 3 *g2^4))/( 32* x20* g1^2 *g2^2); 
c2 = -((48 *a2^2* b2^2 + 16* x20^2* (4* b1^2 + b2^2) - 48* a2* b2* g2^2 + 9 *g2^4)/(384 *x20^2)); 
output = - log(2*pi*del) - Dv + cm1/del + c0 + c1*del + c2*del^2/2; 