function output = ModelB13(x,x0,del,param)
% Definition
% a1 = param(1);
% a2 = param(2);
% b11 = param(3);
% b12 = param(4);
% b21 = param(5);
% b22 = param(6);
% s11 = param(7);
% s12 = param(8);
% s21 = param(9);
% s22 = param(10);
% Model
% sigma11(x1, x2) = s11;
% sigma12(x1, x2) = s12;
% sigma21(x1, x2) = s21;
% sigma22(x1, x2) = s22;
% mu1(x1, x2) = b11*(a1 - x1) + b12*(a2 - x2);
% mu2(x1, x2) = b21*(a1 - x1) + b22*(a2 - x2);
% 

a1 = param(1);
a2 = param(2);
b11 = param(3);
b12 = param(4);
b21 = param(5);
b22 = param(6);
s11 = param(7);
s12 = param(8);
s21 = param(9);
s22 = param(10);

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

y1 = (x1*s22 - x2*s12)/(s11*s22 - s12*s21);
y2 = (x2*s11 - x1*s21)/(s11*s22 - s12*s21);
y10 = (x10*s22 - x20*s12)/(s11*s22 - s12*s21);
y20 = (x20*s11 - x10*s21)/(s11*s22 - s12*s21);

k11 = (b21*s11*s12 + b22*s12*s21 - b11*s11*s22 - b12*s21*s22)/(s12*s21 - s11*s22);
k12 = ((-b21)*s12^2 + s22*(b11*s12 - b22*s12 + b12*s22))/((-s12)*s21 + s11*s22);
k21 = (b21*s11^2 - s21*(b11*s11 - b22*s11 + b12*s21))/((-s12)*s21 + s11*s22);
k22 = (b21*s11*s12 - b11*s12*s21 + b22*s11*s22 - b12*s21*s22)/((-s12)*s21 + s11*s22);
g1 = (a2*s12 - a1*s22)/(s12*s21 - s11*s22);
g2 = (a2*s11 - a1*s21)/((-s12)*s21 + s11*s22);

Dv = (1/2)*log ((s12*s21 - s11*s22)^2);

cYm1 = (-(1/2))*(y1 - y10)^2 - (1/2)*(y2 - y20)^2;

cY0 = (-(1/2))*(y1 - y10)*(-2*g1*k11 + y1*k11 + y10*k11 - 2*g2*k12 + y2*k12 + y20*k12) - (1/2)*(y2 - y20)*(-2*g1*k21 + y1*k21 + y10*k21 - 2*g2*k22 + y2*k22 + y20*k22);

cY1 = (1/24)*(-4*(3*g1^2 + y1^2 + y1*y10 + y10^2 - 3*g1*(y1 + y10))*k11^2 + y1^2*k12^2 - 2*y1*y10*k12^2 + y10^2*k12^2 - 3*y2^2*k12^2 - 6*y2*y20*k12^2 - 3*y20^2*k12^2 - 4*k11*(-3 - 3*g2*(y1 + y10)*k12 + 2*y1*y2*k12 + y10*y2*k12 + 3*g1*(2*g2 - y2 - y20)*k12 + y1*y20*k12 + 2*y10*y20*k12) - 2*y1^2*k12*k21 + 4*y1*y10*k12*k21 - 2*y10^2*k12*k21 - 2*y2^2*k12*k21 + 4*y2*y20*k12*k21 - 2*y20^2*k12*k21 - 12*g1^2*k21^2 + 12*g1*y1*k21^2 - 3*y1^2*k21^2 + 12*g1*y10*k21^2 - 6*y1*y10*k21^2 - 3*y10^2*k21^2 + y2^2*k21^2 - 2*y2*y20*k21^2 + y20^2*k21^2 + 12*k22 + 12*g1*y2*k21*k22 - 8*y1*y2*k21*k22 - 4*y10*y2*k21*k22 + 12*g1*y20*k21*k22 - 4*y1*y20*k21*k22 - 8*y10*y20*k21*k22 - 4*y2^2*k22^2 - 4*y2*y20*k22^2 - 4*y20^2*k22^2 - 12*g2^2*(k12^2 + k22^2) + 12*g2*((-2*g1 + y1 + y10)*k21*k22 + y2*(k12^2 + k22^2) + y20*(k12^2 + k22^2)));

cY2 = (1/12)*((-(y1 - y10))*(2*g2 - y2 - y20)*k12^3 + k11^2*(-2 + (2*g1 - y1 - y10)*(y2 - y20)*(k12 - k21)) + (-2*g1* y1 + y1^2 + 2*g1*y10 - y10^2 + 2*g2*y2 - y2^2 - 2*g2*y20 + y20^2)*k11* k12*(k12 - k21) + k12^2*(-1 + (y1 - y10)*(2*g2 - y2 - y20)*k21) + k21^2*(-1 + (-2*g1 + y1 + y10)*(y2 - y20)*k21) + (-y1^2 + 2*g1*(y1 - y10) + y10^2 - 2*g2*y2 + y2^2 + 2*g2*y20 - y20^2)* k21^2*k22 + (-2 + (y1 - y10)*(2*g2 - y2 - y20)*k21)*k22^2 + k12*(k21*(-2 + (2*g1 - y1 - y10)*(y2 - y20)*k21) + (-2*g1*y1 + y1^2 + 2*g1*y10 - y10^2 + 2*g2*y2 - y2^2 - 2*g2*y20 + y20^2)*k21*k22 + (y1 - y10)*(-2*g2 + y2 + y20)*k22^2));

cY3 = (1/240)*(60* g1^2*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) + (y2 - y20)^2*(15*k12^4 - 5*k21^4 + 2*k11^2*(5*k12^2 + 6*k12*k21 - 3*k21^2) + 32*k11*k12*k21*k22 + 14*k21^2*k22^2 + 16*k22^4 - 2*k12^2*(k21^2 - 15*k22^2) + 4*k12*k21*(2*k21^2 + k22^2)) + y1^2*(16*k11^4 - 5*k12^4 + 8*k12^3*k21 + 2*k11^2*(7*k12^2 + 2*k12*k21 + 15*k21^2) + 32*k11*k12*k21*k22 + 12*k12*k21*k22^2 + 5*k21^2*(3*k21^2 + 2*k22^2) - 2*k12^2*(k21^2 + 3*k22^2)) + y10^2*(16*k11^4 - 5*k12^4 + 8*k12^3*k21 + 2*k11^2*(7*k12^2 + 2*k12*k21 + 15*k21^2) + 32*k11*k12*k21*k22 + 12*k12*k21*k22^2 + 5*k21^2*(3*k21^2 + 2*k22^2) - 2*k12^2*(k21^2 + 3*k22^2)) - 8*y10*(y2 - y20)*(4*k11^3*k12 + 4*k11^2*k21*k22 + k11*k12*(5*k12^2 - 2*k12*k21 + 5*k21^2 + 4*k22^2) + k21*k22*(5*k12^2 - 2*k12*k21 + 5*k21^2 + 4*k22^2)) + 60*((g2 - y20)^2*(k11^2*k12^2 + k12^4 + 2*k11*k12*k21*k22 + 2*k12^2*k22^2 + k21^2*k22^2 + k22^4) + y10^2*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) - 2*y10*(g2 - y20)*(k11^3*k12 + k11^2*k21*k22 + k11*k12*(k12^2 + k21^2 + k22^2) + k21*k22*(k12^2 + k21^2 + k22^2))) - 60*g1*(y1*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) + y10*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) - (2*g2 - y2 - y20)*(k11^3*k12 + k11^2*k21*k22 + k11*k12*(k12^2 + k21^2 + k22^2) + k21*k22*(k12^2 + k21^2 + k22^2))) - 2*y1*(y10*(16*k11^4 - 5*k12^4 + 8*k12^3*k21 + 2*k11^2*(7*k12^2 + 2*k12*k21 + 15*k21^2) + 32*k11*k12*k21*k22 + 12*k12*k21*k22^2 + 5*k21^2*(3*k21^2 + 2*k22^2) - 2*k12^2*(k21^2 + 3*k22^2)) - 4*(y2 - y20)*(4*k11^3*k12 + 4*k11^2*k21*k22 + k11*k12*(5*k12^2 - 2*k12*k21 + 5*k21^2 + 4*k22^2) + k21*k22*(5*k12^2 - 2*k12*k21 + 5*k21^2 + 4*k22^2))) + 60*((g2 - y20)*(-y2 + y20)*(k11^2*k12^2 + k12^4 + 2*k11*k12*k21*k22 + 2*k12^2*k22^2 + k21^2*k22^2 + k22^4) - y10^2*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) + y10*(g2 + y2 - 2*y20)*(k11^3*k12 + k11^2*k21*k22 + k11*k12*(k12^2 + k21^2 + k22^2) + k21*k22*(k12^2 + k21^2 + k22^2)) + y1*(y10*(k11^4 + k11^2*(k12^2 + 2*k21^2) + 2*k11*k12*k21*k22 + k21^2*(k21^2 + k22^2)) - (g2 - y20)*(k11^3*k12 + k11^2*k21*k22 + k11*k12*(k12^2 + k21^2 + k22^2) + k21*k22*(k12^2 + k21^2 + k22^2)))));

output = -Dv - log(2*pi*del) + cYm1/del + cY0 + cY1*del + cY2*(del^2/2) + cY3*(del^3/6);

