function output = ModelB14(x,x0,del,param)

% Definition
% k1 = param(1);
% k2 = param(2);
% theta = param(3);
% sigma1 = param(4);
% sigma2 = param(5);

% Model for Xing Hu 6/19/09
% 
% \[Mu]1[x1_, x2_] = k1*x2 - k1*x1; 
% \[Mu]2[x1_, x2_] = k2*theta - k2*x2; 
% \[Sigma]11[x1_, x2_] = sigma1*Sqrt[x1]; 
% \[Sigma]22[x1_, x2_] = sigma2*Sqrt[x2]; 
% \[Sigma]12[x1_, x2_] = 0; 
% \[Sigma]21[x1_, x2_] = 0; 
% 
% delorder = 2; 
% 
% Dv[x1_, x2_] = Log[sigma1] + Log[sigma2] + (1/2)*Log[x1] + (1/2)*Log[x2]; 
% 
% x10*and*x20*designate*the*two*components*of*the*vector*x0*(the*backward*variable); 
% 
% The*expansion*at*order*delorder = K = 2*for*the*log - transition*function*(is:
% 
% lnpX[del, x1, x2, x10, x20, 2]) =  c[x1, x2, x10, x20, 1]*del + c[x1, x2, x10, x20, 0] + (1/2)*del^2*c[x1, x2, x10, x20, 2] - Dv[x1, x2] - Log[2*Pi*del] +  c[x1, x2, x10, x20, -1]/del; 
% 
% c[x1, x2, x10, x20, -1] = -((21*(x1 - x10)^6)/(256*sigma1^2*x10^5)) + (7*(x1 - x10)^5)/(64*sigma1^2*x10^4) -  (5*(x1 - x10)^4)/(32*sigma1^2*x10^3) + (x1 - x10)^3/(4*sigma1^2*x10^2) +  (1/2)*(-((x1 - x10)^2/(sigma1^2*x10)) - (x2 - x20)^2/(sigma2^2*x20)) - (21*(x2 - x20)^6)/(256*sigma2^2*x20^5) +  (7*(x2 - x20)^5)/(64*sigma2^2*x20^4) - (5*(x2 - x20)^4)/(32*sigma2^2*x20^3) + (x2 - x20)^3/(4*sigma2^2*x20^2); 
% 
% c[x1, x2, x10, x20, 0] = (5*k1*(x1 - x10)^3*(x2 - x20))/(24*sigma1^2*x10^3) - (7*k1*(x1 - x10)^2*(x2 - x20))/(24*sigma1^2*x10^2) +  (k1*(x1 - x10)*(x2 - x20))/(2*sigma1^2*x10) + ((sigma2^2 - 4*k2*theta)*(x2 - x20)^4)/(16*sigma2^2*x20^4) -  ((sigma2^2 - 4*k2*theta)*(x2 - x20)^3)/(12*sigma2^2*x20^3) + ((sigma2^2 - 4*k2*theta)*(x2 - x20)^2)/(8*sigma2^2*x20^2) +  (k1*(x1 - x10)*(x2 - x20)^3)/(48*sigma1^2*x10*x20^2) + (k1*(x1 - x10)^2*(x2 - x20)^2)/(48*sigma1^2*x10^2*x20) -  (k1*(x1 - x10)*(x2 - x20)^2)/(24*sigma1^2*x10*x20) + ((x1 - x10)^4*(sigma1^2 - 4*k1*x20))/(16*sigma1^2*x10^4) -  ((x1 - x10)^3*(sigma1^2 - 4*k1*x20))/(12*sigma1^2*x10^3) + ((x1 - x10)^2*(sigma1^2 - 4*k1*x20))/(8*sigma1^2*x10^2) -  ((x1 - x10)*(sigma1^2 + 4*k1*x10 - 4*k1*x20))/(4*sigma1^2*x10) - ((x2 - x20)*(sigma2^2 - 4*k2*theta + 4*k2*x20))/(4*sigma2^2*x20); 
% 
% c[x1, x2, x10, x20, 1] = (k1*(x1 - x10)*(x2 - x20)*(-9*sigma1^2 + 16*k1*x20))/(48*sigma1^2*x10^2) +  ((x1 - x10)^2*(-27*sigma1^6 + 144*k1*sigma1^4*x20 + 32*k1^2*sigma2^2*x10*x20 +  16*k1*sigma1^2*((-sigma2^2)*x10 + k1*(x10^2 - 9*x20^2))))/(768*sigma1^4*x10^3) +  ((x1 - x10)*(9*sigma1^4 - 48*k1*sigma1^2*x20 + 8*k1*(sigma2^2*x10 + 6*k1*(-x10^2 + x20^2))))/(192*sigma1^2*x10^2) +  ((x2 - x20)*(96*k1^2*sigma2^2*(x10 - x20)*x20^2 + sigma1^2*(9*sigma2^4*x10 + 48*k2^2*x10*(theta^2 - x20^2) -  8*sigma2^2*(6*k2*theta*x10 - 7*k1*x20^2))))/(192*sigma1^2*sigma2^2*x10*x20^2) +  ((x2 - x20)^2*(-32*k1^2*sigma2^2*x20^2*(x10 + 2*x20) + sigma1^2*(-27*sigma2^4*x10 + 16*k2^2*x10*(-9*theta^2 + x20^2) +  16*sigma2^2*(9*k2*theta*x10 - k1*x20^2))))/(768*sigma1^2*sigma2^2*x10*x20^3) +  (-3*sigma1^4*sigma2^2*x20 - 16*k1^2*sigma2^2*(x10 - x20)^2*x20 + sigma1^2*(-3*sigma2^4*x10 - 16*k2^2*x10*(theta - x20)^2 +  16*sigma2^2*(k2*theta*x10 + k1*x20^2)))/(32*sigma1^2*sigma2^2*x10*x20); 
% 
% c[x1, x2, x10, x20, 2] = (1/(384*sigma1^2*x10^2*x20^2))*(-9*sigma1^6*x20^2 + 32*k1^2*sigma2^2*x10*(x10 - 2*x20)*x20^2 +  48*k1*sigma1^4*x20^3 - sigma1^2*(9*sigma2^4*x10^2 - 16*sigma2^2*x10*(3*k2*theta*x10 + k1*x20^2) +  16*(k2^2*x10^2*(3*theta^2 + x20^2) + k1^2*x20^2*(x10^2 + 3*x20^2))));

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

k1 = param(1);
k2 = param(2);
theta = param(3);
sigma1 = param(4);
sigma2 = param(5);


Dv = log(sigma1) + log(sigma2) + (1/2)*log(x1) + (1/2)*log(x2); 
cm1 = -((21*(x1 - x10)^6)/(256*sigma1^2*x10^5)) + (7*(x1 - x10)^5)/(64*sigma1^2*x10^4) -  (5*(x1 - x10)^4)/(32*sigma1^2*x10^3) + (x1 - x10)^3/(4*sigma1^2*x10^2) +  (1/2)*(-((x1 - x10)^2/(sigma1^2*x10)) - (x2 - x20)^2/(sigma2^2*x20)) - (21*(x2 - x20)^6)/(256*sigma2^2*x20^5) +  (7*(x2 - x20)^5)/(64*sigma2^2*x20^4) - (5*(x2 - x20)^4)/(32*sigma2^2*x20^3) + (x2 - x20)^3/(4*sigma2^2*x20^2);
c0 = (5*k1*(x1 - x10)^3*(x2 - x20))/(24*sigma1^2*x10^3) - (7*k1*(x1 - x10)^2*(x2 - x20))/(24*sigma1^2*x10^2) +  (k1*(x1 - x10)*(x2 - x20))/(2*sigma1^2*x10) + ((sigma2^2 - 4*k2*theta)*(x2 - x20)^4)/(16*sigma2^2*x20^4) -  ((sigma2^2 - 4*k2*theta)*(x2 - x20)^3)/(12*sigma2^2*x20^3) + ((sigma2^2 - 4*k2*theta)*(x2 - x20)^2)/(8*sigma2^2*x20^2) +  (k1*(x1 - x10)*(x2 - x20)^3)/(48*sigma1^2*x10*x20^2) + (k1*(x1 - x10)^2*(x2 - x20)^2)/(48*sigma1^2*x10^2*x20) -  (k1*(x1 - x10)*(x2 - x20)^2)/(24*sigma1^2*x10*x20) + ((x1 - x10)^4*(sigma1^2 - 4*k1*x20))/(16*sigma1^2*x10^4) -  ((x1 - x10)^3*(sigma1^2 - 4*k1*x20))/(12*sigma1^2*x10^3) + ((x1 - x10)^2*(sigma1^2 - 4*k1*x20))/(8*sigma1^2*x10^2) -  ((x1 - x10)*(sigma1^2 + 4*k1*x10 - 4*k1*x20))/(4*sigma1^2*x10) - ((x2 - x20)*(sigma2^2 - 4*k2*theta + 4*k2*x20))/(4*sigma2^2*x20);
c1 = (k1*(x1 - x10)*(x2 - x20)*(-9*sigma1^2 + 16*k1*x20))/(48*sigma1^2*x10^2) +  ((x1 - x10)^2*(-27*sigma1^6 + 144*k1*sigma1^4*x20 + 32*k1^2*sigma2^2*x10*x20 +  16*k1*sigma1^2*((-sigma2^2)*x10 + k1*(x10^2 - 9*x20^2))))/(768*sigma1^4*x10^3) +  ((x1 - x10)*(9*sigma1^4 - 48*k1*sigma1^2*x20 + 8*k1*(sigma2^2*x10 + 6*k1*(-x10^2 + x20^2))))/(192*sigma1^2*x10^2) +  ((x2 - x20)*(96*k1^2*sigma2^2*(x10 - x20)*x20^2 + sigma1^2*(9*sigma2^4*x10 + 48*k2^2*x10*(theta^2 - x20^2) -  8*sigma2^2*(6*k2*theta*x10 - 7*k1*x20^2))))/(192*sigma1^2*sigma2^2*x10*x20^2) +  ((x2 - x20)^2*(-32*k1^2*sigma2^2*x20^2*(x10 + 2*x20) + sigma1^2*(-27*sigma2^4*x10 + 16*k2^2*x10*(-9*theta^2 + x20^2) +  16*sigma2^2*(9*k2*theta*x10 - k1*x20^2))))/(768*sigma1^2*sigma2^2*x10*x20^3) +  (-3*sigma1^4*sigma2^2*x20 - 16*k1^2*sigma2^2*(x10 - x20)^2*x20 + sigma1^2*(-3*sigma2^4*x10 - 16*k2^2*x10*(theta - x20)^2 +  16*sigma2^2*(k2*theta*x10 + k1*x20^2)))/(32*sigma1^2*sigma2^2*x10*x20);
c2 = (1/(384*sigma1^2*x10^2*x20^2))*(-9*sigma1^6*x20^2 + 32*k1^2*sigma2^2*x10*(x10 - 2*x20)*x20^2 +  48*k1*sigma1^4*x20^3 - sigma1^2*(9*sigma2^4*x10^2 - 16*sigma2^2*x10*(3*k2*theta*x10 + k1*x20^2) +  16*(k2^2*x10^2*(3*theta^2 + x20^2) + k1^2*x20^2*(x10^2 + 3*x20^2))));
output = c1*del + c0 + (1/2)*del^2*c2 - Dv - log(2*pi*del) +  cm1/del;
