function output = ModelB18(x,x0,del,param)

% Definition
% b1 = param(1);
% a2 = param(2);
% b2 = param(3);
% g11 = param(4);
% g22 = param(5);
% r = param(6);

% \[Mu]1[x1_, x2_] = b1*x1; 
% \[Mu]2[x1_, x2_] = a2 + b2*x2; 
% \[Sigma]11[x1_, x2_] = g11*E^x1; 
% \[Sigma]22[x1_, x2_] = g22*Sqrt[1 - r^2]; 
% \[Sigma]12[x1_, x2_] = 0; 
% \[Sigma]21[x1_, x2_] = g22*r; 
% Dv[x1_, x2_] = Log[g11] + Log[g22] + (1/2)*Log[1 - r^2] + x1

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

b1 = param(1);
a2 = param(2);
b2 = param(3);
g11 = param(4);
g22 = param(5);
r = param(6);

E = exp(1);

Dv = log(g11) + log(g22) + (1/2)*log(1 - r^2) + x1;   

cm1 = -((x1 - x10)^3/(E^(2*x10)*(2*g11^2*(-1 + r^2)))) + (7*(x1 - x10)^4)/(E^(2*x10)*(24*g11^2*(-1 + r^2))) - (x1 - x10)^5/(E^(2*x10)*(8*g11^2*(-1 + r^2))) + (31*(x1 - x10)^6)/(E^(2*x10)*(720*g11^2*(-1 + r^2))) + (g22^2*(x1 - x10)^2 + 2*E^x10*g11*g22*r*(-x1 + x10)*(x2 - x20) + E^(2*x10)*g11^2*(x2 - x20)^2)/(E^(2*x10)*(2*g11^2*g22^2*(-1 + r^2))) - (r*(x1 - x10)^2*(x2 - x20))/(E^x10*(2*g11*g22 - 2*g11*g22*r^2)) + (r*(x1 - x10)^3*(x2 - x20))/(E^x10*(6*g11*g22 - 6*g11*g22*r^2)) - (r*(x1 - x10)^4*(x2 - x20))/(E^x10*(24*g11*g22 - 24*g11*g22*r^2)) + (r*(x1 - x10)^5*(x2 - x20))/(E^x10*(120*g11*g22 - 120*g11*g22*r^2));

c0 = -((r*(-2*b2 + E^(2*x10)*g11^2 + 2*b1*(-1 + x10))*(x1 - x10)*(x2 - x20))/(E^x10*(4*g11*g22*(-1 + r^2)))) - (r*(6*b2 + E^(2*x10)*g11^2 + b1*(10 - 6*x10))*(x1 - x10)^2*(x2 - x20))/(E^x10*(24*g11*g22*(-1 + r^2))) +   (r*(2*b2 + b1*(5 - 2*x10))*(x1 - x10)^3*(x2 - x20))/(E^x10*(24*g11*g22*(-1 + r^2))) - (b2*(x2 - x20)^2)/(2*g22^2*(-1 + r^2)) + ((x2 - x20)*(2*a2*g11 + E^x10*g11^2*g22*r - (2*b1*g22*r*x10)/E^x10 + 2*b2*g11*x20))/(2*g11*g22^2 - 2*g11*g22^2*r^2) +   ((x1 - x10)^4*(4*b1*g22*(-3 + 2*x10) - E^x10*g11*r*(a2 + b2*x20)))/(E^(2*x10)*(24*g11^2*g22*(-1 + r^2))) + ((x1 - x10)^2*(b1*g22*(-1 + 2*x10) - E^x10*g11*r*(a2 + b2*x20)))/(E^(2*x10)*(2*g11^2*g22*(-1 + r^2))) +   ((x1 - x10)^3*(-4*b1*g22*(-1 + x10) + E^x10*g11*r*(a2 + b2*x20)))/(E^(2*x10)*(6*g11^2*g22*(-1 + r^2))) + ((x1 - x10)*(E^(2*x10)*g11^2*g22 - 2*b1*g22*x10 + 2*E^x10*g11*r*(a2 + b2*x20)))/(E^(2*x10)*(2*g11^2*g22*(-1 + r^2)));

c1 = -((r*(x1 - x10)*(4*b2^2*r^2 - 4*b2*E^(2*x10)*g11^2*(-2 + r^2) + E^(4*x10)*g11^4*(-6 + 7*r^2) + 4*b1^2*r^2*(-1 + x10)^2 - 2*b1*(4*b2*(-2 + r^2)*(-1 + x10) - E^(2*x10)*g11^2*(-1 + r^2*(-1 + 2*x10))))*(x2 - x20))/(E^x10*(48*g11*g22*(-1 + r^2)^2))) +   ((4*b2^2*(-4 + 5*r^2) + 4*b2*r^2*(E^(2*x10)*g11^2 + 2*b1*(-1 + x10)) + r^2*(E^(2*x10)*g11^2 + 2*b1*(-1 + x10))^2)*(x2 - x20)^2)/(96*g22^2*(-1 + r^2)^2) +   ((x2 - x20)*(6*a2*b2*g11 - (b1*g22*r*(E^(2*x10)*g11^2 + 6*b2*x10))/E^x10 + g11*(3*b2*E^x10*g11*g22*r - E^(3*x10)*g11^3*g22*r + 6*b2^2*x20)))/(12*g11*g22^2*(-1 + r^2)) +   ((x1 - x10)*(-12*b1^2*g22*(-1 + x10)*x10 + E^(3*x10)*g11^3*(E^x10*g11*g22*(-3 + 8*r^2) + 6*r*(a2 + b2*x20)) + 4*b1*E^x10*g11*(E^x10*g11*g22*(-3 + 2*r^2) + 3*r*(-1 + x10)*(a2 + b2*x20))))/(E^(2*x10)*(24*g11^2*g22*(-1 + r^2))) +   (1/(96*g11^2*g22*(-1 + r^2)^2))*(((x1 - x10)^2*(4*b2^2*g22*r^2 + 4*b2*E^(2*x10)*g11^2*g22*r^2 + E^(4*x10)*g11^4*g22*(6 - 25*r^2 + 20*r^4) + 4*b1^2*g22*(-2*(2 - 9*x10 + 5*x10^2) + r^2*(5 - 20*x10 + 11*x10^2)) +       4*E^(3*x10)*g11^3*r*(-1 + r^2)*(a2 + b2*x20) - 4*b1*(-2*b2*g22*r^2*(-1 + x10) + E^(2*x10)*g11^2*g22*(2 + r^4 - r^2*(2 + x10)) + 2*E^x10*g11*r*(-1 + r^2)*(-5 + 3*x10)*(a2 + b2*x20))))/E^(2*x10)) +   (4*a2^2*E^(2*x10)*g11^2 + 4*b1^2*g22^2*x10^2 + 4*a2*E^x10*g11*(E^(2*x10)*g11^2*g22*r - 2*b1*g22*r*x10 + 2*b2*E^x10*g11*x20) + 4*b1*E^x10*g11*g22*(E^x10*g11*g22*(1 + r^2*(-1 + x10) - 2*x10) - 2*b2*r*x10*x20) +     E^(2*x10)*g11^2*(E^(2*x10)*g11^2*g22^2*(-1 + 2*r^2) + 4*b2^2*x20^2 - 4*b2*g22*(g22*(-1 + r^2) - E^x10*g11*r*x20)))/(E^(2*x10)*(8*g11^2*g22^2*(-1 + r^2)));

c2 = (-4*b2^2*g22*(-2 + r^2) + E^(3*x10)*g11^3*(8*a2*r + E^x10*g11*g22*(-6 + 11*r^2)) - 4*b1^2*g22*(r^2*(-1 + x10)^2 - 2*(1 - 3*x10 + x10^2)) + 4*b2*E^(2*x10)*g11^2*r*(g22*r + 2*E^x10*g11*x20) +    b1*(-4*E^(2*x10)*g11^2*g22*(2 + r^2*(-2 + x10)) + 8*b2*g22*r^2*(-1 + x10) + 8*E^x10*g11*r*(a2 + b2*x20)))/(48*g22*(-1 + r^2));

output = -log(2*pi*del) - Dv + cm1/del + c0 + c1*del + c2 * del^2 / 2;
