function output = ModelB19(x,x0,del,param)

% Definition
% b1 = param(1);
% a2 = param(2);
% b2 = param(3);
% g22 = param(4);
% r = param(5);

% \[Mu]1[x1_, x2_] = b1*x1; 
% \[Mu]2[x1_, x2_] = a2 + b2*x2; 
% \[Sigma]11[x1_, x2_] = E^x2; 
% \[Sigma]22[x1_, x2_] = g22*Sqrt[1 - r^2]; 
% \[Sigma]12[x1_, x2_] = 0; 
% \[Sigma]21[x1_, x2_] = g22*r; 
% Dv[x1_, x2_] = Log[g22] + (1/2)*Log[1 - r^2] + x2

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

b1 = param(1);
a2 = param(2);
b2 = param(3);
g22 = param(4);
r = param(5);

E = exp(1);

Dv = log(g22) + (1/2)*log(1 - r^2) + x2;   

cm1 = (g22^2*(x1 - x10)^4)/(E^(4*x20)*(24*(-1 + r^2)^2)) + (g22^4*(x1 - x10)^6)/(E^(6*x20)*(180*(-1 + r^2)^3)) + ((x1 - x10)^2*(x2 - x20))/(E^(2*x20)*(2 - 2*r^2)) - (g22*r*(x1 - x10)^3*(x2 - x20))/(E^(3*x20)*(6*(-1 + r^2)^2)) - (g22^2*(x1 - x10)^4*(x2 - x20))/(E^(4*x20)*(12*(-1 + r^2)^2)) - (g22^3*r*(x1 - x10)^5*(x2 - x20))/(E^(5*x20)*(30*(-1 + r^2)^3)) + (r*(x1 - x10)*(x2 - x20)^2)/(E^x20*(2*g22*(-1 + r^2))) + ((-2 + 5*r^2)*(x1 - x10)^2*(x2 - x20)^2)/(E^(2*x20)*(12*(-1 + r^2)^2)) + (g22*r*(x1 - x10)^3*(x2 - x20)^2)/(E^(3*x20)*(4*(-1 + r^2)^2)) + (g22^2*(-4 + 9*r^2)*(x1 - x10)^4*(x2 - x20)^2)/(E^(4*x20)*(60*(-1 + r^2)^3)) - (r^3*(x1 - x10)*(x2 - x20)^3)/(E^x20*(6*g22*(-1 + r^2)^2)) - (r^2*(x1 - x10)^2*(x2 - x20)^3)/(E^(2*x20)*(4*(-1 + r^2)^2)) + (g22*r*(23 - 43*r^2)*(x1 - x10)^3*(x2 - x20)^3)/(E^(3*x20)*(180*(-1 + r^2)^3)) + (r^2*(x2 - x20)^4)/(24*g22^2*(-1 + r^2)^2) + ((r + r^3)*(x1 - x10)*(x2 - x20)^4)/(E^x20*(24*g22*(-1 + r^2)^2)) + ((-8 - 17*r^2 + 85*r^4)*(x1 - x10)^2*(x2 - x20)^4)/(E^(2*x20)*(720*(-1 + r^2)^3)) - (r^3*(3 + r^2)*(x1 - x10)*(x2 - x20)^5)/(E^x20*(120*g22*(-1 + r^2)^3)) + (r^2*(3 + r^2)*(x2 - x20)^6)/(720*g22^2*(-1 + r^2)^3) + (g22^2*(x1 - x10)^2 + E^(2*x20)*(x2 - x20)^2 + 2*E^x20*g22*r*(x1 - x10)*(-x2 + x20))/(E^(2*x20)*(2*g22^2*(-1 + r^2)));

c0 = ((-6*b1 + g22^2)*(x1 - x10)^2)/(E^(2*x20)*(12*(-1 + r^2))) + (g22^2*(-60*b1 + 7*g22^2)*(x1 - x10)^4)/(E^(4*x20)*(720*(-1 + r^2)^2)) + (g22*(x1 - x10)^3*(2*a2*E^x20*r + 2*b1*(E^x20*r - 2*g22*x10) + E^x20*r*(g22^2 + 2*b2*(-1 + x20))))/(E^(4*x20)*(24*(-1 + r^2)^2)) + ((x1 - x10)^2*(2*b1*(E^x20*(-8 + 5*r^2) + 6*g22*r*x10) - E^x20*(g22^2*(-2 + 5*r^2) + 6*r^2*(a2 + b2*(-1 + x20))))*(x2 - x20))/(E^(3*x20)*(24*(-1 + r^2)^2)) + ((x1 - x10)*(-6*a2*E^x20*r + 6*b1*(E^x20*r + 2*g22*x10) - E^x20*r*(5*g22^2 + 6*b2*(-1 + x20)))*(x2 - x20))/(E^(2*x20)*(12*g22*(-1 + r^2))) - ((6*b2 + g22*(-g22 + (6*b1*r*x10)/E^x20))*(x2 - x20)^2)/(12*g22^2*(-1 + r^2)) - (r^2*(2*a2*E^x20 + 2*b1*(E^x20 - 2*g22*r*x10) + E^x20*(g22^2 + 2*b2*(-1 + x20)))*(x2 - x20)^3)/ (E^x20*(24*g22^2*(-1 + r^2)^2)) + ((E^x20*(-30*b2*r^2 + g22^2*(2 + 5*r^2)) - 30*b1*g22*r*(1 + r^2)*x10)*(x2 - x20)^4)/(E^x20*(720*g22^2*(-1 + r^2)^2)) - ((x2 - x20)*(2*a2 + g22^2 - (2*b1*g22*r*x10)/E^x20 + 2*b2*x20))/(2*g22^2*(-1 + r^2)) + ((x1 - x10)*(2*a2*E^x20*r - 2*b1*g22*x10 + E^x20*r*(g22^2 + 2*b2*x20)))/ (E^(2*x20)*(2*g22*(-1 + r^2))) - (g22*(x1 - x10)^3*(x2 - x20)*(90*a2*E^x20*r - 30*b1*(3*E^x20*r + 8*g22*x10) + E^x20*r*(73*g22^2 + 30*b2*(-4 + 3*x20))))/ (E^(4*x20)*(720*(-1 + r^2)^2)) + ((x1 - x10)^2*(x2 - x20)^2*(-30*b1*(4*E^x20*(-1 + r^2) + 9*g22*r*x10) + E^x20*(g22^2*(-8 + 74*r^2) + 45*r^2*(2*a2 - 3*b2 + 2*b2*x20))))/ (E^(3*x20)*(360*(-1 + r^2)^2)) - (r*(x1 - x10)*(x2 - x20)^3*(30*a2*E^x20*(1 + 2*r^2) - 30*b1*(E^x20*(-3 + 2*r^2) + 12*g22*r*x10) + E^x20*(g22^2*(23 + 50*r^2) + 30*b2*(-1 + x20 + r^2*(-5 + 2*x20)))))/(E^(2*x20)*(720*g22*(-1 + r^2)^2)) + ((x1 - x10)*(x2 - x20)^2*(b1*(-6*E^x20*r*(-2 + r^2) + 4*g22*(2 - 5*r^2)*x10) + E^x20*r*(6*a2*r^2 + g22^2*(-2 + 5*r^2) + 2*b2*(2 + r^2*(-5 + 3*x20)))))/(E^(2*x20)*(24*g22*(-1 + r^2)^2));

c1 = -(((x1 - x10)*(6*a2*b1*E^x20*r + b2*E^x20*g22^2*r - 6*b1^2*g22*x10 + b1*(E^x20*g22^2*r + 2*g22^3*x10 + 6*b2*E^x20*r*x20)))/(E^(2*x20)*(12*g22*(-1 + r^2)))) + ((x2 - x20)*(-6*b1^2*g22^2*x10^2 + 6*a2*E^x20*(b2*E^x20 + b1*g22*r*x10) + 2*b2*E^(2*x20)*(2*g22^2*r^2 + 3*b2*x20) - b1*E^x20*g22*(2*E^x20*g22 + r*x10*(6*b2 - 5*g22^2 - 6*b2*x20))))/ (E^(2*x20)*(12*g22^2*(-1 + r^2))) + (1/(24*g22^2*(-1 + r^2)))* ((12*a2^2*E^(2*x20) + 12*b1^2*g22^2*x10^2 + E^(2*x20)*(g22^4*(1 + 2*r^2) + 12*b2*g22^2*(1 + r^2*(-1 + x20)) + 12*b2^2*x20^2) - 12*b1*E^x20*g22*(E^x20*g22*(-1 + r^2) + r*x10*(g22^2 + 2*b2*x20)) + 12*a2*E^x20*(-2*b1*g22*r*x10 + E^x20*(g22^2*r^2 + 2*b2*x20)))/E^(2*x20)) + (1/(720*g22*(-1 + r^2)^2))*(((x1 - x10)*(x2 - x20)*(-60*a2^2*E^(2*x20)*r^3 - 60*b1^2*(E^(2*x20)*r^3 + 2*E^x20*g22*(-5 + 2*r^2)*x10 + 6*g22^2*r*x10^2) + 60*a2*E^x20*r*(2*b1*(E^x20*(-3 + r^2) + 3*g22*r*x10) + E^x20*((-g22^2)*r^2 + b2*(2 - 2*r^2*(-1 + x20)))) + 60*b1*E^x20*(g22^2*(E^x20*r*(-3 + r^2) + g22*(-2 + 5*r^2)*x10) + 2*b2*r*(E^x20*(2 + r^2*(-1 + x20) - 3*x20) + 3*g22*r*x10*(-1 + x20))) - E^(2*x20)*r*(g22^4*(4 + 11*r^2) + 60*b2^2*(r^2*(-1 + x20)^2 - 2*x20) + 30*b2*g22^2*(1 + r^2*(-5 + 2*x20)))))/E^(3*x20)) + (1/(1440*(-1 + r^2)^2))*(((x1 - x10)^2*(60*b1^2*(E^(2*x20)*(-4 + 5*r^2) - 6*E^x20*g22*r*x10 + 6*g22^2*x10^2) + E^(2*x20)*(60*a2^2*r^2 + g22^4*(4 + 11*r^2) + 60*a2*(g22^2*r^2 + 2*b2*(-1 + r^2*(-1 + x20))) + 60*b2^2*(r^2*(-1 + x20)^2 - 2*x20) + 60*b2*g22^2*r^2*(-2 + x20)) + 60*b1*E^x20*(-3*g22*r*x10*(2*a2 + g22^2 + 2*b2*(-1 + x20)) + 2*E^x20*(g22^2 + r^2*(2*a2 + b2*(-1 + 2*x20))))))/E^(4*x20)) + (1/(1440*g22^2*(-1 + r^2)^2))*(((x2 - x20)^2*(E^(2*x20)*(60*(a2^2 + 4*a2*b1 + b1^2)*r^2 + 60*(a2 + 2*b1)*g22^2*r^2 + g22^4*(4 + 11*r^2)) - 60*b1*E^x20*g22*r*(6*b1 + 6*a2*r^2 + g22^2*(-2 + 5*r^2))*x10 + 120*b1^2*g22^2*(-2 + 5*r^2)*x10^2 + 60*b2^2*E^(2*x20)*(-4 + r^2*(5 - 4*x20 + x20^2)) - 60*b2*E^x20*r*(E^x20*g22^2*r*(1 + r^2 - x20) - 2*a2*E^x20*r*(-2 + x20) + b1*(-2*E^x20*r*(-1 + 2*x20) + 2*g22*x10*(2 + r^2*(-5 + 3*x20))))))/E^(2*x20));

c2 = (1/(720*(-1 + r^2)))*((-60*b1^2*(E^(2*x20)*(-2 + r^2) + 4*E^x20*g22*r*x10 - 2*g22^2*x10^2) + 60*b1*E^x20*r*(2*a2*E^x20*r + E^x20*g22^2*r + 2*b2*(g22*x10 + E^x20*r*(-1 + x20))) - E^(2*x20)*(60*a2^2*r^2 + g22^4*(4 + 11*r^2) + 60*a2*(g22^2*r^2 + 2*b2*(1 + r^2*(-1 + x20))) + 60*b2^2*(2 + r^2*(-1 + x20))*(-1 + x20) + 60*b2*g22^2*r^2*x20))/E^(2*x20));

output = -log(2*pi*del) - Dv + cm1/del + c0 + c1*del + c2 * del^2 / 2;
