function output = ModelB20(x,x0,del,param)

% \[Mu]1[x1_, x2_] = a1 + b1*x1; 
% \[Mu]2[x1_, x2_] = a2 + b2*x2; 
% \[Sigma]11[x1_, x2_] = Sqrt[x2]; 
% \[Sigma]12[x1_, x2_] = 0; 
% \[Sigma]21[x1_, x2_] = g*r*Sqrt[x2]; 
% \[Sigma]22[x1_, x2_] = g*Sqrt[1 - r^2]*Sqrt[x2]; 
% Dv[x1_, x2_] = Log[g] + (1/2)*Log[1 - r^2] + x2


x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

a1 = param(1);
b1 = param(2);
a2 = param(3);
b2 = param(4);
g = param(5);
r = param(6);

E = exp(1);

Dv = log(g) + (1/2)*log(1 - r^2) + x2;   

cm1 = (7*g^4*(x1 - x10)^6)/(11520*(-1 + r^2)^3*x20^5) - (7*g^3*r*(x1 - x10)^5*(x2 - x20))/(1920*(-1 + r^2)^3*x20^5) + (g^2*(-193 + 298*r^2)*(x1 - x10)^4*(x2 - x20)^2)/(11520*(-1 + r^2)^3*x20^5) + (g*r*(193 - 228*r^2)*(x1 - x10)^3*(x2 - x20)^3)/(2880*(-1 + r^2)^3*x20^5) + ((745 - 2648*r^2 + 2008*r^4)*(x1 - x10)^2*(x2 - x20)^4)/(11520*(-1 + r^2)^3*x20^5) + ((-745*r + 1876*r^3 - 1152*r^5)*(x1 - x10)*(x2 - x20)^5)/(5760*g*(-1 + r^2)^3*x20^5) + ((945 - 2090*r^2 + 1152*r^4)*(x2 - x20)^6)/(11520*g^2*(-1 + r^2)^3*x20^5) - (g^2*(x1 - x10)^4*(x2 - x20))/(64*(-1 + r^2)^2*x20^4) + (g*r*(x1 - x10)^3*(x2 - x20)^2)/(16*(-1 + r^2)^2*x20^4) + ((3 - 6*r^2)*(x1 - x10)^2*(x2 - x20)^3)/(32*(-1 + r^2)^2*x20^4) + (r*(-3 + 4*r^2)*(x1 - x10)*(x2 - x20)^4)/(16*g*(-1 + r^2)^2*x20^4) + ((7 - 8*r^2)*(x2 - x20)^5)/(64*g^2*(-1 + r^2)^2*x20^4) + (g^2*(x1 - x10)^4)/(96*(-1 + r^2)^2*x20^3) - (g*r*(x1 - x10)^3*(x2 - x20))/(24*(-1 + r^2)^2*x20^3) + ((-7 + 10*r^2)*(x1 - x10)^2*(x2 - x20)^2)/(48*(-1 + r^2)^2*x20^3) + ((7*r - 8*r^3)*(x1 - x10)*(x2 - x20)^3)/(24*g*(-1 + r^2)^2*x20^3) + ((-15 + 16*r^2)*(x2 - x20)^4)/(96*g^2*(-1 + r^2)^2*x20^3) - ((x1 - x10)^2*(x2 - x20))/(4*(-1 + r^2)*x20^2) + (r*(x1 - x10)*(x2 - x20)^2)/(2*g*(-1 + r^2)*x20^2) - (x2 - x20)^3/(4*g^2*(-1 + r^2)*x20^2) + (g^2*(x1 - x10)^2 - 2*g*r*(x1 - x10)*(x2 - x20) + (x2 - x20)^2)/(2*g^2*(-1 + r^2)*x20);

c0 = ((12*a2 + g*(g - 12*r*(a1 + b1*x10)))*(x2 - x20)^2)/(24*g^2*(-1 + r^2)*x20^2) + ((x1 - x10)^2*(g^2 - 12*b1*x20))/(24*(-1 + r^2)*x20^2) + ((x2 - x20)*(-a2 + a1*g*r + b1*g*r*x10 - b2*x20))/(g^2*(-1 + r^2)*x20) + ((x1 - x10)^4*(7*g^4 - 40*b1*g^2*x20))/(1920*(-1 + r^2)^2*x20^4) + (g*(x1 - x10)^3*((-a1)*g + a2*r - b1*g*x10 + b1*r*x20))/(24*(-1 + r^2)^2*x20^3) + ((x1 - x10)*(x2 - x20)*(6*a1*g - 6*a2*r - g^2*r + 6*b1*g*x10 + 6*b1*r*x20))/ (12*g*(-1 + r^2)*x20^2) + (g*(x1 - x10)^3*(x2 - x20)*(30*a1*g - 30*a2*r - 7*g^2*r + 30*b1*g*x10 + 10*b1*r*x20))/(480*(-1 + r^2)^2*x20^4) + ((x2 - x20)^3*(a2*(8 - 9*r^2) - g^2*(-1 + r^2) + g*r*(-7 + 8*r^2)*(a1 + b1*x10) - b1*r^2*x20))/ (24*g^2*(-1 + r^2)^2*x20^3) + ((x2 - x20)^4*(360*a2*(-4 + 5*r^2) + g^2*(-215 + 236*r^2) - 360*g*r*(-3 + 4*r^2)*(a1 + b1*x10) + 240*b1*r^2*x20))/(5760*g^2*(-1 + r^2)^2*x20^4) + ((x1 - x10)*(a1*g - a2*r + b1*g*x10 - b2*r*x20))/(g*x20 - g*r^2*x20) + ((x1 - x10)*(x2 - x20)^2*(-2*g^2*r + 2*g^2*r^3 + a1*g*(7 - 10*r^2) + a2*r*(-7 + 10*r^2) + 7*b1*g*x10 - 10*b1*g*r^2*x10 + 9*b1*r*x20 - 6*b1*r^3*x20))/(24*g*(-1 + r^2)^2*x20^3) + ((x1 - x10)*(x2 - x20)^3*(97*g^2*r - 118*g^2*r^3 + 270*a1*g*(-1 + 2*r^2) - 270*a2*r*(-1 + 2*r^2) - 270*b1*g*x10 + 540*b1*g*r^2*x10 - 390*b1*r*x20 + 240*b1*r^3*x20))/(1440*g*(-1 + r^2)^2*x20^4) + ((x1 - x10)^2*(x2 - x20)*(-3*a2*r^2 - g^2*(-1 + r^2) + 3*g*r*(a1 + b1*x10) + b1*(-8 + 5*r^2)*x20))/(24*(-1 + r^2)^2*x20^3) + ((x1 - x10)^2*(x2 - x20)^2*(g^2*(-97 + 160*r^2) - 540*g*r*(a1 + b1*x10) + 60*(9*a2*r^2 + b1*(11 - 8*r^2)*x20)))/ (2880*(-1 + r^2)^2*x20^4);

c1 = ((x2 - x20)*(-6*a2^2 - 6*a1^2*g^2 - g^4 + g^4*r^2 + 2*b1*g^3*r*x10 - 6*b1^2*g^2*x10^2 + 2*a1*g^2*(g*r - 6*b1*x10) + 2*a2*g*(g*(3 - 4*r^2) + 6*r*(a1 + b1*x10)) - 2*b1*g^2*x20 + 6*b2^2*x20^2))/(24*g^2*(-1 + r^2)*x20^2) + (6*a2^2 + 6*a1^2*g^2 + g^4 - g^4*r^2 + 6*b1^2*g^2*x10^2 + 6*b1*g^2*x20 - 6*b1*g^2*r^2*x20 - 12*b1*b2*g*r*x10*x20 + 6*b2^2*x20^2 + 6*a2*(g^2*(-1 + r^2) - 2*g*r*(a1 + b1*x10) + 2*b2*x20) + 12*a1*g*(b1*g*x10 - b2*r*x20))/(12*g^2*(-1 + r^2)*x20) + ((x1 - x10)^2*(90*a1^2*g^2 + g^4 - g^4*r^2 + 30*a2^2*(1 + 2*r^2) + 90*b1^2*g^2*x10^2 + 60*b1*g^2*x20 - 60*b1*g^2*r^2*x20 - 180*b1^2*g*r*x10*x20 - 240*b1^2*x20^2 - 30*b2^2*x20^2 + 300*b1^2*r^2*x20^2 + 60*b1*b2*r^2*x20^2 + 180*a1*b1*g*(g*x10 - r*x20) + 30*a2*(g^2*(-1 + r^2) - 6*g*r*(a1 + b1*x10) + 6*b1*r^2*x20)))/(1440*(-1 + r^2)^2*x20^3) + (1/(1440*g^2*(-1 + r^2)^2*x20^3))*((x2 - x20)^2*(-47*g^4 + 95*g^4*r^2 - 48*g^4*r^4 + 90*a2^2*(-3 + 4*r^2) + 30*a1^2*g^2*(-7 + 10*r^2) + 120*b1*g^3*r*x10 - 120*b1*g^3*r^3*x10 - 210*b1^2*g^2*x10^2 + 300*b1^2*g^2*r^2*x10^2 - 60*b1*g^2*x20 + 60*b1*g^2*r^2*x20 - 180*b1^2*g*r*x10*x20 + 30*b2^2*x20^2 + 60*b1^2*r^2*x20^2 + 60*b1*b2*r^2*x20^2 - 60*b2^2*r^2*x20^2 - 60*a1*g*(2*g^2*r*(-1 + r^2) + b1*g*(7 - 10*r^2)*x10 + 3*b1*r*x20) + 30*a2*(g^2*(9 - 23*r^2 + 14*r^4) - 2*g*r*(-7 + 10*r^2)*(a1 + b1*x10) + 6*b1*r^2*x20))) - (1/(720*g*(-1 + r^2)^2*x20^3))*((x1 - x10)*(x2 - x20)*(90*a1^2*g^2*r + g^4*r - g^4*r^3 + 30*a2^2*(r + 2*r^3) + 60*b1*g^3*x10 - 60*b1*g^3*r^2*x10 + 90*b1^2*g^2*r*x10^2 - 300*b1^2*g*x10*x20 + 120*b1^2*g*r^2*x10*x20 + 60*b1*b2*r*x20^2 - 30*b2^2*r*x20^2 + 60*b1^2*r^3*x20^2 - 60*a1*g*(3*a2*r^2 + g^2*(-1 + r^2) - 3*b1*g*r*x10 + b1*(5 - 2*r^2)*x20) + 30*a2*r*(3*g^2*(-1 + r^2) - 6*b1*g*r*x10 + 2*b1*(5 - 2*r^2)*x20))) + ((x1 - x10)*(a2*r*(g^2 - 6*b1*x20) - a1*(g^3 - 6*b1*g*x20) + b1*((-g^3)*x10 + g^2*r*x20 + 6*b1*g*x10*x20 - 6*b2*r*x20^2)))/(12*g*(-1 + r^2)*x20^2);

c2 = (60*a1^2*g^2 + 23*g^4 - 23*g^4*r^2 - 60*a2^2*(-2 + r^2) + 60*b1^2*g^2*x10^2 - 120*b1^2*g*r*x10*x20 + 120*b1^2*x20^2 - 60*b1^2*r^2*x20^2 + 120*a1*b1*g*(g*x10 - r*x20) + 120*a2*(g^2*(-1 + r^2) - g*r*(a1 + b1*x10) + b1*r^2*x20))/(720*(-1 + r^2)*x20^2);

output = -log(2*pi*del) - Dv + cm1/del + c0 + c1*del + c2 * del^2 / 2;
