function output = ModelB6(x,x0,del,param)

% (* 
% The code below should be usable in any language.
% 
% x1 is the log of the stock price, x2 the instantaneous volatility. I wrote the parameters as m, a, b, s, r:
% 
% 	dx1 = (m - x2/2) dt + sqrt(x2) dW1
% 	dx2 = (a - b x2) dt + s r sqrt(x2) dW1 + s sqrt(1-r^2) sqrt(x2) dW2
% 
% The attached files contain the expressions for lnpX as a function of the coefficients c of order -1,0,1,2, i.e., order K=2 in delta with my notation. This should be sufficient for most if not all practical applications. I'm assuming you'll use something like daily data or maybe weekly?
% 
% lnpX in the code is the log of the transition density of (x1,x2) given (x10,x20), separated by a time interval del. 
% 
% Because of the presence of the sqrt terms, you need to be careful not only to stay on the positive axis (using Feller's condition), but also to keep x2 and x20 well clear of zero. That is, you want the long term mean of x2, namely the parameter a/b to be sufficiently large. Otherwise, you get into boundary issues and the expansion needs an explicit boundary condition. If you calibrate this model to financial data, this should not be a problem. 
% 
% *)
% 
% lnpX(del,x1,x2,x10,x20) = - log(2*del*pi) - Dv(x1,x2) + c(x1,x2,x10,x20,-1)/del + c(x1,x2,x10,x20,0) + del*c(x1,x2,x10,x20,1) + (1/2)*del^2*c(x1,x2,x10,x20,2);

% Dv(x1, x2) = (1/2)*log(1 - r^2) + log(s) + log(x2); 

% c(x1, x2, x10, x20, -1) = (7*s^4*(x1 - x10)^6)/(11520*(-1 + r^2)^3*x20^5) - (7*r*s^3*(x1 - x10)^5*(x2 - x20))/(1920*(-1 + r^2)^3*x20^5) + ((-193 + 298*r^2)*s^2*(x1 - x10)^4*(x2 - x20)^2)/(11520*(-1 + r^2)^3*x20^5) + (r*(193 - 228*r^2)*s*(x1 - x10)^3*(x2 - x20)^3)/(2880*(-1 + r^2)^3*x20^5) + ((745 - 2648*r^2 + 2008*r^4)*(x1 - x10)^2*(x2 - x20)^4)/(11520*(-1 + r^2)^3*x20^5) + ((-745*r + 1876*r^3 - 1152*r^5)*(x1 - x10)*(x2 - x20)^5)/(5760*(-1 + r^2)^3*s*x20^5) + ((945 - 2090*r^2 + 1152*r^4)*(x2 - x20)^6)/(11520*(-1 + r^2)^3*s^2*x20^5) - (s^2*(x1 - x10)^4*(x2 - x20))/(64*(-1 + r^2)^2*x20^4) + (r*s*(x1 - x10)^3*(x2 - x20)^2)/(16*(-1 + r^2)^2*x20^4) + ((3 - 6*r^2)*(x1 - x10)^2*(x2 - x20)^3)/(32*(-1 + r^2)^2*x20^4) + (r*(-3 + 4*r^2)*(x1 - x10)*(x2 - x20)^4)/(16*(-1 + r^2)^2*s*x20^4) + ((7 - 8*r^2)*(x2 - x20)^5)/(64*(-1 + r^2)^2*s^2*x20^4) + (s^2*(x1 - x10)^4)/(96*(-1 + r^2)^2*x20^3) - (r*s*(x1 - x10)^3*(x2 - x20))/ (24*(-1 + r^2)^2*x20^3) + ((-7 + 10*r^2)*(x1 - x10)^2*(x2 - x20)^2)/ (48*(-1 + r^2)^2*x20^3) + ((7*r - 8*r^3)*(x1 - x10)*(x2 - x20)^3)/ (24*(-1 + r^2)^2*s*x20^3) + ((-15 + 16*r^2)*(x2 - x20)^4)/ (96*(-1 + r^2)^2*s^2*x20^3) - ((x1 - x10)^2*(x2 - x20))/(4*(-1 + r^2)*x20^2) + (r*(x1 - x10)*(x2 - x20)^2)/(2*(-1 + r^2)*s*x20^2) - (x2 - x20)^3/(4*(-1 + r^2)*s^2*x20^2) + (s^2*(x1 - x10)^2 - 2*r*s*(x1 - x10)*(x2 - x20) + (x2 - x20)^2)/ (2*(-1 + r^2)*s^2*x20); 


% c(x1, x2, x10, x20, 0) = (7*s^4*(x1 - x10)^4)/(1920*(-1 + r^2)^2*x20^4) - (s*(30*a*r + s*(-30*m + 7*r*s))*(x1 - x10)^3*(x2 - x20))/ (480*(-1 + r^2)^2*x20^4) + ((540*a*r^2 + s*(-540*m*r + (-97 + 160*r^2)*s))* (x1 - x10)^2*(x2 - x20)^2)/(2880*(-1 + r^2)^2*x20^4) + ((-270*a*r*(-1 + 2*r^2) + s*(270*m*(-1 + 2*r^2) + r*(97 - 118*r^2)*s))* (x1 - x10)*(x2 - x20)^3)/(1440*(-1 + r^2)^2*s*x20^4) + ((360*a*(-4 + 5*r^2) + s*(-360*m*r*(-3 + 4*r^2) + (-215 + 236*r^2)*s))* (x2 - x20)^4)/(5760*(-1 + r^2)^2*s^2*x20^4) + (s*(a*r - m*s)*(x1 - x10)^3)/ (24*(-1 + r^2)^2*x20^3) + ((-3*a*r^2 + s*(3*m*r + s - r^2*s))* (x1 - x10)^2*(x2 - x20))/(24*(-1 + r^2)^2*x20^3) + ((a*r*(-7 + 10*r^2) + s*(m*(7 - 10*r^2) + 2*r*(-1 + r^2)*s))*(x1 - x10)* (x2 - x20)^2)/(24*(-1 + r^2)^2*s*x20^3) + ((a*(8 - 9*r^2) + s*(m*r*(-7 + 8*r^2) + s - r^2*s))*(x2 - x20)^3)/ (24*(-1 + r^2)^2*s^2*x20^3) + (s^2*(x1 - x10)^2)/(24*(-1 + r^2)*x20^2) + ((12*a + s*(-12*m*r + s))*(x2 - x20)^2)/(24*(-1 + r^2)*s^2*x20^2) - ((x1 - x10)*(2*a*r - 2*m*s - 2*b*r*x20 + s*x20))/ (2*s*x20 - 2*r^2*s*x20) + ((x2 - x20)*(2*a - 2*m*r*s - 2*b*x20 + r*s*x20))/(2*s^2*x20 - 2*r^2*s^2*x20) + ((6*a*r - 6*m*s + r*s^2)*(x1 - x10)*(x2 - x20))/ (12*s*x20^2 - 12*r^2*s*x20^2); 


% c(x1, x2, x10, x20, 1) = (s*(a*r - m*s)*(x1 - x10))/(12*(-1 + r^2)*x20^2) + ((x1 - x10)^2*(60*a^2*(1 + 2*r^2) + 180*m^2*s^2 + 2*s^4 - 2*r^2*s^4 - 60*a*s*(6*m*r + s - r^2*s) - 60*b^2*x20^2 + 60*b*r*s*x20^2 - 15*s^2*x20^2))/(2880*(-1 + r^2)^2*x20^3) + ((x2 - x20)*(-12*a^2 - 12*m^2*s^2 + 4*m*r*s^3 - 2*s^4 + 2*r^2*s^4 + 4*a*s*(6*m*r + (3 - 4*r^2)*s) + 12*b^2*x20^2 - 12*b*r*s*x20^2 + 3*s^2*x20^2))/(48*(-1 + r^2)*s^2*x20^2) + (1/(2880*(-1 + r^2)^2*s^2*x20^3))* ((x2 - x20)^2*(180*a^2*(-3 + 4*r^2) + 60*m^2*(-7 + 10*r^2)*s^2 - 240*m*r*(-1 + r^2)*s^3 - 94*s^4 + 190*r^2*s^4 - 96*r^4*s^4 + 60*a*s*(m*(14*r - 20*r^3) + (9 - 23*r^2 + 14*r^4)*s) + 60*b^2*x20^2 - 120*b^2*r^2*x20^2 - 60*b*r*s*x20^2 + 120*b*r^3*s*x20^2 + 15*s^2*x20^2 - 30*r^2*s^2*x20^2)) + (1/(24*(-1 + r^2)*s^2*x20))* (12*a^2 + 12*m^2*s^2 + 2*s^4 - 2*r^2*s^4 + 12*m*(2*b*r - s)*s* x20 + 12*b^2*x20^2 - 12*b*r*s*x20^2 + 3*s^2*x20^2 - 12*a*(2*m*r*s + s^2 - r^2*s^2 + 2*b*x20 - r*s*x20)) + (1/(1440*(-1 + r^2)^2*s*x20^3))*((x1 - x10)*(x2 - x20)*(-60*a^2*(r + 2*r^3) - 180*m^2*r*s^2 + 120*m*(-1 + r^2)*s^3 + 180*a*r*s* (2*m*r + s - r^2*s) + r*(2*(-1 + r^2)*s^4 + 60*b^2*x20^2 - 60*b*r*s*x20^2 + 15*s^2*x20^2))); 


% c(x1, x2, x10, x20, 2) = -((60*a^2*(-2 + r^2) - 60*m^2*s^2 + 23*(-1 + r^2)*s^4 + 120*a*s*(m*r + s - r^2*s))/(720*(-1 + r^2)*x20^2)); 


x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

m = param(1);
a = param(2);
b = param(3);
s = param(4);
r = param(5);

Dv = (1/2)*log(1 - r^2) + log(s) + log(x2); 


cm1 = (7*s^4*(x1 - x10)^6)/(11520*(-1 + r^2)^3*x20^5) - (7*r*s^3*(x1 - x10)^5*(x2 - x20))/(1920*(-1 + r^2)^3*x20^5) + ((-193 + 298*r^2)*s^2*(x1 - x10)^4*(x2 - x20)^2)/(11520*(-1 + r^2)^3*x20^5) + (r*(193 - 228*r^2)*s*(x1 - x10)^3*(x2 - x20)^3)/(2880*(-1 + r^2)^3*x20^5) + ((745 - 2648*r^2 + 2008*r^4)*(x1 - x10)^2*(x2 - x20)^4)/(11520*(-1 + r^2)^3*x20^5) + ((-745*r + 1876*r^3 - 1152*r^5)*(x1 - x10)*(x2 - x20)^5)/(5760*(-1 + r^2)^3*s*x20^5) + ((945 - 2090*r^2 + 1152*r^4)*(x2 - x20)^6)/(11520*(-1 + r^2)^3*s^2*x20^5) - (s^2*(x1 - x10)^4*(x2 - x20))/(64*(-1 + r^2)^2*x20^4) + (r*s*(x1 - x10)^3*(x2 - x20)^2)/(16*(-1 + r^2)^2*x20^4) + ((3 - 6*r^2)*(x1 - x10)^2*(x2 - x20)^3)/(32*(-1 + r^2)^2*x20^4) + (r*(-3 + 4*r^2)*(x1 - x10)*(x2 - x20)^4)/(16*(-1 + r^2)^2*s*x20^4) + ((7 - 8*r^2)*(x2 - x20)^5)/(64*(-1 + r^2)^2*s^2*x20^4) + (s^2*(x1 - x10)^4)/(96*(-1 + r^2)^2*x20^3) - (r*s*(x1 - x10)^3*(x2 - x20))/ (24*(-1 + r^2)^2*x20^3) + ((-7 + 10*r^2)*(x1 - x10)^2*(x2 - x20)^2)/ (48*(-1 + r^2)^2*x20^3) + ((7*r - 8*r^3)*(x1 - x10)*(x2 - x20)^3)/ (24*(-1 + r^2)^2*s*x20^3) + ((-15 + 16*r^2)*(x2 - x20)^4)/ (96*(-1 + r^2)^2*s^2*x20^3) - ((x1 - x10)^2*(x2 - x20))/(4*(-1 + r^2)*x20^2) + (r*(x1 - x10)*(x2 - x20)^2)/(2*(-1 + r^2)*s*x20^2) - (x2 - x20)^3/(4*(-1 + r^2)*s^2*x20^2) + (s^2*(x1 - x10)^2 - 2*r*s*(x1 - x10)*(x2 - x20) + (x2 - x20)^2)/ (2*(-1 + r^2)*s^2*x20); 

c0 = (7*s^4*(x1 - x10)^4)/(1920*(-1 + r^2)^2*x20^4) - (s*(30*a*r + s*(-30*m + 7*r*s))*(x1 - x10)^3*(x2 - x20))/ (480*(-1 + r^2)^2*x20^4) + ((540*a*r^2 + s*(-540*m*r + (-97 + 160*r^2)*s))* (x1 - x10)^2*(x2 - x20)^2)/(2880*(-1 + r^2)^2*x20^4) + ((-270*a*r*(-1 + 2*r^2) + s*(270*m*(-1 + 2*r^2) + r*(97 - 118*r^2)*s))* (x1 - x10)*(x2 - x20)^3)/(1440*(-1 + r^2)^2*s*x20^4) + ((360*a*(-4 + 5*r^2) + s*(-360*m*r*(-3 + 4*r^2) + (-215 + 236*r^2)*s))* (x2 - x20)^4)/(5760*(-1 + r^2)^2*s^2*x20^4) + (s*(a*r - m*s)*(x1 - x10)^3)/ (24*(-1 + r^2)^2*x20^3) + ((-3*a*r^2 + s*(3*m*r + s - r^2*s))* (x1 - x10)^2*(x2 - x20))/(24*(-1 + r^2)^2*x20^3) + ((a*r*(-7 + 10*r^2) + s*(m*(7 - 10*r^2) + 2*r*(-1 + r^2)*s))*(x1 - x10)* (x2 - x20)^2)/(24*(-1 + r^2)^2*s*x20^3) + ((a*(8 - 9*r^2) + s*(m*r*(-7 + 8*r^2) + s - r^2*s))*(x2 - x20)^3)/ (24*(-1 + r^2)^2*s^2*x20^3) + (s^2*(x1 - x10)^2)/(24*(-1 + r^2)*x20^2) + ((12*a + s*(-12*m*r + s))*(x2 - x20)^2)/(24*(-1 + r^2)*s^2*x20^2) - ((x1 - x10)*(2*a*r - 2*m*s - 2*b*r*x20 + s*x20))/ (2*s*x20 - 2*r^2*s*x20) + ((x2 - x20)*(2*a - 2*m*r*s - 2*b*x20 + r*s*x20))/(2*s^2*x20 - 2*r^2*s^2*x20) + ((6*a*r - 6*m*s + r*s^2)*(x1 - x10)*(x2 - x20))/ (12*s*x20^2 - 12*r^2*s*x20^2); 


c1 = (s*(a*r - m*s)*(x1 - x10))/(12*(-1 + r^2)*x20^2) + ((x1 - x10)^2*(60*a^2*(1 + 2*r^2) + 180*m^2*s^2 + 2*s^4 - 2*r^2*s^4 - 60*a*s*(6*m*r + s - r^2*s) - 60*b^2*x20^2 + 60*b*r*s*x20^2 - 15*s^2*x20^2))/(2880*(-1 + r^2)^2*x20^3) + ((x2 - x20)*(-12*a^2 - 12*m^2*s^2 + 4*m*r*s^3 - 2*s^4 + 2*r^2*s^4 + 4*a*s*(6*m*r + (3 - 4*r^2)*s) + 12*b^2*x20^2 - 12*b*r*s*x20^2 + 3*s^2*x20^2))/(48*(-1 + r^2)*s^2*x20^2) + (1/(2880*(-1 + r^2)^2*s^2*x20^3))* ((x2 - x20)^2*(180*a^2*(-3 + 4*r^2) + 60*m^2*(-7 + 10*r^2)*s^2 - 240*m*r*(-1 + r^2)*s^3 - 94*s^4 + 190*r^2*s^4 - 96*r^4*s^4 + 60*a*s*(m*(14*r - 20*r^3) + (9 - 23*r^2 + 14*r^4)*s) + 60*b^2*x20^2 - 120*b^2*r^2*x20^2 - 60*b*r*s*x20^2 + 120*b*r^3*s*x20^2 + 15*s^2*x20^2 - 30*r^2*s^2*x20^2)) + (1/(24*(-1 + r^2)*s^2*x20))* (12*a^2 + 12*m^2*s^2 + 2*s^4 - 2*r^2*s^4 + 12*m*(2*b*r - s)*s* x20 + 12*b^2*x20^2 - 12*b*r*s*x20^2 + 3*s^2*x20^2 - 12*a*(2*m*r*s + s^2 - r^2*s^2 + 2*b*x20 - r*s*x20)) + (1/(1440*(-1 + r^2)^2*s*x20^3))*((x1 - x10)*(x2 - x20)*(-60*a^2*(r + 2*r^3) - 180*m^2*r*s^2 + 120*m*(-1 + r^2)*s^3 + 180*a*r*s* (2*m*r + s - r^2*s) + r*(2*(-1 + r^2)*s^4 + 60*b^2*x20^2 - 60*b*r*s*x20^2 + 15*s^2*x20^2))); 


c2= -((60*a^2*(-2 + r^2) - 60*m^2*s^2 + 23*(-1 + r^2)*s^4 + 120*a*s*(m*r + s - r^2*s))/(720*(-1 + r^2)*x20^2)); 


output = - log(2*del*pi) - Dv + cm1/del + c0 + del*c1 + (1/2)*del^2*c2;
