function output = SA11(x,x0,del,param)

% Model SA1(1)
% 
% 
% 
% lnpX(del, x, x0, 1, exact) = -log(2*pi*del)/2 - log(s(x)) + cY(g(x), g(x0), -1, exact)/del + cY(g(x0), g(x0), 0, exact) + cY(g(x0), g(x0), 1, exact)*del; 
% 
% mu(x) = a + b*x + d*sqrt(x); 
% 
% s(x) = sqrt(x); 
% 
% g(x) = 2*sqrt(x); 
% 
% cY(y, y0, -1, exact) = (-(1/2))*(y - y0)^2; 
% 
% cY(y, y0, 0, exact) = (1/ 4)*((y - y0)*(4*d + b*(y + y0)) + (-2 + 8*a)*log(y/y0)); 
% 
% cY(y, y0, 1, exact) = -((1/(96* y*(y - y0)^2))*((y - y0)*(-36 - 192*a^2 + 3*b^2*y^4 + 48*a*(4 + 4*d*y + b*y*(y - y0)) + 24*d^2*y*(y - y0) - b^2*y^3*y0 - b^2*y^2*y0^2 - b^2*y*y0^3 + 8*d*y*(-6 + b*(2*y^2 - y*y0 - y0^2))) + 12*(-1 + 4*a)*y*(-3 + 4*a - 4*d*y0)*log(y/y0))); 

a = param(1);
b = param(2);
d = param(3);

s_x = sqrt(x);
y = 2*sqrt(x); 
y0 = 2*sqrt(x0); 

cm1 = (-(1/2))*(y - y0)^2; 
c0 = (1/ 4)*((y - y0)*(4*d + b*(y + y0)) + (-2 + 8*a)*log(y/y0));
c1 = -((1/(96* y*(y - y0)^2))*((y - y0)*(-36 - 192*a^2 + 3*b^2*y^4 + 48*a*(4 + 4*d*y + b*y*(y - y0)) + 24*d^2*y*(y - y0) - b^2*y^3*y0 - b^2*y^2*y0^2 - b^2*y*y0^3 + 8*d*y*(-6 + b*(2*y^2 - y*y0 - y0^2))) + 12*(-1 + 4*a)*y*(-3 + 4*a - 4*d*y0)*log(y/y0))); 

output = -log(2*pi*del)/2 - log(s_x) + cm1/del + c0 + c1*del; 
