function output = SA12(x,x0,del,param)

% Model SA1(2)
% 
% 
% 
% lnpX(del, x1, x2, x10, x20, 1) = -log(2*pi*del) - Dv(x1, x2) + c(x1, x2, x10, x20, -1)/del + c(x1, x2, x10, x20, 0) + c(x1, x2, x10, x20, 1)*del; 
% 
% mu1(x1, x2) = a + b11*x1 + d1*sqrt(x1); 
% 
% mu2(x1, x2) = b21*x1 + b22*x2 + d2*sqrt(1 + f*x1); 
% 
% sigma11(x1, x2) = sqrt(x1); 
% 
% sigma22(x1, x2) = sqrt(1 + f*x1); 
% 
% sigma12(x1, x2) = 0; 
% 
% sigma21(x1, x2) = 0; 
% 
% Dv(x1, x2) = (1/2)*(log(x1) + log(1 + f*x1)); 
% 
% c(x1, x2, x10, x20, -1) = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/(1 + f*x10)) + (f*(x1 - x10)*(x2 - x20)^2)/(4*(1 + f*x10)^2) - (f*(x1 - x10)^2*(1 + 7*f*x10)*(x2 - x20)^2)/(48*x10*(1 + f*x10)^3) + (f^2*x10*(x2 - x20)^4)/(96*(1 + f*x10)^4); 
% 
% c(x1, x2, x10, x20, 0) = ((x1 - x10)*(-1 + 4*b11*x10 + 4*b11*f*x10^2 + 4*a*(1 + f*x10) + 4*d1*sqrt(x10)*(1 + f*x10)))/(4*x10*(1 + f*x10)) + ((x1 - x10)^2*(6 + 13*f*x10 - 2*f^2*x10^2 - 24*a*(1 + f*x10)^2 - 12*d1*sqrt(x10)*(1 + f*x10)^2))/(48*x10^2*(1 + f*x10)^2) + ((f - 2*f^2*x10 + 24*b22*(1 + f*x10)^2)*(x2 - x20)^2)/(48*(1 + f*x10)^3) + ((x2 - x20)*(b21*x10 + d2*sqrt(1 + f*x10) + b22*x20))/(1 + f*x10) + ((x1 - x10)*(x2 - x20)*((-d2)*f*(1 + f*x10) + 2*sqrt(1 + f*x10)*(b21 - b22*f*x20)))/(4*(1 + f*x10)^(5/2)); 
% 
% c(x1, x2, x10, x20, 1) = (-(1/(96*x10*(1 + f*x10)^2)))*(9 + 48*b22*x10 + 48*d2^2*x10 + 20*f*x10 + 48*b11^2*x10^2 + 96*b22*f*x10^2 + 96*d2^2*f*x10^2 + 8*f^2*x10^2 + 48*b21^2*x10^3 + 96*b11^2*f*x10^3 + 48*b22*f^2*x10^3 + 48*d2^2*f^2*x10^3 + 48*b21^2*f*x10^4 + 48*b11^2*f^2*x10^4 + 96*b21*d2*x10^2*sqrt(1 + f*x10) + 96*b21*d2*f*x10^3*sqrt(1 + f*x10) + 48*a*(-1 + 2*d1*sqrt(x10) + 2*b11*x10)*(1 + f*x10)^2 + 24*d1*sqrt(x10)*(-1 + 4*b11*x10)*(1 + f*x10)^2 + 48*(a + a*f*x10)^2 + 48*x10*(d1 + d1*f*x10)^2 + 96*b21*b22*x10^2*x20 + 96*b21*b22*f*x10^3*x20 + 96*b22*d2*x10*sqrt(1 + f*x10)*x20 + 96*b22*d2*f*x10^2*sqrt(1 + f*x10)*x20 + 48*b22^2*x10*x20^2 + 48*b22^2*f*x10^2*x20^2); 

x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

a = param(1);
b11 = param(2);
d1 = param(3);
b21 = param(4);
b22 = param(5);
d2 = param(6);
f = param(7);

Dv = (1/2)*(log(x1) + log(1 + f*x1)); 

cm1 = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/(1 + f*x10)) + (f*(x1 - x10)*(x2 - x20)^2)/(4*(1 + f*x10)^2) - (f*(x1 - x10)^2*(1 + 7*f*x10)*(x2 - x20)^2)/(48*x10*(1 + f*x10)^3) + (f^2*x10*(x2 - x20)^4)/(96*(1 + f*x10)^4); 

c0 = ((x1 - x10)*(-1 + 4*b11*x10 + 4*b11*f*x10^2 + 4*a*(1 + f*x10) + 4*d1*sqrt(x10)*(1 + f*x10)))/(4*x10*(1 + f*x10)) + ((x1 - x10)^2*(6 + 13*f*x10 - 2*f^2*x10^2 - 24*a*(1 + f*x10)^2 - 12*d1*sqrt(x10)*(1 + f*x10)^2))/(48*x10^2*(1 + f*x10)^2) + ((f - 2*f^2*x10 + 24*b22*(1 + f*x10)^2)*(x2 - x20)^2)/(48*(1 + f*x10)^3) + ((x2 - x20)*(b21*x10 + d2*sqrt(1 + f*x10) + b22*x20))/(1 + f*x10) + ((x1 - x10)*(x2 - x20)*((-d2)*f*(1 + f*x10) + 2*sqrt(1 + f*x10)*(b21 - b22*f*x20)))/(4*(1 + f*x10)^(5/2)); 

c1 = (-(1/(96*x10*(1 + f*x10)^2)))*(9 + 48*b22*x10 + 48*d2^2*x10 + 20*f*x10 + 48*b11^2*x10^2 + 96*b22*f*x10^2 + 96*d2^2*f*x10^2 + 8*f^2*x10^2 + 48*b21^2*x10^3 + 96*b11^2*f*x10^3 + 48*b22*f^2*x10^3 + 48*d2^2*f^2*x10^3 + 48*b21^2*f*x10^4 + 48*b11^2*f^2*x10^4 + 96*b21*d2*x10^2*sqrt(1 + f*x10) + 96*b21*d2*f*x10^3*sqrt(1 + f*x10) + 48*a*(-1 + 2*d1*sqrt(x10) + 2*b11*x10)*(1 + f*x10)^2 + 24*d1*sqrt(x10)*(-1 + 4*b11*x10)*(1 + f*x10)^2 + 48*(a + a*f*x10)^2 + 48*x10*(d1 + d1*f*x10)^2 + 96*b21*b22*x10^2*x20 + 96*b21*b22*f*x10^3*x20 + 96*b22*d2*x10*sqrt(1 + f*x10)*x20 + 96*b22*d2*f*x10^2*sqrt(1 + f*x10)*x20 + 48*b22^2*x10*x20^2 + 48*b22^2*f*x10^2*x20^2); 

output = -log(2*pi*del) - Dv + cm1/del + c0 + c1 * del; 

