function output = SA22(x,x0,del,param)



% Model SA2(2)
% 
% 
% 
% lnpX(del, x1, x2, x10, x20, 1) = -log(2*pi*del) - Dv(x1, x2) + c(x1, x2, x10, x20, -1)/del + c(x1, x2, x10, x20, 0) + c(x1, x2, x10, x20, 1)*del; 
% 
% mu1(x1, x2) = a1 + b11*x1 + b12*x2 + d1*sqrt(x1); 
% 
% mu2(x1, x2) = a2 + b21*x1 + b22*x2 + d2*sqrt(x2); 
% 
% sigma11(x1, x2) = sqrt(x1); 
% 
% sigma22(x1, x2) = sqrt(x2); 
% 
% sigma12(x1, x2) = 0; 
% 
% sigma21(x1, x2) = 0; 
% 
% Dv(x1, x2) = (1/2)*(log(x1) + log(x2)); 
% 
% c(x1, x2, x10, x20, -1) = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2); c(x1, x2, x10, x20, 0) = -(((-1 + 4*a2 + 4*b21*x10 + 2*d2*sqrt(x20))*(x2 - x20)^2)/(8*x20^2)) + ((x1 - x10)*(x2 - x20)*(b21*x10 + b12*x20))/(2*x10*x20) - ((x1 - x10)^2*(-1 + 4*a1 + 2*d1*sqrt(x10) + 4*b12*x20))/(8*x10^2) + ((x1 - x10)*(-1 + 4*a1 + 4*d1*sqrt(x10) + 4*b11*x10 + 4*b12*x20))/(4*x10) + ((x2 - x20)*(-1 + 4*a2 + 4*b21*x10 + 4*d2*sqrt(x20) + 4*b22*x20))/(4*x20); 
% 
% c(x1, x2, x10, x20, 0) = -(((-1 + 4*a2 + 4*b21*x10 + 2*d2*sqrt(x20))*(x2 - x20)^2)/(8*x20^2)) + ((x1 - x10)*(x2 - x20)*(b21*x10 + b12*x20))/(2*x10*x20) -  ((x1 - x10)^2*(-1 + 4*a1 + 2*d1*sqrt(x10) + 4*b12*x20))/(8*x10^2) + ((x1 - x10)*(-1 + 4*a1 + 4*d1*sqrt(x10) + 4*b11*x10 + 4*b12*x20))/(4*x10) +  ((x2 - x20)*(-1 + 4*a2 + 4*b21*x10 + 4*d2*sqrt(x20) + 4*b22*x20))/(4*x20);
% 
% c(x1, x2, x10, x20, 1) = (-(1/(32*x10*x20)))*(16*b21^2*x10^3 + 32*b11*d1*x10^(3/2)*x20 + 8*d1*sqrt(x10)*x20*(-1 + 4*a1 + 4*b12*x20) + x20*(3 + 16*a1^2 - 16*b12*x20 + 16*b12^2*x20^2 + 16*a1*(-1 + 2*b12*x20)) + 16*x10^2*(b11^2*x20 + b21*(-1 + 2*a2 + 2*d2*sqrt(x20) + 2*b22*x20)) + x10*(3 + 16*a2^2 + 32*a1*b11*x20 + 16*d1^2*x20 + 16*d2^2*x20 + 32*b11*b12*x20^2 + 16*b22^2*x20^2 + 16*a2*(-1 + 2*d2*sqrt(x20) + 2*b22*x20) + 8*d2*sqrt(x20)*(-1 + 4*b22*x20))); 
% 



x1 = x(1);
x2 = x(2);
x10 = x0(1);
x20 = x0(2);

a1 = param(1);
b11 = param(2);
b12 = param(3);
d1 = param(4);
a2 = param(5);
b21 = param(6);
b22 = param(7);
d2 = param(8);

Dv = (1/2)*(log(x1) + log(x2)); 

cm1 = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2);

c0 = -(((-1 + 4*a2 + 4*b21*x10 + 2*d2*sqrt(x20))*(x2 - x20)^2)/(8*x20^2)) + ((x1 - x10)*(x2 - x20)*(b21*x10 + b12*x20))/(2*x10*x20) -  ((x1 - x10)^2*(-1 + 4*a1 + 2*d1*sqrt(x10) + 4*b12*x20))/(8*x10^2) + ((x1 - x10)*(-1 + 4*a1 + 4*d1*sqrt(x10) + 4*b11*x10 + 4*b12*x20))/(4*x10) +  ((x2 - x20)*(-1 + 4*a2 + 4*b21*x10 + 4*d2*sqrt(x20) + 4*b22*x20))/(4*x20);

c1 = (-(1/(32*x10*x20)))*(16*b21^2*x10^3 + 32*b11*d1*x10^(3/2)*x20 + 8*d1*sqrt(x10)*x20*(-1 + 4*a1 + 4*b12*x20) + x20*(3 + 16*a1^2 - 16*b12*x20 + 16*b12^2*x20^2 + 16*a1*(-1 + 2*b12*x20)) + 16*x10^2*(b11^2*x20 + b21*(-1 + 2*a2 + 2*d2*sqrt(x20) + 2*b22*x20)) + x10*(3 + 16*a2^2 + 32*a1*b11*x20 + 16*d1^2*x20 + 16*d2^2*x20 + 32*b11*b12*x20^2 + 16*b22^2*x20^2 + 16*a2*(-1 + 2*d2*sqrt(x20) + 2*b22*x20) + 8*d2*sqrt(x20)*(-1 + 4*b22*x20))); 

output = -log(2*pi*del) - Dv + cm1/del + c0 + c1*del; 
