function output = SA33(x,x0,del,param)


% 
% Model SA3(3)
% 
% 
% 
% lnpX(del, x1, x2, x3, x10, x20, x30, 1) = (-(3/2))*log(2*pi*del) - Dv(x1, x2, x3) + c(x1, x2, x3, x10, x20, x30, -1)/del + c(x1, x2, x3, x10, x20, x30, 0) + c(x1, x2, x3, x10, x20, x30, 1)*del; 
% 
% mu1(x1, x2, x3) = a1 + b11*x1 + b12*x2 + b13*x3 + d1*sqrt(x1); 
% 
% mu2(x1, x2, x3) = a2 + b21*x1 + b22*x2 + b23*x3 + d2*sqrt(x2); 
% 
% mu3(x1, x2, x3) = a3 + b31*x1 + b32*x2 + b33*x3 + d3*sqrt(x3); 
% 
% sigma11(x1, x2, x3) = sqrt(x1); 
% 
% sigma22(x1, x2, x3) = sqrt(x2); 
% 
% sigma33(x1, x2, x3) = sqrt(x3); 
% 
% sigma12(x1, x2, x3) = 0; 
% 
% sigma13(x1, x2, x3) = 0; 
% 
% sigma21(x1, x2, x3) = 0; 
% 
% sigma23(x1, x2, x3) = 0; 
% 
% sigma31(x1, x2, x3) = 0; 
% 
% sigma32(x1, x2, x3) = 0; 
% 
% Dv(x1, x2, x3) = (1/2)*(log(x1) + log(x2) + log(x3)); 
% 
% c(x1, x2, x3, x10, x20, x30, -1) = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20 - (x3 - x30)^2/x30) - (5*(x3 - x30)^4)/(32*x30^3) + (x3 - x30)^3/(4*x30^2); 
% 
% c(x1, x2, x3, x10, x20, x30, 0) = ((x1 - x10)*(x2 - x20)*(b21*x10 + b12*x20))/(2*x10*x20) - ((-1 + 4*a3 + 4*b31*x10 + 4*b32*x20 + 2*d3*sqrt(x30))*(x3 - x30)^2)/(8*x30^2) + ((x1 - x10)*(x3 - x30)*(b31*x10 + b13*x30))/(2*x10*x30) - ((x1 - x10)^2*(-1 + 4*a1 + 2*d1*sqrt(x10) + 4*b12*x20 + 4*b13*x30))/(8*x10^2) + ((x1 - x10)*(-1 + 4*a1 + 4*d1*sqrt(x10) + 4*b11*x10 + 4*b12*x20 + 4*b13*x30))/ (4*x10) + ((x2 - x20)*(x3 - x30)*(b32*x20 + b23*x30))/(2*x20*x30) - ((x2 - x20)^2*(-1 + 4*a2 + 4*b21*x10 + 2*d2*sqrt(x20) + 4*b23*x30))/(8*x20^2) + ((x2 - x20)*(-1 + 4*a2 + 4*b21*x10 + 4*d2*sqrt(x20) + 4*b22*x20 + 4*b23*x30))/(4*x20) + ((x3 - x30)*(-1 + 4*a3 + 4*b31*x10 + 4*b32*x20 + 4*d3*sqrt(x30) + 4*b33*x30))/(4*x30); 
% 
% c(x1, x2, x3, x10, x20, x30, 1) = (-(1/(32*x10*x20*x30)))*(32*b11*d1*x10^(3/2)*x20*x30 + 8*d1*sqrt(x10)*x20*x30*(-1 + 4*a1 + 4*b12*x20 + 4*b13*x30) + 16*x10^3*(b31^2*x20 + b21^2*x30) + x20*x30*(3 + 16*a1^2 + 16*b12^2*x20^2 - 16*b13*x30 + 16*b13^2*x30^2 + 16*b12*x20*(-1 + 2*b13*x30) + 16*a1*(-1 + 2*b12*x20 + 2*b13*x30)) + 16*x10^2*(b31*x20*(-1 + 2*a3 + 2*b32*x20 + 2*d3*sqrt(x30) + 2*b33*x30) + x30*(b11^2*x20 + b21*(-1 + 2*a2 + 2*d2*sqrt(x20) + 2*b22*x20 + 2*b23*x30))) + x10*(16*b32^2*x20^3 + 32*b22*d2*x20^(3/2)*x30 + 8*d2*sqrt(x20)*x30*(-1 + 4*a2 + 4*b23*x30) + x30*(3 + 16*a2^2 - 16*b23*x30 + 16*b23^2*x30^2 + 16*a2*(-1 + 2*b23*x30)) + 16*x20^2*((2*b11*b12 + b22^2)*x30 + b32*(-1 + 2*a3 + 2*d3*sqrt(x30) + 2*b33*x30)) + x20*(3 + 16*a3^2 + 32*a1*b11*x30 + 32*a2*b22*x30 + 16*d1^2*x30 + 16*d2^2*x30 + 16*d3^2*x30 + 32*b11*b13*x30^2 + 32*b22*b23*x30^2 + 16*b33^2*x30^2 + 16*a3*(-1 + 2*d3*sqrt(x30) + 2*b33*x30) + 8*d3*sqrt(x30)*(-1 + 4*b33*x30)))); 
% 
% 
x1 = x(1);
x2 = x(2);
x3 = x(3);
x10 = x0(1);
x20 = x0(2);
x30 = x0(3);

a1 = param(1);
b11 = param(2);
b12 = param(3);
b13 = param(4);
d1 = param(5);
a2 = param(6);
b21 = param(7);
b22 = param(8);
b23 = param(9);
d2 = param(10);
a3 = param(11);
b31 = param(12);
b32 = param(13);
b33 = param(14);
d3 = param(15);

Dv = (1/2)*(log(x1) + log(x2) + log(x3)); 

cm1 = -((5*(x1 - x10)^4)/(32*x10^3)) + (x1 - x10)^3/(4*x10^2) - (5*(x2 - x20)^4)/(32*x20^3) + (x2 - x20)^3/(4*x20^2) + (1/2)*(-((x1 - x10)^2/x10) - (x2 - x20)^2/x20 - (x3 - x30)^2/x30) - (5*(x3 - x30)^4)/(32*x30^3) + (x3 - x30)^3/(4*x30^2); 

c0 = ((x1 - x10)*(x2 - x20)*(b21*x10 + b12*x20))/(2*x10*x20) - ((-1 + 4*a3 + 4*b31*x10 + 4*b32*x20 + 2*d3*sqrt(x30))*(x3 - x30)^2)/(8*x30^2) + ((x1 - x10)*(x3 - x30)*(b31*x10 + b13*x30))/(2*x10*x30) - ((x1 - x10)^2*(-1 + 4*a1 + 2*d1*sqrt(x10) + 4*b12*x20 + 4*b13*x30))/(8*x10^2) + ((x1 - x10)*(-1 + 4*a1 + 4*d1*sqrt(x10) + 4*b11*x10 + 4*b12*x20 + 4*b13*x30))/ (4*x10) + ((x2 - x20)*(x3 - x30)*(b32*x20 + b23*x30))/(2*x20*x30) - ((x2 - x20)^2*(-1 + 4*a2 + 4*b21*x10 + 2*d2*sqrt(x20) + 4*b23*x30))/(8*x20^2) + ((x2 - x20)*(-1 + 4*a2 + 4*b21*x10 + 4*d2*sqrt(x20) + 4*b22*x20 + 4*b23*x30))/(4*x20) + ((x3 - x30)*(-1 + 4*a3 + 4*b31*x10 + 4*b32*x20 + 4*d3*sqrt(x30) + 4*b33*x30))/(4*x30); 

c1 = (-(1/(32*x10*x20*x30)))*(32*b11*d1*x10^(3/2)*x20*x30 + 8*d1*sqrt(x10)*x20*x30*(-1 + 4*a1 + 4*b12*x20 + 4*b13*x30) + 16*x10^3*(b31^2*x20 + b21^2*x30) + x20*x30*(3 + 16*a1^2 + 16*b12^2*x20^2 - 16*b13*x30 + 16*b13^2*x30^2 + 16*b12*x20*(-1 + 2*b13*x30) + 16*a1*(-1 + 2*b12*x20 + 2*b13*x30)) + 16*x10^2*(b31*x20*(-1 + 2*a3 + 2*b32*x20 + 2*d3*sqrt(x30) + 2*b33*x30) + x30*(b11^2*x20 + b21*(-1 + 2*a2 + 2*d2*sqrt(x20) + 2*b22*x20 + 2*b23*x30))) + x10*(16*b32^2*x20^3 + 32*b22*d2*x20^(3/2)*x30 + 8*d2*sqrt(x20)*x30*(-1 + 4*a2 + 4*b23*x30) + x30*(3 + 16*a2^2 - 16*b23*x30 + 16*b23^2*x30^2 + 16*a2*(-1 + 2*b23*x30)) + 16*x20^2*((2*b11*b12 + b22^2)*x30 + b32*(-1 + 2*a3 + 2*d3*sqrt(x30) + 2*b33*x30)) + x20*(3 + 16*a3^2 + 32*a1*b11*x30 + 32*a2*b22*x30 + 16*d1^2*x30 + 16*d2^2*x30 + 16*d3^2*x30 + 32*b11*b13*x30^2 + 32*b22*b23*x30^2 + 16*b33^2*x30^2 + 16*a3*(-1 + 2*d3*sqrt(x30) + 2*b33*x30) + 8*d3*sqrt(x30)*(-1 + 4*b33*x30)))); 

output = (-(3/2))*log(2*pi*del) - Dv + cm1/del + c0 + c1*del; 
