function output = ModelT1(x,x0,del,param)

% Model is:
% 
% mu1(x1,x2,x3) = k11*(m1-x1)+k12*(m2-x2);
% mu2(x1,x2,x3) = k21*(m1-x1)+k22*(m2-x2);
% mu3(x1,x2,x3) = k33*(m3-x3);
% 
% sig11(x1,x2,x3) = sqrt(a1+b1*x1);
% sig21(x1,x2,x3) = 0;
% sig31(x1,x2,x3) = 0;
% sig12(x1,x2,x3) = 0;
% sig22(x1,x2,x3) = sqrt(a2+b2*x2);
% sig32(x1,x2,x3) = 0;
% sig13(x1,x2,x3) = 0;
% sig23(x1,x2,x3) = 0;
% sig33(x1,x2,x3) = sqrt(a3+b3*x3);
% 
% 
% ------------------------
% 
% 
% 
% Here is the expression for the irreducible expansion of the log-likelihood at order K = 1 for this model:
% 
% 
% ------------------------
% 
% 
% 
% lnpX(del,x1,x2,x3,x10,x20,x30,1) = - (3/2)log(2Pidel) - lndetv2(x1,x2,x3) + c(x1,x2,x3,x10,x20,x30,-1)/del + c(x1,x2,x3,x10,x20,x30,0) + c(x1,x2,x3,x10,x20,x30,1)*del;
% 
% 
% where
% 
% 
% lndetv2(x1,x2,x3) = log(a1+b1*x1)/2+log(a2+b2*x2)/2+log(a3+b3*x3)/2;
% 
% 
% c(x1,x2,x3,x10,x20,x30,-1) = (-5*b1^2*(x1-x10)^4)/(32*(a1+b1*x10)^3)+(b1*(x1-x10)^3)/(4*(a1+b1*x10)^2)-(5*b2^2*(x2-x20)^4)/(32*(a2+b2*x20)^3)+(b2*(x2-x20)^3)/(4*(a2+b2*x20)^2)-(5*b3^2*(x3-x30)^4)/(32*(a3+b3*x30)^3)+(b3*(x3-x30)^3)/(4*(a3+b3*x30)^2)-((x3-x30)^2+((x1-x10)^2*(a3+b3*x30))/(a1+b1*x10)+((x2-x20)^2*(a3+b3*x30))/(a2+b2*x20))/(2*(a3+b3*x30));
% 
% 
% 
% c(x1,x2,x3,x10,x20,x30,0) = ((x1-x10)^2*(b1^2-4*a1*k11-4*b1*(k11*m1+k12*(m2-x20))))/(8*(a1+b1*x10)^2)+((b2^2-4*a2*k22-4*b2*(k22*m2+k21*(m1-x10)))*(x2-x20)^2)/(8*(a2+b2*x20)^2)-((x1-x10)*(b1-4*k11*m1-4*k12*m2+4*k11*x10+4*k12*x20))/(4*(a1+b1*x10))-((x1-x10)*(x2-x20)*(a2*k12+a1*k21+b1*k21*x10+b2*k12*x20))/(2*(a1+b1*x10)*(a2+b2*x20))-((x2-x20)*(b2-4*k21*m1-4*k22*m2+4*k21*x10+4*k22*x20))/(4*(a2+b2*x20))+((b3^2-4*a3*k33-4*b3*k33*m3)*(x3-x30)^2)/(8*(a3+b3*x30)^2)-((x3-x30)*(b3+4*k33*(-m3+x30)))/(4*(a3+b3*x30));
% 
% 
% 
% 
% c(x1,x2,x3,x10,x20,x30,1) = (32*k33-(3*b1^2)/(a1+b1*x10)+(16*b1*k12*m2)/(a1+b1*x10)-(16*k12^2*m2^2)/(a1+b1*x10)-(16*k11^2*(m1-x10)^2)/(a1+b1*x10)+(16*k11*(a1+b1*m1-2*k12*(m1-x10)*(m2-x20)))/(a1+b1*x10)-(16*b1*k12*x20)/(a1+b1*x10)+(32*k12^2*m2*x20)/(a1+b1*x10)-(16*k12^2*x20^2)/(a1+b1*x10)-(3*b2^2)/(a2+b2*x20)+(16*b2*k21*m1)/(a2+b2*x20)-(16*k21^2*m1^2)/(a2+b2*x20)-(16*b2*k21*x10)/(a2+b2*x20)+(32*k21^2*m1*x10)/(a2+b2*x20)-(16*k21^2*x10^2)/(a2+b2*x20)+(16*k22*(a2+b2*m2-2*k21*(m1-x10)*(m2-x20)))/(a2+b2*x20)-(16*k22^2*(m2-x20)^2)/(a2+b2*x20)-(3*b3^2)/(a3+b3*x30)-(16*a3*k33)/(a3+b3*x30)+(16*b3*k33*m3)/(a3+b3*x30)-(16*k33^2*m3^2)/(a3+b3*x30)-(32*b3*k33*x30)/(a3+b3*x30)+(32*k33^2*m3*x30)/(a3+b3*x30)-(16*k33^2*x30^2)/(a3+b3*x30))/32;
% 
% 

x1 = x(1);
x2 = x(2);
x3 = x(3);
x10 = x0(1);
x20 = x0(2);
x30 = x0(3);

m1 = param(1);
m2 = param(2);
m3 = param(3);
k11 = param(4);
k12 = param(5);
k21 = param(6);
k22 = param(7);
k33 = param(8);
a1 = param(9);
b1 = param(10);
a2 = param(11);
b2 = param(12);
a3 = param(13);
b3 = param(14);

Dv = log(a1+b1*x1)/2+log(a2+b2*x2)/2+log(a3+b3*x3)/2;


cm1 = (-5*b1^2*(x1-x10)^4)/(32*(a1+b1*x10)^3)+(b1*(x1-x10)^3)/(4*(a1+b1*x10)^2)-(5*b2^2*(x2-x20)^4)/(32*(a2+b2*x20)^3)+(b2*(x2-x20)^3)/(4*(a2+b2*x20)^2)-(5*b3^2*(x3-x30)^4)/(32*(a3+b3*x30)^3)+(b3*(x3-x30)^3)/(4*(a3+b3*x30)^2)-((x3-x30)^2+((x1-x10)^2*(a3+b3*x30))/(a1+b1*x10)+((x2-x20)^2*(a3+b3*x30))/(a2+b2*x20))/(2*(a3+b3*x30));

c0 = ((x1-x10)^2*(b1^2-4*a1*k11-4*b1*(k11*m1+k12*(m2-x20))))/(8*(a1+b1*x10)^2)+((b2^2-4*a2*k22-4*b2*(k22*m2+k21*(m1-x10)))*(x2-x20)^2)/(8*(a2+b2*x20)^2)-((x1-x10)*(b1-4*k11*m1-4*k12*m2+4*k11*x10+4*k12*x20))/(4*(a1+b1*x10))-((x1-x10)*(x2-x20)*(a2*k12+a1*k21+b1*k21*x10+b2*k12*x20))/(2*(a1+b1*x10)*(a2+b2*x20))-((x2-x20)*(b2-4*k21*m1-4*k22*m2+4*k21*x10+4*k22*x20))/(4*(a2+b2*x20))+((b3^2-4*a3*k33-4*b3*k33*m3)*(x3-x30)^2)/(8*(a3+b3*x30)^2)-((x3-x30)*(b3+4*k33*(-m3+x30)))/(4*(a3+b3*x30));

c1 = (32*k33-(3*b1^2)/(a1+b1*x10)+(16*b1*k12*m2)/(a1+b1*x10)-(16*k12^2*m2^2)/(a1+b1*x10)-(16*k11^2*(m1-x10)^2)/(a1+b1*x10)+(16*k11*(a1+b1*m1-2*k12*(m1-x10)*(m2-x20)))/(a1+b1*x10)-(16*b1*k12*x20)/(a1+b1*x10)+(32*k12^2*m2*x20)/(a1+b1*x10)-(16*k12^2*x20^2)/(a1+b1*x10)-(3*b2^2)/(a2+b2*x20)+(16*b2*k21*m1)/(a2+b2*x20)-(16*k21^2*m1^2)/(a2+b2*x20)-(16*b2*k21*x10)/(a2+b2*x20)+(32*k21^2*m1*x10)/(a2+b2*x20)-(16*k21^2*x10^2)/(a2+b2*x20)+(16*k22*(a2+b2*m2-2*k21*(m1-x10)*(m2-x20)))/(a2+b2*x20)-(16*k22^2*(m2-x20)^2)/(a2+b2*x20)-(3*b3^2)/(a3+b3*x30)-(16*a3*k33)/(a3+b3*x30)+(16*b3*k33*m3)/(a3+b3*x30)-(16*k33^2*m3^2)/(a3+b3*x30)-(32*b3*k33*x30)/(a3+b3*x30)+(32*k33^2*m3*x30)/(a3+b3*x30)-(16*k33^2*x30^2)/(a3+b3*x30))/32;

output = - (3/2)*log(2*pi*del) - Dv + cm1/del + c0 + c1*del;