function output = ModelT3(x,x0,del,param)

% mu1(x1_, x2_, x3_) = k11*(g1 - x1) + k12*(g2 - x2) + k13*(g3 - x3);
% mu2(x1_, x2_, x3_) = k22*(g2 - x2);
% mu3(x1_, x2_, x3_) = k33*(g3 - x3);
% 
% sig11(x1_, x2_, x3_) = s11*x1;
% sig21(x1_, x2_, x3_) = 0;
% sig31(x1_, x2_, x3_) = 0;
% sig12(x1_, x2_, x3_) = s12*x2;
% sig22(x1_, x2_, x3_) = s22*x2;
% sig32(x1_, x2_, x3_) = 0;
% sig13(x1_, x2_, x3_) = s13*x3;
% sig23(x1_, x2_, x3_) = 0;
% sig33(x1_, x2_, x3_) = s33*x3;
% 
% 
% ------------------------
% 
% 
% 
% Here is the expression for the log-likelihood at order K = 1 for this model:
% 
% 
% ------------------------
% 
% 
% 
% lnpX(del_, x1_, x2_, x3_, x10_, x20_, x30_, 1) = - (3/2) log(2 pi del) - lndetv2(x1, x2, x3) + c(x1, x2, x3, x10, x20, x30, -1)/del + c(x1, x2, x3, x10, x20, x30, 0) + c(x1, x2, x3, x10, x20, x30, 1)*del;
% 
% 
% where 
% 
% 
% lndetv2(x1_, x2_, x3_) = log(s11) + log(s22)+ log(s33) + log(x1) + log(x2) + log(x3);
% 
% 
% c(x1,x2,x3,x10,x20,x30,-1) = 
% (x1 - x10)^3/(2*s11^2*x10^3) - (s12*(x1 - x10)^2*(x2 - x20))/(s11^2*s22*x10^3) + (s12^2*(x1 - x10)*(x2 - x20)^2)/(2*s11^2*s22^2*x10^3) + 
%  (x2 - x20)^3/(2*s22^2*x20^3) - (s13*(x1 - x10)^2*(x3 - x30))/(s11^2*s33*x10^3) + (s12*s13*(x1 - x10)*(x2 - x20)*(x3 - x30))/(s11^2*s22*s33*x10^3) + 
%  (s13^2*(x1 - x10)*(x3 - x30)^2)/(2*s11^2*s33^2*x10^3) + (x3 - x30)^3/(2*s33^2*x30^3) + ((x1 - x10)^4*(-11*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/
%   (24*s11^4*x10^6) - (s12*(x1 - x10)^3*(x2 - x20)*(-6*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/(6*s11^4*s22*x10^6) - 
%  (s13*(x1 - x10)^3*(x3 - x30)*(-6*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/(6*s11^4*s33*x10^6) + 
%  (s12*s13*(x1 - x10)^2*(x2 - x20)*(x3 - x30)*(-7*s11^2*x10^2 + 3*s12^2*x20^2 + 3*s13^2*x30^2))/(6*s11^4*s22*s33*x10^6) - 
%  (s12^2*(x1 - x10)*(x2 - x20)^3*(-(s11^2*s22*x10^3) + s12^3*x20^3 + s12*s13^2*x20*x30^2))/(6*s11^4*s22^3*x10^6*x20) + 
%  (s12^2*s13*(x2 - x20)^3*(x3 - x30)*(s12^3*x20^3 + s11^2*x10^2*(-(s22*x10) + s12*x20) + s12*s13^2*x20*x30^2))/(6*s11^4*s22^3*s33*x10^6*x20) + 
%  ((x2 - x20)^4*(-11*s11^4*s22^2*x10^6 + s12^6*x20^6 + s11^2*s12^3*x10^2*x20^3*(-2*s22*x10 + s12*x20) + s12^4*s13^2*x20^4*x30^2))/(24*s11^4*s22^4*x10^6*x20^4) - 
%  (s13^2*(x1 - x10)*(x3 - x30)^3*(-(s11^2*s33*x10^3) + s12^2*s13*x20^2*x30 + s13^3*x30^3))/(6*s11^4*s33^3*x10^6*x30) + 
%  ((x3 - x30)^4*(-11*s11^4*s33^2*x10^6 + s12^2*s13^4*x20^2*x30^4 + s13^6*x30^6 + s11^2*s13^3*x10^2*x30^3*(-2*s33*x10 + s13*x30)))/(24*s11^4*s33^4*x10^6*x30^4) + 
%  (s12*s13^2*(x2 - x20)*(x3 - x30)^3*(s12^2*s13*x20^2*x30 + s13^3*x30^3 + s11^2*x10^2*(-(s33*x10) + s13*x30)))/(6*s11^4*s22*s33^3*x10^6*x30) + 
%  (s12*(x1 - x10)^2*(x2 - x20)^2*(-(s11^2*x10^2*(s22*x10 + 7*s12*x20)) + 3*s12*x20*(s12^2*x20^2 + s13^2*x30^2)))/(12*s11^4*s22^2*x10^6*x20) + 
%  (s13*(x1 - x10)^2*(x3 - x30)^2*(-(s11^2*x10^2*(s33*x10 + 7*s13*x30)) + 3*s13*x30*(s12^2*x20^2 + s13^2*x30^2)))/(12*s11^4*s33^2*x10^6*x30) + 
%  (s12*s13*(x1 - x10)*(x2 - x20)^2*(x3 - x30)*(s11^2*s22*x10^3 - 3*(s12^3*x20^3 + s12*s13^2*x20*x30^2)))/(6*s11^4*s22^2*s33*x10^6*x20) + 
%  (s12*s13*(x1 - x10)*(x2 - x20)*(x3 - x30)^2*(s11^2*s33*x10^3 - 3*(s12^2*s13*x20^2*x30 + s13^3*x30^3)))/(6*s11^4*s22*s33^2*x10^6*x30) + 
%  (s12*s13*(x2 - x20)^2*(x3 - x30)^2*(3*s12*s13*x20*x30*(s12^2*x20^2 + s13^2*x30^2) - s11^2*x10^2*(s13*s22*x10*x30 + s12*x20*(s33*x10 - 3*s13*x30))))/
%   (12*s11^4*s22^2*s33^2*x10^6*x20*x30) - (s11^2*x10^2*(s22^2*x20^2*(x3 - x30)^2 + s33^2*(x2 - x20)^2*x30^2) + 
%    x20^2*x30^2*(s12*s33*(-x2 + x20) + s22*(s33*(x1 - x10) + s13*(-x3 + x30)))^2)/(2*s11^2*s22^2*s33^2*x10^2*x20^2*x30^2)
% 
% 
% 
% 
% c(x1,x2,x3,x10,x20,x30,0) = 
% -((x1 - x10)*(2*g3*k33*s13*s22 + 2*g2*k22*s12*s33 - 2*g1*k11*s22*s33 - 2*g2*k12*s22*s33 - 2*g3*k13*s22*s33 + 2*k11*s22*s33*x10 + s11^2*s22*s33*x10 - 
%      2*k22*s12*s33*x20 + 2*k12*s22*s33*x20 - 2*k33*s13*s22*x30 + 2*k13*s22*s33*x30))/(2*s11^2*s22*s33*x10^2) + 
%  ((x2 - x20)*(x3 - x30)*(-3*k22*s12*s13*x10^2 - 3*k33*s12*s13*x10^2 - 2*s11^2*s12*s13*x10^2 + 3*k12*s13*s22*x10^2 + 3*k13*s12*s33*x10^2 + s12^2*s13*s22*x10*x20 - 
%     2*s12^3*s13*x20^2 + s12*s13^2*s33*x10*x30 - 2*s12*s13^3*x30^2))/(6*s11^2*s22*s33*x10^4) + 
%  ((x1 - x10)^2*(-12*g1*k11*s22*s33*x10 + 12*g2*(k22*s12 - k12*s22)*s33*x10 + 12*g3*s22*(k33*s13 - k13*s33)*x10 + 6*k11*s22*s33*x10^2 + 3*s11^2*s22*s33*x10^2 - 
%     12*k22*s12*s33*x10*x20 + 12*k12*s22*s33*x10*x20 + s12*s22^2*s33*x10*x20 - 2*s12^2*s22*s33*x20^2 - 12*k33*s13*s22*x10*x30 + 12*k13*s22*s33*x10*x30 + 
%     s13*s22*s33^2*x10*x30 - 2*s13^2*s22*s33*x30^2))/(12*s11^2*s22*s33*x10^4) + 
%  ((x1 - x10)*(x2 - x20)*(6*g1*k11*s12*s22*s33*x10 + 6*g2*s12*(-(k22*s12) + k12*s22)*s33*x10 + 6*g3*s12*s22*(-(k33*s13) + k13*s33)*x10 - 3*k11*s12*s22*s33*x10^2 + 
%     3*k22*s12*s22*s33*x10^2 - 3*s11^2*s12*s22*s33*x10^2 - 3*k12*s22^2*s33*x10^2 + 6*k22*s12^2*s33*x10*x20 - 6*k12*s12*s22*s33*x10*x20 - s12^2*s22^2*s33*x10*x20 + 
%     2*s12^3*s22*s33*x20^2 + 6*k33*s12*s13*s22*x10*x30 - 6*k13*s12*s22*s33*x10*x30 - s12*s13*s22*s33^2*x10*x30 + 2*s12*s13^2*s22*s33*x30^2))/
%   (6*s11^2*s22^2*s33*x10^4) + ((x1 - x10)*(x3 - x30)*(6*g1*k11*s13*s22*s33*x10 + 6*g2*s13*(-(k22*s12) + k12*s22)*s33*x10 + 6*g3*s13*s22*(-(k33*s13) + k13*s33)*x10 - 
%     3*k11*s13*s22*s33*x10^2 + 3*k33*s13*s22*s33*x10^2 - 3*s11^2*s13*s22*s33*x10^2 - 3*k13*s22*s33^2*x10^2 + 6*k22*s12*s13*s33*x10*x20 - 6*k12*s13*s22*s33*x10*x20 - 
%     s12*s13*s22^2*s33*x10*x20 + 2*s12^2*s13*s22*s33*x20^2 + 6*k33*s13^2*s22*x10*x30 - 6*k13*s13*s22*s33*x10*x30 - s13^2*s22*s33^2*x10*x30 + 2*s13^3*s22*s33*x30^2))/
%   (6*s11^2*s22*s33^2*x10^4) + ((x3 - x30)*(2*g3*s22*(k33*s11^2*x10^2 + k33*s13^2*x30^2 - k13*s13*s33*x30^2) - 
%     x30*(2*k33*s22*(s11^2*x10^2 + s13^2*x30^2) + s33*(s11^2*s22*x10*(s33*x10 - 2*s13*x30) - 2*s13*x30*(g2*k22*s12 - g1*k11*s22 - g2*k12*s22 + k11*s22*x10 - 
%           k22*s12*x20 + k12*s22*x20 + k13*s22*x30)))))/(2*s11^2*s22*s33^2*x10^2*x30^2) + 
%  ((x2 - x20)*(2*g2*s33*(k22*s11^2*x10^2 + k22*s12^2*x20^2 - k12*s12*s22*x20^2) - 
%     x20*(2*k22*s33*(s11^2*x10^2 + s12^2*x20^2) + s22*(s11^2*s33*x10*(s22*x10 - 2*s12*x20) - 2*s12*x20*(g3*k33*s13 - g1*k11*s33 - g3*k13*s33 + k11*s33*x10 + 
%           k12*s33*x20 - k33*s13*x30 + k13*s33*x30)))))/(2*s11^2*s22^2*s33*x10^2*x20^2) + 
%  ((x2 - x20)^2*(-12*g2*k22*s11^2*x10^4 + x20*(s11^2*x10^2*(3*s22^2*x10^2 + s12*s22*x10*x20 - 2*s12^2*x20^2) + 6*k22*(s11^2*x10^4 - s12^2*x10^2*x20^2) + 
%       s12*x20^2*(6*k12*s22*x10^2 + s12*(s12*s22*x10*x20 - 2*s12^2*x20^2 + s13*x30*(s33*x10 - 2*s13*x30))))))/(12*s11^2*s22^2*x10^4*x20^3) + 
%  ((x3 - x30)^2*(-12*g3*k33*s11^2*x10^4 + x30*(s11^2*x10^2*(3*s33^2*x10^2 + s13*s33*x10*x30 - 2*s13^2*x30^2) + 6*k33*(s11^2*x10^4 - s13^2*x10^2*x30^2) + 
%       s13*x30^2*(6*k13*s33*x10^2 + s13*(s12*s22*x10*x20 - 2*s12^2*x20^2 + s13*x30*(s33*x10 - 2*s13*x30))))))/(12*s11^2*s33^2*x10^4*x30^3)
% 
% 
% 
% 
% 
% c(x1,x2,x3,x10,x20,x30,1) = 
% -(12*g3^2*s22^2*x20^2*(-2*k13*k33*s13*s33*x30^2 + k13^2*s33^2*x30^2 + k33^2*(s11^2*x10^2 + s13^2*x30^2)) - 
%    24*g3*s22*x20^2*x30*(k13*s33^2*x30*(g2*k22*s12 - g1*k11*s22 - g2*k12*s22 + k11*s22*x10 + s11^2*s22*x10 - k22*s12*x20 + k12*s22*x20 + k13*s22*x30) + 
%      k33^2*s22*(s11^2*x10^2 + s13^2*x30^2) + k33*s33*(s11^2*s22*x10*(s33*x10 - s13*x30) + s13*x30*(-(g2*k22*s12) + g1*k11*s22 + g2*k12*s22 - k11*s22*x10 + 
%          k22*s12*x20 - k12*s22*x20 - 2*k13*s22*x30))) + x30^2*(12*g2^2*s33^2*(-2*k12*k22*s12*s22*x20^2 + k12^2*s22^2*x20^2 + k22^2*(s11^2*x10^2 + s12^2*x20^2)) - 
%      24*g2*s33*x20*(k22^2*s33*(s11^2*x10^2 + s12^2*x20^2) + k12*s22^2*x20*(-(g1*k11*s33) + k11*s33*x10 + s11^2*s33*x10 + k12*s33*x20 - k33*s13*x30 + k13*s33*x30) + 
%        k22*s22*(s11^2*s33*x10*(s22*x10 - s12*x20) + s12*x20*(g1*k11*s33 - k11*s33*x10 - 2*k12*s33*x20 + k33*s13*x30 - k13*s33*x30))) + 
%      x20^2*(12*g1^2*k11^2*s22^2*s33^2 - 24*g1*k11*s22*s33*(k11*s22*s33*x10 + s11^2*s22*s33*x10 - k22*s12*s33*x20 + k12*s22*s33*x20 - k33*s13*s22*x30 + 
%          k13*s22*s33*x30) + 12*k33^2*s22^2*(s11^2*x10^2 + s13^2*x30^2) + 12*k33*s22*s33*(s11^2*s22*x10*(s33*x10 - 2*s13*x30) - 
%          2*s13*x30*(k11*s22*x10 - k22*s12*x20 + k12*s22*x20 + k13*s22*x30)) + s33^2*(12*k22^2*(s11^2*x10^2 + s12^2*x20^2) + 
%          12*k22*s22*(s11^2*x10*(s22*x10 - 2*s12*x20) - 2*s12*x20*(k11*x10 + k12*x20 + k13*x30)) + s22^2*(12*k11^2*x10^2 + 3*s11^4*x10^2 + 12*(k12*x20 + k13*x30)^2 + 
%            12*k11*x10*(s11^2*x10 + 2*k12*x20 + 2*k13*x30) + s11^2*(3*s22^2*x10^2 + 3*s33^2*x10^2 + 24*k12*x10*x20 + 2*s12*s22*x10*x20 - s12^2*x20^2 + 
%              24*k13*x10*x30 + 2*s13*s33*x10*x30 - s13^2*x30^2))))))/(24*s11^2*s22^2*s33^2*x10^2*x20^2*x30^2)



x1 = x(1);
x2 = x(2);
x3 = x(3);
x10 = x0(1);
x20 = x0(2);
x30 = x0(3);

g1 = param(1);
g2 = param(2);
g3 = param(3);
k11 = param(4);
k12 = param(5);
k13 = param(6);
k22 = param(7);
k33 = param(8);
s11 = param(9);
s12 = param(10);
s13 = param(11);
s22 = param(12);
s33 = param(13);

Dv = log(s11) + log(s22)+ log(s33) + log(x1) + log(x2) + log(x3);


cm1 = ...
(x1 - x10)^3/(2*s11^2*x10^3) - (s12*(x1 - x10)^2*(x2 - x20))/(s11^2*s22*x10^3) + (s12^2*(x1 - x10)*(x2 - x20)^2)/(2*s11^2*s22^2*x10^3) + ...
 (x2 - x20)^3/(2*s22^2*x20^3) - (s13*(x1 - x10)^2*(x3 - x30))/(s11^2*s33*x10^3) + (s12*s13*(x1 - x10)*(x2 - x20)*(x3 - x30))/(s11^2*s22*s33*x10^3) + ...
 (s13^2*(x1 - x10)*(x3 - x30)^2)/(2*s11^2*s33^2*x10^3) + (x3 - x30)^3/(2*s33^2*x30^3) + ((x1 - x10)^4*(-11*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/...
  (24*s11^4*x10^6) - (s12*(x1 - x10)^3*(x2 - x20)*(-6*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/(6*s11^4*s22*x10^6) - ...
 (s13*(x1 - x10)^3*(x3 - x30)*(-6*s11^2*x10^2 + s12^2*x20^2 + s13^2*x30^2))/(6*s11^4*s33*x10^6) + ...
 (s12*s13*(x1 - x10)^2*(x2 - x20)*(x3 - x30)*(-7*s11^2*x10^2 + 3*s12^2*x20^2 + 3*s13^2*x30^2))/(6*s11^4*s22*s33*x10^6) - ...
 (s12^2*(x1 - x10)*(x2 - x20)^3*(-(s11^2*s22*x10^3) + s12^3*x20^3 + s12*s13^2*x20*x30^2))/(6*s11^4*s22^3*x10^6*x20) + ...
 (s12^2*s13*(x2 - x20)^3*(x3 - x30)*(s12^3*x20^3 + s11^2*x10^2*(-(s22*x10) + s12*x20) + s12*s13^2*x20*x30^2))/(6*s11^4*s22^3*s33*x10^6*x20) + ...
 ((x2 - x20)^4*(-11*s11^4*s22^2*x10^6 + s12^6*x20^6 + s11^2*s12^3*x10^2*x20^3*(-2*s22*x10 + s12*x20) + s12^4*s13^2*x20^4*x30^2))/(24*s11^4*s22^4*x10^6*x20^4) - ...
 (s13^2*(x1 - x10)*(x3 - x30)^3*(-(s11^2*s33*x10^3) + s12^2*s13*x20^2*x30 + s13^3*x30^3))/(6*s11^4*s33^3*x10^6*x30) + ...
 ((x3 - x30)^4*(-11*s11^4*s33^2*x10^6 + s12^2*s13^4*x20^2*x30^4 + s13^6*x30^6 + s11^2*s13^3*x10^2*x30^3*(-2*s33*x10 + s13*x30)))/(24*s11^4*s33^4*x10^6*x30^4) + ...
 (s12*s13^2*(x2 - x20)*(x3 - x30)^3*(s12^2*s13*x20^2*x30 + s13^3*x30^3 + s11^2*x10^2*(-(s33*x10) + s13*x30)))/(6*s11^4*s22*s33^3*x10^6*x30) + ...
 (s12*(x1 - x10)^2*(x2 - x20)^2*(-(s11^2*x10^2*(s22*x10 + 7*s12*x20)) + 3*s12*x20*(s12^2*x20^2 + s13^2*x30^2)))/(12*s11^4*s22^2*x10^6*x20) + ...
 (s13*(x1 - x10)^2*(x3 - x30)^2*(-(s11^2*x10^2*(s33*x10 + 7*s13*x30)) + 3*s13*x30*(s12^2*x20^2 + s13^2*x30^2)))/(12*s11^4*s33^2*x10^6*x30) + ...
 (s12*s13*(x1 - x10)*(x2 - x20)^2*(x3 - x30)*(s11^2*s22*x10^3 - 3*(s12^3*x20^3 + s12*s13^2*x20*x30^2)))/(6*s11^4*s22^2*s33*x10^6*x20) + ...
 (s12*s13*(x1 - x10)*(x2 - x20)*(x3 - x30)^2*(s11^2*s33*x10^3 - 3*(s12^2*s13*x20^2*x30 + s13^3*x30^3)))/(6*s11^4*s22*s33^2*x10^6*x30) + ...
 (s12*s13*(x2 - x20)^2*(x3 - x30)^2*(3*s12*s13*x20*x30*(s12^2*x20^2 + s13^2*x30^2) - s11^2*x10^2*(s13*s22*x10*x30 + s12*x20*(s33*x10 - 3*s13*x30))))/...
  (12*s11^4*s22^2*s33^2*x10^6*x20*x30) - (s11^2*x10^2*(s22^2*x20^2*(x3 - x30)^2 + s33^2*(x2 - x20)^2*x30^2) + ...
   x20^2*x30^2*(s12*s33*(-x2 + x20) + s22*(s33*(x1 - x10) + s13*(-x3 + x30)))^2)/(2*s11^2*s22^2*s33^2*x10^2*x20^2*x30^2);




c0 = ...
-((x1 - x10)*(2*g3*k33*s13*s22 + 2*g2*k22*s12*s33 - 2*g1*k11*s22*s33 - 2*g2*k12*s22*s33 - 2*g3*k13*s22*s33 + 2*k11*s22*s33*x10 + s11^2*s22*s33*x10 - ...
     2*k22*s12*s33*x20 + 2*k12*s22*s33*x20 - 2*k33*s13*s22*x30 + 2*k13*s22*s33*x30))/(2*s11^2*s22*s33*x10^2) + ...
 ((x2 - x20)*(x3 - x30)*(-3*k22*s12*s13*x10^2 - 3*k33*s12*s13*x10^2 - 2*s11^2*s12*s13*x10^2 + 3*k12*s13*s22*x10^2 + 3*k13*s12*s33*x10^2 + s12^2*s13*s22*x10*x20 - ...
    2*s12^3*s13*x20^2 + s12*s13^2*s33*x10*x30 - 2*s12*s13^3*x30^2))/(6*s11^2*s22*s33*x10^4) + ...
 ((x1 - x10)^2*(-12*g1*k11*s22*s33*x10 + 12*g2*(k22*s12 - k12*s22)*s33*x10 + 12*g3*s22*(k33*s13 - k13*s33)*x10 + 6*k11*s22*s33*x10^2 + 3*s11^2*s22*s33*x10^2 - ...
    12*k22*s12*s33*x10*x20 + 12*k12*s22*s33*x10*x20 + s12*s22^2*s33*x10*x20 - 2*s12^2*s22*s33*x20^2 - 12*k33*s13*s22*x10*x30 + 12*k13*s22*s33*x10*x30 + ...
    s13*s22*s33^2*x10*x30 - 2*s13^2*s22*s33*x30^2))/(12*s11^2*s22*s33*x10^4) + ...
 ((x1 - x10)*(x2 - x20)*(6*g1*k11*s12*s22*s33*x10 + 6*g2*s12*(-(k22*s12) + k12*s22)*s33*x10 + 6*g3*s12*s22*(-(k33*s13) + k13*s33)*x10 - 3*k11*s12*s22*s33*x10^2 + ...
    3*k22*s12*s22*s33*x10^2 - 3*s11^2*s12*s22*s33*x10^2 - 3*k12*s22^2*s33*x10^2 + 6*k22*s12^2*s33*x10*x20 - 6*k12*s12*s22*s33*x10*x20 - s12^2*s22^2*s33*x10*x20 + ...
    2*s12^3*s22*s33*x20^2 + 6*k33*s12*s13*s22*x10*x30 - 6*k13*s12*s22*s33*x10*x30 - s12*s13*s22*s33^2*x10*x30 + 2*s12*s13^2*s22*s33*x30^2))/...
  (6*s11^2*s22^2*s33*x10^4) + ((x1 - x10)*(x3 - x30)*(6*g1*k11*s13*s22*s33*x10 + 6*g2*s13*(-(k22*s12) + k12*s22)*s33*x10 + 6*g3*s13*s22*(-(k33*s13) + k13*s33)*x10 - ...
    3*k11*s13*s22*s33*x10^2 + 3*k33*s13*s22*s33*x10^2 - 3*s11^2*s13*s22*s33*x10^2 - 3*k13*s22*s33^2*x10^2 + 6*k22*s12*s13*s33*x10*x20 - 6*k12*s13*s22*s33*x10*x20 - ...
    s12*s13*s22^2*s33*x10*x20 + 2*s12^2*s13*s22*s33*x20^2 + 6*k33*s13^2*s22*x10*x30 - 6*k13*s13*s22*s33*x10*x30 - s13^2*s22*s33^2*x10*x30 + 2*s13^3*s22*s33*x30^2))/...
  (6*s11^2*s22*s33^2*x10^4) + ((x3 - x30)*(2*g3*s22*(k33*s11^2*x10^2 + k33*s13^2*x30^2 - k13*s13*s33*x30^2) - ...
    x30*(2*k33*s22*(s11^2*x10^2 + s13^2*x30^2) + s33*(s11^2*s22*x10*(s33*x10 - 2*s13*x30) - 2*s13*x30*(g2*k22*s12 - g1*k11*s22 - g2*k12*s22 + k11*s22*x10 - ...
          k22*s12*x20 + k12*s22*x20 + k13*s22*x30)))))/(2*s11^2*s22*s33^2*x10^2*x30^2) + ...
 ((x2 - x20)*(2*g2*s33*(k22*s11^2*x10^2 + k22*s12^2*x20^2 - k12*s12*s22*x20^2) - ...
    x20*(2*k22*s33*(s11^2*x10^2 + s12^2*x20^2) + s22*(s11^2*s33*x10*(s22*x10 - 2*s12*x20) - 2*s12*x20*(g3*k33*s13 - g1*k11*s33 - g3*k13*s33 + k11*s33*x10 + ...
          k12*s33*x20 - k33*s13*x30 + k13*s33*x30)))))/(2*s11^2*s22^2*s33*x10^2*x20^2) + ...
 ((x2 - x20)^2*(-12*g2*k22*s11^2*x10^4 + x20*(s11^2*x10^2*(3*s22^2*x10^2 + s12*s22*x10*x20 - 2*s12^2*x20^2) + 6*k22*(s11^2*x10^4 - s12^2*x10^2*x20^2) + ...
      s12*x20^2*(6*k12*s22*x10^2 + s12*(s12*s22*x10*x20 - 2*s12^2*x20^2 + s13*x30*(s33*x10 - 2*s13*x30))))))/(12*s11^2*s22^2*x10^4*x20^3) + ...
 ((x3 - x30)^2*(-12*g3*k33*s11^2*x10^4 + x30*(s11^2*x10^2*(3*s33^2*x10^2 + s13*s33*x10*x30 - 2*s13^2*x30^2) + 6*k33*(s11^2*x10^4 - s13^2*x10^2*x30^2) + ...
      s13*x30^2*(6*k13*s33*x10^2 + s13*(s12*s22*x10*x20 - 2*s12^2*x20^2 + s13*x30*(s33*x10 - 2*s13*x30))))))/(12*s11^2*s33^2*x10^4*x30^3);





c1 = ...
-(12*g3^2*s22^2*x20^2*(-2*k13*k33*s13*s33*x30^2 + k13^2*s33^2*x30^2 + k33^2*(s11^2*x10^2 + s13^2*x30^2)) - ...
   24*g3*s22*x20^2*x30*(k13*s33^2*x30*(g2*k22*s12 - g1*k11*s22 - g2*k12*s22 + k11*s22*x10 + s11^2*s22*x10 - k22*s12*x20 + k12*s22*x20 + k13*s22*x30) + ...
     k33^2*s22*(s11^2*x10^2 + s13^2*x30^2) + k33*s33*(s11^2*s22*x10*(s33*x10 - s13*x30) + s13*x30*(-(g2*k22*s12) + g1*k11*s22 + g2*k12*s22 - k11*s22*x10 + ...
         k22*s12*x20 - k12*s22*x20 - 2*k13*s22*x30))) + x30^2*(12*g2^2*s33^2*(-2*k12*k22*s12*s22*x20^2 + k12^2*s22^2*x20^2 + k22^2*(s11^2*x10^2 + s12^2*x20^2)) - ...
     24*g2*s33*x20*(k22^2*s33*(s11^2*x10^2 + s12^2*x20^2) + k12*s22^2*x20*(-(g1*k11*s33) + k11*s33*x10 + s11^2*s33*x10 + k12*s33*x20 - k33*s13*x30 + k13*s33*x30) + ...
       k22*s22*(s11^2*s33*x10*(s22*x10 - s12*x20) + s12*x20*(g1*k11*s33 - k11*s33*x10 - 2*k12*s33*x20 + k33*s13*x30 - k13*s33*x30))) + ...
     x20^2*(12*g1^2*k11^2*s22^2*s33^2 - 24*g1*k11*s22*s33*(k11*s22*s33*x10 + s11^2*s22*s33*x10 - k22*s12*s33*x20 + k12*s22*s33*x20 - k33*s13*s22*x30 + ...
         k13*s22*s33*x30) + 12*k33^2*s22^2*(s11^2*x10^2 + s13^2*x30^2) + 12*k33*s22*s33*(s11^2*s22*x10*(s33*x10 - 2*s13*x30) - ...
         2*s13*x30*(k11*s22*x10 - k22*s12*x20 + k12*s22*x20 + k13*s22*x30)) + s33^2*(12*k22^2*(s11^2*x10^2 + s12^2*x20^2) + ...
         12*k22*s22*(s11^2*x10*(s22*x10 - 2*s12*x20) - 2*s12*x20*(k11*x10 + k12*x20 + k13*x30)) + s22^2*(12*k11^2*x10^2 + 3*s11^4*x10^2 + 12*(k12*x20 + k13*x30)^2 + ...
           12*k11*x10*(s11^2*x10 + 2*k12*x20 + 2*k13*x30) + s11^2*(3*s22^2*x10^2 + 3*s33^2*x10^2 + 24*k12*x10*x20 + 2*s12*s22*x10*x20 - s12^2*x20^2 + ...
             24*k13*x10*x30 + 2*s13*s33*x10*x30 - s13^2*x30^2))))))/(24*s11^2*s22^2*s33^2*x10^2*x20^2*x30^2);

output = - (3/2)* log(2* pi* del) - Dv + cm1/del + c0 + c1*del;             