function output = ModelT5(x,x0,del,param)

% This model has three state variables, X1,x2 and X3, with dynamics
% 
% dX1 = mu1(x1,x2,x3) dt + sigma11(x1,x2,x3) dW1 + sigma12(x1,x2,x3) dW2+ sigma13(x1,x2,x3) dW3
% 
% dX2 = mu2(x1,x2,x3) dt + sigma21(x1,x2,x3) dW1 + sigma22(x1,x2,x3) dW2+ sigma23(x1,x2,x3) dW3
% 
% dX3 = mu3(x1,x2,x3) dt + sigma31(x1,x2,x3) dW1 + sigma32(x1,x2,x3) dW2+ sigma33(x1,x2,x3) dW3
% 
% 
% @@ x1~log stock, x2~variance, x3~interest rate @@
% @@ v1 mean reversion, v2 long term variance, v3 volatility of variance process.
% @@ r1 long term mean, could this parameter be time dependent as in the Hull-White model (see Brigo and Mercurio (2006, Chapter 3))?, r2 mean reversion, r3 volatility.
% 
% 
% The three Brownian motions are independent; any correlation comes through
% the off-diagonal terms in the sigma matrix.
% 
% 
% 
% mu1(x1,x2,x3)=x3-x2/2;
% mu2(x1,x2,x3)=v1*(v2-x2);
% mu3(x1,x2,x3)=r1-r2*x3;
% 
% sigma11(x1,x2,x3)=sqrt(x2);
% sigma12(x1,x2,x3)=0;
% sigma13(x1,x2,x3)=0;
% sigma21(x1,x2,x3)=rho12*v3*sqrt(x2);
% sigma22(x1,x2,x3)=sqrt(1-rho12^2)*v3*sqrt(x2);
% sigma23(x1,x2,x3)=0;
% sigma31(x1,x2,x3)=r3*rho13;
% sigma32(x1,x2,x3)=r3*((rho23-rho13*rho12)/(sqrt(1-rho12^2)));
% sigma33(x1,x2,x3)=r3*sqrt(1-rho13^2-((rho23-rho13*rho12)/(sqrt(1-rho12^2)))^2);
% 
% 
% 
% 
% 
% Dv(x1, x2, x3) = log(r3) + (1/2)*log(1 - rho12^2 - rho13^2 - rho23^2 + 2*rho12*rho13*rho23) + log(v3) + log(x2); 
% 
% 
% 
% 
% 
% lnpX(del, x1, x2, x3, x10, x20, x30) = (-3/2)*log(2*Pi*del) - Dv(x1, x2, x3) + c(x1, x2, x3, x10, x20, x30, -1)/del + c(x1, x2, x3, x10, x20, x30, 0) + c(x1, x2, x3, x10, x20, x30, 1)*del; 
% 
% 
% c(x1, x2, x3, x10, x20, x30, -1) = ((-1 + rho23^2)^2*v3^2*(x1 - x10)^4)/(96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) - ((-1 + rho23^2)*(rho13*rho23 + rho12*(-2 + rho23^2))*v3*(x1 - x10)^3*(x2 - x20))/(48*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) - ((14*(-1 + rho23^2)^2 + rho13^2*(-15 + 14*rho23^2) + rho12^2*(-20 + 19*rho23^2) + rho12*rho13*(36*rho23 - 34*rho23^3))*(x1 - x10)^2*(x2 - x20)^2)/ (96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) + ((-16*rho12^3 + 47*rho12^2*rho13*rho23 + rho13*rho23*(15*rho13^2 + 14*(-1 + rho23^2)) - rho12*(14*(-1 + rho23^2) + rho13^2*(15 + 31*rho23^2)))* (x1 - x10)*(x2 - x20)^3)/(48*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^3) + ((-15*rho13^4 + rho12^2*(16 - 15*rho13^2) + rho12*(-32*rho13*rho23 + 30*rho13^3*rho23) + rho13^2*(30 - 14*rho23^2) + 15*(-1 + rho23^2))*(x2 - x20)^4)/ (96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3^2*x20^3) + ((-1 + rho23^2)*(x1 - x10)^2*(x2 - x20))/(4*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20^2) + ((rho12 - rho13*rho23)*(x1 - x10)*(x2 - x20)^2)/(2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20^2) + ((-1 + rho13^2)*(x2 - x20)^3)/(4*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20^2) + (r3^2*((-(-1 + rho23^2))*v3^2*(x1 - x10)^2 - 2*(rho12 - rho13*rho23)*v3*(x1 - x10)*(x2 - x20) - (-1 + rho13^2)*(x2 - x20)^2) - 2*r3*v3*sqrt(x20)*(rho23*(rho12*v3*(-x1 + x10) + x2 - x20) + rho13*(v3*(x1 - x10) + rho12*(-x2 + x20)))*(x3 - x30) - (-1 + rho12^2)*v3^2*x20*(x3 - x30)^2)/ (2*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20) + ((rho13 - rho12*rho23)*(-1 + rho23^2)*v3^2*(x1 - x10)^3*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) - ((rho13^2*rho23 + rho12*rho13*(-3 + rho23^2) + rho12^2*(3*rho23 - 2*rho23^3))*v3*(x1 - x10)^2*(x2 - x20)*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) - ((6*rho13^3 - 20*rho12*rho13^2*rho23 + rho12*rho23*(5 - 8*rho12^2 - 5*rho23^2) + rho13*(5*(-1 + rho23^2) + 2*rho12^2*(4 + 7*rho23^2)))* (x1 - x10)*(x2 - x20)^2*(x3 - x30))/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) + ((6*rho12^3*rho13 - rho12^2*(7 + 12*rho13^2)*rho23 + rho23*(6 - 7*rho13^2 - 6*rho23^2) + rho12*rho13*(-5 + 6*rho13^2 + 19*rho23^2))*(x2 - x20)^3*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^(5/2)) + ((rho13 - rho12*rho23)*(x1 - x10)*(x2 - x20)*(x3 - x30))/(4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20^(3/2)) + (((-rho12)*rho13 + rho23)*(x2 - x20)^2*(x3 - x30))/(4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20^(3/2)) + ((rho13 - rho12*rho23)^2*v3^2*(x1 - x10)^2*(x3 - x30)^2)/ (96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2) - (rho12*(rho13 - rho12*rho23)^2*v3*(x1 - x10)*(x2 - x20)*(x3 - x30)^2)/ (48*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2) + ((rho13 - rho12*rho23)^2*(x2 - x20)^2*(x3 - x30)^2)/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2); 
% 
% 
% 
% 
% c(x1, x2, x3, x10, x20, x30, 0) = -(((-1 + rho23^2)*(-4 + 5*rho13^2 - 10*rho12*rho13*rho23 + 4*rho23^2 + rho12^2*(4 + rho23^2))*v3^2*(x1 - x10)^2)/(96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2)) + (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(3/2)))*(x1 - x10)*(24*r3*rho12^2*(-1 + rho23^2)*sqrt(x20) + 24*r3*(-1 + rho23^2)^2*sqrt(x20) - 2*rho13^3*(v3^2 + 12*r2*x20) + rho12*rho23*(-1 + rho23^2)*(v3^2 + 24*r2*x20) + rho12^3*rho23*((1 + rho23^2)*v3^2 + 24*r2*x20) + 6*rho13^2*(4*r3*(-1 + rho23^2)*sqrt(x20) + rho12*rho23*(v3^2 + 12*r2*x20)) - rho13*((-1 + rho23^2 + rho12^2*(1 + 5*rho23^2))*v3^2 + 24*(2*r3*rho12*rho23*(-1 + rho23^2)*sqrt(x20) + r2*(-1 + rho12^2 + rho23^2 + 2*rho12^2*rho23^2)*x20)))*(x3 - x30) + (1/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20))*(48*r3*rho13^3*sqrt(x20) - 48*r3*rho12^3*rho23*sqrt(x20) - 48*r3*rho12*rho23*(-1 + rho23^2)*sqrt(x20) + 48*r2*(-1 + rho23^2)*x20 - rho12^4*(rho23^2*v3^2 + 48*r2*x20) + rho12^2*(96*r2*x20 + rho23^2*(v3^2 - 48*r2*x20)) + 2*rho13*(24*r3*(-1 + rho23^2)*sqrt(x20) + 24*r3*rho12^2*(1 + 2*rho23^2)*sqrt(x20) - rho12*rho23*(v3^2 + 48*r2*x20) + rho12^3*rho23*(v3^2 + 48*r2*x20)) + rho13^2*((-(-1 + rho12^2))*v3^2 - 48*(3*r3*rho12*rho23*sqrt(x20) + r2*(-1 + rho12^2)*x20)))*(x3 - x30)^2 + ((x3 - x30)*(r3*(rho12^2*rho23*v3^2 - rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) + rho12*(4*rho13*v1*(-v2 + x20) + 2*rho23*v3*(x20 - 2*x30)) - 2*rho13*v3*(x20 - 2*x30)) + 4*(-1 + rho12^2)*v3*sqrt(x20)*(r1 - r2*x30)))/ (4*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*sqrt(x20)) + ((x1 - x10)*(r3*(rho12*((-rho23^2)*v3^2 + 4*v1*(v2 - x20)) + rho13*rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) - 2*(-1 + rho23^2)*v3*(x20 - 2*x30)) + 4*(rho13 - rho12*rho23)*v3*sqrt(x20)*(r1 - r2*x30)))/ (4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20) + (1/(96*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3^2*x20^2))*(x2 - x20)^2* (24*(rho12^3*rho13 - rho12^2*(rho23 + 2*rho13^2*rho23) - rho23*(-1 + rho13^2 + rho23^2) + rho12*rho13*(-1 + rho13^2 + 3*rho23^2))*v3*sqrt(x20)*(r1 - r2*x30) - r3*(48*(-1 + rho13^2)*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v1*v2 + v3*((3*rho13^4 - 14*rho12^3*rho13*rho23 + rho13^2*(-7 + 18*rho23^2) - 2*rho12*rho13*rho23*(-12 + 10*rho13^2 + 23*rho23^2) + 4*(1 - 5*rho23^2 + 4*rho23^4) + rho12^2*(-4 + 15*rho23^2 + rho13^2*(2 + 29*rho23^2)))*v3 + 48*(rho12^3 - 3*rho12^2*rho13*rho23 - rho13*rho23*(-1 + rho13^2 + rho23^2) + rho12*(-1 + rho23^2 + rho13^2*(1 + 2*rho23^2)))*x30))) + (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^(3/2)))*(x2 - x20)*(x3 - x30)* (-4*rho12^4*rho23*v3^2 - 3*rho23^3*(-v3^2 + 8*r3*rho13*sqrt(x20) + 8*r2*x20 + 4*v1*(v2 + x20)) + rho23*((-3 + 2*rho13^2)*v3^2 - 24*(-1 + rho13^2)*(r3*rho13 + r2*sqrt(x20))*sqrt(x20) - 12*(-1 + rho13^2)*v1*(v2 + x20)) - 6*rho13*(-1 + rho13^2)*v3*(x20 + 2*x30) - 6*rho13*rho23^2*v3*(x20 + 2*x30) - rho12^2*(5*rho23^3*v3^2 + rho23*((-7 + 8*rho13^2)*v3^2 + 12*(1 + 2*rho13^2)*v1*(v2 + x20) + 24*(3*r3*rho13*sqrt(x20) + r2*x20 + 2*r2*rho13^2*x20)) + 6*rho13*v3*(x20 + 2*x30) + 12*rho13*rho23^2*v3*(x20 + 2*x30)) + rho12^3*(rho13*(v3^2 + 9*rho23^2*v3^2 + 24*r2*x20 + 12*v1*(v2 + x20)) + 6*(4*r3*sqrt(x20) + rho23*v3*(x20 + 2*x30))) + rho12*(2*rho13^3*(v3^2 + 12*r2*x20 + 6*v1*(v2 + x20)) + rho13*((-(1 + 3*rho23^2))*v3^2 + 24*r2*(-1 + 3*rho23^2)*x20 + 12*(-1 + 3*rho23^2)*v1*(v2 + x20)) + 6*(-1 + rho23^2)*(4*r3*sqrt(x20) + rho23*v3*(x20 + 2*x30)) + 6*rho13^2*(4*r3*(1 + 2*rho23^2)*sqrt(x20) + 3*rho23*v3*(x20 + 2*x30)))) + ((x2 - x20)*(-4*(rho12*rho13 - rho23)*v3*sqrt(x20)*(r1 - r2*x30) + r3*(4*(-1 + rho13^2)*v1*(v2 - x20) + v3*((-rho12)*(rho13*rho23*v3 + 2*x20 - 4*x30) + rho23*(rho23*v3 + 2*rho13*x20 - 4*rho13*x30)))))/ (4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20) - (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^2))*(x1 - x10)*(x2 - x20)* (12*(rho13^3 - 3*rho12*rho13^2*rho23 - rho12*rho23*(-1 + rho12^2 + rho23^2) + rho13*(-1 + rho23^2 + rho12^2*(1 + 2*rho23^2)))*v3*sqrt(x20)*(r1 - r2*x30) + r3*((-rho13)*rho23*(-1 + rho23^2)*(24*v1*v2 - 5*v3^2) + 4*rho13^3*rho23*(-6*v1*v2 + v3^2) + 4*rho12^3*(6*v1*v2 + (1 - 2*rho23^2)*v3^2) + 24*rho13^2*(-1 + rho23^2)*v3*x30 + 24*(-1 + rho23^2)^2*v3*x30 + rho12^2*(rho13*rho23*(-72*v1*v2 + (-5 + 17*rho23^2)*v3^2) + 24*(-1 + rho23^2)*v3*x30) + rho12*(24*(-1 + rho23^2 + rho13^2*(1 + 2*rho23^2))*v1*v2 + v3*((-4 + 13*rho23^2 - 9*rho23^4 + rho13^2*(5 - 17*rho23^2))*v3 - 48*rho13*rho23*(-1 + rho23^2)*x30)))); 
% 
% 
% 
% 
% c(x1, x2, x3, x10, x20, x30, 1) = (1/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20))* (-24*r3*v3*sqrt(x20)*(rho12^2*rho23*v3^2 - rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) + rho12*(4*rho13*v1*(-v2 + x20) + 2*rho23*v3*(x20 - 2*x30)) - 2*rho13*v3*(x20 - 2*x30))*(r1 - r2*x30) - 48*(-1 + rho12^2)*v3^2*x20*(r1 - r2*x30)^2 + r3^2*(-48*(-1 + rho13^2)*v1^2*(v2 - x20)^2 + v3^2*((-(-8 + 7*rho13^2 - 14*rho12*rho13*rho23 + 5*rho23^2 + 2*rho12^2*(4 + rho23^2)))*v3^2 + 12*(4*r2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20 - (-1 + rho23^2)*(x20 - 2*x30)^2) + 12*rho23*(rho13 - rho12*rho23)*v3*(x20 - 2*x30)) + 24*v1*v3*(v2*((-2 + 2*rho12^2 + 2*rho13^2 - 3*rho12*rho13*rho23 + rho23^2)*v3 + 2*(rho12 - rho13*rho23)*(x20 - 2*x30)) + x20*((-rho12)*(rho13*rho23*v3 + 2*x20 - 4*x30) + rho23*(rho23*v3 + 2*rho13*x20 - 4*rho13*x30))))); 


x1 = x(1);
x2 = x(2);
x3 = x(3);
x10 = x0(1);
x20 = x0(2);
x30 = x0(3);

v1 = param(1);
v2 = param(2);
v3 = param(3);
r1 = param(4);
r2 = param(5);
r3 = param(6);
rho12 = param(7);
rho13 = param(8);
rho23 = param(9);

Dv = log(r3) + (1/2)*log(1 - rho12^2 - rho13^2 - rho23^2 + 2*rho12*rho13*rho23) + log(v3) + log(x2); 

cm1 = ((-1 + rho23^2)^2*v3^2*(x1 - x10)^4)/(96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) - ((-1 + rho23^2)*(rho13*rho23 + rho12*(-2 + rho23^2))*v3*(x1 - x10)^3*(x2 - x20))/(48*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) - ((14*(-1 + rho23^2)^2 + rho13^2*(-15 + 14*rho23^2) + rho12^2*(-20 + 19*rho23^2) + rho12*rho13*(36*rho23 - 34*rho23^3))*(x1 - x10)^2*(x2 - x20)^2)/ (96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^3) + ((-16*rho12^3 + 47*rho12^2*rho13*rho23 + rho13*rho23*(15*rho13^2 + 14*(-1 + rho23^2)) - rho12*(14*(-1 + rho23^2) + rho13^2*(15 + 31*rho23^2)))* (x1 - x10)*(x2 - x20)^3)/(48*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^3) + ((-15*rho13^4 + rho12^2*(16 - 15*rho13^2) + rho12*(-32*rho13*rho23 + 30*rho13^3*rho23) + rho13^2*(30 - 14*rho23^2) + 15*(-1 + rho23^2))*(x2 - x20)^4)/ (96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3^2*x20^3) + ((-1 + rho23^2)*(x1 - x10)^2*(x2 - x20))/(4*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20^2) + ((rho12 - rho13*rho23)*(x1 - x10)*(x2 - x20)^2)/(2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20^2) + ((-1 + rho13^2)*(x2 - x20)^3)/(4*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20^2) + (r3^2*((-(-1 + rho23^2))*v3^2*(x1 - x10)^2 - 2*(rho12 - rho13*rho23)*v3*(x1 - x10)*(x2 - x20) - (-1 + rho13^2)*(x2 - x20)^2) - 2*r3*v3*sqrt(x20)*(rho23*(rho12*v3*(-x1 + x10) + x2 - x20) + rho13*(v3*(x1 - x10) + rho12*(-x2 + x20)))*(x3 - x30) - (-1 + rho12^2)*v3^2*x20*(x3 - x30)^2)/ (2*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20) + ((rho13 - rho12*rho23)*(-1 + rho23^2)*v3^2*(x1 - x10)^3*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) - ((rho13^2*rho23 + rho12*rho13*(-3 + rho23^2) + rho12^2*(3*rho23 - 2*rho23^3))*v3*(x1 - x10)^2*(x2 - x20)*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) - ((6*rho13^3 - 20*rho12*rho13^2*rho23 + rho12*rho23*(5 - 8*rho12^2 - 5*rho23^2) + rho13*(5*(-1 + rho23^2) + 2*rho12^2*(4 + 7*rho23^2)))* (x1 - x10)*(x2 - x20)^2*(x3 - x30))/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(5/2)) + ((6*rho12^3*rho13 - rho12^2*(7 + 12*rho13^2)*rho23 + rho23*(6 - 7*rho13^2 - 6*rho23^2) + rho12*rho13*(-5 + 6*rho13^2 + 19*rho23^2))*(x2 - x20)^3*(x3 - x30))/ (48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^(5/2)) + ((rho13 - rho12*rho23)*(x1 - x10)*(x2 - x20)*(x3 - x30))/(4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20^(3/2)) + (((-rho12)*rho13 + rho23)*(x2 - x20)^2*(x3 - x30))/(4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20^(3/2)) + ((rho13 - rho12*rho23)^2*v3^2*(x1 - x10)^2*(x3 - x30)^2)/ (96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2) - (rho12*(rho13 - rho12*rho23)^2*v3*(x1 - x10)*(x2 - x20)*(x3 - x30)^2)/ (48*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2) + ((rho13 - rho12*rho23)^2*(x2 - x20)^2*(x3 - x30)^2)/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2); 

c0 = -(((-1 + rho23^2)*(-4 + 5*rho13^2 - 10*rho12*rho13*rho23 + 4*rho23^2 + rho12^2*(4 + rho23^2))*v3^2*(x1 - x10)^2)/(96*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^2)) + (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20^(3/2)))*(x1 - x10)*(24*r3*rho12^2*(-1 + rho23^2)*sqrt(x20) + 24*r3*(-1 + rho23^2)^2*sqrt(x20) - 2*rho13^3*(v3^2 + 12*r2*x20) + rho12*rho23*(-1 + rho23^2)*(v3^2 + 24*r2*x20) + rho12^3*rho23*((1 + rho23^2)*v3^2 + 24*r2*x20) + 6*rho13^2*(4*r3*(-1 + rho23^2)*sqrt(x20) + rho12*rho23*(v3^2 + 12*r2*x20)) - rho13*((-1 + rho23^2 + rho12^2*(1 + 5*rho23^2))*v3^2 + 24*(2*r3*rho12*rho23*(-1 + rho23^2)*sqrt(x20) + r2*(-1 + rho12^2 + rho23^2 + 2*rho12^2*rho23^2)*x20)))*(x3 - x30) + (1/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*x20))*(48*r3*rho13^3*sqrt(x20) - 48*r3*rho12^3*rho23*sqrt(x20) - 48*r3*rho12*rho23*(-1 + rho23^2)*sqrt(x20) + 48*r2*(-1 + rho23^2)*x20 - rho12^4*(rho23^2*v3^2 + 48*r2*x20) + rho12^2*(96*r2*x20 + rho23^2*(v3^2 - 48*r2*x20)) + 2*rho13*(24*r3*(-1 + rho23^2)*sqrt(x20) + 24*r3*rho12^2*(1 + 2*rho23^2)*sqrt(x20) - rho12*rho23*(v3^2 + 48*r2*x20) + rho12^3*rho23*(v3^2 + 48*r2*x20)) + rho13^2*((-(-1 + rho12^2))*v3^2 - 48*(3*r3*rho12*rho23*sqrt(x20) + r2*(-1 + rho12^2)*x20)))*(x3 - x30)^2 + ((x3 - x30)*(r3*(rho12^2*rho23*v3^2 - rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) + rho12*(4*rho13*v1*(-v2 + x20) + 2*rho23*v3*(x20 - 2*x30)) - 2*rho13*v3*(x20 - 2*x30)) + 4*(-1 + rho12^2)*v3*sqrt(x20)*(r1 - r2*x30)))/ (4*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*sqrt(x20)) + ((x1 - x10)*(r3*(rho12*((-rho23^2)*v3^2 + 4*v1*(v2 - x20)) + rho13*rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) - 2*(-1 + rho23^2)*v3*(x20 - 2*x30)) + 4*(rho13 - rho12*rho23)*v3*sqrt(x20)*(r1 - r2*x30)))/ (4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3*x20) + (1/(96*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3^2*x20^2))*(x2 - x20)^2* (24*(rho12^3*rho13 - rho12^2*(rho23 + 2*rho13^2*rho23) - rho23*(-1 + rho13^2 + rho23^2) + rho12*rho13*(-1 + rho13^2 + 3*rho23^2))*v3*sqrt(x20)*(r1 - r2*x30) - r3*(48*(-1 + rho13^2)*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v1*v2 + v3*((3*rho13^4 - 14*rho12^3*rho13*rho23 + rho13^2*(-7 + 18*rho23^2) - 2*rho12*rho13*rho23*(-12 + 10*rho13^2 + 23*rho23^2) + 4*(1 - 5*rho23^2 + 4*rho23^4) + rho12^2*(-4 + 15*rho23^2 + rho13^2*(2 + 29*rho23^2)))*v3 + 48*(rho12^3 - 3*rho12^2*rho13*rho23 - rho13*rho23*(-1 + rho13^2 + rho23^2) + rho12*(-1 + rho23^2 + rho13^2*(1 + 2*rho23^2)))*x30))) + (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^(3/2)))*(x2 - x20)*(x3 - x30)* (-4*rho12^4*rho23*v3^2 - 3*rho23^3*(-v3^2 + 8*r3*rho13*sqrt(x20) + 8*r2*x20 + 4*v1*(v2 + x20)) + rho23*((-3 + 2*rho13^2)*v3^2 - 24*(-1 + rho13^2)*(r3*rho13 + r2*sqrt(x20))*sqrt(x20) - 12*(-1 + rho13^2)*v1*(v2 + x20)) - 6*rho13*(-1 + rho13^2)*v3*(x20 + 2*x30) - 6*rho13*rho23^2*v3*(x20 + 2*x30) - rho12^2*(5*rho23^3*v3^2 + rho23*((-7 + 8*rho13^2)*v3^2 + 12*(1 + 2*rho13^2)*v1*(v2 + x20) + 24*(3*r3*rho13*sqrt(x20) + r2*x20 + 2*r2*rho13^2*x20)) + 6*rho13*v3*(x20 + 2*x30) + 12*rho13*rho23^2*v3*(x20 + 2*x30)) + rho12^3*(rho13*(v3^2 + 9*rho23^2*v3^2 + 24*r2*x20 + 12*v1*(v2 + x20)) + 6*(4*r3*sqrt(x20) + rho23*v3*(x20 + 2*x30))) + rho12*(2*rho13^3*(v3^2 + 12*r2*x20 + 6*v1*(v2 + x20)) + rho13*((-(1 + 3*rho23^2))*v3^2 + 24*r2*(-1 + 3*rho23^2)*x20 + 12*(-1 + 3*rho23^2)*v1*(v2 + x20)) + 6*(-1 + rho23^2)*(4*r3*sqrt(x20) + rho23*v3*(x20 + 2*x30)) + 6*rho13^2*(4*r3*(1 + 2*rho23^2)*sqrt(x20) + 3*rho23*v3*(x20 + 2*x30)))) + ((x2 - x20)*(-4*(rho12*rho13 - rho23)*v3*sqrt(x20)*(r1 - r2*x30) + r3*(4*(-1 + rho13^2)*v1*(v2 - x20) + v3*((-rho12)*(rho13*rho23*v3 + 2*x20 - 4*x30) + rho23*(rho23*v3 + 2*rho13*x20 - 4*rho13*x30)))))/ (4*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20) - (1/(48*r3*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)^2*v3*x20^2))*(x1 - x10)*(x2 - x20)* (12*(rho13^3 - 3*rho12*rho13^2*rho23 - rho12*rho23*(-1 + rho12^2 + rho23^2) + rho13*(-1 + rho23^2 + rho12^2*(1 + 2*rho23^2)))*v3*sqrt(x20)*(r1 - r2*x30) + r3*((-rho13)*rho23*(-1 + rho23^2)*(24*v1*v2 - 5*v3^2) + 4*rho13^3*rho23*(-6*v1*v2 + v3^2) + 4*rho12^3*(6*v1*v2 + (1 - 2*rho23^2)*v3^2) + 24*rho13^2*(-1 + rho23^2)*v3*x30 + 24*(-1 + rho23^2)^2*v3*x30 + rho12^2*(rho13*rho23*(-72*v1*v2 + (-5 + 17*rho23^2)*v3^2) + 24*(-1 + rho23^2)*v3*x30) + rho12*(24*(-1 + rho23^2 + rho13^2*(1 + 2*rho23^2))*v1*v2 + v3*((-4 + 13*rho23^2 - 9*rho23^4 + rho13^2*(5 - 17*rho23^2))*v3 - 48*rho13*rho23*(-1 + rho23^2)*x30)))); 

c1 = (1/(96*r3^2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*v3^2*x20))* (-24*r3*v3*sqrt(x20)*(rho12^2*rho23*v3^2 - rho23*(-4*v1*v2 + v3^2 + 4*v1*x20) + rho12*(4*rho13*v1*(-v2 + x20) + 2*rho23*v3*(x20 - 2*x30)) - 2*rho13*v3*(x20 - 2*x30))*(r1 - r2*x30) - 48*(-1 + rho12^2)*v3^2*x20*(r1 - r2*x30)^2 + r3^2*(-48*(-1 + rho13^2)*v1^2*(v2 - x20)^2 + v3^2*((-(-8 + 7*rho13^2 - 14*rho12*rho13*rho23 + 5*rho23^2 + 2*rho12^2*(4 + rho23^2)))*v3^2 + 12*(4*r2*(-1 + rho12^2 + rho13^2 - 2*rho12*rho13*rho23 + rho23^2)*x20 - (-1 + rho23^2)*(x20 - 2*x30)^2) + 12*rho23*(rho13 - rho12*rho23)*v3*(x20 - 2*x30)) + 24*v1*v3*(v2*((-2 + 2*rho12^2 + 2*rho13^2 - 3*rho12*rho13*rho23 + rho23^2)*v3 + 2*(rho12 - rho13*rho23)*(x20 - 2*x30)) + x20*((-rho12)*(rho13*rho23*v3 + 2*x20 - 4*x30) + rho23*(rho23*v3 + 2*rho13*x20 - 4*rho13*x30))))); 

output = (-3/2)*log(2*pi*del) - Dv + cm1/del + c0 + c1*del; 


