function output = ModelU2(x,x0,del,param)

% mu(x_) = a + b*x; 
% 
% s(x_) = d*x; 
% 
% g(x_) = log(x)/d; 
% 
% 
% lnpX(del_, x_, x0_, 2, exact) = (-(1/2))*log(2*Pi*del) - log(s(x)) + cY(g(x), g(x0), -1, exact)/del + cY(g(x), g(x0), 0, exact) + 
%     cY(g(x), g(x0), 1, exact)*del + cY(g(x), g(x0), 2, exact)*(del^2/2); 
% 
% 
% cY(y, y0, -1, exact) = (-(1/2))*(y - y0)^2; 
% 
% cY(y, y0, 0, exact) = (E^((-d)*y) - E^((-d)*y0))*(-(a/d^2)) + (y - y0)*(b/d - d/2); 
% 
% cY(y, y0, 1, exact) = (a^2/(4*d^3))*((E^(-2*d*y) - E^(-2*d*y0))/(y - y0)) + ((a*b)/d^3 - a/d)*((E^((-d)*y) - E^((-d)*y0))/(y - y0)) - 
%     (2*b - d^2)^2/(8*d^2); 
% 
% cY(y, y0, 2, exact) = (-(a^2/(2*d^3)))*((E^(-2*d*y) - E^(-2*d*y0))/(y - y0)^3) + 
%     ((2*a)/d - (2*a*b)/d^3)*((E^((-d)*y) - E^((-d)*y0))/(y - y0)^3) + (-(a^2/(2*d^2)))*((E^(-2*d*y) + E^(-2*d*y0))/(y - y0)^2) + 
%     (a - (a*b)/d^2)*((E^((-d)*y) + E^((-d)*y0))/(y - y0)^2); 
% 
% (* Expressions below to be used for coefficients of order 1 and 2 at y0=y: *)
% 
% 
% cY(y, y, 1, exact) = (-4*a^2 - 8*a*(b - d^2)*E^(d*y) - (-2*b +
% d^2)^2*E^(2*d*y))/(E^(2*d*y)*(8*d^2));
% 
% cY(y, y, 2, exact) = ((1/6)*a*(-2*a + (-b + d^2)*E^(d*y)))/E^(2*d*y); 

a = param(1);
b = param(2);
d = param(3);

y = log(x)/d;
y0 = log(x0)/d;

E = exp(1);

sx = d*x;

cYm1 = (-(1/2))*(y - y0)^2;
cY0 = (E^((-d)*y) - E^((-d)*y0))*(-(a/d^2)) + (y - y0)*(b/d - d/2);

if y~=y0
    cY1 = (a^2/(4*d^3))*((E^(-2*d*y) - E^(-2*d*y0))/(y - y0)) + ((a*b)/d^3 - a/d)*((E^((-d)*y) - E^((-d)*y0))/(y - y0)) -  (2*b - d^2)^2/(8*d^2); 
    cY2 = (-(a^2/(2*d^3)))*((E^(-2*d*y) - E^(-2*d*y0))/(y - y0)^3) + ...
         ((2*a)/d - (2*a*b)/d^3)*((E^((-d)*y) - E^((-d)*y0))/(y - y0)^3) + (-(a^2/(2*d^2)))*((E^(-2*d*y) + E^(-2*d*y0))/(y - y0)^2) + ...
         (a - (a*b)/d^2)*((E^((-d)*y) + E^((-d)*y0))/(y - y0)^2); 
else
    cY1 = (-4*a^2 - 8*a*(b - d^2)*E^(d*y) - (-2*b + d^2)^2*E^(2*d*y))/(E^(2*d*y)*(8*d^2));
    cY2 = ((1/6)*a*(-2*a + (-b + d^2)*E^(d*y)))/E^(2*d*y); 
end
output = (-(1/2))*log(2*pi*del) - log(sx) + cYm1/del + cY0 +  cY1*del + cY2*(del^2/2);

