% Model = linear drift, CEV diffusion (Univariate Model U3), dX = b(a - X) dt + c X^d dW
% 4 parameters to be estimated: (a,b,c,d)
%
% Works for all values of d > 1/2 using two different forms of the loglik for d=1 and d~=1 in file closedform_expansion_cev_loglik



% starting values for MLE algorithm and simulated series
%% Step 1: Simulating CEV data
clear
astart=0.08; bstart=0.5; cstart=0.7; dstart=1.5;
del=1/52; 
x0=0.08;
param0 = [astart,bstart,cstart,dstart]';

% weekly data: del = 1/52
del = 1/52;

% read your data here: create a vector x where x(1) = first observations, x(n) = last observations

% instead, for illustrations purposes, let's just simulate a series from the model

n = 500;

    tic
    x0 = astart;
    factor = 21;
    nsimul = factor*n;
    delsimul = del/factor;

    rndn = randn(nsimul,1);
    xsimul = zeros(nsimul,1);
    xsimul(1) = x0;
    for i=2:nsimul,
        xsimul(i) = xsimul(i-1) + bstart*(astart-xsimul(i-1))*delsimul + cstart*xsimul(i-1)^dstart*sqrt(delsimul)*rndn(i);
    end;
    x = zeros(n,1);
    x(1) = x0; 
    for i=2:n,
        x(i) = xsimul(1+(i-1)*factor);
    end;
%%  Step 2: Estimation
home;close all;
% estimation
output = mymle(@ModelU3, x, del, param0);
% output = mymle(@ModelU3, x, del, param0,options);


%%  Step 3: Post estimation analysis
mymle_summary(output);
% mymle_summary(output,[output.param-output.se, output.param+output.se]);

