function mymle_summary(mle_output,varargin)
% Check local maximum by plotting the likelihood marginally around the mle
% estimate
%
% mymle_plot(mle_output,param_range)
% mle_output is the output struct produced by mymle
% param_range is a Kx2 matrix specifying the range for each parameter,
% where K is the dimension of the parameter vector

% Input checking
mle_param = mle_output.param;
K = length(mle_param);
if nargin == 1
    param_range = [mle_param - mle_output.se_robust mle_param + mle_output.se_robust];
elseif nargin == 2
    param_range = varargin{1};
    if size(param_range,1) ~= K || size(param_range,2)~=2
        error(['The param_range should be ' num2str(K) ' x 2 matrix']);
    end
else
   error('The number of input is wrong');
end

% Setting temporary search path
addpath(genpath(cd)); % adding the current folder and all subfolders

% Printing the MLE result
disp(repmat('*',1,30))
fprintf('%10s%10s%10s\n','COEF','SE','Robust SE');
se = mle_output.se;
se_robust = mle_output.se_robust;
for k=1:K
    fprintf('%10.4f%10.4f%10.4f\n',mle_param(k),se(k),se_robust(k));
end
disp(repmat('*',1,30))
disp(mle_output.exitmsg);

% Plotting the log-likelihood
nrows = floor(sqrt(K));
ncols = K/nrows;
figure;
for k=1:K
    subplot(nrows,ncols,k)
    tmp_grid = linspace(param_range(k,1),param_range(k,2),100);
    tmp_y = zeros(length(tmp_grid),1);
    tmp_param = mle_param;
    for i=1:length(tmp_grid)
        tmp_param(k) = tmp_grid(i);
        tmp_y(i) = -mle_output.objfun(tmp_param);
    end
    plot(tmp_grid,tmp_y);
    hold on;
    plot(mle_param(k),-mle_output.objfun(mle_param),'r*');
    hold off;
    xlabel(['Parameter ' num2str(k)])
end
% remove the search path
rmpath(genpath(cd));
