function [sig,fs] = splay4(action,param,param2)

warning off

if ((nargin == 0) | ((nargin == 1) & ~isstr(action)))

  callauto = ['ud = get(gcbf,''userdata'');',...
              '[ud.sig,ud.fs] = splay4(''auto'',get(gcbo,''value''),gcbf);',...
              'if size(ud.sig,2) == 1,ud.sig = ud.sig'';end,',... 
              'ud.dft = fft(ud.sig);',...
              'ud.ldft = length(ud.dft);',...
              'set(gcbf,''userdata'',ud);',...
              'if ud.currdes == 1, splay4(''timedes'',gcbf); else, splay4(''freqdes'',gcbf); end;',...
              'splay4(''apply'',gcbf);'];

  callws = ['ud = get(gcbf,''userdata'');',...
            'var = get(gcbo,''string'');',...
             'evalin(''base'',[''ud.sig = '',var,''+0;'']);',...
             'if size(ud.sig,2) == 1,ud.sig = ud.sig'';end,',... 
             'ud.dft = fft(ud.sig);',...
             'ud.ldft = length(ud.dft);',...
             'set(gcbf,''userdata'',ud);',...
             'if ud.currdes == 1, splay4(''timedes'',gcbf); else, splay4(''freqdes'',gcbf); end;',...
             'splay4(''apply'',gcbf);'];

  callfs = ['ud = get(gcbf,''userdata'');',...
            'ud.fs = str2num(get(gcbo,''string''));',...
            'set(gcbf,''userdata'',ud);',...
            'splay4(''apply'',gcbf);'];

  calllow = ['ud = get(gcbf,''userdata'');',...
            'ud.low = str2num(get(gcbo,''string''));',...
            'if ud.low > ud.high, t = ud.low; ud.low = ud.high; ud.high = t;',...
            'set(ud.lowbox,''string'',num2str(ud.low));',...
            'set(ud.highbox,''string'',num2str(ud.high));end;',...
            'ud.low = max(1,ud.low);',...
            'set(gcbf,''userdata'',ud);',...
            'splay4(''freqdes'',gcbf);'];

  callhigh = ['ud = get(gcbf,''userdata'');',...
            'ud.high = str2num(get(gcbo,''string''));',...
            'if ud.low > ud.high, t = ud.low; ud.low = ud.high; ud.high = t;',...
            'set(ud.lowbox,''string'',num2str(ud.low));',...
            'set(ud.highbox,''string'',num2str(ud.high));end;',...
            'set(gcbf,''userdata'',ud);',...
            'splay4(''freqdes'',gcbf);'];


  if (nargin == 0)
    ud.sig = zeros(1,256);
    ud.rsig = zeros(1,256);
  else
    ud.sig = action;
    ud.rsig = action;
  end

  ud.fs = 10000;

  ud.dft = fft(ud.sig);

  ud.ldft = length(ud.dft);

  ud.filt = [1 zeros(1,10)];
  ud.filtdft = fft(ud.filt,ud.ldft);

  ud.numbins = 11;
  ud.fbins = linspace(0,ud.fs/2,12);
  ud.flevs = ones(1,11);
  ud.tbins = [1:11];
  ud.tlevs = [1 zeros(1,10)];


  ud.currdes = 1;

  ud.fymax = 3;
  ud.fymin = 0;
  ud.fgrid = .2;

  ud.tymin = -3;
  ud.tymax = 3;
  ud.tgrid = .5;

  ud.low = 1;
  ud.high = floor(ud.fs/2);

  h0 = figure('Color',[0.8 0.8 0.8], ...
	'MenuBar','none', ...
	'Name','ELE 201 Signal Viewer and Audio Player: Filter Tipped', ...
	'NumberTitle','off', ...
	'Position',[10 200 1000 493], ...  
	'Tag','Fig1');

  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'CameraUpVectorMode','manual', ...
	'Color',[1 1 1], ...
	'Position',[66 271 367 190], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.tax = h1;

  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4973   -0.1217    9.1603], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[-0.07923497267759563 0.4920634920634921 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Position',[-0.180327868852459 1.169312169312169 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4973    1.0317    9.1603], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',callfs, ...
	'ListboxTop',0, ...
	'Position',[500 195 50 16.5], ...
	'Style','edit', ...
	'Tag','EditText1');

  ud.fsbox = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[440 192.75 55 25], ...
	'String',{'Sampling' 'Frequency'}, ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback','ud = get(gcbf,''userdata'');if ~isempty(ud.sig),sound(ud.sig,ud.fs);end', ...
	'ListboxTop',0, ...
	'Position',[435 270 72 28.5], ...
	'String','Play Original', ...
	'Tag','Pushbutton1');

  ud.autos = str2mat(' Onions',' Lack of faith',' So whiny',' Yes mmmm',...
         ' Artoo',' Noisy onions',' Phone Darth');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',callauto, ...
	'ListboxTop',0, ...
	'Position',[435 370 60.75 24], ...
	'String',ud.autos,...
	'Style','popupmenu', ...
	'Tag','PopupMenu1', ...
	'Value',1);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[440 400 79.5 12], ...
	'String','Built-in signals', ...
	'Style','text', ...
	'Tag','StaticText2');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',callws, ...
	'ListboxTop',0, ...
	'Position',[440 310 70 15], ...
	'Style','edit', ...
	'Tag','EditText2');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[440 330 55.5 22.5], ...
	'String',{'Workspace' 'Variable'}, ...
	'Style','text', ...
	'Tag','StaticText3');

  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'CameraUpVectorMode','manual', ...
	'Color',[1 1 1], ...
	'Position',[69 35.5 367 190], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.fax = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4973   -0.1217    9.1603], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.07923497267759565 0.4920634920634921 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-0.1885245901639344 2.412698412698413 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4973    1.0317    9.1603], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[100 465 170 12], ...
	'String','Signal samples in the time domain', ...
	'Style','text', ...
	'Tag','StaticText4');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[100 230 210 12.75], ...
	'String','DFT of original (blue) and filtered (green)', ...
	'Style','text', ...
	'Tag','StaticText5');

  h1 = uicontrol('Parent',h0, ...
        'Callback','splay4(''update'',gcbf)',...
	'Units','points', ...
	'ListboxTop',0, ...
	'Position',[435 160 95 26.25], ...
	'String','Update Response', ...
	'Tag','Pushbutton2');

  h1 = uicontrol('Parent',h0, ...
        'Callback','splay4(''apply'',gcbf)',...
	'Units','points', ...
	'ListboxTop',0, ...
	'Position',[435 120 69.25 26.25], ...
	'String','Apply Filter!', ...
	'Tag','Pushbutton2');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback','ud = get(gcbf,''userdata'');if ~isempty(ud.rsig),sound(ud.rsig,ud.fs);end', ...
	'ListboxTop',0, ...
	'Position',[435 90 69.25 26.25], ...
	'String','Play Filtered', ...
	'Tag','Pushbutton1');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[440 60 85 12], ...
	'String','Design Filter In...', ...
	'Style','text', ...
	'Tag','StaticText6');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'ListboxTop',0, ...
	'Position',[440 38 93 18.75], ...
	'String','Time Domain', ...
	'Style','radiobutton', ...
	'Tag','Radiobutton1',...
        'Value',1);

  h2 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'ListboxTop',0, ...
	'Position',[440 20 115 18.75], ...
	'String','Frequency Domain', ...
	'Style','radiobutton', ...
	'Tag','Radiobutton1');

  bgud.other = h2;
  bgud.action = 'timedes';

  set(h1,'UserData',bgud)

  bgud.other = h1;
  bgud.action = 'freqdes';

  set(h2,'UserData',bgud)

  set([h1 h2],'CallBack',...
      ['if(get(gcbo,''Value'')==1),',...
       'bgud = get(gcbo,''UserData''); set(bgud.other,''Value'',0),splay4(bgud.action,gcbf);',...
       'else,set(gcbo,''Value'',1),bgud = get(gcbo,''UserData'');end;'])


  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[625 273 266 186], ...
	'Tag','Axes2', ...
        'Visible','on',...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);
  ud.tdax1 = h1;

  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981132075471697 -0.1243243243243244 9.160254037844386], ...
	'Tag','Axes2Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[  -0.1094    0.4919    9.1603], ...
	'Rotation',90, ...
	'Tag','Axes2Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Position',[-2.358490566037736 1.183783783783784 9.160254037844386], ...
	'Tag','Axes2Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981    1.0324    9.1603], ...
	'Tag','Axes2Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[625 273 266 186], ...
	'Tag','Axes2', ...
        'Visible','off',...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.tdax2 = h1;

  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981132075471697 -0.1243243243243244 9.160254037844386], ...
	'Tag','Axes2Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[  -0.1094    0.4919    9.1603], ...
	'Rotation',90, ...
	'Tag','Axes2Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Position',[-2.358490566037736 1.183783783783784 9.160254037844386], ...
	'Tag','Axes2Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981    1.0324    9.1603], ...
	'Tag','Axes2Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);


  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[625 37.5 266 186], ...
	'Tag','Axes2', ...
        'Visible','on',...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.fdax1 = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4981132075471697 -0.1243243243243244 9.160254037844386], ...
	'Tag','Axes2Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.1094    0.4919    9.1603], ...
	'Rotation',90, ...
	'Tag','Axes2Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-2.358490566037736 2.454054054054054 9.160254037844386], ...
	'Tag','Axes2Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4981132075471697 1.032432432432432 9.160254037844386], ...
	'Tag','Axes2Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[625 37.5 266 186], ...
	'Tag','Axes2', ...
        'Visible','off',...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.fdax2 = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4981132075471697 -0.1243243243243244 9.160254037844386], ...
	'Tag','Axes2Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.1094    0.4919    9.1603], ...
	'Rotation',90, ...
	'Tag','Axes2Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-2.358490566037736 2.454054054054054 9.160254037844386], ...
	'Tag','Axes2Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4981132075471697 1.032432432432432 9.160254037844386], ...
	'Tag','Axes2Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[660 465 140 12], ...
	'String','Impulse response of filter', ...
	'Style','text', ...
	'Tag','StaticText7');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[660 230 150 12], ...
	'String','Frequency response of filter', ...
	'Style','text', ...
	'Tag','StaticText8');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[900 133 60 12], ...
	'String',{'Low edge:'}, ...
	'Style','text', ...
	'Tag','StaticText1');

  ud.lowtext = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',calllow, ...
	'ListboxTop',0, ...
	'Position',[910 115 31.5 15], ...
        'String','1',...
	'Style','edit', ...
	'Tag','EditText1');

  ud.lowbox = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',0.9*[1 1 1], ...
	'ListboxTop',0, ...
	'Position',[900 98 60 12], ...
	'String',{'High edge:'}, ...
	'Style','text', ...
	'Tag','StaticText1');

  ud.hightext = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',callhigh, ...
	'ListboxTop',0, ...
	'Position',[910 80 31.5 15], ...
        'String',num2str(floor(ud.fs/2)),...
	'Style','edit', ...
	'Tag','EditText1');

  ud.highbox = h1;

  rscall = (['for i=1:11,v = get(ud.fhand(i),''vertices'');',...
        '   v(:,2) = [1 1 0 0]'';',...
        '   set(ud.fhand(i),''vertices'',v);end;',...
        '   ud.flevs = ones(1,11);',...
        '   set(gcbf,''userdata'',ud);']);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',rscall, ...
	'Position',[900 45 50 25], ...
	'String','Reset');

  ud.frsbtn = h1;

  uscall = (['   y1 = get(ud.thand(1),''ydata'');',...
        '   summ = sum(y1);',...
        '   y1 = y1/summ;',...
        '   set(ud.thand(1),''ydata'',y1);',...
        '   ud.tlevs = ud.tlevs/summ;',...
        '   set(gcbf,''userdata'',ud);']);
 
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',uscall, ...
	'Position',[900 370 55 25], ...
	'String','Unit sum');

  ud.usbtn = h1;

  zscall = (['   y1 = get(ud.thand(1),''ydata'');',...
        '   summ = sum(y1);',...
        '   nz = (y1 ~= 0); lz = sum(nz);',...
        '   y1(nz) = y1(nz)-summ/lz;',...
        '   set(ud.thand(1),''ydata'',y1);',...
        '   ud.tlevs = y1;',...
        '   set(gcbf,''userdata'',ud);']);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',zscall, ...
	'Position',[900 340 60 25], ...
	'String','Zero sum');

  ud.zsbtn = h1;

  rscall = (['   y1 = [1, zeros(1,10)];',...
        '   set(ud.thand(1),''ydata'',y1);',...
        '   ud.tlevs = y1;',...
        '   set(gcbf,''userdata'',ud);']);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Callback',rscall, ...
	'Position',[900 310 50 25], ...
	'String','Reset');

  ud.rsbtn = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'Position',[900 400 80 12], ...
	'String','Normalizations:', ...
	'Style','text', ...
	'Tag','StaticText1');

  ud.normtext = h1;

  set(h0,'userdata',ud);

  if (nargin == 0)
    splay4('timedes',gcf);
    splay4('apply',gcf);
  end

  sig = [];
  fs = [];

elseif strcmp(action,'refresh')

%%disp('refresh');

  ud = get(param,'userdata');

  l = length(ud.sig);

  set(ud.fsbox,'string',num2str(ud.fs));

  if (ud.currdes == 1)
     ud.rsig = filter(ud.filt,1,ud.sig);
     ud.rdft = fft(ud.rsig);
  else
length(ud.filtdft);
     ud.rdft = ud.dft .* ud.filtdft;
     ud.rsig = real(ifft(ud.rdft));
  end

  axes(ud.tax);
  cla
  hold on

  plot(ud.sig,'b');
  plot(ud.rsig,'g');
  axis tight
  hold off

  axes(ud.fax);
  cla
  hold on
  plot([1:round(ud.ldft/2)]/ud.ldft*ud.fs,abs(ud.dft(1:round(ud.ldft/2))),'b');
  plot([1:round(ud.ldft/2)]/ud.ldft*ud.fs,abs(ud.rdft(1:round(ud.ldft/2))),'g');
  axis tight
  hold off

  set(param,'userdata',ud);

elseif strcmp(action,'auto');

  ud = get(param2,'userdata');

  fs = 8192;
  file = lower(ud.autos(param,:));
  file(file == ' ') = [];      % get rid of extra blanks in filename
  file = [file '.wav'];         % append .wav to filename
  display(file);
  [sig,fs] = audioread(file);
  ud.sig = sig/max(abs(sig));
  ud.fs = fs;

  set(param2,'userdata',ud);

elseif strcmp(action,'timedes');

%disp('timedes');

  ud = get(param,'userdata');

  ud.tbins = [1:11];
  ud.tlevs = [1 zeros(1,10)];

  set(param,'userdata',ud);

  axes(ud.tdax2),cla
  axes(ud.fdax2),cla

  set([ud.tdax2;ud.fdax2;ud.lowtext;ud.lowbox;ud.hightext;ud.highbox;ud.frsbtn],'visible','off');
  set([ud.tdax1;ud.fdax1;ud.normtext;ud.usbtn;ud.zsbtn;ud.rsbtn],'visible','on');

  ud.currdes = 1;

  axes(ud.tdax1);
  cla
  hold on
  set(gca,'xlimmode','manual',...
          'ylimmode','manual',...
          'xlim',[ud.tbins(1)-.1 ud.tbins(end)+.1],...
          'ylim',[ud.tymin ud.tymax]);

  ud.thand = stem('v6',ud.tbins,ud.tlevs);

  ud.moving = 0;
  ud.tbin = 0;

  set(param,'userdata',ud);

  %% Window button down

  wbdf = (['ud = get(gcbf,''userdata'');',...
         'if (gca == ud.tdax1),',...
         '   g = get(gca,''currentpoint'');',...
         '   [val,bin] = min(abs(ud.tbins - g(1,1)));',...
         '   if ((val < .2) & (abs(g(1,2) - ud.tlevs(bin)) < .2)),',...
         '      ud.moving = 1;',...
         '      ud.tbin = bin;',...
         '      set(gcbf,''userdata'',ud);',...
         '   end,',...
         'end;']);


  %% Window motion

  wmf = (['ud = get(gcbf,''userdata'');',...
        'if (ud.moving == 1),',...
        '   g = get(gca,''currentpoint'');',...
        '   if (g(1,2) < ud.tymin),',...
        '       g(1,2) = ud.tymin;',...
        '   elseif (g(1,2) > ud.tymax),',...
        '       g(1,2) = ud.tymax;',...
        '   else,',...
        '       g(1,2) = ud.tgrid*round(g(1,2)/ud.tgrid);',...
        '   end,',...
        '   y1 = get(ud.thand(1),''ydata'');',...
        '   y1(ud.tbin) = g(1,2);',...
        '   set(ud.thand(1),''ydata'',y1);',...
        '   ud.tlevs(ud.tbin) = g(1,2);',...
        '   set(gcbf,''userdata'',ud);',...
        'end;']);

  %% Window button up

  wbuf = (['ud = get(gcbf,''userdata'');',...
         'if (ud.moving == 1),',...
         '   ud.moving = 0;',...
         '   set(gcbf,''userdata'',ud);',...
         'end;']);

  set(param,'windowbuttondownfcn',wbdf);
  set(param,'windowbuttonmotionfcn',wmf);
  set(param,'windowbuttonupfcn',wbuf);

  splay4('update',param);
  splay4('apply',param);

elseif strcmp(action,'freqdes');

%disp('freqdes');
  ud = get(param,'userdata');

  ud.fbins = linspace(ud.low,ud.high,12);
  ud.flevs = ones(1,11);

  set(param,'userdata',ud);

  axes(ud.tdax1),cla
  axes(ud.fdax1),cla

  set([ud.tdax1;ud.fdax1;ud.normtext;ud.usbtn;ud.zsbtn;ud.rsbtn],'visible','off');
  set([ud.tdax2;ud.fdax2;ud.lowtext;ud.lowbox;ud.hightext;ud.highbox;ud.frsbtn],'visible','on');

  ud.currdes = 2;
  axes(ud.fdax2);
  cla

  hold on

  zz = abs(ud.dft(ceil([ud.low:ud.high]*ud.ldft/ud.fs)));
  plot(ceil([ud.low:ud.high]),zz/max(zz)*ud.fymax,'r');

  set(gca,'xlimmode','manual',...
          'ylimmode','manual',...
          'xlim',[ud.low-(ud.high-ud.low)/10 ud.high+(ud.high-ud.low)/10],...
          'ylim',[ud.fymin ud.fymax]);

%          'xlim',[ud.fbins(1)-.1 ud.fbins(end)+.1],...

  for i=1:length(ud.flevs)

   vert = [ud.fbins(i) ud.flevs(i) 1 ; ud.fbins(i+1) ud.flevs(i) 1 ;...
           ud.fbins(i+1) 0 1; ud.fbins(i) 0 1];
   fac = [1 2 3 4];
   col = [0 0 1];

   ud.fhand(i) = patch('vertices',vert,'faces',fac,...
                'facevertexcdata',col,'facecolor','none',...
                'marker','o','markerfacecolor',[.1 .1 1]);
      %used to be 'flat'

  end
  
  ud.moving = 0;
  ud.fbin = 0;

  set(param,'userdata',ud);

  %% Window button down
  wbdf = (['ud = get(gcbf,''userdata'');',...
         'if (gca == ud.fdax2),',...
         '   g = get(gca,''currentpoint'');',...
         '   if ((g(1,1) >= ud.fbins(1)) & (g(1,1) <= ud.fbins(end))),',...
         '      bin = min(find(g(1,1) < ud.fbins(2:end)));',...
         '      if (abs(g(1,2) - ud.flevs(bin)) < .1),',...
         '         ud.moving = 1;',...
         '         ud.fbin = bin;',...
         '         set(gcbf,''userdata'',ud);',...
         '      end,',...
         '   end,',...
         'end;']);

  %% Window motion

  wmf = (['ud = get(gcbf,''userdata'');',...
        'if (ud.moving == 1),',...
        '   g = get(gca,''currentpoint'');',...
        '   if (g(1,2) < ud.fymin),',...
        '       g(1,2) = ud.fymin;',...
        '   elseif (g(1,2) > ud.fymax),',...
        '       g(1,2) = ud.fymax;',...
        '   else,',...
        '       g(1,2) = ud.fgrid*round(g(1,2)/ud.fgrid);',...
        '   end,',...
        '   v = get(ud.fhand(ud.fbin),''vertices'');',...
        '   v(:,2) = [g(1,2) g(1,2) 0 0]'';',...
        '   set(ud.fhand(ud.fbin),''vertices'',v);',...
        '   ud.flevs(ud.fbin) = g(1,2);',...
        '   set(gcbf,''userdata'',ud);',...
        'end;']);

  %% Window button up

  wbuf = (['ud = get(gcbf,''userdata'');',...
         'if (ud.moving == 1),',...
         '   ud.moving = 0;',...
         '   set(gcbf,''userdata'',ud);',...
         'end;']);

  set(param,'windowbuttondownfcn',wbdf);
  set(param,'windowbuttonmotionfcn',wmf);
  set(param,'windowbuttonupfcn',wbuf);

  splay4('update',param);

  splay4('apply',param);


elseif strcmp(action,'update');

%disp('update');

  ud = get(param,'userdata');

  if (ud.currdes == 1)
     filtdft = fft(ud.tlevs,ud.ldft);
     axes(ud.fdax1)
     cla
     plot([1:round(ud.ldft/2)]/ud.ldft*ud.fs,abs(filtdft(1:round(ud.ldft/2))),'b');
  else

     lowloc = ceil(ud.ldft*ud.low/ud.fs);
     highloc = floor(ud.ldft*ud.high/ud.fs);

     s = floor((highloc-lowloc)/(length(ud.flevs)-2));
     t = kron(ud.flevs(2:end-1),ones(1,s));
     thing = [ud.flevs(1)*ones(1,lowloc) t ud.flevs(end)*ones(1,round(ud.ldft/2)-highloc)];

     if length(thing) == ud.ldft/2
        thing = thing(1:end-1);
     end

     thing = [1 thing zeros(1,ud.ldft-1-2*length(thing)) fliplr(thing)];
     filt = real(ifft(thing));

     axes(ud.tdax2)
     cla

     c = ceil(length(filt)/2);

     filt = [filt(c:end),filt(1:(c-1))];
     mz = max(abs(filt));

     ind1 = min(find((abs(filt) >= mz/100) == 1));
     ind2 = max(find((abs(filt) >= mz/100) == 1));

     plot([ind1:ind2]-round((ind1+ind2)/2),filt(ind1:ind2));
  end

elseif strcmp(action,'apply');

%disp('apply');

  ud = get(param,'userdata');

  if (ud.currdes == 1)
     ud.filt = ud.tlevs;
     ud.filtdft = fft(ud.filt,ud.ldft);
     set(param,'userdata',ud);

     splay4('update',param);
     splay4('refresh',param);
  else


%     s = floor((ud.ldft/2-1)/length(ud.flevs));
%     t = kron(ud.flevs,ones(1,s));
%     ud.filtdft = [1 t zeros(1,ud.ldft-1-2*length(t)) fliplr(t)];

     lowloc = ceil(ud.ldft*ud.low/ud.fs);
     highloc = floor(ud.ldft*ud.high/ud.fs);

     s = floor((highloc-lowloc)/(length(ud.flevs)-2));
     t = kron(ud.flevs(2:end-1),ones(1,s));
     thing = [ud.flevs(1)*ones(1,lowloc) t ud.flevs(end)*ones(1,round(ud.ldft/2)-highloc)];

     if length(thing) == ud.ldft/2
        thing = thing(1:end-1);
     end

     ud.filtdft = [1 thing zeros(1,ud.ldft-1-2*length(thing)) fliplr(thing)];

     ud.filt = real(ifft(ud.filtdft));
     set(param,'userdata',ud);

     splay4('update',param);
     splay4('refresh',param);
  end

end