function out = uquant(in,numlevels,fig)

% Uniform quantization.  Breakpoints are placed at the mean of the
%   reconstruction levels.
%
% Syntax:  out = uquant(in,numlevels);   (numlevels is a scalar)
%

in = double(in);

breaks = linspace(min(in(:)),max(in(:)),numlevels+1);
levels = (breaks(2:end) + breaks(1:end-1))/2;

out = zeros(size(in));

for i=1:length(levels)
  out = out+levels(i)*((in >= breaks(i)) & (in < breaks(i+1)));
end

out = out+levels(end)*(in == breaks(end));


if min(size(in)) > 1
  if nargin < 3
     figure(99)
     imagesc(out)
     axis equal
     axis tight
     axis off
     colormap(gray)
  elseif (fig ~= 0)
     figure(fig)
     imagesc(out) 
     axis equal
     axis tight
     axis off
     colormap(gray)
  end
end
