[y,fs] = wavread('ifeelgood.wav');

mag = abs(fft(y));
ph = angle(fft(y));



% Zero phase
zeroPhase = real(ifft(mag));

% Random phase
phtemp = 2*pi*rand(size(ph));
% Make the phase odd (otherwise random attenuations occur)
phtemp = phtemp(2:end);
phtemp = phtemp - flipud(phtemp);
phtemp = [0; phtemp];
randPhase = real(ifft(mag.*exp(i*phtemp)));

% Flat magnitude
flatSpec = real(ifft(exp(i*ph)));

% Random magnitude
magtemp = randn(size(mag));
magtemp = magtemp(2:end);
magtemp = magtemp + flipud(magtemp);
magtemp = [randn+randn; magtemp];
randSpec = real(ifft(magtemp.*exp(i*ph)));



figure(5)
spectrogram(randSpec,512,256,512,fs)
view(-90,90)
caxis([-156.5356  -28.3861])
title('Random Magnitude')

figure(4)
spectrogram(flatSpec,512,256,512,fs)
view(-90,90)
caxis([-156.5356  -28.3861])
title('Flat Magnitude')

figure(3)
spectrogram(randPhase,512,256,512,fs)
view(-90,90)
caxis([-156.5356  -28.3861])
title('Random Phase')

figure(2)
spectrogram(zeroPhase,512,256,512,fs)
view(-90,90)
caxis([-156.5356  -28.3861])
title('Zero Phase')

figure(1)
spectrogram(y,512,256,512,fs)
view(-90,90)
caxis([-156.5356  -28.3861])
title('Original')