function [sig,fs] = convview(action,param,param2)

if ((nargin == 0) | ((nargin == 2) & ~isstr(action)))

  callws1 = 'ud = get(gcbf,''userdata'');var = get(gcbo,''string'');evalin(''base'',[''ud.sig1 = '',var,''+0;'']);set(gcbf,''userdata'',ud);convview(''refresh'',gcbf);';
  callws2 = 'ud = get(gcbf,''userdata'');var = get(gcbo,''string'');evalin(''base'',[''ud.sig2 = '',var,''+0;'']);set(gcbf,''userdata'',ud);convview(''refresh'',gcbf);';

   callconv = ['ud = get(gcbf,''userdata'');sl = get(ud.sl,''value'');',...
              'axes(ud.ax3);hold on,p3 = stem(1,ud.conv(1));',...
              'axes(ud.ax2);plot(ud.sig2(end:-1:1));', ...
              'set(ud.ax2,''ylim'',[min(ud.sig2)-1,max(ud.sig2)+1]); hold on,',...
              'p2 = stem(ud.start2(1),ud.sig2(ud.start2(1)));',...
              'set(ud.t2,''Position'',[15.75 167.25 90 11.25],''string'',''Reversed Signal 2'');',...
              'axes(ud.ax1);hold on,p1 = stem(ud.start1(1),ud.sig1(ud.start1(1)));',...
              'l1 = length(ud.sig1);l2 = length(ud.sig2);',...
              'for i=1:(l1+l2)-1,',...
              'c1 = (ud.end1(i)+ud.start1(i))/2;c2 = (ud.end2(i)+ud.start2(i))/2;',...
              'set(ud.ax1,''xlim'',[-(l1+l2)+c1,(l1+l2)+c1]);',...
              'set(ud.ax2,''xlim'',[-(l1+l2)+c2,(l1+l2)+c2]);set(ud.ax3,''xlim'',[-l1-l2+i,l1+l2+i]);',...
              'set(p1,''xdata'',ud.start1(i):ud.end1(i),''ydata'',ud.sig1(ud.start1(i):ud.end1(i)));',...
              'set(p2,''xdata'',ud.start2(i):ud.end2(i),''ydata'',ud.sig2(l2+1-ud.start2(i):-1:l2+1-ud.end2(i)));',...
              'set(p3,''xdata'',i,''ydata'',ud.conv(i));',...
              'dee = [];eee=[];for j=ud.start1(i):ud.end1(i),dee = [dee,j j NaN];eee = [eee,0 ud.sig1(j) NaN];end,set(p1,''xdata'',dee,''ydata'',eee);',...
              'dee = [];eee=[];for j=ud.start2(i):ud.end2(i),dee = [dee,j j NaN];eee = [eee,0 ud.sig2(l2+1-j) NaN];end,set(p2,''xdata'',dee,''ydata'',eee);',...
              'set(p3,''xdata'',[i i NaN],''ydata'',[0 ud.conv(i) NaN]);',...
              'pause(sl+2*(i==1));end,pause(2),axes(ud.ax1),hold off,axes(ud.ax2),hold off,axes(ud.ax3),hold off,convview(''refresh'',gcbf);',...
              'set(ud.t2,''Position'',[15.75 167.25 45 11.25],''string'',''Signal 2'');'];

  if (nargin == 0)
    ud.sig1 = 1;
    ud.sig2 = 1;
  else
    ud.sig1 = action;
    ud.sig2 = param;
  end

  h0 = figure('Color',[0.8 0.8 0.8], ...
	'MenuBar','none', ...
        'Name','ELE 201 Convolution Viewer', ...
	'NumberTitle','off', ...
	'Position',[200 300 560 371], ...
	'Tag','Fig1');
  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[23 261 366 77], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.ax1 = h1;

  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4986301369863013 -0.3026315789473684 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[-0.07945205479452056 0.486842105263158 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Position',[-0.0630    1.4342    9.1603], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[ 0.4986    1.0789    9.1603], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);
  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[23 145 366 77], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.ax2 = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4986301369863013 -0.3026315789473681 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.07945205479452056 0.486842105263158 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-0.06301369863013699 2.960526315789474 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[    0.4986    1.0789    9.1603], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);
  h1 = axes('Parent',h0, ...
	'Units','pixels', ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[23 27 366 77], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'YColor',[0 0 0], ...
	'ZColor',[0 0 0]);

  ud.ax3 = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4986301369863013 -0.3026315789473681 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.07945205479452056 0.4868421052631584 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-0.06301369863013699 4.513157894736843 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[   0.4986    1.0789    9.1603], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[310.5 209.25 45.75 24], ...
	'String','Workspace Variable', ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[310.5 126 45.75 24], ...
	'String','Workspace Variable', ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
        'Callback', callconv, ...
	'ListboxTop',0, ...
	'Position',[312 49.5 88.5 27.75], ...
	'String','Convolve!', ...
	'Tag','Pushbutton1');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[17.25 254.25 45 11.25], ...
	'String','Signal 1', ...
	'Style','text', ...
	'Tag','StaticText2');

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[15.75 167.25 45 11.25], ...
	'String','Signal 2', ...
	'Style','text', ...
	'Tag','StaticText2');

  ud.t2 = h1;


  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[16.5 78.75 67.5 11.25], ...
	'String','Convolved Signal', ...
	'Style','text', ...
	'Tag','StaticText2');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',callws1, ...
	'ListboxTop',0, ...
	'Position',[361.125 213.75 39.75 15], ...
	'Style','edit', ...
	'Tag','EditText2');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Callback',callws2, ...
	'ListboxTop',0, ...
	'Position',[361.125 131.25 39.75 15], ...
	'Style','edit', ...
	'Tag','EditText2');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[312 24.75 51 12.75], ...
        'Min',.01, ...
        'Max',2, ...
	'Style','slider', ...
	'Tag','Slider1' , ...
        'Value', 1.2);

  ud.sl = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[369.75 25.5 30 11.25], ...
	'String','Slower', ...
	'Style','text', ...
	'Tag','StaticText3');

  set(h0,'userdata',ud);

  convview('refresh',h0);

  sig = [];
  fs = [];

elseif strcmp(action,'refresh')
    
  ud = get(param,'userdata');

  l1 = length(ud.sig1);
  l2 = length(ud.sig2);

  convcol = 'b';
  
  t1 = rand(1,5);
  t2 = rand(1,5);

  ud.conv = conv(ud.sig1,ud.sig2);

  axes(ud.ax1);
  plot(ud.sig1);
  set(ud.ax1,'xlim',[0 l1+1],'ylim',[min(ud.sig1)-1,max(ud.sig1)+1]);
  axes(ud.ax2);
  plot(ud.sig2);
  set(ud.ax2,'xlim',[0 l2+1],'ylim',[min(ud.sig2)-1,max(ud.sig2)+1]);
  axes(ud.ax3);
  plot(ud.conv,'color',convcol);
  set(ud.ax3,'xlim',[0 length(ud.conv)+1],'ylim',[min(ud.conv)-1,max(ud.conv)+1]);

  if (l1 <= l2)
    ud.start1 = [ones(1,l2) 2:l1];
    ud.end1 = [1:l1 l1*ones(1,l2-1)];
    ud.start2 = [l2:-1:1 ones(1,l1-1)];
    ud.end2 = [l2*ones(1,l1-1) l2:-1:1];
  else
    ud.start1 = [ones(1,l2-1) 1:l1];
    ud.end1 = [1:l1 l1*ones(1,l2-1)];
    ud.start2 = [l2:-1:2 ones(1,l1)];
    ud.end2 = [l2*ones(1,l1-1) l2:-1:1];
  end

  set(param,'userdata',ud);

end  


