
load ramp

r1 = uquant(r,2,0);

in = double(r) + 45*(rand(size(r))-.5);
in(in<0) = 0;
in(in>255) = 255;

in = uint8(in);

r2 = uquant(in,2,0);

noiselevel = 80;

blocksize = 4;

n  = noiselevel*(randn(blocksize)-.5);
nn = repmat(n,size(r)/blocksize);
ni = double(r)+nn;
r3 = quant(ni,[64,192],0);

blocksize = 8;

n  = noiselevel*(randn(blocksize)-.5);
nn = repmat(n,size(r)/blocksize);
ni = double(r)+nn;
r4 = quant(ni,[64,192],0);

blocksize = 16;

n  = noiselevel*(randn(blocksize)-.5);
nn = repmat(n,size(r)/blocksize);
ni = double(r)+nn;
r5 = quant(ni,[64,192],0);

r6 = dither(r/256);

figure(14)
clf
a = axes('position',[.27 .76 .42 .2]);
imagesc(r);
title('Original ramp')
axis equal,axis tight,axis off
a1 = axes('position',[.05 .52 .42 .2]);
imagesc(r1);
title('2-level quantized')
axis equal,axis tight,axis off
a1 = axes('position',[.05 .28 .42 .2]);
imagesc(r2);
title('Dithered')
axis equal,axis tight,axis off
a1 = axes('position',[.05 .04 .42 .2]);
imagesc(r3);
title('Tiled noise, blocksize = 4')
axis equal,axis tight,axis off
a1 = axes('position',[.53 .52 .42 .2]);
imagesc(r4);
title('Tiled noise, blocksize = 8')
axis equal,axis tight,axis off
a1 = axes('position',[.53 .28 .42 .2]);
imagesc(r5);
title('Tiled noise, blocksize = 16')
axis equal,axis tight,axis off
a1 = axes('position',[.53 .04 .42 .2]);
imagesc(r6);
title('Floyd-Steinberg dithering')
axis equal,axis tight,axis off
colormap gray
