function coder(action,param);

warning off

if ((nargin == 0) | ((nargin == 1) & ~isstr(action)))

  bgcol = [0.752941176470588 0.752941176470588 0.752941176470588];

  ud.im = imread('apple.bmp');

  h0 = figure('Color',[0.8 0.8 0.8], ...
	'Position',[245 20 680 680], ...
        'Name','ELE 201 Error Protection Demo',...
        'Numbertitle','off',...
	'Tag','Fig2');

% Original

  h1 = axes('Parent',h0, ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[0.05294117647058824 0.5485294117647058 0.4 0.4], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'XTickLabel',['0  ';'0.2';'0.4';'0.6';'0.8';'1  '], ...
	'XTickLabelMode','manual', ...
	'XTickMode','manual', ...
	'YColor',[0 0 0], ...
	'YTickLabelMode','manual', ...
	'YTickMode','manual', ...
	'ZColor',[0 0 0]);

  imshow(ud.im);
  ud.orig = h1;

  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981549815498155 -0.02952029520295207 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[-0.02583025830258304 0.4944649446494465 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Position',[   -0.1365    1.1255    9.1603], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Position',[0.4981549815498155 1.022140221402214 9.160254037844386], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

% Corrupted

  h1 = axes('Parent',h0, ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[0.5191176470588236 0.5485294117647058 0.4014705882352941 0.4], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'XTickMode','manual', ...
	'YColor',[0 0 0], ...
	'YTickLabelMode','manual', ...
	'YTickMode','manual', ...
	'ZColor',[0 0 0]);

  ud.corr = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4963235294117647 -0.02952029520295207 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.02573529411764697 0.4944649446494465 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-1.301470588235294 1.125461254612546 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4963235294117647 1.022140221402214 9.160254037844386], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

%  Protected

  h1 = axes('Parent',h0, ...
	'CameraUpVector',[0 1 0], ...
	'Color',[1 1 1], ...
	'Position',[0.525 0.07352941176470589 0.4014705882352941 0.4], ...
	'Tag','Axes1', ...
	'XColor',[0 0 0], ...
	'XTickMode','manual', ...
	'YColor',[0 0 0], ...
	'YTickMode','manual', ...
	'ZColor',[0 0 0]);

  ud.prot = h1;

  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4963235294117647 -0.02952029520295207 9.160254037844386], ...
	'Tag','Axes1Text4', ...
	'VerticalAlignment','cap');
  set(get(h2,'Parent'),'XLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[-0.02573529411764697 0.4944649446494462 9.160254037844386], ...
	'Rotation',90, ...
	'Tag','Axes1Text3', ...
	'VerticalAlignment','baseline');
  set(get(h2,'Parent'),'YLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','right', ...
	'Interruptible','off', ...
	'Position',[-1.316176470588235 2.317343173431734 9.160254037844386], ...
	'Tag','Axes1Text2', ...
	'Visible','off');
  set(get(h2,'Parent'),'ZLabel',h2);
  h2 = text('Parent',h1, ...
	'ButtonDownFcn','ctlpanel SelectMoveResize', ...
	'Color',[0 0 0], ...
	'HandleVisibility','off', ...
	'HorizontalAlignment','center', ...
	'Interruptible','off', ...
	'Position',[0.4963235294117647 1.022140221402214 9.160254037844386], ...
	'Tag','Axes1Text1', ...
	'VerticalAlignment','bottom');
  set(get(h2,'Parent'),'Title',h2);

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
        'Callback','ud = get(gcbf,''userdata'');set(ud.slabel,''string'',get(gcbo,''value''));',...
	'ListboxTop',0, ...
        'Min',0,...
        'Max',0.4,...
	'Position',[51.375 208.5 150 12.75], ...
	'Style','slider', ...
	'Tag','Slider1',...
        'Value',.01);

  ud.slider = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[71.625 224.25 109.5 12], ...
	'String','Probability of bit error', ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[111.375 193.5 30 12], ...
        'String',.01,...
	'Style','text', ...
	'Tag','StaticText2');

  ud.slabel = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[39 209.25 10.5 11.25], ...
	'String','0', ...
	'Style','text', ...
	'Tag','StaticText3');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[204 209.25 10.5 11.25], ...
	'String','0.4', ...
	'Style','text', ...
	'Tag','StaticText3');

  popcall = ['ud = get(gcf,''userdata'');',...
             'v = get(gcbo,''value'');',...
             'v = (2*v+9)/8;',...
             'str = {''Original image was 8 bpp.'',[''Error protection expands by a factor of '',num2str(v),''.'']};',...
             'set(ud.str,''string'',str);'];
  

  h1 = uicontrol('Parent',h0, ...
	'Callback',popcall,...
        'Units','points', ...
	'ListboxTop',0, ...
	'Position',[171 164.25 31.5 15], ...
	'String',{'1','2','3','4','5'}, ...
	'Style','popupmenu', ...
	'Tag','PopupMenu1', ...
	'Value',1);

  ud.popup = h1;

  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[54.75 165 109.5 12], ...
	'String','Number of bits to protect', ...
	'Style','text', ...
	'Tag','StaticText1');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[97.5 487.5 61.5 9.75], ...
	'String','Original image', ...
	'Style','text', ...
	'Tag','StaticText4');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[291 486.75 141 11.25], ...
	'String','Corrupted image (no error protection)', ...
	'Style','text', ...
	'Tag','StaticText4');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[297 245.25 141 11.25], ...
	'String','Corrupted image (error protected)', ...
	'Style','text', ...
	'Tag','StaticText4');
  h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.752941176470588 0.752941176470588 0.752941176470588], ...
	'ListboxTop',0, ...
	'Position',[40.5 56.25 171.75 24], ...
	'String',{'Original image was 8 bpp.','Error protection costs an additional 3 bpp.'}, ...
	'Style','text', ...
	'Tag','StaticText5');

  ud.str = h1;

  maincall = ['ud = get(gcf,''userdata'');',...
              'p = get(ud.slider,''value'');',...
              'b = get(ud.popup,''value'');',...
              'e = zeros([size(ud.im) 8]);',...
              'corr = uint8(zeros(size(ud.im)));',...
              'prot = uint8(zeros(size(ud.im)));',...
              'sumr = zeros(size(ud.im));',...
              'for i=1:8,',...
              '  tim = (bitand(ud.im,uint8(2^(i-1))));',...
              '  r = rand(size(ud.im));',...
              '  r = (r <= p);',...
              '  sumr = sumr + r;',...
              '  x = bitxor(tim,uint8(2^(i-1)*r));',...
              '  ind = (sumr > b);'...
              '  prot(ind) = bitor(prot(ind),x(ind));',...
              '  prot(~ind) = bitor(prot(~ind),tim(~ind));',...
              '  corr = bitor(corr,x);',...
              'end,',...
              'axes(ud.corr),'...
              'imshow(corr),',...
              'axes(ud.prot),'...
              'imshow(prot);'];
              

  h1 = uicontrol('Parent',h0, ...
        'Callback',maincall,...
	'Units','points', ...
	'ListboxTop',0, ...
	'Position',[96.75 106.5 59.25 29.25], ...
	'String','Transmit!', ...
	'Tag','Pushbutton1');

  set(h0,'userdata',ud);

elseif strcmp(action,'refresh')

end
