function thres = findThreshold(y)

FFTlength=512;
fs=44100;
f=[1:FFTlength/2]*(fs/FFTlength);
% find the frequencies in barks
b=hz2bark(f);

% step 1: get power density spectrum
power=psd(y, FFTlength);

% step 2: find tones (boolean vector)
tone_psd=find_tones(power(1:FFTlength/2));  % take first half of psd

% step 3: find noise maskers within critical band
noise_psd=noise_masker(power, tone_psd);

% step 4: now that we have important maskers, calculate global threshold
thres=global_threshold(tone_psd, noise_psd);
