function Ptm = find_tones(P)
% power_spectral_density_of_tones = find_tones(power_spectral_density_of_sig)
%
% find_tones takes a given power spectrum, finds the tones,
% and returns a spectrum with only the tones intact.  These values
% are produced by summing the value at some k with the values at
% k-1 and k+1.
% take the power found one index before [k-1] and after [k+1] and combine
% with the power at [k] to create a tone masker approximation, since the
% tone may actually be between the frequency samples.

% first assign Ptm
Ptm=zeros(1,length(P));

% go through spectrum
for k=1:length(P),
   % if the value at k is a tone
   if(is_it_tone_masker(P,k))
      % place the tone in the output spectrum with its new value
      Ptm(k) = P(k);%10*log10(dbinv(P(k-1))+dbinv(P(k))+dbinv(P(k+1)));
   end
end

% *************************************************************
function bool = is_it_tone_masker(P, k)
% boolean = is_it_tone_masker(power_spectrum, index)
%
% is_it_tone_masker checks the power spectrum P at index k
% and returns a boolean indicating whether it is a tone.
% If P(k) is a local maxima and is greater than 7dB in
% a frequency dependent neighborhood, it is a tone.
%
% This neighborhood is defined as:
%   within 2           if 2   < k  < 63
%   within 2,3            63  <= k < 127
%   within 2,3,4,5,6      127 <= k < 256

% if it's at the beginning or end of P (where a 6 length neighborhood is required), then it's not a local maxima
if ((k<=1) || (k>=250))
   bool = 0;
% if it's not a local maxima, get out now with bool=0
elseif ((P(k)<P(k-1)) || (P(k)<P(k+1))),
   bool = 0;
   % otherwise, we need to check if it is a max in its
   % neighborhood.
elseif ((k>2) && (k<63)),
   % for frequencies between 0.17-5.5kHz (window size = 5)
   bool = ((P(k)>(P(k-2)+7)) & (P(k)>(P(k+2)+7)));
elseif ((k>=63) && (k<127)),
   % for frequencies between 5.5-11Khz (window size = 7)
   bool = ((P(k)>(P(k-2)+7)) & (P(k)>(P(k+2)+7)) & (P(k)>(P(k-3)+7)) & (P(k)>(P(k+3)+7)));
elseif ((k>=127) && (k<=256)),
   % for frequencies between 11-20Khz (window size = 13)
   bool = ((P(k)>(P(k-2)+7)) & (P(k)>(P(k+2)+7)) & (P(k)>(P(k-3)+7)) & (P(k)>(P(k+3)+7)) & (P(k)>(P(k-4)+7)) & (P(k)>(P(k+4)+7)) & (P(k)>(P(k-5)+7)) & (P(k)>(P(k+5)+7)) & (P(k)>(P(k-6)+7)) & (P(k)>(P(k+6)+7)));
else
   bool = 0;
end