function vect = iq(levelNumbers, bits)

% reconstructs quantized signal from level numbers

[M,N] = size(levelNumbers);
if (M>1)
     levelNumbers = levelNumbers'
end
base  = -1;
high  =  1;
range =  2;

delta = range/2^(bits);
levels = 2^bits;

%quantValues = [base : delta  : (high-delta/2)]' + delta/2;
quantValues = [base : delta  : (high-delta/2)]';

% vect = quantValues(levelNumbers);

if (length(quantValues)==0)
   vect = zeros(1,length(levelNumbers));  
else
   vect = quantValues(levelNumbers);
end  


