(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 8.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc.                                               *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       835,         17]
NotebookDataLength[     19876,        478]
NotebookOptionsPosition[     20203,        470]
NotebookOutlinePosition[     20558,        486]
CellTagsIndexPosition[     20515,        483]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{"<<", "PlotLegends`"}], "\[IndentingNewLine]", 
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "fcos", ",", " ", "fsin", ",", " ", "a0", ",", " ", "g", ",", "h", ",", 
       " ", "originalPlot", ",", "separatePlot", ",", " ", "resultPlot"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"range", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2"}], ",", " ", "1.2"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fcos", "[", "k_", "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "Pi"}], ")"}]}], "*", " ", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "t", "]"}], 
            RowBox[{"Cos", "[", 
             RowBox[{"t", "*", "k"}], "]"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"t", ",", " ", 
             RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], " ", "//", 
        "N"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fsin", "[", "k_", "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "*", "Pi"}], ")"}]}], "*", " ", 
         RowBox[{"Integrate", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"f", "[", "t", "]"}], 
            RowBox[{"Sin", "[", 
             RowBox[{"t", "*", "k"}], "]"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"t", ",", " ", 
             RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], " ", "//", 
        "N"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"a0", " ", "=", "  ", 
       RowBox[{
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"2", "*", "Pi"}], ")"}]}], " ", 
        RowBox[{"Integrate", "[", 
         RowBox[{
          RowBox[{"f", "[", "t", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"t", ",", " ", 
            RowBox[{"-", "Pi"}], ",", " ", "Pi"}], "}"}]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"x_", ",", "k_"}], "]"}], " ", "=", " ", 
       RowBox[{"a0", " ", "+", 
        RowBox[{"2", "*", " ", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fcos", "[", "i", "]"}], 
            RowBox[{"Cos", "[", 
             RowBox[{"x", "*", "i"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "1", ",", "k"}], "}"}]}], "]"}]}], "+", " ", 
        RowBox[{"2", "*", " ", 
         RowBox[{"Sum", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"fsin", "[", "i", "]"}], 
            RowBox[{"Sin", "[", 
             RowBox[{"x", "*", "i"}], "]"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", " ", "1", ",", " ", "k"}], "}"}]}], "]"}]}]}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"x_", ",", "k_"}], "]"}], " ", "=", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"fcos", "[", "k", "]"}], " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"x", 
           RowBox[{"(", "k", ")"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"fsin", "[", "k", "]"}], " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"x", 
           RowBox[{"(", "k", ")"}]}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"sin0", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{"a0", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<Separate Signals\>\""}], ",", 
         " ", 
         RowBox[{"PlotRange", " ", "\[Rule]", 
          RowBox[{"range", "/", "3"}]}], ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sin1", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a0", ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "1"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<Separate Signals\>\""}], ",", 
         " ", 
         RowBox[{"PlotRange", " ", "\[Rule]", 
          RowBox[{"range", "/", "3"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sin2", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a0", ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "1"}], "]"}], ",", " ", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "2"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<Separate Signals\>\""}], ",", 
         " ", 
         RowBox[{"PlotRange", " ", "\[Rule]", 
          RowBox[{"range", "/", "3"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sin3", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a0", ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "1"}], "]"}], ",", " ", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "2"}], "]"}], ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "3"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<Separate Signals\>\""}], ",", 
         " ", 
         RowBox[{"PlotRange", " ", "\[Rule]", 
          RowBox[{"range", "/", "3"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"sin4", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"a0", ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "1"}], "]"}], ",", " ", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "2"}], "]"}], ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "3"}], "]"}], ",", 
           RowBox[{"h", "[", 
            RowBox[{"x", ",", "4"}], "]"}]}], "}"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", 
           RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
         RowBox[{"PlotLabel", "\[Rule]", "\"\<Separate Signals\>\""}], ",", 
         " ", 
         RowBox[{"PlotRange", " ", "\[Rule]", 
          RowBox[{"range", "/", "3"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"originalPlot", " ", "=", " ", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"f", "[", "x", "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"x", ",", " ", 
           RowBox[{"-", "Pi"}], ",", " ", "Pi"}], "}"}], ",", " ", 
         RowBox[{"PlotRange", "\[Rule]", "range"}], ",", " ", 
         RowBox[{"PlotLabel", " ", "\[Rule]", "\"\<Original Signal\>\""}], 
         ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"resultPlot", " ", "=", " ", 
       RowBox[{"Dynamic", "[", 
        RowBox[{"Plot", "[", 
         RowBox[{
          RowBox[{"g", "[", 
           RowBox[{"x", ",", "numIter"}], "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"x", ",", " ", 
            RowBox[{
             RowBox[{"-", "2"}], "Pi"}], ",", " ", 
            RowBox[{"2", "Pi"}]}], "}"}], ",", " ", 
          RowBox[{"PlotRange", "\[Rule]", "range"}], ",", " ", 
          RowBox[{"PlotLabel", " ", "\[Rule]", "\"\<Sum of Sinusoids\>\""}], 
          ",", " ", 
          RowBox[{"AspectRatio", "\[Rule]", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{"2", "GoldenRatio"}], ")"}]}]}], ",", " ", 
          RowBox[{"ImageSize", "\[Rule]", 
           RowBox[{"Scaled", "[", ".5", "]"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"showNum", " ", "=", " ", 
       RowBox[{"Min", "[", 
        RowBox[{"numIter", ",", " ", "4"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"separatePlot", " ", "=", " ", 
       RowBox[{"Switch", "[", 
        RowBox[{
        "showNum", ",", " ", "0", ",", " ", "sin0", ",", " ", "1", ",", " ", 
         "sin1", ",", " ", "2", ",", " ", "sin2", ",", " ", "3", ",", " ", 
         "sin3", ",", " ", "4", ",", " ", "sin4"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"{", 
       RowBox[{
       "originalPlot", ",", " ", "separatePlot", ",", "\[IndentingNewLine]", 
        "  ", "resultPlot"}], "}"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"UnitStep", "[", 
          RowBox[{"#", " ", "+", " ", "1"}], "]"}], "*", 
         RowBox[{"UnitStep", "[", 
          RowBox[{"1", " ", "-", " ", "#"}], "]"}]}], " ", "&"}], ",", " ", 
       "\"\<Signal\>\""}], " ", "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"UnitStep", "[", 
           RowBox[{"#", " ", "+", " ", "1"}], "]"}], "*", 
          RowBox[{"UnitStep", "[", 
           RowBox[{"1", " ", "-", " ", "#"}], "]"}]}], " ", "&"}], " ", 
        "\[Rule]", "\"\<Rect\>\""}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], "#"}], " ", "&"}], "\[Rule]", " ", 
        "\"\<Linear\>\""}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", ".2"}], " ", "+", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", "8"}], ")"}], 
           RowBox[{"#", "^", "2"}]}]}], " ", "&"}], "\[Rule]", " ", 
        "\"\<Parabola\>\""}], ",", "  ", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "3"}], ")"}], 
          RowBox[{"Exp", "[", 
           RowBox[{"#", "/", "3"}], "]"}]}], "&"}], " ", "\[Rule]", " ", 
        "\"\<Exp\>\""}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"If", " ", "[", 
          RowBox[{
           RowBox[{"#", " ", ">", " ", "0"}], ",", " ", 
           RowBox[{"1", "-", 
            RowBox[{"2", 
             RowBox[{"#", "/", "3"}]}]}], ",", " ", 
           RowBox[{"1", "+", " ", 
            RowBox[{"2", 
             RowBox[{"#", "/", "3"}]}]}]}], "]"}], "&"}], "\[Rule]", " ", 
        "\"\<Triangle\>\""}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"SquareWave", "[", 
          RowBox[{"3", 
           RowBox[{"#", "/", "Pi"}]}], "]"}], " ", "&"}], "\[Rule]", 
        "\"\<Square Wave\>\""}]}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"numIter", ",", " ", "0", ",", " ", "\"\<Number of terms\>\""}],
       "}"}], ",", " ", "0", ",", " ", "80", ",", " ", "1", ",", " ", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "\[IndentingNewLine]", "]"}]}], "Input",
 CellOpen->False,
 CellChangeTimes->{{3.56891337505396*^9, 3.568913417924412*^9}, {
   3.5689134670002193`*^9, 3.568913481333039*^9}, {3.568914143297901*^9, 
   3.5689141663902216`*^9}, 3.5689195950017204`*^9, {3.568919657500295*^9, 
   3.5689197396439934`*^9}, {3.568919950148034*^9, 3.568919958602517*^9}, {
   3.5689202096018734`*^9, 3.5689203329409285`*^9}, {3.568921115824707*^9, 
   3.5689211854006863`*^9}, {3.568921238726736*^9, 3.5689212753638315`*^9}, {
   3.5689213610437326`*^9, 3.5689213848890963`*^9}, {3.568921538739896*^9, 
   3.5689215679635677`*^9}, {3.568954468366363*^9, 3.568954479169981*^9}, {
   3.5689545293518515`*^9, 3.5689545300368905`*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = UnitStep[# + 1] 
    UnitStep[1 - #]& , $CellContext`numIter$$ = 32, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`f$$], UnitStep[# + 1] UnitStep[1 - #]& , 
       "Signal"}, {(UnitStep[# + 1] UnitStep[1 - #]& ) -> "Rect", ((1/3) #& ) -> 
       "Linear", (-0.2 + (1/8) #^2& ) -> "Parabola", ((1/3) Exp[#/3]& ) -> 
       "Exp", (If[# > 0, 1 - 2 (#/3), 1 + 2 (#/3)]& ) -> 
       "Triangle", (SquareWave[3 (#/Pi)]& ) -> "Square Wave"}}, {{
       Hold[$CellContext`numIter$$], 0, "Number of terms"}, 0, 80, 1}}, 
    Typeset`size$$ = {385., {206., 70.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True, $CellContext`f$6194$$ =
     False, $CellContext`numIter$6199$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`f$$ = 
        UnitStep[# + 1] UnitStep[1 - #]& , $CellContext`numIter$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`f$$, $CellContext`f$6194$$, False], 
        Hold[$CellContext`numIter$$, $CellContext`numIter$6199$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`fcos$, $CellContext`fsin$, $CellContext`a0$, \
$CellContext`g$, $CellContext`h$, $CellContext`originalPlot$, \
$CellContext`separatePlot$, $CellContext`resultPlot$}, $CellContext`range = \
{-1.2, 1.2}; $CellContext`fcos$[
           Pattern[$CellContext`k$, 
            Blank[]]] = 
         N[(1/(2 Pi)) 
           Integrate[$CellContext`f$$[$CellContext`t] 
             Cos[$CellContext`t $CellContext`k$], {$CellContext`t, -Pi, 
              Pi}]]; $CellContext`fsin$[
           Pattern[$CellContext`k$, 
            Blank[]]] = 
         N[(1/(2 Pi)) 
           Integrate[$CellContext`f$$[$CellContext`t] 
             Sin[$CellContext`t $CellContext`k$], {$CellContext`t, -Pi, 
              Pi}]]; $CellContext`a0$ = (1/(2 Pi)) Integrate[
            $CellContext`f$$[$CellContext`t], {$CellContext`t, -Pi, 
             Pi}]; $CellContext`g$[
           Pattern[$CellContext`x$, 
            Blank[]], 
           Pattern[$CellContext`k$, 
            Blank[]]] = $CellContext`a0$ + 
          2 Sum[$CellContext`fcos$[$CellContext`i] 
             Cos[$CellContext`x$ $CellContext`i], {$CellContext`i, 
              1, $CellContext`k$}] + 
          2 Sum[$CellContext`fsin$[$CellContext`i] 
             Sin[$CellContext`x$ $CellContext`i], {$CellContext`i, 
              1, $CellContext`k$}]; $CellContext`h$[
           Pattern[$CellContext`x$, 
            Blank[]], 
           Pattern[$CellContext`k$, 
            Blank[]]] = $CellContext`fcos$[$CellContext`k$] 
           Cos[$CellContext`x$ $CellContext`k$] + \
$CellContext`fsin$[$CellContext`k$] 
           Sin[$CellContext`x$ $CellContext`k$]; $CellContext`sin0 = 
         Plot[$CellContext`a0$, {$CellContext`x, -Pi, Pi}, PlotLabel -> 
           "Separate Signals", PlotRange -> $CellContext`range/3, PlotStyle -> 
           Blue]; $CellContext`sin1 = Plot[{$CellContext`a0$, 
            $CellContext`h$[$CellContext`x, 1]}, {$CellContext`x, -Pi, Pi}, 
           PlotLabel -> "Separate Signals", PlotRange -> $CellContext`range/3,
            PlotStyle -> Blue]; $CellContext`sin2 = Plot[{$CellContext`a0$, 
            $CellContext`h$[$CellContext`x, 1], 
            $CellContext`h$[$CellContext`x, 2]}, {$CellContext`x, -Pi, Pi}, 
           PlotLabel -> "Separate Signals", PlotRange -> $CellContext`range/3,
            PlotStyle -> Blue]; $CellContext`sin3 = Plot[{$CellContext`a0$, 
            $CellContext`h$[$CellContext`x, 1], 
            $CellContext`h$[$CellContext`x, 2], 
            $CellContext`h$[$CellContext`x, 3]}, {$CellContext`x, -Pi, Pi}, 
           PlotLabel -> "Separate Signals", PlotRange -> $CellContext`range/3,
            PlotStyle -> Blue]; $CellContext`sin4 = Plot[{$CellContext`a0$, 
            $CellContext`h$[$CellContext`x, 1], 
            $CellContext`h$[$CellContext`x, 2], 
            $CellContext`h$[$CellContext`x, 3], 
            $CellContext`h$[$CellContext`x, 4]}, {$CellContext`x, -Pi, Pi}, 
           PlotLabel -> "Separate Signals", PlotRange -> $CellContext`range/3,
            PlotStyle -> Blue]; $CellContext`originalPlot$ = Plot[
           $CellContext`f$$[$CellContext`x], {$CellContext`x, -Pi, Pi}, 
           PlotRange -> $CellContext`range, PlotLabel -> "Original Signal", 
           PlotStyle -> Blue]; $CellContext`resultPlot$ = Dynamic[
           Plot[
            $CellContext`g$[$CellContext`x, $CellContext`numIter$$], \
{$CellContext`x, (-2) Pi, 2 Pi}, PlotRange -> $CellContext`range, PlotLabel -> 
            "Sum of Sinusoids", AspectRatio -> 1/(2 GoldenRatio), ImageSize -> 
            Scaled[0.5], PlotStyle -> Blue]]; $CellContext`showNum = 
         Min[$CellContext`numIter$$, 4]; $CellContext`separatePlot$ = 
         Switch[$CellContext`showNum, 0, $CellContext`sin0, 
           1, $CellContext`sin1, 2, $CellContext`sin2, 3, $CellContext`sin3, 
           4, $CellContext`sin4]; {$CellContext`originalPlot$, \
$CellContext`separatePlot$, $CellContext`resultPlot$}], 
      "Specifications" :> {{{$CellContext`f$$, UnitStep[# + 1] 
          UnitStep[1 - #]& , "Signal"}, {(UnitStep[# + 1] UnitStep[1 - #]& ) -> 
          "Rect", ((1/3) #& ) -> "Linear", (-0.2 + (1/8) #^2& ) -> 
          "Parabola", ((1/3) Exp[#/3]& ) -> 
          "Exp", (If[# > 0, 1 - 2 (#/3), 1 + 2 (#/3)]& ) -> 
          "Triangle", (SquareWave[3 (#/Pi)]& ) -> 
          "Square Wave"}}, {{$CellContext`numIter$$, 0, "Number of terms"}, 0,
          80, 1, Appearance -> "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{428., {191., 197.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.568648251380665*^9, 3.568921398295863*^9, 
  3.5689544805940623`*^9, 3.568954530693928*^9, 3.568997426075598*^9}]
}, Open  ]]
},
WindowSize->{838, 636},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (February 23, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[1257, 32, 12326, 315, 19, "Input",
 CellOpen->False],
Cell[13586, 349, 6601, 118, 405, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature mvp0vNEsDb#eNCw5XHNKRLoj *)
