[x,fs] = wavread('aah.wav');
offset = 100120;
duration = round(.0342*fs);
y = x(offset:offset+duration-1);


t = 0:1/duration:(duration-1)/duration;


ffty = fft(y);


k = 50;

%recon1_mask keeps all frequencies less than k
recon1_mask = zeros(size(ffty));
recon1_mask(1:k) = 1;
recon1_mask(end-k+2:end) = 1;

%recon2_mask keeps all frequencies less than or equal to k
recon2_mask = zeros(size(ffty));
recon2_mask(1:k+1) = 1;
recon2_mask(end-k+1:end) = 1;

recon1 = ifft(ffty.*recon1_mask);
recon2 = ifft(ffty.*recon2_mask);
new_term = ifft(ffty.*(recon2_mask-recon1_mask));



figure(7)
plot(t,y)
hold on
plot(t,recon1,'g')
plot(t,recon2,'g','LineWidth',2)
hold off
axis([0,1,-.02,.02])


mag_new_term = 2*abs(ffty(k+1))/duration;
phase_new_term = -phase(ffty(k+1));
if phase_new_term < 0
    phase_new_term = phase_new_term + 2*pi;
end
time_new_term = phase_new_term/k/2/pi;

figure(9)
plot(t,new_term,'g','LineWidth',2)
axis([-inf,inf,-.02,.02])
hold on
plot([0,1],[mag_new_term,mag_new_term],'r-.')
plot([0,1],[-mag_new_term,-mag_new_term],'r-.')
plot([time_new_term,time_new_term],[-0.02,0.02],'r-.')
hold off


mag_cos = 2*abs(ffty.*recon1_mask)/duration;
phase_cos = -phase(ffty).*recon1_mask;
phase_cos = phase_cos + 2*pi*(phase_cos<0);
phase_cos = phase_cos + 2*pi*(phase_cos<0);
phase_cos = phase_cos + 2*pi*(phase_cos<0);
phase_cos(1) = 0;
time_cos = phase_cos/2/pi./([0:duration-1]+eps);

figure(8)
subplot(2,1,1)
stem([0:k-1],mag_cos(1:k))
hold on
stem(k,mag_new_term,'g')
hold off
axis([0,50,0,0.004])
ylabel('Amplitude')
xlabel('frequency')
subplot(2,1,2)
stem([0:k-1],time_cos(1:k))
hold on
stem(k,time_new_term,'g')
hold off
axis([0,50,0,1])
ylabel('Shift')
xlabel('frequency')


% 
% figure(10)
% subplot(2,1,1)
% stem([0:k-1]/.0342,mag_cos(1:k))
% hold on
% stem(k/.0342,mag_new_term,'g')
% hold off
% axis([0,50/.0342,0,0.004])
% ylabel('Amplitude')
% xlabel('frequency (Hz)')
% subplot(2,1,2)
% stem([0:k-1]/.0342,time_cos(1:k))
% hold on
% stem(k/.0342,time_new_term,'g')
% hold off
% axis([0,50/.0342,0,1])
% ylabel('Shift')
% xlabel('frequency (Hz)')
% 

