[aah,fs] = wavread('aah.wav');
aah2 = wavread('aah2.wav');
ooh = wavread('ooh.wav');
ooh2 = wavread('ooh2.wav');
ii = wavread('ieh.wav');
ii2 = wavread('ieh2.wav');
uuh = wavread('uuh.wav');
eeh = wavread('eeh.wav');
iih = wavread('iih.wav');

% aah = aah(fs+1:1.5*fs,1);
% aah2 = aah2(.5*fs+1:fs,1);
% ooh = ooh(.5*fs+1:fs,1);
% ooh2 = ooh2(.5*fs+1:fs,1);
% ii = ii(fs+1:1.5*fs,1);
% ii2 = ii2(fs+1:1.5*fs,1);
% uuh = uuh(fs+1:1.5*fs,1);
% eeh = eeh(fs+1:1.5*fs,1);
% iih = iih(.5*fs+1:fs,1);
% 
% 
aah = aah(2*fs+1:3*fs,1);
aah2 = aah2(2*fs+1:3*fs,1);
ooh = ooh(2*fs+1:3*fs,1);
ooh2 = ooh2(2*fs+1:3*fs,1);
ii = ii(2*fs+1:3*fs,1);
ii2 = ii2(2*fs+1:3*fs,1);
uuh = uuh(2*fs+1:3*fs,1);
eeh = eeh(2*fs+1:3*fs,1);
iih = iih(1*fs+1:2*fs,1);





N = fs;
freq_vector = [0:1:fs-1]';


figure(1)
subplot(4,1,1)
plot(freq_vector, abs(fft(aah)))
title('aah')
subplot(4,1,2)
plot(freq_vector, abs(fft(aah2)))
title('aah2')
subplot(4,1,3)
plot(freq_vector, abs(fft(ii)))
title('ii')
subplot(4,1,4)
plot(freq_vector, abs(fft(ii2)))
title('ii2')


figure(2)
subplot(4,1,1)
plot(freq_vector, log(abs(fft(aah))))
title('aah')
subplot(4,1,2)
plot(freq_vector, log(abs(fft(aah2))))
title('aah2')
subplot(4,1,3)
plot(freq_vector, log(abs(fft(ii))))
title('ii')
subplot(4,1,4)
plot(freq_vector, log(abs(fft(ii2))))
title('ii2')




figure(3)
subplot(4,1,1)
plot(freq_vector, abs(fft(aah)))
axis([0,4000,-inf,inf])
title('aah')
subplot(4,1,2)
plot(freq_vector, abs(fft(aah2)))
axis([0,4000,-inf,inf])
title('aah2')
subplot(4,1,3)
plot(freq_vector, abs(fft(ii)))
axis([0,4000,-inf,inf])
title('ii')
subplot(4,1,4)
plot(freq_vector, abs(fft(ii2)))
axis([0,4000,-inf,inf])
title('ii2')





figure(4)
subplot(4,1,1)
plot(freq_vector, log(abs(fft(aah))))
axis([0,4000,-inf,inf])
title('aah')
subplot(4,1,2)
plot(freq_vector, log(abs(fft(aah2))))
axis([0,4000,-inf,inf])
title('aah2')
subplot(4,1,3)
plot(freq_vector, log(abs(fft(ii))))
axis([0,4000,-inf,inf])
title('ii')
subplot(4,1,4)
plot(freq_vector, log(abs(fft(ii2))))
axis([0,4000,-inf,inf])
title('ii2')


smooth_width = 400;
aah_log_smooth = smooth(log(abs(fft(aah))), smooth_width);
aah2_log_smooth = smooth(log(abs(fft(aah2))), smooth_width);
ii_log_smooth = smooth(log(abs(fft(ii))), smooth_width);
ii2_log_smooth = smooth(log(abs(fft(ii2))), smooth_width);
figure(4)
subplot(4,1,1)
hold on
plot(freq_vector, aah_log_smooth, 'r')
hold off
subplot(4,1,2)
hold on
plot(freq_vector, aah2_log_smooth, 'r')
hold off
subplot(4,1,3)
hold on
plot(freq_vector, ii_log_smooth, 'r')
hold off
subplot(4,1,4)
hold on
plot(freq_vector, ii2_log_smooth, 'r')
hold off

% aah_log_smooth = aah_log_smooth - mean(aah_log_smooth);
% aah2_log_smooth = aah2_log_smooth - mean(aah2_log_smooth);
% ii_log_smooth = ii_log_smooth - mean(ii_log_smooth);
% ii2_log_smooth = ii2_log_smooth - mean(ii2_log_smooth);



figure(5)
plot([aah_log_smooth, aah2_log_smooth + 1, ii_log_smooth, ii2_log_smooth + .25])
axis([0,4000,-inf,inf])
legend('aah', 'aah2', 'ii', 'ii2')


cutoff = 8000;

a2i_filter = exp(-.5*(aah_log_smooth + aah2_log_smooth - ii_log_smooth - ii2_log_smooth)).*(freq_vector>50).*(freq_vector<cutoff);
a2i_filter = a2i_filter + circshift(flipud(a2i_filter),1);

i2a_filter = exp(.5*(aah_log_smooth + aah2_log_smooth - ii_log_smooth - ii2_log_smooth)).*(freq_vector>50).*(freq_vector<cutoff);
i2a_filter = i2a_filter + circshift(flipud(i2a_filter),1);

figure(6)
plot(freq_vector, i2a_filter)
axis([0,10000,-inf,inf])
title('i2a_filter')


a2i = fftshift(ifft(a2i_filter));
i2a = fftshift(ifft(i2a_filter));
figure(7)
subplot(2,1,1)
plot(a2i)
axis([21900,22200, -inf, inf])
title('a2i')
subplot(2,1,2)
plot(i2a)
title('i2a')
axis([21900,22200, -inf, inf])



% Whispers

aah_filter = exp(.5*(aah_log_smooth + aah2_log_smooth)).*(freq_vector>50).*(freq_vector<cutoff);
aah_filter = aah_filter + circshift(flipud(aah_filter),1);
aah_whisper = fftshift(ifft(aah_filter));

ii_filter = exp(.5*(ii_log_smooth + ii2_log_smooth)).*(freq_vector>50).*(freq_vector<cutoff);
ii_filter = ii_filter + circshift(flipud(ii_filter),1);
ii_whisper = fftshift(ifft(ii_filter));

