* Growth


*---------------------------------------------------------------------------------------

* Constructing the capital shares: ks.dta


* Renaming Compensation of Employees for every year
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ce.dta", clear
rename _1987 ce1987
rename _1988 ce1988
rename _1989 ce1989
rename _1990 ce1990
rename _1991 ce1991
rename _1992 ce1992
rename _1993 ce1993
rename _1994 ce1994
rename _1995 ce1995
rename _1996 ce1996
rename _1997 ce1997
rename _1998 ce1998
rename _1999 ce1999
rename _2000 ce2000
rename _2001 ce2001
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace

* Renaming GDP for every year
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\gdp.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"
rename _1987 gdp1987
rename _1988 gdp1988
rename _1989 gdp1989
rename _1990 gdp1990
rename _1991 gdp1991
rename _1992 gdp1992
rename _1993 gdp1993
rename _1994 gdp1994
rename _1995 gdp1995
rename _1996 gdp1996
rename _1997 gdp1997
rename _1998 gdp1998
rename _1999 gdp1999
rename _2000 gdp2000
rename _2001 gdp2001
drop _merge
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace

* Merging Adjustment coefficients 
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\adjustment.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta"
drop _merge
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", replace

*------------------------------------------------------------------------------------------
* Constructing growth in size 1990-2000 (intgrowth9000.dta) from growth9000

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\growth9000.dta" , clear
drop if  ___change_in_emp_==.
rename establishment_size minsize
rename establishments ctg9000
gen g9000 = 1 + ___change_in_emp_/100

* Selecting SIC
drop if  sic=="0700"
drop if  sic=="0800"
drop if  sic=="0900"
drop if sic=="10--"
drop if  sic=="1500"
drop if  sic=="1600"
drop if  sic=="1700"
replace sic = "-1" if sic=="20--" 
drop if  sic=="40--"
drop if  sic=="60--"
drop if  sic=="5000"
drop if  sic=="5100"
drop if  sic=="5200"
drop if  sic=="5300"
drop if  sic=="5400"
drop if  sic=="5500"
drop if  sic=="5600"
drop if  sic=="5700"
drop if  sic=="5800"
drop if  sic=="5900"
drop if  sic=="70--"
drop if sic=="99--"
replace sic = "709" if sic=="07--"
replace sic = "1517" if sic=="15--"
replace sic = "5051" if sic=="50--"
replace sic = "5259" if sic=="52--"
replace sic = "8489" if (sic=="8400")|(sic=="8700")|(sic=="8900")
sort sic 
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", replace

* Construct growth (g9000) for every size and industry bin by weighting with the number of surviving firms (ctg9000)
collapse (mean) g9000 [w=ctg9000] , by(sic minsize)
sort sic
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

* Sum the number of continuing firms for every size and industry bin
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", clear
collapse (sum) ctg9000, by(sic minsize)
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge

* Define Growth Rate between 1990 and 2000
gen Growth9000 = g9000-1

* Rename size bins (minsize)
drop if minsize=="0 employees"
drop if minsize=="Total"
replace minsize = "5000" if minsize =="5,000 or more employees" 
gen size = word(subinstr(minsize,"-"," -",. ),1)
replace size = subinstr(size,",","",. )
replace size="5000" if minsize=="5000"
destring size, replace
drop minsize
gen minsize = size
drop size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", replace

* Construct a variable (avsize) equal to the average of the sizes encompassed in a size bin
gen avsize = 0
collapse avsize , by(minsize)
replace avsize = (minsize+minsize[_n+1] - 1)/2
replace avsize = 8000 if minsize==5000
sort minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", clear
sort minsize
merge minsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
replace sic = "0" if sic=="----"
destring sic , replace
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", replace
*------------------------------------------------------------------------------------------

*  Constructing the number of establishments in 1990 (intest1990.dta) from est1990

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\est1990.dta", clear

rename establishments est1990
rename establishment_size minsize

* Selecting SIC
drop if  sic=="0700"
drop if  sic=="0800"
drop if  sic=="0900"
drop if sic=="10--"
drop if  sic=="1500"
drop if  sic=="1600"
drop if  sic=="1700"
 replace sic = "-1" if sic=="20--" 
drop if  sic=="40--"
drop if  sic=="60--"
drop if  sic=="5000"
drop if  sic=="5100"
drop if  sic=="5200"
drop if  sic=="5300"
drop if  sic=="5400"
drop if  sic=="5500"
drop if  sic=="5600"
drop if  sic=="5700"
drop if  sic=="5800"
drop if  sic=="5900"
drop if  sic=="70--"
drop if sic=="99--"
replace sic = "709" if sic=="07--"
replace sic = "1517" if sic=="15--"
replace sic = "5051" if sic=="50--"
replace sic = "5259" if sic=="52--"
replace sic = "8489" if (sic=="8400")|(sic=="8700")|(sic=="8900")
collapse (sum) est1990 , by(sic minsize)

* Renaming size bins
drop if minsize=="0 employees"
drop if minsize=="Total"
replace minsize = "10000" if minsize =="10,000 or more employees" 
gen size = word(subinstr(minsize,"-"," -",. ),1)
replace size = subinstr(size,",","",. )
replace size="10000" if minsize=="10000"
destring size, replace
drop minsize
gen minsize = size
drop size
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", replace

* Defining average size
gen avsize = 0
collapse avsize , by(minsize)
replace avsize = (minsize+minsize[_n+1] - 1)/2
replace avsize = 12500 if minsize==10000
sort minsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace
use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", clear
sort minsize
merge minsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
replace sic = "0" if sic=="----"
destring sic, replace
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", replace
*--------------------------------------------------------------------------------
* Merging the previous files within the file transfered.dta

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intest1990.dta", clear
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

* Harmonizing size bins
replace avsize = 14.5 if (avsize==12)|(avsize==17)
replace avsize = 24.5 if (avsize==22)|(avsize==27)
replace avsize = 34.5 if (avsize==32)|(avsize==37)
replace avsize = 44.5 if (avsize==42)|(avsize==47)
replace avsize = 149.5 if (avsize==112)|(avsize==137)|(avsize==162)|(avsize==187)
replace avsize = 249.5 if (avsize==212)|(avsize==237)|(avsize==274.5)
replace avsize = 349.5 if (avsize==324.5)|(avsize==374.5)
replace avsize = 449.5 if (avsize==424.5)|(avsize==474.5)
replace avsize = 1249.5 if (avsize==1124.5)|(avsize==1374.5)
replace avsize = 1749.5 if (avsize==1624.5)|(avsize==1874.5)
replace avsize = 2249.5 if (avsize==2124.5)|(avsize==2374.5)
replace avsize = 8000 if avsize>4999

replace est1990 = 0 if est1990==.
collapse (sum) est1990 , by (sic avsize)

replace est1990 = . if est1990==0
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\intgrowth9000.dta", clear
sort sic avsize
merge sic avsize using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

use "C:\Documents and Settings\Proprio\My Documents\RA\USA\ks.dta", clear
sort sic
merge sic using "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta"
drop _merge
sort sic avsize
save "C:\Documents and Settings\Proprio\My Documents\RA\USA\transfered.dta", replace

*----------------------------------------------------------------------------------------------------
*Definition of KS

gen ksav= 1-(ce1990/gdp1990+ce1991/gdp1991+ce1992/gdp1992+ce1993/gdp1993+ce1994/gdp1994+ce1995/gdp1995+ce1996/gdp1996+ce1997/gdp1997+ce1998/gdp1998+ce1999/gdp1999+ce2000/gdp2000)/11
gen ksavadj = ksav*adjustment

*Regressors

gen logsize = ln(avsize)
gen ksavlsize = ksav*logsize
gen ksavadjlsize = ksavadj*logsize
gen logGrowth = ln(1+Growth9000)
*----------------------------------------------------------------------------
* Regressions

*weights: ctg9000 or ctg9000/(1-ksav)^2 or ctg9000/(1-ksavadj)^2  
gen we1 = ctg9000
gen we2 = ctg9000/(1-ksav)^2
gen we3 = ctg9000/(1-ksavadj)^2


* Table 1
*xi: reg logGrowth i.sic logsize ksavlsize  [aw=we1] if (ksav>=0)&(ksav<=0.5)
*xi: reg logGrowth i.sic logsize ksavadjlsize  [aw=we1] if (ksavadj>=0)&(ksavadj<=0.5)
*xi: reg logGrowth i.sic logsize ksavlsize  [aw=we2] if (ksav>=0)&(ksav<=0.5)
*xi: reg logGrowth i.sic logsize ksavadjlsize  [aw=we3] if (ksavadj>=0)&(ksavadj<=0.5)


*Table 2

gen ksavlsizemf = 0
replace ksavlsizemf = ksavlsize if (sic>=2000)&(sic<=3900)
gen ksavadjlsizemf = 0
replace ksavadjlsizemf = ksavadjlsize if (sic>=2000)&(sic<=3900)

gen ksavlsizenmf = 0
replace ksavlsizenmf = ksavlsize if (sic<2000)|(sic>3900)
gen ksavadjlsizenmf = 0
replace ksavadjlsizenmf = ksavadjlsize if (sic<2000)|(sic>3900)

gen logsizemf = 0
replace logsizemf = logsize if (sic>=2000)&(sic<=3900)
gen logsizenmf = 0
replace logsizenmf = logsize if (sic<2000)|(sic>3900)


* 1 regression
*xi: reg logGrowth i.sic logsizemf logsizenmf ksavlsizemf ksavlsizenmf [aw=we1] if (ksav>=0)&(ksav<=0.5)
*xi: reg logGrowth i.sic logsizemf logsizenmf ksavadjlsizemf ksavadjlsizenmf [aw=we1] if (ksavadj>=0)&(ksavadj<=0.5)
*xi: reg logGrowth i.sic logsizemf logsizenmf ksavlsizemf ksavlsizenmf [aw=we2] if (ksav>=0)&(ksav<=0.5)
xi: reg logGrowth i.sic logsizemf logsizenmf ksavadjlsizemf ksavadjlsizenmf [aw=we3] if (ksavadj>=0)&(ksavadj<=0.5)







