aaa
clear

set matsize 3000


***** DIRECTORY WHERE TO SAVE ALL RESULTS
{

global output = "C:\Users\Public\Documents\LocationAsset\output"
global root C:\Users\Public\Documents\LocationAsset
global data C:\Users\Public\Documents\data\source\edp
global datasal C:\Users\Public\Documents\data\source

cap mkdir "$output\temp"


* Create new directory
global graphs "C:\Users\Public\Documents\LocationAsset\output\graphs_rev2_2020"
local date = subinstr("$S_DATE"," ","",.)
local time = substr(subinstr("$S_TIME",":","",.),1,2)
local datetime `date'T`time'

global Folder Regressions_Ols_Rev2_`datetime'
cd "$graphs"
cap mkdir "$Folder"

}




			**********************
			*** CONSTRUCT DATA ***
			**********************
	
			
			
{			

cd "$output"

	
*** Select variables in edp and basic edp sample
{
	   
	   
global varlist_individu_ear ///
	   id_diff id_log_diff annee_col sexe anai  ///
	   cs dclt dcnai dcran depcom_code dipl empl ///
	   lienf lprf lprm matr naf numf prof poids_ea typact

global varlist_revenu ///
	   id_fisc_log_diff an_fisc an_revenu ///
	   depcom sexerf occtyp ztsam zsalm zchom zrtom zricm zrncm zfonm ///
	   zvamm0 zvamm zvalm0 zvalm zthabm zthabm_decl ///
	   /// csgisalm crdsm crdssalm csgpatm csgvalm csgimpm csgdm csgdsalm ///
	   produitfin zimpform
	   
global varlist_panact ///
	   id_diff an nbent netnet netnetr dp dpc nbheur cs2 pcs4 a38 ///
	   depr comr dept comt nbsa_ent nbsa_et
	   
global varlist_individu ///
	   id_diff id_fisc_foy_diff id_fisc_log_diff anais ///
	   an_fisc sexe csdep cne1 id_fisc_foy_conj lien_familial


* Individual data
{


forvalues t = 2011(1)2017 {

use $varlist_individu using "$data\edp_be2017_fisc_individu_`t'", clear

* identifiers
rename id_fisc_log_diff id_log_diff
rename id_fisc_foy_diff id_foy_diff
rename id_fisc_foy_conj id_foy_partner

* year
rename an_fisc year_fisc

* other
rename anais year_birth_fisc
gen com_fisc = csdep + cne1
drop csdep cne1
rename sexe sex_fisc
rename lien_familial relat_ref_fisc

save "temp/EdpIndividu`t'Rev2", replace

}


* Append
clear
forvalues t = 2011(1)2017 {
append using "temp/EdpIndividu`t'Rev2"
}
save "EdpIndividuRev2", replace



}	   
	   
* Individual ear (census) data
{

forvalues t = 2011(1)2017 {

use $varlist_individu_ear using "$data\edp_be2017_ear`t'_individu", clear

* year
rename annee_col year_income

* geography
rename dcnai com_birth
rename depcom_code com_res
drop dcran

* education
replace dipl = "" if dipl == "ZZ"

* employment ? (coincides with naf filled in)
replace empl = "" if empl == "ZZ" // (15 or 16)

* link to reference person in household
drop lienf lprf
rename lprm relat_ref

* industry
replace naf = "" if naf == "ZZZZ"
rename naf industry

* numf
drop numf

* weights
rename poids_ea wt

* occupation
rename prof occ
replace occ = "" if occ == "ZZZZ"

* employment status
rename typact empstat

* sex
rename sexe sex

save "temp/EdpEarIndividu`t'Rev2", replace

}


* Append
clear
forvalues t = 2011(1)2017 {
append using "temp/EdpEarIndividu`t'Rev2"
}
save "EdpEarIndividuRev2", replace

}

* Fiscal data
{

forvalues t = 2011(1)2017 {

use $varlist_revenu using "$data\edp_be2017_fisc_revenu_`t'", clear

* Identifier
rename id_fisc_log_diff id_log_diff

* years
rename an_fisc year_fisc
rename an_revenu year_income

* geography
rename depcom com_res_fisc

* Home ownership
rename occtyp owner

* Income
rename ztsam labor_income
rename zsalm wage
rename zchom unemp_benef
rename zrtom lifetime_rents
gen business_income = zricm  + zrncm
drop zricm zrncm
rename zfonm housing_income
gen taxable_financial_income_raw = zvamm0 + zvalm0
gen taxable_financial_income = zvamm + zvalm
drop zvamm0 zvalm0 zvamm zvalm
rename zthabm residency_tax // taxe d'habitation
rename zthabm_decl residency_tax_decl 
rename produitfin nontaxable_financial_income
rename zimpform tax_capital_gains

save "temp/EdpFiscal`t'Rev2", replace

}


* Append
clear
forvalues t = 2011(1)2017 {
append using "temp/EdpFiscal`t'Rev2"
}
save "EdpFiscalRev2", replace

}

* Panact (DADS) data
{

use $varlist_panact using "$data\edp_be2017_panact", clear

rename an year_income
rename nbent num_employers
rename dp days
rename dpc days_fulltime
rename cs2 occ2
rename pcs4 occ4
replace comr = depr + comr
replace comt = dept + comt
drop depr dept
rename nbsa_ent firm_size // at december 31st
rename nbsa_et plant_size

keep if year_income >= 2010

keep if id_diff != ""

bys id_diff year_income : gen N = _N
su N, d // only
drop N

save "EdpPanactRev2", replace

}

}

*** Construct employment shocks from DADS etablissements
{

** Extract basic data from Etablissements
{

global varlistEta siren nic siret apet a38 comt zempt ///
				  eff_3112_et eff_moy_et nb_sal nb_dads

clear
forvalues t=2009(1)2015 {

use $varlistEta using "$datasal\DADS Etablissements\eta`t'", clear

rename eff_3112_et plant_size_3112
rename eff_moy_et  plant_size_mean
rename nb_sal 	   plant_size_nbsa
rename nb_dads 	   plant_size_dads

foreach T in 3112 mean nbsa dads {
egen firm_size_`T' = sum( plant_size_`T' ), by(siren)
}

gen year = `t'

save "temp/EtaEdp`t'Rev2", replace
}

}

** Compute firm growth in Etablissements
{

clear
forvalues t=2009(1)2015 {
append using "temp/EtaEdp`t'Rev2"
}
keep siren year firm_size_mean

sort siren year
bys siren year : keep if _n == 1

bys siren: gen dlempFirm = log(firm_size_mean[_n+1]) - log(firm_size_mean) if _n < _N
bys siren: gen dHempFirm = 2 * ( firm_size_mean[_n+1] - firm_size_mean ) /  ///
							   ( firm_size_mean[_n+1] + firm_size_mean )   if _n < _N

* Keep only firms continuously in sample
egen maxyear = max(year), by(siren)							   
egen minyear = min(year), by(siren)							   
sort siren year
bys siren : gen N = _N
drop if N != maxyear - minyear + 1 // drop 266k out of 13m
drop N minyear
	
* Adjust if firm exits before end of sample							   
sort siren year
bys siren: replace dHempFirm = - 2 if year == maxyear & maxyear < 2015	
	* quite important, 1m changes
						   
save "temp/FirmGrowth0915Rev2", replace

}

** Extract uniquely identified firms in Etablissements
{

global Suff 3112
global binsize = 1

forvalues t=2010(1)2015 {

use "temp/EtaEdp`t'Rev2", clear

keep if comt != "" & a38 != ""

foreach var in firm plant {
gen `var'_size_group = floor(`var'_size_$Suff / $binsize )
}

foreach s in en { // et
egen N`s' = nvals(sir`s'), by( comt a38 firm_size_group ) //  plant_size_group )
}
keep if Nen == 1
local varliste siren firm_size_mean comt a38 firm_size_group
keep `varliste'
sort `varliste'
bys `varliste' : keep if _n == 1


save "temp/EtaEdp`t'UniqueRev2", replace

}

}

** Merge with panact
{

forvalues t=2010(1)2015 {

use "EdpPanactRev2" if year == `t' , clear 

foreach var in firm plant {
gen `var'_size_group = floor(`var'_size / $binsize )
}

merge m:1 comt a38 firm_size_group ///
	  using "temp/EtaEdp`t'UniqueRev2", keep(1 3)

rename _m _m`t'

save "temp/EdpPanactMerged`t'Rev2", replace

}

clear
forvalues t=2010(1)2015 {
append using "temp/EdpPanactMerged`t'Rev2"
}

rename year_income year
merge m:1 siren year using "temp/FirmGrowth0915Rev2", nogen keep(1 3)

rename year year_income

drop *group
ds firm_size*
drop firm_size plant_size

save "EdpPanactMergedRev2", replace

sort id_diff year
order id_diff year siren dlempFirm dHempFirm

}

}

*** Merge household and individual fiscal data, and panact for geography and IV
{

use "EdpFiscalRev2", clear
merge 1:m id_log_diff year_fisc using "EdpIndividuRev2"

keep if _m == 3
drop _m

* keep only observations with an id_diff to match wih panact
keep if id_diff != ""

format year_income %4.0f
format year_fisc   %4.0f

merge m:1 id_diff year_income using "EdpPanactMergedRev2"

forvalues t=2010(1)2015 {
rename _m`t' merge`t'
}
keep if _m == 3
drop _m

order id_diff id_log_diff year_income com*

save "EdpFiscalIndivPanactRev2", replace

}

*** Cleaning and definition: fiscal data only
{

use "EdpFiscalIndivPanactRev2", clear

rename year_birth year_birth
destring year_birth, replace force

rename year_income year

gen age = year - year_birth
keep if age >= 25 & age <= 60 
keep if labor_income > 0

gen wealth = 1 / 0.05 * ( lifetime_rents + housing_income + ///
						  nontaxable_financial_income + ///
					      taxable_financial_income )
						  
gen LiquidWealth = 1 / 0.05 * ( nontaxable_financial_income + ///
								taxable_financial_income )
gen IlliquidWealth = 1 / 0.05 * ( lifetime_rents + housing_income )
gen HousingWealth = 1/ 0.05 * housing_income

* Check wealth distribution						  
*hist wealth if wealth > - 50000 & wealth < 500000, bin(100)

	
drop lifetime_rents housing_income nontaxable_financial_income ///
	 taxable_financial_income
	 
* Keep only household heads by keeping lines where the gender
* of the household head is equal to the gender of the line
keep if sex_fisc == sexerf 
rename sex_fisc sex
drop sexerf

* clean geography data
keep if comr != ""
	
* Need to make sure households are continuously in the panel
rename maxyear maxyearFirm
fegen gid = group(id_log_diff)
egen minyear = min(year), by(gid)
egen maxyear = max(year), by(gid)
sort gid year
bys gid: gen N = _N
gen hole = N != maxyear - minyear + 1

keep if hole == 0 & N >= 2
drop hole N

rename com_fisc comf
sort gid year

foreach var in r f {
bys gid: gen mig`var' = com`var' != com`var'[_n-1] & _n > 1
}

drop comf migf

drop residency* tax* business* id_foy* relat* days_full*

save "edpRev2_1", replace

}

*** Construct city ranks and employment shocks from DADS salaries
{

* Put all to annual format
{

global reglist1 11 21 22 23 24 25 26 31 41 42 43 ///
			    52 53 54 72 73 74 82 83 91 93 93 94 97 99
			   
global reglist2	11 24 27 28 32 44 52 53 75 76 84 93 94 97 99		  

clear
forvalues t = 2010(1)2013 {
foreach reg in $reglist1 {		   
append using "$datasal\DADS Salaries\Raw\post`t'p`reg'"			   		   
}
save "$datasal\DADS Salaries\Annual\salaries`t'", replace
}

clear
forvalues t = 2014(1)2015 {
foreach reg in $reglist2 {		   
append using "$datasal\DADS Salaries\Raw\post`t'p`reg'"			   	   
}
save "$datasal\DADS Salaries\Annual\salaries`t'", replace
}

clear
use  "$datasal\DADS Salaries\Raw\post2016p", clear			   	   
save "$datasal\DADS Salaries\Annual\salaries2016", replace


* Compute employment by municipality and occupation
{

global varlist comr duree pcs s_brut zempr

forvalues t=2010(1)2016 {

use $varlist using "$datasal\DADS Salaries\Annual\salaries`t'", clear

gen emp = duree / 360
gen occ2 = substr(pcs,1,2)
rename zempr zer

keep if duree != . & duree >= 1
keep if occ2 != "" & comr != "" & zer != "" & s_brut > 0


fcollapse (sum) emp s_brut (first) zer , by(occ2 comr)

gen year = `t'

save "temp/salariesComOcc`t'Rev2", replace

}

forvalues t=2010(1)2016 {

use "temp/salariesComOcc`t'Rev2", clear

* For city ranks
preserve
fcollapse (sum) emp s_brut (first) zer , by(comr)
gen year = `t'
save "temp/ComEmpSbrut`t'Rev2", replace
restore

* Employment by comr only
preserve
keep emp occ2 comr zer year
save "temp/EmpComOcc`t'Rev2", replace
restore

* Employment by zer and occ2
preserve
fcollapse (sum) emp (mean) year , by(occ2 zer)
save "temp/EmpZeOcc`t'Rev2", replace
restore

* Employment : aggregate (occ2)
preserve
fcollapse (sum) emp (mean) year , by(occ2)
save "temp/EmpAgOcc`t'Rev2", replace
restore

}


* Merge years : city ranks
clear
forvalues t=2010(1)2016 {
append using "temp/ComEmpSbrut`t'Rev2"
}
save "temp/ComEmpSbrut20102016Rev2",replace
gen w = s_brut / emp
egen rank = rank(w), by(year)
egen mrank = max(rank), by(year)
gen zAnnual = rank / mrank
keep comr year z*
save "SalariesCityRankAnnualRev2", replace

use "temp/ComEmpSbrut20102016Rev2", clear
fcollapse (sum) s_brut emp , by(comr)
gen w = s_brut / emp
egen rank = rank(w)
egen mrank = max(rank)
gen zConstant = rank / mrank
keep comr z*
save "SalariesCityRankConstantRev2", replace

* Employment changes at the municipality level
use "temp/ComEmpSbrut20102016Rev2", clear
sort comr year
keep comr year emp zer
bys comr: gen HempCom = 2 * ( emp[_n+1] - emp ) / ( emp[_n+1] + emp )


gen LocationGoesDown =  HempCom < - 0.10 // approximately p25
replace Location = . if HempCom == .
rename emp empCom

save "ComShocksRev2", replace

* Merge years : employment
foreach type in Com Ze Ag {

if "`type'" == "Com" {
local var comr
}
if "`type'" == "Ze" {
local var zer
}
if "`type'" == "Ag" {
local var 
}

clear
forvalues t=2010(1)2016 {
append using "temp/Emp`type'Occ`t'Rev2"
}

sort occ2 `var' year
bys occ2 `var' : gen d`type'Emp = ///
					2 * ( emp[_n+1] - emp[_n] ) / ( emp[_n+1] + emp[_n] ) if _n < _N
bys occ2 `var' : gen d`type'Emp_lag1 = ///
					2 * ( emp[_n] - emp[_n-1] ) / ( emp[_n] + emp[_n-1] ) if _n > 1
drop emp
save "temp/dEmp`type'OccRev2", replace

}


* Merge instruments
use "temp/dEmpComOccRev2", clear
merge m:1 zer occ2 year using "temp/dEmpZeOccRev2" // all matched
drop _m
merge m:1 occ2 year using "temp/dEmpAgOccRev2" // all matched
drop _m

save "dEmpSalariesRev2", replace


}


}

*** Compute wealth ranks and merge in city ranks, amenities and latitude/longitude
{

* City ranks
use "edpRev2_1", clear

fcollapse (mean) wage , by(comr)
egen rank = rank(wage)
egen mrank = max(rank)
replace rank = rank / mrank

rename wage MeanLocalWage
rename rank z
keep comr MeanLocalWage z

save "temp/EdpCityRankRev2", replace

* City ranks, employment shocks and wealth ranks

use "edpRev2_1", clear

	* city ranks
merge m:1 comr year using "SalariesCityRankRev2", gen(_m)
drop _merge
*merge m:1 comr year using "SalariesCityRankAnnual"

keep if _m == 3
drop _m

merge m:1 comr using "SalariesCityRankConstantRev2"

keep if _m == 3
drop _m

	* Amenities
	
merge m:1 comr using "$root\source\amenitiesPCA07"

keep if inlist(_m,1,3)
drop _m

*

merge m:1 comr using "$root\source\amenitiesExternal"

keep if inlist(_m,1,3)
drop _m


	* Latitude/longitude
	
rename comr com
merge m:1 com using "$root\source\latlong"
rename com comr

keep if inlist(_m,1,3)
drop _m

	
	* Location-level shocks and Ze
	
merge m:1 comr year using "ComShocksRev2"

keep if inlist(_m,1,3)
drop _m

* Ensure panel again
sort gid year
bys gid: gen N = _N

drop minyear maxyear
egen minyear = min(year), by(gid)
egen maxyear = max(year), by(gid)
gen hole  =  N != maxyear - minyear + 1
drop if hole == 1 | N < 2
drop hole

	* Wealth ranks

egen wealth_rankLoc = rank(wealth), by( comr year )
egen max_wealth_rankLoc = max(wealth_rankLoc), by( comr year )
replace wealth_rankLoc = wealth_rankLoc / max_wealth_rankLoc

egen wealth_rankAg = rank(wealth), by( year )
egen max_wealth_rankAg = max(wealth_rankAg), by( year )
replace wealth_rankAg = wealth_rankAg / max_wealth_rankAg

foreach type in Loc Ag {

gen M1Assets`type' = wealth_rank`type' <  0.5
gen M2Assets`type' = wealth_rank`type' >= 0.5

gen     MAssets`type' = 1 if M1Assets`type' == 1
replace MAssets`type' = 2 if M2Assets`type' == 1

gen Poor`type' = M1Assets`type' == 1

gen Q1Assets`type' = wealth_rank`type' <  0.25
gen Q2Assets`type' = wealth_rank`type' >= 0.25  & wealth_rank`type' < 0.5
gen Q3Assets`type' = wealth_rank`type' >= 0.5   & wealth_rank`type' < 0.75
gen Q4Assets`type' = wealth_rank`type' >= 0.75 

gen     QAssets`type' = 1 if Q1Assets`type' == 1
replace QAssets`type' = 2 if Q2Assets`type' == 1
replace QAssets`type' = 3 if Q3Assets`type' == 1
replace QAssets`type' = 4 if Q4Assets`type' == 1

}

save "edpRev2_2", replace

}

*** Migration variables and others
{

use "edpRev2_2", clear

* Choose type of rank
rename zAnnual zA
rename zConstant zC

* Age bins
gen agebin = floor( age / 5 )

* Migration and distance

rename migr mig
foreach R in A C {
gen dz`R'0 = 0
replace z`R' = 100 * z`R'
}

rename lat lat
rename long lon

	* Future
	
forvalues i=1(1)4 {
	* Change in location rank
	foreach R in A C {
	sort gid year
	bys gid: gen dz`R'`i'  = z`R'[_n+`i'] - z`R'[_n] if _n < _N - `i' + 1
	}
	* Migration
	sort gid year
	bys gid: gen mig`i'   = comr[_n+`i'] != comr 	  if _n < _N - `i' + 1
	bys gid: gen migZe`i' = zer[_n+`i'] != zer 		  if _n < _N - `i' + 1
	*Change employer
	sort gid year
	bys gid: gen sir`i'   = siren[_n+`i'] != siren 	  if (_n < _N - `i' + 1 &  siren!="" & siren [_n+`i']!="")
	bys gid: gen sir`i'_bis   = siren[_n+`i'] != siren 	  if _n < _N - `i' + 1 
	* Latitude/longitude
	foreach var in lat lon {
	sort gid year
	bys gid: gen `var'`i' = `var'[_n+`i'] 		 		  if _n < _N - `i' + 1
	}
	* Distance
	geodist lat`i' lon`i' lat lon , generate( Dist`i' )
	gen dist`i' = log(Dist`i')
	drop Dist`i'
}


	* Past
	
forvalues i=1(1)3 {
	* Change in location rank
	foreach R in A C {
	sort gid year
	bys gid: gen dz`R'm`i'  = z`R'[_n] - z`R'[_n-`i'] if _n > `i'
	}
	* Migration
	sort gid year
	bys gid: gen migm`i' = comr[_n-`i'] != comr 	   if _n > `i'
	bys gid: gen migZem`i' = zer[_n-`i'] != zer 		   if _n > `i'
	*Change employer
	sort gid year
	bys gid: gen sirm`i'   = siren[_n-`i'] != siren 	  if (_n > `i' &  siren!="" & siren [_n-`i']!="")
	bys gid: gen sirm`i'_bis   = siren[_n-`i'] != siren 	  if _n > `i' 
	* Latitude/longitude
	foreach var in lat lon {
	sort gid year
	bys gid: gen `var'm`i' = `var'[_n-`i'] 		 	   if _n > `i'
	}
	geodist latm`i' lonm`i' lat lon , generate( Distm`i' )
	gen distm`i' = log(Distm`i')
	drop Distm`i'
}

drop lat* lon*


* Assets : adjust computation of growth rate for negative values

	* Future
	
forvalues i=1(1)4 {
	sort gid year
	bys gid: gen wealth`i'  = wealth[_n+`i'] if _n < _N - `i' + 1
	bys gid: gen dwealth`i'  = wealth[_n+`i'] - wealth if _n < _N - `i' + 1
	gen Hwealth`i' = 2 * ( abs(wealth`i') - abs(wealth) ) / ///
					     ( abs(wealth`i') - abs(wealth) ) * ///
						 sign(wealth`i'-wealth)
}

	* Past

forvalues i=1(1)3 {
	sort gid year
	bys gid: gen wealthm`i'  = wealth[_n-`i']  if _n > `i'
	bys gid: gen dwealthm`i'  = wealth[_n-`i'] - wealth  if _n > `i'
	gen Hwealthm`i' = 2 * ( abs(wealthm`i') - abs(wealth) ) / ///
					      ( abs(wealthm`i') - abs(wealth) ) * ///
						  sign(wealthm`i'-wealth)
}


* Income and amenities
rename labor_income inc
forvalues j=1(1)5 {
rename pc`j' Amenities`j'
}

gen a = exp(la)
drop la

foreach var in wage inc Amenities1 Amenities2 Amenities3 a {
gen l`var' = log(`var')

forvalues i=1(1)4 {
bys gid: gen  `var'`i' =  `var'[_n+`i'] if _n < _N - `i' + 1
bys gid: gen l`var'`i' = l`var'[_n+`i'] if _n < _N - `i' + 1
gen dl`var'`i' = l`var'`i' - l`var'
gen H`var'`i' = 2 * ( `var'`i' - `var' ) / ( `var'`i' + `var' )
}
forvalues i=1(1)3 {
bys gid: gen  `var'm`i' =  `var'[_n-`i'] if _n > `i'
bys gid: gen l`var'm`i' = l`var'[_n-`i'] if _n > `i'
gen dl`var'm`i' = l`var'm`i' - l`var'
gen H`var'm`i' = 2 * ( `var'm`i' - `var' ) / ( `var'm`i' + `var' )
}
}


* Wage and income data
sort gid year
foreach var in wage inc {

bys gid: gen l`var'_lag1 = l`var'[_n-1] if _n > 1
gen dl`var'_lag1 = l`var' - l`var'_lag1

bys gid: gen NegGrowth_`var' = ///
	- 2 * ( `var'[_n+1] - `var' ) / ( `var'[_n+1] + `var' ) ///
	if _n < _N

}

sort gid year
bys gid: gen IncRawShock       = NegGrowth_inc > 0.25   if _n < _N
bys gid: gen WageRawShock      = NegGrowth_wage > 0.25  if _n < _N

bys gid: gen WealthShock      = dwealth1 < -50000  if _n < _N
bys gid: gen WealthShock2      = dwealth1 < -30000  if _n < _N

bys gid: gen PosIncRawShock       = NegGrowth_inc < -0.25   if _n < _N
bys gid: gen PosWageRawShock      = NegGrowth_wage < -0.25  if _n < _N
bys gid: gen PosWealthShock      = dwealth1 > 50000  if _n < _N
bys gid: gen PosWealthShock2      = dwealth1 > 30000  if _n < _N

* Factor variables
foreach var in occ2 zer comr {
fegen g`var' = group(`var')
}

* Baseline IV	
gen IvRawShock = dHempFirm < - 0.10 if dHempFirm != .

* Unemployment
gen UShockm1 = days < 0.5 * 360
su UShockm1 // mean = 0.5

sort gid year
bys gid: gen days1 = days[_n+1] if _n < _N
bys gid: gen URawShock = days1 < 0.5 * 360 if _n < _N
drop UShockm1


* Clean owner variable
destring owner, replace force
replace owner = 0 if owner != 1
sort gid year

* Quintiles: need to be before the de-meaning
forvalues i=1(1)5 {
gen QuiA`i' = ( wealth_rankLoc >= (`i'-1) / 5 ) * ///
			  ( wealth_rankLoc <   `i' / 5 )
}
replace QuiA5 = 1 if wealth_rankLoc == 1
	
gen QuiA = .
forvalues i=1(1)5 {
replace QuiA = `i' if QuiA`i' == 1
}

**

forvalues i=1(1)5 {
gen QuiAg`i' = ( wealth_rankAg >= (`i'-1) / 5 ) * ///
			  ( wealth_rankAg <   `i' / 5 )
}
replace QuiAg5 = 1 if wealth_rankAg == 1


*Lag quintiles

forvalues i=1(1)5 {
	sort gid year
	bys gid: gen QuiA`i'm1  = QuiA`i'[_n-1]  if _n > 1
}

*Initial quintiles of location

gen QuiLoc1 = (zC<20)
gen QuiLoc2 = (zC<40 & zC>=20)
gen QuiLoc3 = (zC<60 & zC>=40)
gen QuiLoc4 = (zC<80 & zC>=60)
gen QuiLoc5 = (zC>=80 & zC!=.)

gen MedLoc = (zC>50 & zC!=.)


*Quintiles of income

_pctile inc, p(20,40,60,80)

gen QuiInc1 = (inc<r(r1))
gen QuiInc2 = (inc<r(r2) & inc>=r(r1))
gen QuiInc3 = (inc<r(r3) & inc>=r(r2))
gen QuiInc4 = (inc<r(r4) & inc>=r(r3))
gen QuiInc5 = (inc>=r(r4) & inc!=.)


*

rename LocationGoesDown LocDown

* Quintiles: interactions
forvalues i=1(1)5 {
	
gen QuiA`i'_URawShock   = ( URawShock == 1 ) * QuiA`i'
gen QuiA`i'_IncRawShock = ( IncRawShock == 1 ) * QuiA`i'
gen QuiA`i'_IvRawShock = IvRawShock * QuiA`i'

gen QuiA`i'_WealthShock = ( WealthShock == 1 ) * QuiA`i'
gen QuiA`i'_WealthShock2 = ( WealthShock2 == 1 ) * QuiA`i'

gen QuiA`i'_PosIncRawShock = ( PosIncRawShock == 1 ) * QuiA`i'
gen QuiA`i'_PosWealthShock = ( PosWealthShock == 1 ) * QuiA`i'
gen QuiA`i'_PosWealthShock2 = ( PosWealthShock2 == 1 ) * QuiA`i'

gen QuiAg`i'_IncRawShock = ( IncRawShock == 1 ) * QuiAg`i'


gen QuiA`i'm1_IncRawShock = ( IncRawShock == 1 ) * QuiA`i'm1
gen QuiA`i'm1_PosIncRawShock = ( PosIncRawShock == 1 ) * QuiA`i'm1
gen QuiA`i'm1_PosWealthShock = ( PosWealthShock == 1 ) * QuiA`i'm1


gen QuiA`i'_LocDown = LocDown * QuiA`i'
gen QuiA`i'_LocDown_URawShock = ///
	QuiA`i'_LocDown * ( URawShock == 1 )
gen QuiA`i'_LocDown_IncRawShock = ///
	QuiA`i'_LocDown * ( IncRawShock == 1 )
gen QuiA`i'_LocDown_IvRawShock = ///
	QuiA`i'_LocDown * ( IvRawShock == 1 )

}		

*Interactions with initial ...

*Level
forvalue j=1/5 {
	forvalue i=1/5 {
		gen QuiLoc`j'_QuiA`i' = QuiLoc`j' * QuiA`i'
	}
}
*
forvalue i=1/5 {
	gen MedLoc_QuiA`i' = MedLoc * QuiA`i'
}

*DiD
forvalue j=1/5 {
	forvalue i=1/5 {
		gen QuiLoc`j'_QuiA`i'_IncRawShock = QuiLoc`j' * QuiA`i'_IncRawShock
	}
}
*
forvalue i=1/5 {
	gen MedLoc_QuiA`i'_IncRawShock = MedLoc * QuiA`i'_IncRawShock
}

*Shock
forvalue j=1/5 {
	gen QuiLoc`j'_IncRawShock = QuiLoc`j' * IncRawShock
}
*
gen MedLoc_IncRawShock = MedLoc * IncRawShock



* Deciles: need to be before the de-meaning
forvalues i=1(1)10 {
gen DecA`i' = ( wealth_rankLoc >= (`i'-1) / 10 ) * ///
			  ( wealth_rankLoc <   `i' / 10 )
}
replace DecA10 = 1 if wealth_rankLoc == 1

	
gen DecA = .
forvalues i=1(1)10 {
replace DecA = `i' if DecA`i' == 1
}

* Deciles: interaction
forvalues i=1(1)10 {
		
gen DecA`i'_URawShock     = ( URawShock == 1 ) * DecA`i'
gen DecA`i'_IncRawShock   = ( IncRawShock == 1 ) * DecA`i'
gen DecA`i'_IvRawShock = IvRawShock * DecA`i'

}

* Owner interactions		
gen owner_URawShock   = ( URawShock == 1 ) * owner
gen owner_IncRawShock = ( IncRawShock == 1 ) * owner


* Residualize income and unemployment shock
gen ldays = log(days) 
gen ldays1 = log(days1) 

foreach var in inc days {
foreach RHS in Qui Dec {
reghdfe l`var'1 i.`RHS'A ldays linc owner , a( gcomr gocc2 agebin year ) ///
	residuals(l`var'1_`RHS'_Res)
}
}


foreach Var in Inc U {
qui count if `Var'RawShoc == 1
local Num`Var'shock = r(N)
}
qui count
local NumTot = r(N)


foreach RHS in Qui Dec {

	* Income shock
		
		* Compute centile
		local Percentile = floor( 100 * `NumIncshock' / `NumTot' )
		centile linc1_`RHS'_Res, centile( `Percentile' )
		local centile = r(c_1)
		* Compute new shock
		gen Inc`RHS'ResShock = linc1_`RHS'_Res < `centile' if linc1_`RHS'_Res != .
		
	* Unemployment shock
	
		* Compute centile
		local Percentile = floor( 100 * `NumUshock' / `NumTot' )
		centile ldays1_`RHS'_Res, centile( `Percentile' )
		local centile = r(c_1)
		* Compute new shock
		gen U`RHS'ResShock = ldays1_`RHS'_Res < `centile' if ldays1_`RHS'_Res != .
		
}

* Residualize IV

foreach RHS in Qui Dec {
reghdfe dHempFirm i.`RHS'A linc owner , a( gcomr gocc2 agebin year ) ///
	residuals(dHempFirm_`RHS'_Res)
}

qui count if IvRawShock == 1
local NumIv1 = r(N)
qui count
local NumTot = r(N)

foreach RHS in Qui Dec {
	
		* Compute centile
		local Percentile = floor( 100 * `NumIv1' / `NumTot' )
		centile dHempFirm_`RHS'_Res, centile( `Percentile' )
		local centile = r(c_1)
		* Compute new shock
		gen Iv`RHS'ResShock = dHempFirm_`RHS'_Res < `centile' if dHempFirm_`RHS'_Res != .
		
}

* Interact residualized shock with quintiles, deciles, IV and owner

	* Quintiles: interactions
forvalues i=1(1)5 {
gen QuiA`i'_UQuiResShock   = ( UQuiResShock == 1 )   * QuiA`i'
gen QuiA`i'_IncQuiResShock = ( IncQuiResShock == 1 ) * QuiA`i'
gen QuiA`i'_IvQuiResShock  = ( IvQuiResShock == 1 )  * QuiA`i'
}		

	* Deciles: interaction
forvalues i=1(1)10 {	
gen DecA`i'_UDecResShock     = ( UDecResShock == 1 )   * DecA`i'
gen DecA`i'_IncDecResShock   = ( IncDecResShock == 1 ) * DecA`i'
gen DecA`i'_IvDecResShock    = ( IvDecResShock == 1 )  * DecA`i'
}

foreach var in QuiRes DecRes {
gen owner_U`var'Shock   = ( U`var'Shock == 1 ) * owner
gen owner_Inc`var'Shock = ( Inc`var'Shock == 1 ) * owner
}


* Save
save "edpRev2_3", replace


}

*** Event study format dataset
{

** Basic variables to even study format
{

global varliste gid year dz* mig* dlinc* Hinc* dwealth*  ///
				linc* Amenities1* dist* sir* la* 
global varliste2 dzA dzC mig migZe dlinc Hinc dwealth Amenities1 dist sir la

use "edpRev2_3", clear

drop dlinc_lag1 mig
keep $varliste

sort gid year
bys gid year : gen N = _N
su N
drop if N > 1
drop N 

global Nh = 100 // a large enough number

forvalues t=-3(1)4 {
if `t' != 0 {

if `t' < 0 {
local s = -`t'
local suf m`s'
}
if `t' > 0 {
local suf `t'
}

local new = $Nh + `t'

foreach var in $varliste2 {
rename `var'`suf' `var'`new'
}

}
}

drop *0
drop Amenities1 la


foreach var in $varliste2 {
gen `var'$Nh = 0
}

reshape long $varliste2 , i(gid year) j(h)
replace h = h - $Nh
keep if dzC != .
count 

save "temp/edpRev2_3h", replace

}

** Right-hand-side variables
{

use "edpRev2_3", clear
keep gid year linc gcomr gzer gocc2 zer occ2 agebin  ///
	 QuiA* DecA* owner* Inc* QuiLoc* MedLoc* Wealth* Pos* U* z* Iv* LocDown wealth  

sort gid
bys gid year : gen Num = _N
su Num
drop if Num > 1
drop Num 

save "temp/edpRev2_3v", replace	 

}

** Merge both
{

use "temp/edpRev2_3h", clear
merge m:1 gid year using "temp/edpRev2_3v"
drop _m

drop if h == 0
gen Period = h > 0

foreach var in ig igZe {
egen M`var' = max( m`var' * ( m`var' != . ) ), by(gid Period)
rename m`var' hm`var'
rename M`var' m`var'
}

gen zerocc2 = zer + occ2

save "edpRev2_4", replace

}

}

}
}
*



			*************************************
			*** DATABASE OF DESCRIPTIVE STATS ***
			*************************************

{

cd "$graphs"


* Lists
global StatList mean sd count max
global StatList2     sd count max
global TabList QuiA /// n mig1 migZe1 IncRawShock

	* List of numeric variables
	use "$output\edpRev2_3", clear
	drop *_*  				// drops interactions
	drop QuiA DecA mig1 migZe1 IncRawShock URawShock
	qui ds, has(type numeric)
	
global AllNumVars `r(varlist)'


* Prepare dataset for summary stats
use "$output\edpRev2_3", clear
drop *_*  				// drops interactions
gen n = 1
keep $AllNumVars $TabList
save "$output\temp/edp_3_SumStat", replace


foreach stat in mean { // $StatList
foreach tabvar in $TabList {

use "$output\temp/edp_3_SumStat", clear

* Compute sum ov absolute values for confidentiality
if "`stat'" == "mean" {

global AbsVars
global AbsVars2
foreach var in $AllNumVars {
if inlist( substr("`var'",1,1) , "d" , "H" ) == 1 & substr("`var'",1,4) != "days" {
gen `var'_Abs = abs(`var')
global AbsVars $AbsVars `var'_Abs
global AbsVars2 $AbsVars2 `var'

}
}


}

di "start collapse..."
gcollapse (`stat') $AllNumVars $AbsVars , by( `tabvar' )
di "end collapse..."

foreach var in $AllNumVars {
rename `var' `stat'_`var'
}

di "end rename..."


if "`stat'" != "mean" {
save "$output\temp/`stat'_`tabvar'", replace
}

if "`stat'" == "mean" {

foreach var in $AbsVars2 {
rename `var'_Abs meanAbs_`var'
}

di "end rename 2..."


preserve
keep `tabvar' meanAbs_*
save "$output\temp/meanAbs_`tabvar'", replace
restore


preserve
keep `tabvar' mean_*
save "$output\temp/mean_`tabvar'", replace
restore


}

}
}


* Reshape

foreach stat in meanAbs  { // $StatList
foreach tabvar in $TabList {
use  "$output\temp/`stat'_`tabvar'", clear
reshape long `stat'_ , i( `tabvar' ) j( variable  ) string
rename `stat'_ `stat'
save  "$output\temp/`stat'_`tabvar'_1", replace
}
}

* Merge

foreach tabvar in $TabList {

use "$output\temp/mean_`tabvar'_1", clear
merge 1:1 `tabvar' variable using "$output\temp/meanAbs_`tabvar'_1", nogen

foreach stat in $StatList2 {
merge 1:1 `tabvar' variable using "$output\temp/`stat'_`tabvar'_1", nogen
}

rename count N
drop if N == 0
save "$output\temp/`tabvar'_2", replace

}

* Export and control files
foreach tabvar in $TabList {

use "$output\temp/`tabvar'_2", clear

if meanAbs == . {
gen Ratio = max / ( N * mean )
}
if meanAbs != . {
replace Ratio = max / ( N * meanAbs )
}

drop if substr(variable,-1,1) == "0"
drop if `tabvar' == . 
drop if Ratio == .

* Correction pour les taux de croissance qui ont une moyenne 0 par construction

drop if N < 12 | Ratio > 0.85

save "$Folder/Controle_`tabvar'", replace

drop max Ratio meanAbs

save "$Folder/Export_`tabvar'", replace
}

}


			********************************************************************
			*** DEFINE LIST OF LHS, RHS, SAMPLES, CONTROLS AND FIXED EFFECTS ***
			********************************************************************

{

** Useful variables and cluster

global ClusterVar zerocc2

* LHS variables

global LHS_C dzC
global LHS_I Hinc
global LHS_W dwealth

** Samples

local sampleAll
local sampleMass ( ( IvRaw == 1 & IncRawShock == 1 ) | ///
				 ( IvRaw == 0 & IncRawShock == 0 ) )
 
	* All CZ
	
global Samp_StayAll  
 
global Samp_StayMass ///
	   if `sampleMass'
	   
global Samp_MovAll ///
	   if mig == 1
	   
global Samp_MovMass ///
	   if mig == 1 & `sampleMass'
	   
	* Within-between CZ	   
	   
global Samp_ZeMovMovAll ///
	   if mig ==1 & migZe == 1
	   
global Samp_ZeStayMovAll ///
	   if mig == 1 & migZe == 0 
	   
global Samp_ZeMovMovMass ///
	   if mig == 1 & migZe == 1 & `sampleMass'
	   
global Samp_ZeStayMovMass ///
	   if mig == 1 & migZe == 0 & `sampleMass'

	
** RHS variables

* Baseline variables

global Jmax = 4
	
global SimpleDiff_Qui_IncRaw
global DoubleDiff_Qui_IncRaw
global TripleDiff_Qui_IncRaw
	
forvalues j=1(1)$Jmax {
	global SimpleDiff_Qui_IncRaw ${SimpleDiff_Qui_IncRaw} QuiA`j'
	global DoubleDiff_Qui_IncRaw ${DoubleDiff_Qui_IncRaw} QuiA`j'_IncRawShock
}
	* Add level
global DoubleDiff_Qui_IncRaw ${DoubleDiff_Qui_IncRaw} IncRawShock


* Additional variables REV2

	* Wealth shock

foreach d in Simple Double {
	foreach v in Qui_IncRaw_Pos Qui_Wealth Qui_Wealth2 Qui_Wealth_Pos Qui_Wealth_Pos2 QuiAg_IncRaw {
		global `d'Diff_`v'
	}
}

forvalues j=1(1)4 {

		foreach v in Qui_IncRaw_Pos Qui_Wealth2 Qui_Wealth_Pos2 {
			global SimpleDiff_`v' ///
				  ${SimpleDiff_`v'} QuiA`j'
		}
		
		global SimpleDiff_QuiAg_IncRaw ${SimpleDiff_QuiAg_IncRaw} QuiAg`j'			  
			  
		global DoubleDiff_Qui_IncRaw_Pos ${DoubleDiff_Qui_IncRaw_Pos} QuiA`j'_PosIncRawShock

		global DoubleDiff_Qui_Wealth_Pos2 ${DoubleDiff_Qui_Wealth_Pos2} QuiA`j'_PosWealthShock2

		global DoubleDiff_Qui_Wealth2 ${DoubleDiff_Qui_Wealth2} QuiA`j'_WealthShock2

		global DoubleDiff_QuiAg_IncRaw ${DoubleDiff_QuiAg_IncRaw} QuiAg`j'_IncRawShock
}

	* Add level
global DoubleDiff_Qui_IncRaw_Pos  ${DoubleDiff_Qui_IncRaw_Pos}  PosIncRawShock
global DoubleDiff_Qui_Wealth2     ${DoubleDiff_Qui_Wealth2}     WealthShock2
global DoubleDiff_Qui_Wealth_Pos2 ${DoubleDiff_Qui_Wealth_Pos2} PosWealthShock2
global DoubleDiff_QuiAg_IncRaw    ${DoubleDiff_QuiAg_IncRaw}    IncRawShock


** Controls
	
* Baseline DiD	
	
global Control1 
global FE1 year

global Control2 linc
global FE2 year 

global Control3 linc
global FE3 year gzer

global Control4 linc
global FE4 year gcomr

global Control5 linc
global FE5 year gcomr gocc2

global Control6 linc
global FE6 year gcomr gocc2 agebin

global Control7 linc owner
global FE7 year gcomr gocc2 agebin

global Control8 linc owner Amenities1
global FE8 year gcomr gocc2 agebin

global Control9 linc owner Amenities1 dist
global FE9 year gcomr gocc2 agebin

global Control10 QuiA#c.linc QuiA#owner QuiA#owner_IncRawShock QuiA#c.Amenities1 QuiA#c.dist
global FE10 QuiA#year QuiA#gcomr QuiA#gocc2 QuiA#agebin
		
* CZ movers only

forvalues j=13(1)14 {
global Control`j' ${Control7}
global FE`j' ${FE7}
}
forvalues j=15(1)16 {
global Control`j' ${Control9}
global FE`j' ${FE9}
}	


}
*

			**************
			*** TABLES ***
			**************

{

cd "$graphs"


*** Common settings for all tables
{

global RefCat QuiA1_IncRawShock " "
			   
global OrderVar QuiA1_IncRawShock ///
				QuiA2_IncRawShock ///
				QuiA3_IncRawShock ///
				QuiA4_IncRawShock ///
				IncRawShock

global RhsLab QuiA1_IncRawShock "\hskip3mm Q1 $\times$ Shock" ///
			  QuiA2_IncRawShock "\hskip3mm Q2 $\times$ Shock" ///
			  QuiA3_IncRawShock "\hskip3mm Q3 $\times$ Shock" ///
			  QuiA4_IncRawShock "\hskip3mm Q4 $\times$ Shock" ///
			  IncRawShock		"\hskip3mm Shock"

*
global RefCat2 QuiA1_PosWealthShock2 " "
			   
global OrderVar2 QuiA1_PosWealthShock2 ///
				QuiA2_PosWealthShock2 ///
				QuiA3_PosWealthShock2 ///
				QuiA4_PosWealthShock2 ///
				PosWealthShock2

global RhsLab2 QuiA1_PosWealthShock2 "\hskip3mm Q1 $\times$ Shock" ///
			  QuiA2_PosWealthShock2 "\hskip3mm Q2 $\times$ Shock" ///
			  QuiA3_PosWealthShock2 "\hskip3mm Q3 $\times$ Shock" ///
			  QuiA4_PosWealthShock2 "\hskip3mm Q4 $\times$ Shock" ///
			  PosWealthShock2		"\hskip3mm Shock"
*


global DropMain _cons ///
				 QuiA1 ///
				 QuiA2 ///
				 QuiA3 ///
				 QuiA4 ///
				 owner ///
				 0.gcomr ///
				 0.gocc2 ///
				 0.agebin
				 
global DropMainShort $DropMain ///
				     QuiA2_IncRawShock ///
				     QuiA3_IncRawShock ///
				     QuiA4_IncRawShock				 

global DropMainShort2 $DropMain ///
				     QuiA2_PosWealthShock2 ///
				     QuiA3_PosWealthShock2 ///
				     QuiA4_PosWealthShock2				 
					 
global DropApp   $DropMain ///
				 Amenities1
				 
global DropAppShort  $DropMainShort ///
				     Amenities1	
					 
}


*** Table 1
{

* Load data for columns 1 to 5

use "$output\edpRev2_4" if Period == 1 , clear

* Column 1
eststo c1: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///						
			${SimpleDiff_Qui_IncRaw} 		///
			${Control1}						///
			${Samp_StayAll}					///
			, a( ${FE1} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col1", replace

			
* Column 2
eststo c2: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col2", replace

* Column 3
eststo c3: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///					
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayMass}				///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col3", replace
			
* Column 4
eststo c4: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_MovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col4", replace

* Column 5
eststo c5: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_MovMass}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col5", replace

* Load data for column 6

use "$output\edpRev2_4" if Period == 0 , clear


* Column 6
eststo c6: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
			
qui test QuiA1_IncRawShock = IncRawShock 
estadd scalar Q1_Shock = r(p)
qui test QuiA1_IncRawShock = QuiA2_IncRawShock 
estadd scalar Q1_Q2 = r(p)
qui test QuiA2_IncRawShock = QuiA3_IncRawShock 
estadd scalar Q2_Q3 = r(p)
qui test QuiA3_IncRawShock = QuiA4_IncRawShock 
estadd scalar Q3_Q4 = r(p)		
qui test QuiA4_IncRawShock = IncRawShock 
estadd scalar Q4_Shock = r(p)

qui estimates save "$Folder/Table1Col6", replace

esttab c1 c2 c3 c4 c5 c6, se r2 b(2) stats(Q1_Shock Q1_Q2 Q2_Q3 Q3_Q4 Q4_Shock) nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()


** Produce Table 1 in tex format

local Results c1 c2 c3 c4 c5 c6
local pattern 1 0 0 0 0 1
local ColTitles mtitles("" "" "\shortstack{Mass\\layoffs}" "Movers" "\shortstack{Mass\\\& movers}" "")
local adjust // used when dividing by 1,000

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	
		   
esttab `Results' using "$Folder/Table1.tex", replace ///
	compress b(2) se(2) alignment(c c) `adjust' ///
	mgroups("Post shock" "Pre shock" ///
			, pattern(`pattern') ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	`ColTitles' ///
	title(Effect of an income shock on location rank (p.p.) by financial assets quintile.) ///
	refcat($RefCat , nolabel) /// 
	order( $OrderVar "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropMain ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 Q1_Shock Q1_Q2 Q2_Q3 Q3_Q4 Q4_Shock, fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' `"Q1xShock = Shock"' `"Q1xShock = Q2xShock"' `"Q2xShock = Q3xShock"' `"Q3xShock = Q4xShock"' `"Q4xShock = Shock"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$")

eststo clear

}


*** Table 2
{

* Load data for columns 1 to 5

use "$output\edpRev2_4" if Period == 1 , clear


* Column 1
eststo c1: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///				
			${SimpleDiff_Qui_IncRaw} 		///
			${Control1}						///
			${Samp_StayAll}					///
			, a( ${FE1} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col1", replace

* Column 2
eststo c2: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col2", replace

* Column 3
eststo c3: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///										
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayMass}				///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col3", replace
			
* Column 4
eststo c4: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_MovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col4", replace

* Column 5
eststo c5: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_MovMass}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col5", replace

* Load data for column 6

use "$output\edpRev2_4" if Period == 0 , clear


* Column 6
eststo c6: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///							
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_StayAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table2Col6", replace

esttab c1 c2 c3 c4 c5 c6, se r2 b(2) stats() nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()

** Produce Table 2 in tex format

local Results c1 c2 c3 c4 c5 c6
local pattern 1 0 0 0 0 1
local ColTitles mtitles("" "" "\shortstack{Mass\\layoffs}" "Movers" "\shortstack{Mass\\\& movers}" "")
local adjust transform(@/1000 1/1000)

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	
		   
esttab `Results' using "$Folder/Table2.tex", replace ///
	compress b(2) se(2) alignment(c c) `adjust' ///
	mgroups("Post shock" "Pre shock" ///
			, pattern(`pattern') ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	`ColTitles' ///
	title(Effect of an income shock on location rank (p.p.) by financial assets quintile.) ///
	refcat($RefCat , nolabel) /// 
	order( $OrderVar "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropMainShort ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 , fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$")

eststo clear

}


*** Table 3 is from A0BAWFI --- separate do-file


*** Table 4
{

* Load data for Table 4 columns 1 to 4

use "$output\edpRev2_4" if Period == 1 , clear


* Column 1
eststo c1: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control9} la					///
			${Samp_Qui_StayAll}				///
			, a( ${FE9} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table4Col1", replace


* Column 2
eststo c2: qui reghdfe 	${LHS_C} 				///
			${DoubleDiff_Qui_IncRaw}			///									
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_StayMass}					///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table4Col2", replace

		
* Column 3
eststo c3: qui reghdfe 	${LHS_C} 				///
			${DoubleDiff_Qui_IncRaw}			///										
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_MovAll}						///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table4Col3", replace

* Column 4
eststo c4: qui reghdfe 	${LHS_C} 				///
			${DoubleDiff_Qui_IncRaw}			///								
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_MovMass}						///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table4Col4", replace

* Load data for column 5

use "$output\edpRev2_4" if Period == 0 , clear


* Column 5
eststo c5: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///							
			${SimpleDiff_Qui_IncRaw} la		///
			${Control9}						///
			${Samp_StayAll}					///
			, a( ${FE9} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table4Col5", replace

esttab c1 c2 c3 c4 c5 , se r2 b(2) stats() nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()

** Produce Table 4 in tex format

local Results c1 c2 c3 c4 c5
local pattern 1 0 0 0 1
local ColTitles mtitles("" "\shortstack{Mass\\layoffs}" "Movers" "\shortstack{Mass\\\& movers}" "")
local adjust

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	
		   
esttab `Results' using "$Folder/Table4.tex", replace ///
	compress b(2) se(2) alignment(c c) `adjust' ///
	mgroups("Post shock" "Pre shock" ///
			, pattern(`pattern') ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	`ColTitles' ///
	title(Effect of a negative shock on location rank by financial assets quintile.) ///
	refcat($RefCat , nolabel) /// 
	order( $OrderVar "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  "\hskip3mm Distance, Amenities = dist"  ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropAppShort ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 , fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$")

eststo clear


}


*** Table 5
{

* Load data for columns 1 to 3

use "$output\edpRev2_4" if Period == 1 , clear


* Column 1
eststo c1: qui reghdfe 	${LHS_C} 						///
			${DoubleDiff_Qui_Wealth_Pos2}						///										///
			${SimpleDiff_Qui_Wealth_Pos2} 		///
			${Control1}	///
			${Samp_StayAll}						///
			, a( ${FE1} )		///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table5Col1", replace

* Column 2
eststo c2: qui reghdfe 	${LHS_C} 						///
			${DoubleDiff_Qui_Wealth_Pos2}						///										///
			${SimpleDiff_Qui_Wealth_Pos2} 		///
			${Control7}	///
			${Samp_StayAll}						///
			, a( ${FE7} )		///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table5Col2", replace

			
* Column 3
eststo c3: qui reghdfe 	${LHS_C} 						///
			${DoubleDiff_Qui_Wealth_Pos2}						///										///
			${SimpleDiff_Qui_Wealth_Pos2} 		///
			${Control7}	///
			${Samp_MovAll}						///
			, a( ${FE7} )		///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table5Col3", replace


* Load data for column 4

use "$output\edpRev2_4" if Period == 0 , clear

* Column 4
eststo c4: qui reghdfe 	${LHS_C} 						///
			${DoubleDiff_Qui_Wealth_Pos2}						///										///
			${SimpleDiff_Qui_Wealth_Pos2} 		///
			${Control7}	///
			${Samp_StayAll}						///
			, a( ${FE7} )		///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table5Col4", replace

esttab c1 c2 c3 c4 , se r2 b(2) stats() nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()

** Produce Table 5 in tex format

local Results c1 c2 c3 c4
local pattern 1 0 0 1
local ColTitles mtitles("" "" "Movers" "")
local adjust

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	
		   
esttab `Results' using "$Folder/Table5.tex", replace ///
	compress b(2) se(2) alignment(c c) `adjust' ///
	mgroups("Post shock" "Pre shock" ///
			, pattern(`pattern') ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	`ColTitles' ///
	title(Effect of a positive wealth shock (30k) on location rank (p.p.) by financial assets quintile.) ///
	refcat($RefCat2 , nolabel) /// 
	order( $OrderVar2 "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab2 ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropMainShort2 ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 , fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$")

eststo clear

}


*** Table 6
{

* Load data for columns 1 to 4

use "$output\edpRev2_4" if Period == 1 , clear

		
* Column 1
eststo c1: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_ZeStayMovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table6Col1", replace

* Column 2
eststo c2: qui reghdfe 	${LHS_C} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_ZeMovMovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table6Col2", replace

* Column 3
eststo c3: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_ZeStayMovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table6Col3", replace

* Column 4
eststo c4: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///								
			${SimpleDiff_Qui_IncRaw} 		///
			${Control7}						///
			${Samp_ZeMovMovAll}					///
			, a( ${FE7} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table6Col4", replace

esttab c1 c2 c3 c4 , se r2 b(2) stats() nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()

** Produce Table 6 in tex format

local Results c1 c2 c3 c4

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	

		   
esttab `Results' using "$Folder/Table6.tex", replace ///
	compress b(2) se(2) alignment(c c) transform(@/1000 1/1000, pattern(0 0 1 1)) ///
	mgroups("Location rank (p.p.)" "Wealth (1,000 euros)" ///
			, pattern(1 0 1 0) ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	mtitles("\shortstack{W/in-CZ\\movers}" "\shortstack{Cross-CZ\\movers}" "\shortstack{W/in-CZ\\movers}" "\shortstack{Cross-CZ\\movers}") ///
	title(Effect of an income shock on location and wealth, by financial assets.) ///
	refcat($RefCat , nolabel) /// 
	order( $OrderVar "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropMainShort ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 , fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$") ///
	
eststo clear

}


*** Table 7
{

* Load data for Table 4 columns 1 to 4

use "$output\edpRev2_4" if Period == 1 , clear

* Column 1
eststo c1: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///									
			${SimpleDiff_Qui_IncRaw} 		///
			${Control9} la					///
			${Samp_Qui_StayAll}				///
			, a( ${FE9} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table7Col1", replace


* Column 2
eststo c2: qui reghdfe 	${LHS_W} 				///
			${DoubleDiff_Qui_IncRaw}			///									
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_StayMass}					///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table7Col2", replace

		
* Column 3
eststo c3: qui reghdfe 	${LHS_W} 				///
			${DoubleDiff_Qui_IncRaw}			///										
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_MovAll}						///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table7Col3", replace

* Column 4
eststo c4: qui reghdfe 	${LHS_W} 				///
			${DoubleDiff_Qui_IncRaw}			///								
			${SimpleDiff_Qui_IncRaw} la 		///
			${Control9}							///
			${Samp_MovMass}						///
			, a( ${FE9} )						///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table7Col4", replace

* Load data for column 5

use "$output\edpRev2_4" if Period == 0 , clear

* Column 5
eststo c5: qui reghdfe 	${LHS_W} 			///
			${DoubleDiff_Qui_IncRaw}		///							
			${SimpleDiff_Qui_IncRaw} la		///
			${Control9}						///
			${Samp_StayAll}					///
			, a( ${FE9} )					///
			cluster( $ClusterVar )
qui estimates save "$Folder/Table7Col5", replace

esttab c1 c2 c3 c4 c5 , se r2 b(2) stats() nocons star(* 0.10 ** 0.05 *** 0.01) title("") mtitle()

** Produce Table 7 in tex format

local Results c1 c2 c3 c4 c5
local pattern 1 0 0 0 1
local ColTitles mtitles("" "\shortstack{Mass\\layoffs}" "Movers" "\shortstack{Mass\\\& movers}" "")
local adjust

estfe `Results' , ///
	labels(year 		"\hskip3mm Year, Q1-Q5"				///
		   gcomr 		"\hskip3mm Municip, occ, age," 		///
		   gocc2		"\hskip3mm 2-digit occupation"      ///	
		   agebin		"\hskip3mm 5-year age bin")	
		   
esttab `Results' using "$Folder/Table7.tex", replace ///
	compress b(2) se(2) alignment(c c) `adjust' ///
	mgroups("Post shock" "Pre shock" ///
			, pattern(`pattern') ///
			  prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	`ColTitles' ///
	title(Effect of an income shock on financial assets (1,000 euros) by financial assets quintiles.) ///
	refcat($RefCat , nolabel) /// 
	order( $OrderVar "\textit{Controls and FEs}") /// 
	coeflabel( $RhsLab ) ///
	indicate( "\hskip3mm Year, Q1-Q5, Q2-Q4 $\times$ Shock = 0.year" 		 ///
			  "\hskip3mm Inc., Mun., Occ., Age., HO = linc" ///
			  "\hskip3mm Distance, Amenities = dist"  ///
			  , labels("\multicolumn{1}{c}{\checkmark}"  "") ) ///
	drop( $DropAppShort ) ///
	star(* 0.10 ** 0.05 *** 0.01) ///
	stats(N r2 , fmt(0 3) layout("\multicolumn{1}{c}{@}" "\multicolumn{1}{c}{@}") ///
		  labels(`"Obs."' `"\(R^{2}\)"' ) ///
		  ) ///
	nonotes ///
	addnotes("\tiny S.E.s in parenthesis, clustered at commuting zone by occupation level." ///
	         "\tiny $^* \ p<0.10, \ ^{**} \ p<0.05, \ ^{***}\ p<0.01.$")

eststo clear


}

}
*

			***************
			*** FIGURES ***
			***************


{

cd "$graphs"


*** Figure 5
{

** Left panel: wealth distribution

* Load data

foreach p in Loc Ag {

	use "$output\edpRev2_3", clear
	drop *1 *2 *3 *4 *m* Qui* Dec*

	* Define ranks as local wealth ranks
	rename wealth_rank`p' WR
	replace WR = floor( WR * 100 )
	drop if WR == .
	replace WR = min( 1 + WR , 100)
	*drop N

	* Bin into quintiles
	gen QuiA = .
	forvalues i=1(1)5{
	replace QuiA = `i' if WR > 100 * (`i'-1)/5 & WR <= 100 * `i'/5
	}

	* Collapse
	fcollapse (mean) owner wealth Liquid Illi [w=N], by(QuiA)

	* Put in 1000 euros
	foreach var in wealth Liquid Illi {
	replace `var' = `var' / 1000
	}

	* Plot
	graph bar wealth , over(QuiA ) ///
		  bar(1 , color(navy) ) 		/// 
		  xsize(8) ysize(5) ylabel(0(50)250) ///
		  yscale( titlegap(3) ) ///
		  graphregion(color(white)) bgcolor(white) ///
		  legend(off region(lcolor(white)) ) ///
		  ytitle(Wealth (1,000 euros) ) ///
		  b1title("low                            Financial assets quintile                                high") ///
		  name(WealthDistribution_`p', replace)

	* Save
	graph export "$Folder/WealthDistribution_`p'.pdf", name(WealthDistribution_`p') replace
}



** Right panel: migration rates

* Load data
use "$Folder/Export_QuiA", clear

* Construt 
keep if substr(variable,1,3) == "mig"
drop sd

* rename
replace variable = "mig1" if variable == "mig"
replace variable = "migZe1" if variable == "migZe"

gen h = 0 if substr(variable,4,1) == ""
replace h = 0 if substr(variable,6,1) == ""

* for mig
replace h = 1 if substr(variable,4,1) == "1"
replace h = 2 if substr(variable,4,1) == "2"
replace h = 3 if substr(variable,4,1) == "3"
replace h = 4 if substr(variable,4,1) == "4"
replace h = -1 if substr(variable,4,2) == "m1"
replace h = -2 if substr(variable,4,2) == "m2"
replace h = -3 if substr(variable,4,2) == "m3"

* for migZe
replace h = 1 if substr(variable,6,1) == "1"
replace h = 2 if substr(variable,6,1) == "2"
replace h = 3 if substr(variable,6,1) == "3"
replace h = 4 if substr(variable,6,1) == "4"
replace h = -1 if substr(variable,6,2) == "m1"
replace h = -2 if substr(variable,6,2) == "m2"
replace h = -3 if substr(variable,6,2) == "m3"

* prepare for reshape
replace variable = "migZe" if substr(variable,4,1) == "Z"
replace variable = "migCo" if substr(variable,4,1) != "Z"

reshape wide mean N , i(QuiA h) j(variable) s

drop NmigZe
rename NmigCo Nmig
order Qui h mean* N

keep if abs(h) == 1 | h == 2

rename meanmigCo migCo
rename meanmigZe migZe

* interpolate migZe
sort QuiA h
bys QuiA: replace migZe = migZe[_n-1] + ( migZe[_n+1] - migZe[_n-1] ) / ( migCo[_n+1] - migCo[_n-1] ) * ( migCo[_n] - migCo[_n-1] ) if h == 1

* keep only one-year migration
keep if h == 1
drop h

* Put in percent
foreach var in migCo migZe {
replace `var' = 100 * `var'
}

* Detailed bar plot
graph bar migCo migZe , over(QuiA ) ///
	  bar(1 , color(navy) ) 		/// 
	  bar(2 , color(maroon))        /// 
	  xsize(8) ysize(5) ylabel(0(1)5) ///
	  yscale( titlegap(3) ) ///
	  graphregion(color(white)) bgcolor(white) ///
	  legend(on cols(2) order(1 2) ///
						label(1 "Across municipalities") ///
						label(2 "Across commuting zones") ///
						region(lcolor(white)) ) ///
	  ytitle(Annual migration rate (percent) ) ///
	  b1title(   low                            Financial assets quintile                                high) ///
	  name(MigrationRate, replace)

* Save
graph export "$Folder/MigrationRate.pdf", name(MigrationRate) replace

}


*** Figure 6 is from A0BAWFI --- separate do-file 


*** Figures 7 and 8
{

** Regressions: loop over all horizons h and outcomes

foreach LHS in C W {
forvalues h=-3(1)4 {

if `h' != 0 {

	if `h' > 0 {
	local Suff `h'
	}
	if `h' < 0 {
	local mh = -`h'
	local Suff m`mh'
	}

	* Load only relevant data
	use "$output\edpRev2_4" if h == `h' , clear
	
	* Blue line at horizon h
	qui reghdfe 	${LHS_`LHS'} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control4}						///
					${Samp_StayAll}					///
					, a( ${FE4} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure78`LHS'Blue`Suff'", replace

	* Red line at horizon h
	qui reghdfe 	${LHS_`LHS'} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control7}						///
					${Samp_StayAll}					///
					, a( ${FE7} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure78`LHS'Red`Suff'", replace

	* Green line at horizon h
	qui reghdfe 	${LHS_`LHS'} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control9}						///
					${Samp_StayAll}					///
					, a( ${FE9} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure78`LHS'Green`Suff'", replace

}
}
}


** Merge estimates


* Loop over three specifications and both outcomes
foreach LHS in C W {

* Prepare to load estimates
clear
set obs 8
gen h = _n - 4

* Define quintiles of interest
local N = 5
local Nm1 = 4
local Nmid = 3

foreach i in Blue Red Green {

	* Initialize point estimates and standard errors
	foreach var in coef se lci uci {
	gen `var'`i' = 0
	}
	forvalues j=1(1)`N' {
	gen coef`i'_`j' = 0
	}

	* Loop over horizons to import regression results
	forvalues h=-3(1)4 {
	if `h' != 0 {

		if `h' > 0 {
		local Suff `h'
		}
		if `h' < 0 {
		local mh = -`h'
		local Suff m`mh'
		}
		local t = `h' + 4

		* Load estimation results for specification i at horizon h
		estimates use "$Folder/Figure78`LHS'`i'`Suff'"
			
		* Read in point estimates and standard errors for differential effect
		replace coef`i' = _b[QuiA1_IncRawShock]     if _n == `t'
		replace se`i'   = _se[QuiA1_IncRawShock]    if _n == `t'
		replace lci`i'  = coef`i' + 1.96 * se`i' if _n == `t'
		replace uci`i'  = coef`i' - 1.96 * se`i' if _n == `t'
		
		* Construct level effect
		replace coef`i'_`N' = _b[IncRawShock]    if _n == `t'
					
		forvalues j=1(1)`Nm1' {
			replace coef`i'_`j' = _b[IncRawShock] + _b[QuiA`j'_IncRawShock]  if _n == `t'
		}
					
	}
	}

}

save "$Folder/Figure78`LHS'", replace

}


** Produce figure 7

* Load estimates
use "$Folder/Figure78C", clear

* Graphical parameters
global minh = 2
keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5

* Plot
scatter coefBlue h           if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
   rcap lciBlue uciBlue h    if h != . , lcolor(navy) lwidth(0.1) || ///
scatter coefRed h            if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) lpattern(dash) || ///
   rcap lciRed uciRed h      if h != . , lcolor(maroon) lwidth(0.1) || ///
scatter coefGreen h          if h != . , connect(l) clwidth(0.5) lcolor(forest_green) msymbol(T) mcolor(forest_green) lpattern(dash_dot) || ///
   rcap lciGreen uciGreen h  if h != . , lcolor(forest_green) lwidth(0.1) ///
   xtitle("Horizon") xscale(range(-`minh2' 4.5)) xlabel(-`minh'(1)4) ///
   ytitle("Change in location rank (p.p.)") ///
   title( "Relative effect of income shock on location" "Q1-Q5 difference." ///
		  , size(large) ) ///
   legend( on order( 1 3 5 ) cols(1) ///
		   label(1 "Municipality and income controls") ///
		   label(3 "+ occupation, age and owner") ///
		   label(5 "+ amenities and distance") ///
		   region(lcolor(white)) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) ///
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   name(Figure7, replace) 

* Save plot
graph export "$Folder/Figure7.pdf", name(Figure7) replace


** Produce figure 8(a)

* Load estimates
use "$Folder/Figure78C", clear

* Graphical parameters
global minh = 2
keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5

* Plot	
scatter coefBlue_1    h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
scatter coefRed_1     h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(S) mcolor(navy) lpattern(dash) || ///
scatter coefGreen_1  h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(T) mcolor(navy) lpattern(dash_dot) || ///
scatter coefBlue_5  h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(O) mcolor(maroon) || ///
scatter coefRed_5   h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) lpattern(dash) || ///
scatter coefGreen_5 h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(T) mcolor(maroon) lpattern(dash_dot) ///
  xtitle("Horizon", size(small) ) xscale(range(-`minh2' 4.5)  titlegap(3) ) ///
   xlabel(-`minh'(1)4, labsize(small) ) ylabel( , labsize(small) ) yscale( titlegap(3) ) ///
   ytitle("Change in location rank (p.p.)", size(small) ) ///
      legend( on order(1 4 2 5 3 6) cols(2) ///
			  label(1 "Q1, municip. and inc. controls") ///
			  label(2 "Q1, + occ., age and owner") ///
			  label(3 "Q1, + amenities and distance") ///
			  label(4 "Q5, municip. and inc. controls") ///
			  label(5 "Q5, + occ., age and owner") ///
			  label(6 "Q5, + amenities and distance") ///
		      region(lcolor(white)) size(small) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) /// 
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   name(Figure8a, replace) 

* Save plot
graph export "$Folder/Figure8a.pdf", name(Figure8a) replace



** Produce figure 8(b)

* Load estimates
use "$Folder/Figure78W", clear

* Graphical parameters
global minh = 2
keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5

foreach var in coefBlue_1 coefRed_1 coefGreen_1 coefBlue_5 coefRed_5 coefGreen_5 {
	replace `var' = `var'/1000
}

* Plot	
scatter coefBlue_1    h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
scatter coefRed_1     h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(S) mcolor(navy) lpattern(dash) || ///
scatter coefGreen_1  h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(T) mcolor(navy) lpattern(dash_dot) || ///
scatter coefBlue_5  h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(O) mcolor(maroon) || ///
scatter coefRed_5   h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) lpattern(dash) || ///
scatter coefGreen_5 h     	  if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(T) mcolor(maroon) lpattern(dash_dot) ///
  xtitle("Horizon", size(small) ) xscale(range(-`minh2' 4.5)  titlegap(3) ) ///
   xlabel(-`minh'(1)4, labsize(small) ) ylabel( , labsize(small) ) yscale( titlegap(3) ) ///
   ytitle("Change in financial assets (1,000 euros)", size(small) ) ///
      legend( on order(1 4 2 5 3 6) cols(2) ///
			  label(1 "Q1, municip. and inc. controls") ///
			  label(2 "Q1, + occ., age and owner") ///
			  label(3 "Q1, + amenities and distance") ///
			  label(4 "Q5, municip. and inc. controls") ///
			  label(5 "Q5, + occ., age and owner") ///
			  label(6 "Q5, + amenities and distance") ///
		      region(lcolor(white)) size(small) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) /// 
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   name(Figure8b, replace) 

* Save plot
graph export "$Folder/Figure8b.pdf", name(Figure8b) replace



}


*** Figure 9
{

** Regressions: loop over all horizons h and samples

foreach sample in StayMass MovAll {
forvalues h=-3(1)4 {

if `h' != 0 {

	if `h' > 0 {
	local Suff `h'
	}
	if `h' < 0 {
	local mh = -`h'
	local Suff m`mh'
	}

	* Load only relevant data
	use "$output\edpRev2_4" if h == `h' , clear
	
	* Blue line at horizon h
	qui reghdfe 	${LHS_C} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control4}						///
					${Samp_`sample'}					///
					, a( ${FE4} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure9`sample'Blue`Suff'", replace

	* Red line at horizon h
	qui reghdfe 	${LHS_C} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control7}						///
					${Samp_`sample'}					///
					, a( ${FE7} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure9`sample'Red`Suff'", replace

	* Green line at horizon h
	qui reghdfe 	${LHS_C} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control9}						///
					${Samp_`sample'}					///
					, a( ${FE9} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure9`sample'Green`Suff'", replace

}
}
}


** Merge estimates

* Loop over three specifications and both outcomes
foreach sample in StayMass MovAll {

* Prepare to load estimates
clear
set obs 8
gen h = _n - 4

* Define quintiles of interest
local N = 5
local Nm1 = 4
local Nmid = 3

foreach i in Blue Red Green {

	* Initialize point estimates and standard errors
	foreach var in coef se lci uci {
	gen `var'`i' = 0
	}
	forvalues j=1(1)`N' {
	gen coef`i'_`j' = 0
	}

	* Loop over horizons to import regression results
	forvalues h=-3(1)4 {
	if `h' != 0 {

		if `h' > 0 {
		local Suff `h'
		}
		if `h' < 0 {
		local mh = -`h'
		local Suff m`mh'
		}
		local t = `h' + 4

		* Load estimation results for specification i at horizon h
		estimates use "$Folder/Figure9`sample'`i'`Suff'"
			
		* Read in point estimates and standard errors for differential effect
		replace coef`i' = _b[QuiA1_IncRawShock]     if _n == `t'
		replace se`i'   = _se[QuiA1_IncRawShock]    if _n == `t'
		replace lci`i'  = coef`i' + 1.96 * se`i' if _n == `t'
		replace uci`i'  = coef`i' - 1.96 * se`i' if _n == `t'
		
		* Construct level effect
		replace coef`i'_`N' = _b[IncRawShock]    if _n == `t'
					
		forvalues j=1(1)`Nm1' {
			replace coef`i'_`j' = _b[IncRawShock] + _b[QuiA`j'_IncRawShock]  if _n == `t'
		}
					
	}
	}

}

save "$Folder/Figure9`sample'", replace

}


** Produce figure 9(a)

* Load estimates
use "$Folder/Figure9StayMass", clear

* Graphical parameters
global minh = 2
keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5

* Plot
scatter coefBlue h           if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
   rcap lciBlue uciBlue h    if h != . , lcolor(navy) lwidth(0.1) || ///
scatter coefRed h            if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) lpattern(dash) || ///
   rcap lciRed uciRed h      if h != . , lcolor(maroon) lwidth(0.1) || ///
scatter coefGreen h          if h != . , connect(l) clwidth(0.5) lcolor(forest_green) msymbol(T) mcolor(forest_green) lpattern(dash_dot) || ///
   rcap lciGreen uciGreen h  if h != . , lcolor(forest_green) lwidth(0.1) ///
   xtitle("Horizon") xscale(range(-`minh2' 4.5)) xlabel(-`minh'(1)4) ///
   ytitle("Change in location rank (p.p.)") ///
   title( "Relative effect of income shock on location: mass layoffs" "Q1-Q5 difference." ///
		  , size(large) ) ///
   legend( on order( 1 3 5 ) cols(1) ///
		   label(1 "Municipality and income controls") ///
		   label(3 "+ occupation, age and owner") ///
		   label(5 "+ amenities and distance") ///
		   region(lcolor(white)) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) ///
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   name(Figure9a, replace) 

* Save plot
graph export "$Folder/Figure9a.pdf", name(Figure9a) replace


** Produce figure 9(b)

* Load estimates
use "$Folder/Figure9MovAll", clear

* Graphical parameters
global minh = 2
keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5

* Plot
scatter coefBlue h           if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
   rcap lciBlue uciBlue h    if h != . , lcolor(navy) lwidth(0.1) || ///
scatter coefRed h            if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) lpattern(dash) || ///
   rcap lciRed uciRed h      if h != . , lcolor(maroon) lwidth(0.1) || ///
scatter coefGreen h          if h != . , connect(l) clwidth(0.5) lcolor(forest_green) msymbol(T) mcolor(forest_green) lpattern(dash_dot) || ///
   rcap lciGreen uciGreen h  if h != . , lcolor(forest_green) lwidth(0.1) ///
   xtitle("Horizon") xscale(range(-`minh2' 4.5)) xlabel(-`minh'(1)4) ///
   ytitle("Change in location rank (p.p.)") ///
   title( "Relative effect of income shock on location: movers" "Q1-Q5 difference." ///
		  , size(large) ) ///
   legend( on order( 1 3 5 ) cols(1) ///
		   label(1 "Municipality and income controls") ///
		   label(3 "+ occupation, age and owner") ///
		   label(5 "+ amenities and distance") ///
		   region(lcolor(white)) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) ///
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   name(Figure9b, replace) 

* Save plot
graph export "$Folder/Figure9b.pdf", name(Figure9b) replace

}


*** Figure 13
{

** Compute mean income 

use "$Folder/Export_QuiA", clear
keep if substr(variable,1,3) == "inc"
drop sd N

gen h = 0 if substr(variable,4,4) == ""
replace h = 1 if substr(variable,4,5) == "1"
replace h = 2 if substr(variable,4,5) == "2"
replace h = 3 if substr(variable,4,5) == "3"
replace h = 4 if substr(variable,4,5) == "4"
replace h = -1 if substr(variable,4,5) == "m1"
replace h = -2 if substr(variable,4,5) == "m2"
replace h = -3 if substr(variable,4,5) == "m3"

drop variable
rename mean Inc_
rename QuiA Qui

reshape wide Inc , i(h) j(Qui)

keep if h == 0
drop h
expand 8
gen h = _n - 4

save "$Folder/MeanIncomeByQuintile", replace


** Regressions: loop over all horizons h and outcomes

forvalues h=-3(1)4 {

if `h' != 0 {

	if `h' > 0 {
	local Suff `h'
	}
	if `h' < 0 {
	local mh = -`h'
	local Suff m`mh'
	}

	* Load only relevant data
	use "$output\edpRev2_4" if h == `h' , clear
	
	* Regression at horizon h
	qui reghdfe 	${LHS_I} 		///
					${DoubleDiff_Qui_IncRaw}		///						
					${SimpleDiff_Qui_IncRaw} 		///
					${Control7}						///
					${Samp_StayAll}					///
					, a( ${FE7} )					///
					cluster( $ClusterVar )	
	qui estimates save "$Folder/Figure13`Suff'", replace

}
}


** Merge estimates

* Prepare to load estimates
clear
set obs 8
gen h = _n - 4

* Define quintiles of interest
local N = 5
local Nm1 = 4
local Nmid = 3

* Loop over three specifications and both outcomes

* Initialize point estimates and standard errors
foreach var in coef ser lci uci {
gen `var'`i' = 0
}
forvalues j=1(1)`N' {
gen coef`i'_`j' = 0
}

* Loop over horizons to import regression results
forvalues h=-3(1)4 {
if `h' != 0 {

	if `h' > 0 {
	local Suff `h'
	}
	if `h' < 0 {
	local mh = -`h'
	local Suff m`mh'
	}
	local t = `h' + 4

	* Load estimation results at horizon h
	estimates use "$Folder/Figure13`Suff'"
		
	* Read in point estimates and standard errors for differential effect
	replace coef = _b[QuiA1_IncRawShock]     if _n == `t'
	replace ser   = _se[QuiA1_IncRawShock]    if _n == `t'
	replace lci  = coef + 1.96 * ser if _n == `t'
	replace uci  = coef - 1.96 * ser if _n == `t'
	
	* Construct level effect
	replace coef_`N' = _b[IncRawShock]    if _n == `t'
				
	forvalues j=1(1)`Nm1' {
		replace coef_`j' = _b[IncRawShock] + _b[QuiA`j'_IncRawShock]  if _n == `t'
	}
				
}
}

* Construct level in euros
merge 1:1 h using "$Folder/MeanIncomeByQuintile"
forvalues j=1(1)`N'{
gen Coef_`j' = coef_`j' * Inc_`j' / 1000
}


* Save estimates
save "$Folder/Figure13", replace


** Produce figure 13(a)

* Load estimates
use "$Folder/Figure13", clear

keep if h >= - $minh & h <= 4

local minh  = $minh
local minh2 = $minh + 0.5


* Plot
scatter Coef_1 h     	  if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
scatter Coef_`Nmid' h     if h != . , connect(l) clwidth(0.5) lcolor(forest_green) msymbol(T) mcolor(forest_green) || ///
scatter Coef_`N' h        if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) ///
   xtitle("Horizon") xscale(range(-`minh2' 4.5)) xlabel(-`minh'(1)4) ///
   ytitle("Change in income (1,000 euros)") ///
      legend( on order(1 2 3) cols(1) ///
			  label(1 "Low financial assets (Q1)") ///
			  label(2 "Intermediate financial assets (Q3)") ///
			  label(3 "High financial assets (Q5)") ///
		      region(lcolor(white)) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) /// 
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   note("Municipality, income, occupation, age and home-ownership controls") ///
   name(Figure13a, replace) 

* Save plot
graph export "$Folder/Figure13a.pdf", name(Figure13a) replace
 

** Produce figure 13(b)

* Load estimates
use "$Folder/Figure13", clear

keep if h >= - $minh & h <= 4

* Percent change
foreach i in 1 `Nmid' `N' {
replace coef_`i' = 100 * coef_`i'
}
	
* Plot	
scatter coef_1 h     	 if h != . , connect(l) clwidth(0.5) lcolor(navy) msymbol(O) mcolor(navy) || ///
scatter coef_`Nmid' h    if h != . , connect(l) clwidth(0.5) lcolor(forest_green) msymbol(T) mcolor(forest_green) || ///
scatter coef_`N' h       if h != . , connect(l) clwidth(0.5) lcolor(maroon) msymbol(S) mcolor(maroon) ///
   xtitle("Horizon") xscale(range(-`minh2' 4.5)) xlabel(-`minh'(1)4) ///
   ytitle("Change in income (%)") ///
      legend( on order(1 2 3) cols(1) ///
			  label(1 "Low financial assets (Q1)") ///
			  label(2 "Intermediate financial assets (Q3)") ///
			  label(3 "High financial assets (Q5)") ///
		      region(lcolor(white)) ) ///
   yline(0, lcolor(black) lpattern(dash) ) ///
   xline(0, lcolor(black) lpattern(dash) ) ///
   xsize(8) ysize(6) /// 
   graphregion(color(white) margin(b+`bm')) bgcolor(white) ///
   note("Municipality, income, occupation, age and home-ownership controls") ///
   name(Figure13b, replace) 

* Save plot
graph export "$Folder/Figure13b.pdf", name(Figure13b) replace
  

}



}
*
