function [  ] = DiDLongPlot(Tmax,time,It,Atp1,At,Ztp1,...
                     cIt,cAtp1,cAt,cZtp1,...
                     pIt,pAtp1,pAt,pZtp1)


% Graphical parameters
global date 

DefBlue = [0    0.4470    0.7410];
DefRed = [0.8500    0.3250    0.0980];

xlimi = -0.5 +[0,Tmax] ;
MarkerSize = 8  ;

pa = [ 10 5 1 ] ;

xtlab = {'0','1','2','3','4'} ;
xtpos = [0 1 2 3 4] ;

if ishandle(12)
    close(12)
end

figure(12) ;
nx=4;ny=3;

subplot(nx,ny,1)
I1 = 100 * ( cIt(:,1) ./ cIt(1,1) - 1 ) ;
I2 = 100 * ( cIt(:,2) ./ cIt(1,2) - 1 ) ;
plot(time, I1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, I2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('\% change in income $y_t + s z_t$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1 * min([I1(:);I2(:)]),5])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,4)
A1 = cAtp1(:,1) - cAtp1(1,1) ;
A2 = cAtp1(:,2) - cAtp1(1,2);
plot(time,A1,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, A2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in assets $a_{t+1}-a_1$','interpreter','latex')
xlim(xlimi) 
ylim([1.1*min([A1(:);A2(:)]),0.1])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,7)
Z1 = cZtp1(:,1) - cZtp1(1,1);
Z2 =  cZtp1(:,2) - cZtp1(1,2)  ;
plot(time, Z1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time,Z2,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in location $z_{t+1}-z_1$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1*min([Z1(:);Z2(:)]) ,0.05 ] )
xlabel('Years since shock','interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,10)
plot(time, NaN *time ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, NaN *time,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
leg = legend('Wealth-poor (D1), $s=s_0$','Wealth-rich (D10)',...
             'Location', 'northoutside');
set(leg,'Interpreter','latex')
set(gca,'visible','off')
legend boxoff 



subplot(nx,ny,2)
I1 = 100 * ( pIt(:,1) ./ pIt(1,1) - 1 ) ;
I2 = 100 * ( pIt(:,2) ./ pIt(1,2) - 1 ) ;
plot(time, I1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, I2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('\% change in income $y_t + s z_t$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1 * min([I1(:);I2(:)]),5])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)
legend boxoff 

subplot(nx,ny,5)
A1 = pAtp1(:,1) - pAtp1(1,1) ;
A2 = pAtp1(:,2) - pAtp1(1,2);
plot(time,A1,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, A2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in assets $a_{t+1}-a_1$','interpreter','latex')
xlim(xlimi) 
ylim([1.1*min([A1(:);A2(:)]),0.1])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,8)
Z1 = pZtp1(:,1) - pZtp1(1,1);
Z2 =  pZtp1(:,2) - pZtp1(1,2)  ;
plot(time, Z1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time,Z2,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in location $z_{t+1}-z_1$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1*min([Z1(:);Z2(:)]) ,0.05 ] )
xlabel('Years since shock','interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,11)
plot(time, NaN *time ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, NaN *time,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
leg = legend('Wealth-poor, $a_0 = \underline{a}$','Wealth-rich (D10)',...
             'Location','northoutside');
set(leg,'Interpreter','latex')
set(gca,'visible','off')
legend boxoff 



subplot(nx,ny,3)
I1 = 100 * ( It(:,1) ./ It(1,1) - 1 ) ;
I2 = 100 * ( It(:,2) ./ It(1,2) - 1 ) ;
plot(time, I1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, I2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('\% change in income $y_t + s z_t$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1 * min([I1(:);I2(:)]),5])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,6)
A1 = Atp1(:,1) - Atp1(1,1) ;
A2 = Atp1(:,2) - Atp1(1,2);
plot(time,A1,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, A2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in assets $a_{t+1}-a_1$','interpreter','latex')
xlim(xlimi) 
ylim([1.1*min([A1(:);A2(:)]),0.1])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,9)
Z1 = Ztp1(:,1) - Ztp1(1,1);
Z2 =  Ztp1(:,2) - Ztp1(1,2)  ;
plot(time, Z1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time,Z2,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in location $z_{t+1}-z_1$','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1*min([Z1(:);Z2(:)]) ,0.05 ] )
xlabel('Years since shock','interpreter','latex')
% ylabel('Units = percentage points','interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)

subplot(nx,ny,12)
plot(time, NaN *time ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',2,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, NaN *time,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',2,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
leg = legend('Wealth-poor (D1)','Wealth-rich (D10)',...
             'Location','northoutside');
set(leg,'Interpreter','latex')
set(gca,'visible','off')
legend boxoff 

drawnow

hold off


end

