function [  ] = DiDPlot( Tmax,Anorm,time,It,At,Zt,lege)


global date

% Graphical parameters

DefBlue = [0    0.4470    0.7410];
DefRed = [0.8500    0.3250    0.0980];

lw = 3 ; 
ms = 3 ;
width = 1.25 ; 
height = 1.4 ;
pbscale = 1.5 ;
pbscale2 = 0.7 ;

xlimi = -0.5 +[0,Tmax] ;
MarkerSize = 8  ;

pa = [ 4 1.5 3 ] ;

xtlab = {'0','1','2','3','4'} ;
xtpos = [0 1 2 3 4] ;

fontsize = 18 ;
factor = 0.7 ;

if ishandle(4)
    close(4)
end

figure('visible','on','Pos',[200,200,1000,350]);
nx=2;ny=3;

I1 = 100 * ( It(:,1) ./ It(1,1) - 1 ) ;
I2 = 100 * ( It(:,2) ./ It(1,2) - 1 ) ;
s1 = subplot(nx,ny,1) ;
s1pos = get(s1,'Pos') ; set(s1,'Pos',s1pos .* [0.5,0.5,width,height]);
plot(time, I1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',lw,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, I2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',lw,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
hold on
title('Percent change in income $y_t + s z_t$','interpreter','latex','Fontsize',fontsize)
xlabel('Years since shock','interpreter','latex')
xlim(xlimi)  
ylim([ 1.1 * min([I1(:);I2(:)]),3.7])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)
leg = legend(['Q1' lege],'Q5',...
             'Location','SouthEast');
set(leg,'Interpreter','latex')
set(leg,'FontSize',factor*fontsize)
legend boxoff 
AxisFonts(factor*fontsize,fontsize,factor*fontsize,fontsize)
pbaspect([pbscale pbscale2 1])


A1 = At(:,1) - At(1,1) ;
A2 = At(:,2) - At(1,2);
s2 = subplot(nx,ny,2) ;
s2pos = get(s2,'Pos') ; set(s2,'Pos',s2pos .* [0.9,0.5,width,height]);
plot(time,A1,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',lw,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time, A2 ,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',lw,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in assets $a_{t+1}-a_1$','interpreter','latex','Fontsize',fontsize)
xlabel('Years since shock','interpreter','latex')
xlim(xlimi) 
ylim([1.1*min([A1(:);A2(:)]),0.06])
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)
AxisFonts(factor*fontsize,fontsize,factor*fontsize,fontsize)
pbaspect([pbscale pbscale2 1])



Z1 = Zt(:,1) - Zt(1,1);
Z2 =  Zt(:,2) - Zt(1,2)  ;
s3 = subplot(nx,ny,3) ;
s3pos = get(s3,'Pos') ; set(s3,'Pos',s3pos .* [0.98,0.5,width,height]);
plot(time, Z1 ,'-o','MarkerSize',MarkerSize,'Color',DefBlue,'LineWidth',lw,'MarkerEdgeColor',DefBlue,'MarkerFaceColor',DefBlue)
hold on
plot(time,Z2,'--s','MarkerSize',MarkerSize,'Color',DefRed,'LineWidth',lw,'MarkerEdgeColor',DefRed,'MarkerFaceColor',DefRed)
title('Change in location $z_{t+1}-z_1$','interpreter','latex','Fontsize',fontsize)
xlim(xlimi)  
ylim([ 1.1*min([Z1(:);Z2(:)]) ,0.02 ] )
xlabel('Years since shock','interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
grid on
pbaspect(pa)
xticklabels(xtlab)
xticks(xtpos)
AxisFonts(factor*fontsize,fontsize,factor*fontsize,fontsize)
pbaspect([pbscale pbscale2 1])

drawnow

hold off


end

