function [ fMass , fDensity , Trans ] = Distribution( s , q , Dq , aP , zP )

% Computes the population distribution across locations

% Globals
global Ty a z Na Nz Ny amin da dz

tic;
start = toc;

% Find index of unconstrained izU
[ ~ , ~ , iZUBot , iZUTop , fracZU ] = ZU( s , q , Dq ) ;

% Get indices and fractions of policy function
[iaBot,iaTop,~,~,afrac] = Brackets2fast(a,reshape(aP,Na*Nz*Ny,1),Na,1,Na*Nz*Ny);

% Compute indices of location policy on new grid
[izBot,izTop,~,~,zfrac] = Brackets2fast(z,reshape(zP,Na*Nz*Ny,1),Nz,1,Na*Nz*Ny);

% Compute constrained
zfrac(zfrac==Inf | zfrac==-Inf) = 0;

% Income transitions
TyM = kron(Ty,ones(Na*Nz,1)); 

vBotBot = repmat(iaBot + Na*(izBot-1),1,Ny) + Na*Nz*(0:(Ny-1)) ;
vBotTop = repmat(iaBot + Na*(izTop-1),1,Ny) + Na*Nz*(0:(Ny-1)) ;
vTopBot = repmat(iaTop + Na*(izBot-1),1,Ny) + Na*Nz*(0:(Ny-1)) ;
vTopTop = repmat(iaTop + Na*(izTop-1),1,Ny) + Na*Nz*(0:(Ny-1)) ;

wBotBot = repmat( (1-afrac).*(1-zfrac) , 1,Ny) .* TyM ;
wBotTop = repmat( (1-afrac).* zfrac    , 1,Ny) .* TyM ;
wTopBot = repmat(  afrac   .*(1-zfrac) , 1,Ny) .* TyM ;
wTopTop = repmat(  afrac   .* zfrac    , 1,Ny) .* TyM ;

M = spalloc(Na*Nz*Ny,Na*Nz*Ny,Ny*Na*Nz*Ny);
for iy=1:Ny
    M = M ...
        + sparse(1:(Na*Nz*Ny),vBotBot(:,iy),wBotBot(:,iy),Na*Nz*Ny,Na*Nz*Ny) ...
        + sparse(1:(Na*Nz*Ny),vBotTop(:,iy),wBotTop(:,iy),Na*Nz*Ny,Na*Nz*Ny) ...
        + sparse(1:(Na*Nz*Ny),vTopBot(:,iy),wTopBot(:,iy),Na*Nz*Ny,Na*Nz*Ny) ...
        + sparse(1:(Na*Nz*Ny),vTopTop(:,iy),wTopTop(:,iy),Na*Nz*Ny,Na*Nz*Ny) ;       
end

% Transition matrix
Trans = M' ;

% Matrix to invert to find invariant distribution
N = speye(Na*Nz*Ny) - Trans ;

% Right-hand-side of system
rhs = zeros(Na*Nz*Ny,1);

% Normalize one value
in  = 1 + Na*(iZUBot-1) ;                               
rhs(in) = 0.1;
N(in,:) = [zeros(1,in-1) , 1 , zeros(1,Na*Nz*Ny-in)];

% Compute distribution
fMassStack = max( N\rhs , 0 ) ;
fMassStack = fMassStack/(sum(fMassStack));

fMass = reshape(fMassStack,Na,Nz,Ny);
fDensity = fMass./repmat(da*(dz'),1,1,Ny);

end

