
set(groot,'defaultAxesTickLabelInterpreter','latex');  
set(groot,'defaulttextinterpreter','latex');
set(groot,'defaultLegendInterpreter','latex');
    
figure('visible','on','Pos',[200,200,900,300]);
nx = 1 ; ny = 3 ;

sgtitle([ 'Location changes: ' shocks ' preference shocks'], 'Interpreter', 'LaTeX')

subplot(nx,ny,1)
plot(z,pi_low,'LineWidth',2,'Color','r')
hold on
plot(z,pi_low_new,'LineWidth',2,'Color','r','LineStyle','--')
hold on
plot(z,pi_med,'LineWidth',2,'Color','b')
hold on
plot(z,pi_med_new,'LineWidth',2,'Color','b','LineStyle','--')
hold on
plot(z,pi_high,'LineWidth',2,'Color','m')
hold on
plot(z,pi_high_new,'LineWidth',2,'Color','m','LineStyle','--')
hold on
ylabel('Population','interpreter','latex')
xlabel('$z_0$','interpreter','latex')
legend('Pop., init., poor','Pop., final, poor','Pop., init., medium','Pop., final, medium','Pop., init., rich','Pop., final, rich','Interpreter','latex')
title('Population distributions before and after shock','interpreter','latex')
hold off

subplot(nx,ny,2)
plot(z,dzLowCond,'LineWidth',2,'Color','r')
hold on
plot(z,dzMedCond,'LineWidth',2,'Color','b')
hold on
plot(z,dzHighCond,'LineWidth',2,'Color','m')
hold on
ylabel('$z_1-z_0$','interpreter','latex')
xlabel('$z_0$','interpreter','latex')
yline(0,'k:','LineWidth',1.5)
legend(['Mean poor = ' num2str(dzLow,2)],['Mean medium = ' num2str(dzMed,2)],['Mean rich = ' num2str(dzHigh,2)],'Interpreter','latex')
title('Simple diff: location downgrading','interpreter','latex')
hold off

subplot(nx,ny,3)
plot(z,dzLowCond-dzHighCond,'LineWidth',2,'Color','r')
hold on
plot(z,dzMedCond-dzHighCond,'LineWidth',2,'Color','b')
hold on
ylabel('Relative $z_1-z_0$','interpreter','latex')
xlabel('$z_0$','interpreter','latex')
yline(0,'k:','LineWidth',1.5)
legend([ 'Mean poor-rich = ' num2str(ddzMean,2) ] ,[ 'Mean medium-rich = ' num2str(ddzMeanMed,2) ] ,'Interpreter','latex')
title('Diff-in-diff: location downgrading relative to rich','interpreter','latex')
hold off

hold off

    