function [ cP , aP , zP , qP , ...
           iaBot , iaTop, afrac , ...
           izBot , izTop, zfrac ] ...
           = Policies( s , q , qStack , Dq , DqStack , cP )

% Computes individual policy functions

% Globals
global gamma Na Nz Ny a z zmin zmax tol R beta amin TyTranspose
global aStack yStack zStack smoothP y

% Compute optimal unconstrained location
[ zU , qU , izUBot , izUTop , fraczU ] = ZU( s , q , Dq ) ;
fraczUrep = fraczU*ones(Na,Ny);

disp([ 'zU = ' num2str(zU) ])

% Initialization
aP = zeros(Na*Nz*Ny,1);
zP = zeros(Na*Nz*Ny,1);
qP = qU*ones(Na*Nz*Ny,1);

error = 1;
it=1;

while (error > tol)
    
    %%% 1. Asset policy function for unconstrained individuals
    
    % Clean
    cPold = cP(:) ;
    cP = real(cP) ;
    cP = max( cP , 0.00001 * y(1) ) ;
    
    % RHS of Euler equation
    EuPrimeSquare = beta*R*(cP.^(-gamma))*TyTranspose;
    EuPrime = reshape(EuPrimeSquare,Na*Nz*Ny,1);
    
    % Invert Euler equation to recover current consumption c_t as a
    % function of future assets a_{t+1} and location z_{t+1}
    cPInt = EuPrime.^(-1/gamma);
    cPSquare = reshape(cPInt,Na,Nz,Ny) ;
        
    % Consumption today at unconstrained location choice tomorrow c_t(a_{t+1},z_{t+1}=Z^U)
    cPIntzU = reshape( ...
                   kron(    (1-fraczUrep).* squeeze(cPSquare(:,izUBot,:)) ... 
                          +    fraczUrep .* squeeze(cPSquare(:,izUTop,:)) , ...
                         ones(1,Nz) ) , ...
                      Na*Nz*Ny,1 );
                  
    % Recover initial assets a_t as a function of future assets a_{t+1} on
    % grid, assuming that the individual is at her unconstrained location,
    % using the budget constraint
    aSol =   (aStack   + cPIntzU   + qU  - yStack   - s*zStack )/R ;
    
    % Interpolate asset grid a on a_t 
    [iaBot,iaTop,iaBotStack,iaTopStack,afrac] = Brackets2fast(aSol,a,Na,Ny*Nz,Na);
    
    % Interpolate consumption policy function c(a_t,z_{t+1}=z^U)
    cPNew = (1-afrac).*cPIntzU(iaBotStack) + afrac.*cPIntzU(iaTopStack);
    
    % Update asset policy function from budget constraint
    aPNew = R*aStack + yStack + s*zStack - qU - cPNew ;
    
    % Compute constrained states in terms of (a_t,z_t , z_{t+1}=Z^U)
    Constrained = aPNew < amin;
    aPNew = max(aPNew,amin);
    
    
    %%% 2. Location policy function, for constrained individuals
    
    % Recover consumption c_t(a_{t+1},z_{t+1}) from mobility EE
    cInt2 = (R*DqStack./(s*EuPrime)).^(1/gamma) ;
        
    % Keep as a function of (a_{t+1},z_{t+1}).
    % DO NOT project as a function of (a_t,z_{t+1}) because below we evaluate at a_{t+1} = amin
    cPSquare = max( reshape(cInt2,Na,Nz,Ny) , 0.001 * y(1) ) ; 
    
    % Impose that we pick consumption of constrained only c_t(a_{t+1} = c(amin,z_{t+1})
    cIntCons = reshape( ...
                        kron(   reshape(squeeze( cPSquare(1,:,:) ) , 1 , Nz*Ny ) ...
                        , ones(Na,1) ) ...
                        , Na*Nz*Ny , 1 ) ;
    zSol = max( 1/s*( amin - R*aStack + qStack - yStack + cIntCons ) , z(1) ) ;
        
    % Interpolate z grid on z_t
        % We first need to change the order of indices to use the Brackets2sort function 
    zSolReshuffle = reshape(permute(reshape(zSol,Na,Nz,Ny),[2 1 3]),Nz*Na*Ny,1);
    
    [izBot,izTop,~,~,zfrac] = Brackets2fast(zSolReshuffle,z,Nz,Na*Ny,Nz);
            
    zPReshuffle = (1-zfrac).*z(izBot)+ zfrac.*z(izTop);
    qPReshuffle = (1-zfrac).*q(izBot)+ zfrac.*q(izTop);
     
    zPNew = reshape(permute(reshape(zPReshuffle,Nz,Na,Ny),[2,1,3]),Na*Nz*Ny,1);
    qP    = reshape(permute(reshape(qPReshuffle,Nz,Na,Ny),[2,1,3]),Na*Nz*Ny,1);
    zfrac = reshape(permute(reshape(zfrac,Nz,Na,Ny),[2,1,3]),Na*Nz*Ny,1);
    
    % Update location and rent policy function for unconstrained individuals
    zPNew(~Constrained) = zU ;
    qP(~Constrained) = qU ;
    zPNew = max(min(zPNew,z(Nz)),zmin);
    qP = max(q(1),min(qP,q(Nz)));
         
    % Update consumption for constrained individuals
    cPNew(Constrained) = R*aStack(Constrained)-amin + yStack(Constrained) + s*zStack(Constrained) - qP(Constrained);
    
    % Errors
    errorc = max(abs(cPNew-cPold));
    errora = max(abs(aPNew-aP));
    errorz = max(abs(zPNew-zP));
    error = max([errora,errorz,errorc]);
    
    % Update policy functions and consumption
    aP = aPNew ;
    zP = zPNew ;    
    cP = (1-smoothP)*cPNew + smoothP*reshape(cP,Na*Nz*Ny,1);
    
    cP = reshape(cP,Na*Nz,Ny);
    
    if mod(it,200)==0
        disp([num2str(it,2) ' ; errora = ' num2str(errora,2) ' ; errorz = ' num2str(errorz,2)])
    end
    it = it+1;
     
end

cP = reshape(cP,Na,Nz,Ny);
aP = reshape(aP,Na,Nz,Ny);
zP = reshape(zP,Na,Nz,Ny);
qP = reshape(qP,Na,Nz,Ny);

end

