function [ cPFL , aPFL , iaBotFL , iaTopFL , fracFL  ] ...
           = PoliciesFL( s , cPFL , zFL , qFL)

% Computes individual policy functions in the absence of the location asset
% "Fixed Location"
       
% Globals
global gamma Na Ny tol R beta amin TyTranspose a aStackFL yStackFL y smoothP

% Initialization
aPFL = zeros(Na*Ny,1);
error = 1;
it = 1;

while  (error > tol)
    
    % Clean
    cPFLold = cPFL(:) ;
    cPFL = real(cPFL) ;
    cPFL = max( cPFL , 1e-10 * y(1) ) ;
    
    % RHS of Euler equation
    EuPrimeSquare = beta*R*(cPFL.^(-gamma))*TyTranspose;
    EuPrime = reshape(EuPrimeSquare,Na*Ny,1);
    
    % Invert Euler equation to recover current consumption c_t as a
    % function of future assets a_{t+1}
    cPFL = EuPrime.^(-1/gamma);
    
    % Recover initial assets a_t as a function of future assets a_{t+1} on
    % grid, with the individual is at her unconstrained location
    aSolFL = ( aStackFL + cPFL + qFL - yStackFL - s*zFL )/R ;
    
    % Interpolate asset grid a on a_t
    [iaBotFL,iaTopFL,iaBotStackFL,iaTopStackFL,fracFL] = Brackets2fast(aSolFL,a,Na,Ny,Na);
        
    % Interpolate consumption function
    cPNewFL = (1-fracFL).*cPFL(iaBotStackFL) + fracFL.*cPFL(iaTopStackFL);
    
    % Compute constrained states
    aPNewFL = R*aStackFL + yStackFL + s*zFL - qFL - cPNewFL ;
    ConstrainedFL = aPNewFL < amin;
    
    % Update asset policy function
    aPNewFL(ConstrainedFL) = amin ;
    
    % Update consumption for constrained individuals
    cPNewFL = R*aStackFL- aPNewFL + yStackFL + s*zFL - qFL;

    % Compute error
    errora = max(abs(aPNewFL - aPFL));
    errorc = max(abs(cPNewFL - cPFLold));
    error = max(errora,errorc) ;
    
    % Update policy functions
    aPFL = aPNewFL;
    cPFL = (1-smoothP) * cPNewFL + smoothP * cPFL ; 
    cPFL = reshape(cPFL,Na,Ny);
    it = it+1;
   
        
end

cPFL = reshape(cPFL,Na,Ny);
aPFL = reshape(aPFL,Na,Ny);


end

