function [ At,Zt,SZt,Yt,It,Ct,qt ] = ...
         TimeSeries_v2(Trans,TransFL,cMat,cPFL,q,Dq,T1,T2,a0,isRef)

global z y Na Nz Ny a Ty S

NQ = 2 ;

T = 1 + T1 + T2 ;

sRef = S(isRef) ;

% Income states

    % Pre-shock
    iy0 = 2 ;
    
    % Shock
    iy1 = 1 ;

    % Post-shock
    iy2 = 2 ;


% Initialize distribution and time series
f   = zeros(Na*Nz,T,2) ;

At  = zeros(T,2);
Zt  = zeros(T,2);
SZt = zeros(T,2);
Yt  = zeros(T,2);
yt  = zeros(T,2);
It  = zeros(T,2);
Mt  = zeros(T,2);
Ct  = zeros(T,2);
qt  = zeros(T,2);


[ ~ , ~ , iBot , iTop , fracZ ] = ZU( sRef , q , Dq ) ;

[~,~,iaBot,iaTop,fraca] = Brackets2fast(a,a0,Na,1,1);

% Useful arrays for later
assets      = repmat(a,1,Nz) ;
locations   = permute(repmat(z,1,Na),[2 1]) ;
houseprices = permute(repmat(q,1,Na),[2 1]) ;

% Extract transition matrices conditional on y from Distribution.m
trans = cell(Ny,1) ;
transFL = cell(Ny,1) ;

for j=1:Ny

    startj = (j-1)*Na*Nz + 1 ;
    endj   = j*Na*Nz ;

    TT = full(Trans{isRef});
    trans{j} = TT(startj:endj,startj:endj) / Ty(j,j) ;

    TTFL = full(TransFL);

    transFL{j} = TTFL(startj:endj,startj:endj) / Ty(j,j) ;

end

cP = cMat(:,:,:,isRef);

for t=1:T

    % Income state

    if t == 1
        Yt(t) = y(iy0);
        yt(t) = iy0;
    elseif t < 1+T1        
        Yt(t) = y(iy1);
        yt(t) = iy1;
    else
        Yt(t) = y(iy2);
        yt(t) = iy2;
    end

    % INITIAL DISTRIBUTION FOR s=S(is) ... sparse(reshape(f0{iq},Na*Nz*Ny)) ;
    if t == 1

        % Slice distribution at iz and iy0(iq)
        f0 = zeros(Na,Nz) ;
        f0(iaBot,iBot) = (1-fracZ)*(1-fraca) ;
        f0(iaBot,iTop) =    fracZ *(1-fraca) ;
        f0(iaTop,iBot) = (1-fracZ)*  fraca ;
        f0(iaTop,iBot) =   fracZ  *  fraca ;

        f(:,1,1) = reshape( f0 , Na*Nz , 1 ) ;
        f(:,1,2) = reshape( f0 , Na*Nz , 1 ) ;

    % OTHER PERIODS     
    else

    f(:,t,1) = trans{yt(t)}   * f(:,t-1,1) ;
    f(:,t,2) = transFL{yt(t)} * f(:,t-1,2) ;

    end
end

    
% Compute paths from distribution
for i=1:2
    
    distrib0 = f(:,1,i) ;
    mass0 = sum( distrib0(:) ) ;
    
    for t=1:T

        distrib = reshape(f(:,t,i),Na,Nz) / mass0 ;
        
        At(t,i)  = sum( distrib(:) .* assets(:) ) ;
        Zt(t,i)  = sum( distrib(:) .* locations(:) ) ;
        SZt(t,i) = S(isRef) * sum( distrib(:) .* locations(:) ) ;
        It(t,i)  = Yt(t) +  SZt(t,i) ;
        qt(t,i)  = sum( distrib(:) .* houseprices(:) ) ;
        Mt(t,i)  = sum( distrib(:) ) ;
        
        if i == 1
            Ct(t,i)  = sum( distrib(:) .* reshape(cP(:,:,yt(t)),Na*Nz,1) ) ;
        elseif i == 2
            Ct(t,i)  = sum( distrib(:) .* reshape(cPFL(:,:,yt(t)),Na*Nz,1) ) ;
        end
               
    end

end

end


