function [ At,Atp1,Ztp1,SZt,It,...
           cAt,cAtp1,cZtp1,cSZt,cIt,...
           pAt,pAtp1,pZtp1,pSZt,pIt,...
           Yt ] = ...
         TimeSeriesDiD_v5(fMat,zMat,aMat,Trans,T1,T2,Q1,Q5,iz,isRef)

global z y Na Nz Ny Ns a S Ty

NQ = 2 ;

T = 1 + T1 + T2 ;
 
% Income states

    % Pre-shock
    if Ny == 3
        iy0 = [ 2 ; 3 ] ;
    elseif Ny == 2
        iy0 = [ 2 ; 2 ] ;
    end
        
    
    % Shock
    if Ny == 3
        iy1 = [ 1 ; 2 ] ;
    elseif Ny == 2
        iy1 = [ 1 ; 1 ] ;
    end
    
    % Post-shock
    if Ny == 3
        iy2 = [ 2 ; 3 ] ;
    elseif Ny == 2
        iy2 = [ 2 ; 2 ] ;
    end


% Initialize distribution and time series
f = zeros(Na*Nz,Ns,T,NQ) ;
g = zeros(Na*Nz,T,NQ) ;
h = zeros(Na*Nz,Ns,T,NQ) ;

At  = zeros(T,NQ);
Atp1  = zeros(T,NQ);
Ztp1  = zeros(T,NQ);
SZt = zeros(T,NQ);
Yt  = zeros(T,NQ);
yt  = zeros(T,NQ);
It  = zeros(T,NQ);

cAt  = zeros(T,NQ);
cAtp1  = zeros(T,NQ);
cZtp1  = zeros(T,NQ);
cSZt = zeros(T,NQ);
cIt  = zeros(T,NQ);

pAt  = zeros(T,NQ);
pAtp1  = zeros(T,NQ);
pZtp1  = zeros(T,NQ);
pSZt = zeros(T,NQ);
pIt  = zeros(T,NQ);

% Useful arrays for later
assets    = repmat(a,1,Nz,Ns) ;
locations = permute(repmat(z,1,Na,Ns),[2 1 3]) ;
skills    = permute(repmat(S,1,Na,Nz),[2 3 1]) ;

cassets    = repmat(a,1,Nz) ;
clocations = permute(repmat(z,1,Na),[2 1 3]) ;

% Indicators for assets in Q1 and Q5
aQ = zeros(Na,NQ) ;
aQ(:,1) = ismember(1:Na,Q1) ;
aQ(:,2) = ismember(1:Na,Q5) ;

paQ = aQ ;
paQ(:,1) = zeros(Na,1);
paQ(1,1) = 1;

% Loop
for is = 1:Ns
    
    % Extract transition matrices conditional on y from Distribution.m
    trans = cell(Ny,1) ;
    for j=1:Ny
        
        startj = (j-1)*Na*Nz + 1 ;
        endj   = j*Na*Nz ;
        
        TT = full(Trans{is});
        
        trans{j} = TT(startj:endj,startj:endj) / Ty(j,j) ;
        
    end

    for t=1:T
                
        for iq=1:NQ
            
            % Income state
        
            if t == 1
                Yt(t,iq) = y(iy0(iq));
                yt(t,iq) = iy0(iq);
            elseif t < 1+T1        
                Yt(t,iq) = y(iy1(iq));
                yt(t,iq) = iy1(iq);
            else
                Yt(t,iq) = y(iy2(iq));
                yt(t,iq) = iy2(iq);
            end

            % INITIAL DISTRIBUTION FOR s=S(is) ... sparse(reshape(f0{iq},Na*Nz*Ny)) ;
            if t == 1
                
                % Slice distribution at zMat = z(iz) and iy0(iq)
                IsInLoc = ( 0.99 * z(iz) <= zMat(:,:,iy0(iq),is) ) ...
                       .* ( 1.01 * z(iz) >  zMat(:,:,iy0(iq),is) ) ;
                
                f0 = repmat( aQ(:,iq) , 1 , Nz ) ...
                   .* IsInLoc ...
                   .* fMat(:,:,iy0(iq),is) ;
                
                h0 = repmat( paQ(:,iq) , 1 , Nz ) ...
                   .* IsInLoc ...
                   .* fMat(:,:,iy0(iq),is) ;
               
                f(:,is,1,iq) = reshape( f0 , Na*Nz , 1 ) ;
                h(:,is,1,iq) = reshape( h0 , Na*Nz , 1 ) ;
                
                if is == isRef
                    g0 = repmat( aQ(:,iq) , 1 , Nz ) ...
                       .* IsInLoc ...
                       .* fMat(:,:,iy0(iq),isRef) ;

                    g(:,1,iq) = reshape( g0 , Na*Nz , 1 ) ;
                    
                end
                
            % OTHER PERIODS     
            else
                
            f(:,is,t,iq) = trans{yt(t-1)} * f(:,is,t-1,iq) ;
            h(:,is,t,iq) = trans{yt(t-1)} * h(:,is,t-1,iq) ;
            
            if is == isRef
                g(:,t,iq) = trans{yt(t-1)} * g(:,t-1,iq) ;
            end
            
            end
        end
    end

    
    % Compute paths from distribution
    for iq=1:NQ

        massh = sum(sum(h(:,:,1,iq))) ;
        massf = sum(sum(f(:,:,1,iq))) ;
        massg = sum(sum(g(:,1,iq))) ;

        for t=1:T

            % conditional on z

            distrib = reshape(f(:,:,t,iq),Na,Nz,Ns) / massf ;
            zmaty = squeeze(squeeze(squeeze(zMat(:,:,yt(t),:)))) ;
            amaty = squeeze(squeeze(squeeze(aMat(:,:,yt(t),:)))) ;

            At(t,iq)    = sum( distrib(:) .* assets(:) ) ;
            Atp1(t,iq)  = sum( distrib(:) .* amaty(:) ) ;
            Ztp1(t,iq)  = sum( distrib(:) .* zmaty(:) ) ;
            SZt(t,iq)   = sum( distrib(:) .* locations(:) .* skills(:) ) ;

            % conditional on (s,z)

            distrib = reshape(g(:,t,iq),Na,Nz) / massg ;
            zmaty = squeeze(squeeze(squeeze(zMat(:,:,yt(t),isRef)))) ;
            amaty = squeeze(squeeze(squeeze(aMat(:,:,yt(t),isRef)))) ;

            cAt(t,iq)    = sum( distrib(:) .* cassets(:) ) ;
            cAtp1(t,iq)  = sum( distrib(:) .* amaty(:) ) ;
            cZtp1(t,iq)  = sum( distrib(:) .* zmaty(:) ) ;
            cSZt(t,iq)   = S(isRef) * sum( distrib(:) .* clocations(:) ) ;

            % conditional on (abar,z)

            distrib = reshape(h(:,:,t,iq),Na,Nz,Ns) / massh ;
            zmaty = squeeze(squeeze(squeeze(zMat(:,:,yt(t),:)))) ;
            amaty = squeeze(squeeze(squeeze(aMat(:,:,yt(t),:)))) ;

            pAt(t,iq)    = sum( distrib(:) .* assets(:) ) ;
            pAtp1(t,iq)  = sum( distrib(:) .* amaty(:) ) ;
            pZtp1(t,iq)  = sum( distrib(:) .* zmaty(:) ) ;
            pSZt(t,iq)   = sum( distrib(:) .* locations(:) .* skills(:) ) ;

        end

    It(:,iq)   = Yt(:,iq) +   SZt(:,iq) ;
    cIt(:,iq)  = Yt(:,iq) +  cSZt(:,iq) ;
    pIt(:,iq)  = Yt(:,iq) +  pSZt(:,iq) ;

    % Zt(:,iq) = [ Zt(2:end,iq) ; Zt(end,iq) ] ;
    % At(:,iq) = [ At(2:end,iq) ; At(end,iq) ] ;

    end

end

