function [ ] = TimeSeriesPlot(s,At,AtFL,Ct,CtFL,Zt,Yt,qt,qU,zU,T1,T,time,Anorm)

global y Ny amin date

DefBlue = [0    0.4470    0.7410];
DefRed = [0.8500    0.3250    0.0980];
DefYellow = [0.9290    0.6940    0.1250];

if ishandle(3)
    close(3)
end

linewidth = 0.75;
linestyle = '--';
firstshockcolor = DefYellow;
secondshockcolor = DefYellow;
constraintcolor = DefBlue;
constraintstyle = '-.';
constraintcolorFL = DefRed;
constraintstyleFL = '-.';
icons = find(At<=amin+0.01); icons = icons(1)-1;
iconsFL = find(AtFL<=amin+0.01); iconsFL = iconsFL(1)-1;
tcons = time(icons);
tconsFL = time(iconsFL);

MarkerInterval = 1;

time0 = time(1:end-1) - 1 ;

tshock1 = 1 ;
tshock2 = time(T1);

argZ = 1:T ;
argAll = 1:T ;

pbscale = 2 ; 
lwblue = 3 ; 
lwred = 1 ; 
msblue = 6 ; 
msred = 8 ;

width=1;
height=1;

figure('visible','on','Pos',[200,200,800,400]);

nx=2;ny=2;

s1 = subplot(nx,ny,1) ;
s1pos = get(s1,'Pos') ; set(s1,'Pos',s1pos .* [1,1,width,height]);

plot(time0,Yt(argAll),'-o','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msblue,'Color',DefBlue,'LineWidth',lwblue)
hold on
plot(time0,Yt(argAll),'--s','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msred,'Color',DefRed,'LineWidth',lwred)
xlim([-1,time(T)])
ylim([0.9*y(1),1.1*y(Ny)])
xlabel('Time','interpreter','latex')
yL = get(gca,'YLim');
set(gca,'TickLabelInterpreter','latex')
line([tshock1 tshock1],yL,'Color',firstshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tshock2 tshock2],yL,'Color',secondshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tcons tcons],yL,'Color',constraintcolor,'LineStyle',constraintstyle,'LineWidth',linewidth);
line([tconsFL tconsFL],yL,'Color',constraintcolorFL,'LineStyle',constraintstyleFL,'LineWidth',linewidth);
title('Income $y_t$','interpreter','latex','FontSize',16)
leg = legend('With location asset','Without location asset',...
             'Location','SouthEast');
set(leg,'Interpreter','latex')
grid on
pbaspect([pbscale 1 1])


subplot(nx,ny,2)
plot(time0,At(argAll,1),'-o','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msblue,'Color',DefBlue,'LineWidth',lwblue)
hold on
plot(time0,AtFL(argAll),'--s','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msred,'Color',DefRed,'LineWidth',lwred)
title('Financial assets $a_t$','interpreter','latex','FontSize',16)
xlabel('Time','interpreter','latex')
xlim([-1,time(T)])
ylim( [amin-0.025 , max([At/Anorm;AtFL/Anorm]) + 0.025 ] )
yL = get(gca,'YLim');
set(gca,'TickLabelInterpreter','latex')
line([tshock1 tshock1],yL,'Color',firstshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tshock2 tshock2 ],yL,'Color',secondshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tcons tcons],yL,'Color',constraintcolor,'LineStyle',constraintstyle,'LineWidth',linewidth);
line([tconsFL tconsFL],yL,'Color',constraintcolorFL,'LineStyle',constraintstyleFL,'LineWidth',linewidth);
grid on
pbaspect([pbscale 1 1])

subplot(nx,ny,3)
plot(time0,Zt(argZ),'-o','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msblue,'Color',DefBlue,'LineWidth',lwblue)
hold on
plot(time0,zU*ones(T,1),'--s','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msred,'Color',DefRed,'LineWidth',lwred)
title('Location $z_{t+1}$','interpreter','latex','FontSize',16)
xlabel('Time','interpreter','latex')
xlim([-1,time(T)])
ylim( [ min(Zt)-0.025 , max(Zt)+0.025 ] )
yL = get(gca,'YLim');
set(gca,'TickLabelInterpreter','latex')
line([tshock1 tshock1],yL,'Color',firstshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tshock2 tshock2 ],yL,'Color',secondshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tcons tcons],yL,'Color',constraintcolor,'LineStyle',constraintstyle,'LineWidth',linewidth);
line([tconsFL tconsFL],yL,'Color',constraintcolorFL,'LineStyle',constraintstyleFL,'LineWidth',linewidth);
grid on
pbaspect([pbscale 1 1])

subplot(nx,ny,4)
plot(time0,Ct(argAll),'-o','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msblue,'Color',DefBlue,'LineWidth',lwblue)
hold on
plot(time0,CtFL(argAll),'--s','MarkerIndices',1:MarkerInterval:length(time),'MarkerSize',msred,'Color',DefRed,'LineWidth',lwred)
xlim([-1,time(T)])
ylim( [ min(min(Ct),min(CtFL))-0.015 , max(max(Ct),max(CtFL)) + 0.015 ] )
xlabel('Time','interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
title('Consumption $c_t$','interpreter','latex','FontSize',16)
yL = get(gca,'YLim');
line([tshock1 tshock1],yL,'Color',firstshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tshock2 tshock2 ],yL,'Color',secondshockcolor,'LineStyle',linestyle,'LineWidth',linewidth);
line([tcons tcons],yL,'Color',constraintcolor,'LineStyle',constraintstyle,'LineWidth',linewidth);
line([tconsFL tconsFL],yL,'Color',constraintcolorFL,'LineStyle',constraintstyleFL,'LineWidth',linewidth);
grid on
pbaspect([pbscale 1 1])

drawnow
hold off


end

