function [ cFL,c,czU,VFL,V,VzU ] = ValueFunctions(aPFL,cPFL,aP,cP,zP,s,q,Dq)

% Computes value functions from policy functions

% Globals
global a z y Na Nz Ny tol
global aStack yStack
global beta gamma TyTranspose

% Unconstrained location
[ ~ , ~ , izUBot , izUTop , fraczU ] = ZU( s , q , Dq ) ;

% Utility and value function at fixed consumption
u = @(c) ( c.^(1-gamma) - 1 ) / (1-gamma) ;
v = @(V) ( 1 + (1-beta) * (1-gamma) * V ).^(1/(1-gamma));


%% Value function without location asset

% Initialize
V0 = u(cPFL) / (1 - beta) ;
VStack = V0;
cStack = reshape(cPFL,Na*Ny,1) ;

iy = (0:(Ny-1))' ;

[iaFLBot,iaFLTop,~,~,aFLfrac] = Brackets2fast(a ,reshape(aPFL,Na*Ny,1),Na,1,Na*Ny);
iaFLBotStack = iaFLBot + kron(iy,ones(Na,1)) * Na ;
iaFLTopStack = iaFLTop + kron(iy,ones(Na,1)) * Na ;

% Loop
error = 1;
while error>tol
    
    % Compute E[V_{t+1}](a_{t+1},y_t)
    EV = reshape((reshape(VStack,Na,Ny)*TyTranspose),Na *Ny,1) ;

    % Compute E[V_{t+1}](a_{t+1}(a_t,y_t),y_t)    
    EV = (1-aFLfrac)  .* EV(iaFLBotStack) ...
       +   aFLfrac    .* EV(iaFLTopStack) ;
                      
    % Update
    VNew = u(cStack) + beta*EV;
    
    error = max(abs(VNew(:)-VStack(:)));
    VStack = VNew;
                            
end
VFL = reshape(VStack,Na ,Ny);

% Compute permanent consumption-equivalent
cFL = v(VFL) ;


%% Value function with location asset

% Initialize
V0 = u(cP) / (1 - beta) ;
VStack = V0;
cStack = reshape(cP,Na*Nz*Ny,1) ;

[iaBot,iaTop,~,~,afrac] = Brackets2fast(a,reshape(aP,Na*Nz*Ny,1),Na,1,Na*Nz*Ny);
[izBot,izTop,~,~,zfrac] = Brackets2fast(z,reshape(zP,Na*Nz*Ny,1),Nz,1,Na*Nz*Ny);

% Construct indices in matrix form
iBotBot = iaBot + (izBot-1)*Na + kron(iy,ones(Na*Nz,1)) * Na * Nz;
iBotTop = iaBot + (izTop-1)*Na + kron(iy,ones(Na*Nz,1)) * Na * Nz;
iTopBot = iaTop + (izBot-1)*Na + kron(iy,ones(Na*Nz,1)) * Na * Nz;
iTopTop = iaTop + (izTop-1)*Na + kron(iy,ones(Na*Nz,1)) * Na * Nz;

% Loop 
error = 1;
while error>tol
        
    % Compute E[V_{t+1}](a_{t+1},,z_{t+1},y_t)
    EV = reshape((reshape(VStack,Na*Nz,Ny)*TyTranspose),Na*Nz*Ny,1) ;

    % Compute E[V_{t+1}](a_{t+1}(a_t,z_t,y_t),z_{t+1}(a_t,z_t,y_t),y_t)   
    EV = (1-afrac) .* (1-zfrac) .* EV(iBotBot) ...
       + (1-afrac) .*    zfrac  .* EV(iBotTop) ...
       +   afrac   .* (1-zfrac) .* EV(iTopBot) ...
       +   afrac   .*   zfrac   .* EV(iTopTop) ;   
    
    VNew = u(cStack) + beta*EV;
    
    error = max(abs(VNew(:)-VStack(:)));
    VStack = VNew;
                            
end
V = reshape(VStack,Na,Nz,Ny);

% Compute permanent consumption-equivalent
c = v(V) ;

% Compute consumption-equivalent evaluated at zU
    % First evaluate V
FraczU = fraczU*ones(Na,Ny) ;
VzU = (1-FraczU).*squeeze(V(:,izUBot,:)) + FraczU.*squeeze(V(:,izUTop,:)) ;
    % Compute conusmption
czU = v(VzU) ;


end

