function [ ] = WelfarePlots( cP,cPFL,cFL,czU,aMax,fraczU,izUBot,izUTop,fMass,fMassZU)

global a Na Ny da date

if ishandle(5)
    close(5)
end
if ishandle(6)
    close(6)
end

% Colors
LightOliveGreen = 2 * [ 165 184 154 ] / ( 165 + 184 + 154 ) ;
DarkOrange = [1 0.502 0] ;
fontsize = 10 ;

% Consumption
FraczU = fraczU*ones(Na,Ny) ;
cPzU1 = (1-FraczU).*cP(:,izUBot,1) + FraczU.*cP(:,izUTop,1) ;
cPzU2 = (1-FraczU).*cP(:,izUBot,Ny) + FraczU.*cP(:,izUTop,Ny) ;

% Aggregate density
NaCoarse = 10 ;
fa = fMassZU; 
ia = 3 ;
a2 = [ a(1:ia) ; a(ia+1) + (aMax - a(ia+1)) * ( logspace(0,1,NaCoarse-ia)' - 1) / (10 - 1) ] ;

[iBot,iTop,iBotStack,iTopStack,frac] = Brackets2fast(a2,a,NaCoarse,1,Na) ;

aBot = a2(iBot) ;
aTop = a2(iTop) ;

da2 = [ a2(2:end) - a2(1:end-1) ; a2(end) - a2(end-1) ];
a3 = [ a2(1) ; a2(2:end) + da2(2:end) / 2 ] ;
    % Bin new grid
    
A = zeros(NaCoarse,Na) ;
for i=1:NaCoarse
    A(i,:) = ( a2(i) >= aBot' ) .* ( a2(i) < aTop' ) ;
end

fa2 = A * reshape(fa,Na,Ny) ;

fa = fa ./ repmat(da,1,Ny) ;
fa2 = fa2 ./ repmat(da2,1,Ny) ;

% Compute upper bound of support
iabar1 = find(fa2(:,1)  < 0.00001,1);
iabar2 = find(fa2(:,Ny) < 0.00001,1);
abar = max(a3(iabar1),a3(iabar2));

aMax = 1.5*abar ;

% Smooth distribution for graphical purposes
ff1 = fit(a(2:end),fMassZU(2:end,1)./da(2:end),'fourier1');
ff2 = fit(a(2:end),fMassZU(2:end,Ny)./da(2:end),'fourier1');
f1 = max(ff1(a(2:end)),0);
f2 = max(ff2(a(2:end)),0);
f1(a(2:end)>abar) = [] ;
f2(a(2:end)>abar) = [] ;
f1 = [ fMassZU(1,1)/da(1) ; f1 ];
f2 = [ fMassZU(1,Ny)/da(1) ; f2 ];
A = a;
A(a>abar) = [];

fmax = max( [f1(:);f2(:)] ) ;

% Figure 11

figure(11)
nx=1;ny=2;

subplot(nx,ny,1)
plot(a, 100 * ( cPzU1 ./ cPFL(:,1) - 1 ),'LineStyle','-','Color',DarkOrange,'LineWidth',2)
hold on
plot(a, 100 * ( cPzU2 ./ cPFL(:,Ny) - 1 ),'LineStyle',':','Color',DarkOrange,'LineWidth',2)
yL = get(gca,'YLim');
hold on
plot([abar abar],yL,'Color','k','LineStyle',':','LineWidth',1);
hold on
xlabel('Assets $a$','interpreter','latex')
ylabel('\%','interpreter','latex')
title({'Consumption gains relative to no location asset',''},'interpreter','latex')
set(gca,'TickLabelInterpreter','latex')
xlim([0,aMax])
set(gca,'FontSize',fontsize)
grid on
pbaspect([1 1 1])



subplot(nx,ny,2) ;

        % left axis
        yyaxis left

ax = gca;
ax.YColor = 'k' ;

plot(a,100*(czU(:,1)./cFL(:,1)-1),'Color',DarkOrange,'LineStyle','-','LineWidth',2)
hold on
plot(a,100*(czU(:,Ny)./cFL(:,Ny)-1),'Color',DarkOrange,'LineStyle',':','LineWidth',2)
hold on

yL = get(gca,'YLim');
plot([abar abar],[yL(1) 0.9999*yL(2)],'Color','k','LineStyle',':','LineWidth',1);
hold on

ylabel('Consumption equivalent \%','interpreter','latex')

        % right axis
        yyaxis right
        
ylim([0,1.75*fmax])
ax = gca;
ax.YColor = 'k';

plot(A,f1,'Color',LightOliveGreen,'LineStyle','-','LineWidth',2)
hold on
plot(A,f2,'Color',LightOliveGreen,'LineStyle',':','LineWidth',2)
hold on

ylabel('Marginal asset density','interpreter','latex')

xlabel('Assets $a$','interpreter','latex') ;

    % common settings

title({'Welfare gains relative to no location asset','\hskip10mm '},'interpreter','latex')
set(gca,'TickLabelInterpreter','latex')

xlim([0,aMax])
set(gca,'FontSize',fontsize)
grid on
pbaspect([1 1 1])
leg = legend('Low  income, $Z^U$','High income, $Z^U$','Highest eq. asset','Low income density, $Z^U$','High income density, $Z^U$','Location','NorthEast') ;
set(leg,'Interpreter','latex')
leg.FontSize = 8 ;

drawnow

hold off

end

