function [ zU , qU , iZUBot , iZUTop , fracZU ] = ZU( s , q , Dq )

% Computes unconstrained location given skill s and housing prices q , Dq

global Nz R z

[~,iMin] = max(Dq - s/R>=0);

% Correct for out-of grid cases
if Dq(Nz) < s/R
    iMin = Nz ;
elseif Dq(1) > s/R
    iMin = 1 ;
end

iZUBot = iMin-1;
iZUTop = iMin;

% Correct ends of grid
iZUTop(iZUBot==0) = 2;
iZUBot(iZUBot==0) = 1;
iZUTop(iZUTop==Nz) = Nz;
iZUBot(iZUTop==Nz) = Nz-1;

% Prortionality factor
fracZU = ( s/R - Dq(iZUBot) ) / ( Dq(iZUTop)-Dq(iZUBot) ) ;
if fracZU==Inf
    fracZU = 0.5 ;
end

% Assign output
zU = (1-fracZU)*z(iZUBot)+fracZU*z(iZUTop) ;
qU = (1-fracZU)*q(iZUBot)+fracZU*q(iZUTop) ;

end

