clear
addpath('Routines')

% Read the data

dat=readmatrix('dat.txt');

y=dat(:,1);
d=dat(:,2);
x=dat(:,3:size(dat,2));

% Specify interval options

bbcv=-0.18:0.01:-0.05; %Points to be considered
bn=15000; % Size of subsamples
nrep=250; % Number of subsamples
pct=95; % Specify that we want a 95% confidence interval

tic %start timer

[f,f_sub,cv,CI]=getbounds(d,y,x,bbcv,bn,nrep,pct);

toc %end timer

% Print confidence interval
if isempty(CI)
    fprintf('\n%3.0f percent confidence interval empty\n',pct)
else
    fprintf('\n%3.0f percent confidence interval: ( %5.3f , %5.3f )\n',pct,min(CI),max(CI))
end

%  Plot objective function and the critical value function

plot(bbcv,f,bbcv,cv)



    


