function [yhat]=cond_mean(y,x,h,method)
% x,y n-by-1
    if nargin<4
        method=1;
    end
%     fprintf('Method %g',method)
    yhat=zeros(size(y));
    if method==1
    for i=1:length(y)
        k=normpdf((x-x(i,1))/h);
        k(i)=0;
        yhat(i)=(k'*y)/sum(k);
    end
    else
        a1=min(x);
        a2=max(x);
        grid=a1+(0:0.001:1)*(a2-a1);
        ytilde=zeros(size(grid));
        for i=1:length(grid)
            k=normpdf((x-grid(i))/h);
            ytilde(i)=(k'*y)/sum(k);
        end
        for i=1:length(y)
            [minValue,closestIndex] = min(abs(x(i)-grid));
            yhat(i)=ytilde(closestIndex);
        end
        
        
    end
end