
function [f]=find_function2a_total(d,y,x,b)

    n=length(y);
    % Logit
    [blogit,slogit,flogit,Hlogit,Vlogit,scoreslogit]=estimate_logit(d,x);
    gamma_hat=blogit(1:length(blogit))/blogit(1);
    xg=x*gamma_hat;
    bw=0.2*std(xg(d==1));
    x2=x(:,2:size(x,2)-1);
    a2=PeterRobinson(y(d==1),x2(d==1,:),xg(d==1), bw);
    dd=(1:4)/5;
    ccz = [-Inf quantile(xg,dd) Inf];
    nz=length(ccz);
    f=zeros(length(b),2);
    
    for i=1:length(b)
        ymx2a=y-x2*a2-xg*b(i);
        dd=(1:9)/10;
        ccy = [-Inf quantile(ymx2a(d==1),dd) Inf];
        ymx2a=y-x2*a2-xg*b(i);
        ny=length(ccy);
        E=zeros(nz-1,ny-1);

        for iz=1:nz-1
            ii1=(xg>ccz(iz)).*(xg<=ccz(iz+1));
            for iy=1:ny-1
                E(iz,iy)=((ccy(iy)<ymx2a).*(ymx2a<=ccy(iy+1)).*(1-isnan(y(:))))'*ii1/sum(ii1);
            end
        end
        
        
        
        EmE=zeros(nz-2,ny-1);
        for iz=2:nz-1
            EmE(iz-1,:)=E(iz,:)-E(iz-1,:);
        end
        f(i,1)=min(min(min(EmE,0)))*sqrt(n);
        f(i,2)=-sum(sum(min(EmE,0).^2))*n;

    end

end