function [bhat,scores,hess,Failed]=probit(y,x,bstart)

    [n,k]=size(x);
    if nargin<3
        bstart=0*(1:k)'/k;
    end

    b=bstart;
    Converged=0;
    Failed=0;
    ftol=1.0d-6;
    btol=1.0d-5;
    maxiter=25;
    
%     fprintf('\n\n');
%     fprintf('PROBIT ESTIMATION')
%     fprintf('\n');
    iter=0;
    f=0;
    while (Converged==0)
        fold=f;
        [f,scores,ddf]=logli(y,x,b);
        
%        


% 
        
        
        df=sum(scores)';
        db=-ddf\df;
        b=b+db;
        Converged=(f>fold-ftol)*(max(abs(db))<btol);
        iter=iter+1;
        if iter>maxiter
            fprintf('\nPROBIT: max number of iterations exceeded')
            Converged=1;
            Failed=1;
        end
%         fprintf('Iteration Number: %4.0f',iter)
%         fprintf('        Function Value: %16.4f\n',f)
        
    end
     
    bhat=b;
    hess=ddf;
        
%     fprintf('\n\n');
end

function [f,scores,ddf]=logli(y,x,b)

    [n,k]=size(x);
    xb=x*b;
    p1=normcdf(xb);
    p0=normcdf(xb,'upper');
    lp1=log(p1);
    lp0=log(p0);
    f=lp1'*y+lp0'*(1-y);
    if nargout>1
        phi=normpdf(xb);
        a1=(p1.*p0);
        a2=repmat(phi,1,k).*x;
        a3=(y-p1)./a1;
        scores=repmat(a3,1,k).*a2;
        if nargout>2
            b1=phi./(a1.*a1);
            b2=(y-2*y.*p1+p1.*p1).*phi+(y-p1).*a1.*xb;
            c1=repmat(b1,1,k).*x;
            c2=repmat(b2,1,k).*x;
            ddf=-c1'*c2;
        end
    end

end