function [f,f_sub,cv,CI]=getbounds(d,y,x,b,bn,nrep,pct)

    bbcv=b;
    alpha=1-pct/100;
    fprintf('\nCalculate Sample Objective Function\n')
    % calculate objective function
    f=find_function2a_total(d,y,x,bbcv);

    % sub-sampling

    fss1=zeros(nrep,length(bbcv));
    fss2=zeros(nrep,length(bbcv));
    
    rng default

    for irep=1:nrep
        fprintf('\nSubsample Replication Number:%6i',irep)
%         tic
        ii=datasample(1:length(d),bn,'Replace',false)';
        ff=find_function2a_total(d(ii),y(ii),x(ii,:),bbcv);
        fss1(irep,:)=ff(:,1)';
        fss2(irep,:)=ff(:,2)';
%         toc
    end
    fprintf('\n\n\n')

    cv=zeros(length(bbcv),2);


    for ib=1:length(bbcv)
        cv(ib,1)=quantile(fss1(:,ib),alpha);  
        cv(ib,2)=quantile(fss2(:,ib),alpha);  
    end

    CI=bbcv( f(:,2) > cv(:,2));
    f=f(:,2);
    cv=cv(:,2);
    f_sub=fss2;

end